@echo off

:: Copyright (C) 2020 Efinix Inc. All rights reserved.
::
:: No portion of this code may be reused, modified or
:: distributed in any way without the expressed written
:: consent of Efinix Inc.
::
:: Efinity Patch Installer
:: 
:: INSTALLATION
::
::  1.  In CMD terminal, run this command first, to set up environment variables
::             > \path\to\efinity\<version>\bin\setup.bat
::  2.  Then run
::             > run.bat

setlocal EnableDelayedExpansion

set SCRIPT_PATH=%~dp0
set SILENT_PYTHON_ARG=
set SILENT=0
set NO_PYTHON=0
set EXIT_CODE=0

:PARSEOPTS
if "%1" == "-s" (
	set SILENT_PYTHON_ARG="-s"
	set SILENT=1
)
if "%1" == "--silent" (
	set SILENT_PYTHON_ARG="-s"
	set SILENT=1
)
if "%1" == "-n" (
	set NO_PYTHON=1
)
if "%1" == "--no_python" (
	set NO_PYTHON=1
)
if "%1" == "-ns" (
	set SILENT_PYTHON_ARG="-s"
	set SILENT=1
	set NO_PYTHON=1
)
if "%1" == "-sn" (
	set SILENT_PYTHON_ARG="-s"
	set SILENT=1
	set NO_PYTHON=1
)
shift
if not "%1" == "" goto PARSEOPTS

set DEFAULT_EFINITY_PATH=C:\Efinity\2024.2

:: If EFINITY_HOME variable is not set, see if Efinity was placed in default
:: location.  Try to allow user who installed Efinity in default
:: location to just click on this BAT script from Windows Explorer
:: without issues.
IF "%EFINITY_HOME%"=="" (
	IF EXIST %DEFAULT_EFINITY_PATH%\ (
		call %DEFAULT_EFINITY_PATH%\bin\setup.bat
	)
)

if %SILENT%==1 goto :PATCH

echo Efinity installation at %EFINITY_HOME% will be modified
SET /P "AREYOUSURE=Is this OK (Y/[N])? "
IF /I "%AREYOUSURE%" NEQ "Y" GOTO ABORT

:PATCH
if %NO_PYTHON% neq 1 (
	"%EFINITY_HOME%\python311\bin\python.exe" "%SCRIPT_PATH%\update_manifest.py" %SILENT_PYTHON_ARG%
	set EXIT_CODE=!ERRORLEVEL!
	if !EXIT_CODE! neq 0 (
		if not %SILENT%==1 (
			echo Patch validation failed with error code !EXIT_CODE!!
			GOTO :ABORT
		)
		GOTO :EXIT
	)
)

Robocopy "%SCRIPT_PATH%\files" "%EFINITY_HOME%" /E /R:0 /DCOPY:T /NFL /NDL /NJH /NJS
copy "%SCRIPT_PATH%\patch_readme.txt" /Y "%EFINITY_HOME%\patch_readme.txt" >NUL
for /f "usebackq delims=" %%A in ("%SCRIPT_PATH%\patch_removes.txt") do (
	if exist "%EFINITY_HOME%\%%A" del "%EFINITY_HOME%\%%A"
)

if "%~1"=="--silent" goto :EXIT

GOTO :END

:ABORT
echo Patch installation aborted by user
GOTO :END

:END
pause

:EXIT
exit /b !EXIT_CODE!
endlocal
