from typing import List
from design.db_item import GenericPinGroup, GenericParamService

def verify_gen_pin(inst_name: str, pin_group: GenericPinGroup,
                   exp_type_name: List[str], skip_bus: bool = False):
    for type_name in exp_type_name:
        #print(f"Pin type name: {type_name}")
        pin = pin_group.get_pin_by_type_name(type_name)
        assert pin is not None, f"Fail to get pin, type_name: {type_name}"
        assert pin.type_name == type_name
        assert pin.name == f"{inst_name}_{type_name}"
        if not skip_bus:
            assert pin.is_bus is False

def verify_bus_gen_pin(inst_name: str, pin_group: GenericPinGroup, exp_type_names: List[str]):
    for type_name in exp_type_names:
        pin = pin_group.get_pin_by_type_name(type_name)
        assert pin is not None, type_name
        assert pin.type_name == type_name
        assert pin.name == f"{inst_name}_{type_name}"
        assert pin.is_bus is True

def verify_gen_param(target, exp_design):

    param_svc = GenericParamService(target.param_group, target.get_param_info())
    for param_id, exp_value in exp_design.items():
        val = param_svc.get_param_value(param_id)
        #print(f"id:{param_id} exp_val:{exp_value} val:{val}")
        assert val == exp_value

# Different alternative to above
def verify_gen_pin_expected_name(gen_pin: GenericPinGroup, type_name: str,
                                 expected_name, expected_bus=False):

    pin = gen_pin.get_pin_by_type_name(type_name)
    assert pin is not None
    assert pin.type_name == type_name
    assert pin.name == expected_name
    assert pin.is_bus is expected_bus