from __future__ import annotations
import sys
import os
from pathlib import Path
from typing import TYPE_CHECKING, Optional
from PyQt5.QtCore import pyqtSlot
from PyQt5.QtWidgets import QMainWindow, QMessageBox

from util.app_setting import AppSetting
from util.app_launcher import AppLauncher
from util.excp import PTException
from util.singleton_logger import Logger

sys.path.append(os.path.dirname(__file__))
from Ui_tx375_device_soc_setting import Ui_MainWindow as UIFORM_CLASS

if TYPE_CHECKING:
    from PyQt5.QtWidgets import QWidget
    from design.db import PeriDesign

__LOGGER = Logger


class SOCWindow(QMainWindow, UIFORM_CLASS):
    """
    Main window for SOC configuration
    """
    _is_show_config = True

    def __init__(self, parent: Optional[QWidget] = None):
        self.design = None
        self.parent = parent

        QMainWindow.__init__(self, parent)
        self.setupUi(self)

        self.dw_config.setVisible(SOCWindow._is_show_config)
        self.actionShow_Hide_Config.triggered.connect(self.show_config_window)
        self.actionHelp.triggered.connect(self.on_show_help)
        self.statusBar().hide()

        self.browser = AppLauncher()

    def update_design(self, design: PeriDesign):
        self.design = design

    def show_config_window(self):
        if self.dw_config.isVisible():
            self.dw_config.hide()
            SOCWindow._is_show_config = False
        else:
            self.dw_config.show()
            SOCWindow._is_show_config = True

    @pyqtSlot()
    def on_show_help(self):
        setting = AppSetting()
        help_file = Path(setting.app_path[AppSetting.PathType.qcrv_html_help])
        if help_file.exists():
            try:
                self.browser.open_in_browser(help_file)
            except PTException:
                msg = "Fail to open help for Quad-Core RISC-V."
                QMessageBox.warning(self.parent, "Open Quad-Core RISC-V help", msg)
                __LOGGER.warning(msg)

        else:
            msg = "Help file for Quad-Core RISC-V is missing. Please contact support to fix your installation."
            QMessageBox.warning(self.parent, "Open Quad-Core RISC-V help", msg)
            __LOGGER.warning(msg)
