from functools import partial
from common_device.property import PropertyMetaData
from common_gui.base_dep_graph import DependencyGraph
from design.db_item import GenericPinGroup


class RawSerdesPinDependencyGraph(DependencyGraph):
    def build_pin_dependency(self, param_info: PropertyMetaData, port_info: GenericPinGroup):
      # removed since this is not a direct config pin
      #   self.add_param_to_port_dependency(
      #      param_name='ss_raw_bundle_mode_lane_NID',
      #      port_name='PCS_CLK_TX',
      #      change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="Raw Serdes" && ss_raw_bundle_mode_lane_NID != "x8" ')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='ss_raw_mode_lane_NID',
           port_name='PCS_RST_N_TX',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="Raw Serdes" && ss_raw_mode_lane_NID != "Rx FIFO"')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='PHY_RESET_EN',
           port_name='PHY_CMN_RESET_N',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && (ss_topology_lane_NID=="Raw Serdes" ||  ss_topology_lane_NID=="Raw Serdes" || ss_topology_lane_NID=="Raw Serdes"  ||  ss_topology_lane_NID=="Raw Serdes") && PHY_RESET_EN')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='ss_raw_eq_eval_lane_NID',
           port_name='PMA_RX_EQ_EVAL',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="Raw Serdes" && ss_raw_eq_eval_lane_NID==1')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='ss_raw_eq_eval_lane_NID',
           port_name='PMA_RX_EQ_EVAL_COMPLETE',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="Raw Serdes" && ss_raw_eq_eval_lane_NID==1')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='ss_raw_eq_eval_lane_NID',
           port_name='PMA_RX_EQ_EVAL_STATUS',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="Raw Serdes" && ss_raw_eq_eval_lane_NID==1')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='ss_raw_eq_eval_lane_NID',
           port_name='PMA_RX_EQ_TRAINING_DATA_VALID',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="Raw Serdes" && ss_raw_eq_eval_lane_NID==1')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='ss_raw_eq_eval_lane_NID',
           port_name='PMA_RX_LINK_EVAL_FB_DIR_CHANGE',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="Raw Serdes" && ss_raw_eq_eval_lane_NID==1')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='ss_raw_mode_lane_NID',
           port_name='PMA_TX_ELEC_IDLE',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="Raw Serdes" && ss_raw_mode_lane_NID != "Rx FIFO"')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='ss_raw_mode_lane_NID',
           port_name='PMA_TX_RCV_DETECT_EN',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="Raw Serdes" && ss_raw_mode_lane_NID != "Rx FIFO"')) # type: ignore
        # commenting this out due to another dependency in the UI
        #self.add_param_to_port_dependency(
        #   param_name='ss_raw_mode_lane_NID',
        #   port_name='RAW_SERDES_TX_CLK',
        #   change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="Raw Serdes" && ss_raw_mode_lane_NID != "Rx FIFO"')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='ss_raw_mode_lane_NID',
           port_name='TXD',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="Raw Serdes" && ss_raw_mode_lane_NID != "Rx FIFO"')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='ss_raw_mode_lane_NID',
           port_name='TXDATA_VALID',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="Raw Serdes"  && ss_raw_mode_lane_NID != "Rx FIFO"')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='APB_EN',
           port_name='USER_APB_CLK',
           change_func=partial(self.on_enable_changed_pin, condition_str='(quad=="q0" && (ss_topology_lane_NID=="Raw Serdes" ||  ss_topology_lane_NID=="Raw Serdes" || ss_topology_lane_NID=="Raw Serdes"  ||  ss_topology_lane_NID=="Raw Serdes")) && (APB_EN)')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='APB_EN',
           port_name='USER_APB_PADDR',
           change_func=partial(self.on_enable_changed_pin, condition_str='(quad=="q0" && (ss_topology_lane_NID=="Raw Serdes" ||  ss_topology_lane_NID=="Raw Serdes" || ss_topology_lane_NID=="Raw Serdes"  ||  ss_topology_lane_NID=="Raw Serdes")) && (APB_EN)')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='APB_EN',
           port_name='USER_APB_PENABLE',
           change_func=partial(self.on_enable_changed_pin, condition_str='(quad=="q0" && (ss_topology_lane_NID=="Raw Serdes" ||  ss_topology_lane_NID=="Raw Serdes" || ss_topology_lane_NID=="Raw Serdes"  ||  ss_topology_lane_NID=="Raw Serdes")) && (APB_EN)')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='APB_EN',
           port_name='USER_APB_PRDATA',
           change_func=partial(self.on_enable_changed_pin, condition_str='(quad=="q0" && (ss_topology_lane_NID=="Raw Serdes" ||  ss_topology_lane_NID=="Raw Serdes" || ss_topology_lane_NID=="Raw Serdes"  ||  ss_topology_lane_NID=="Raw Serdes")) && (APB_EN)')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='APB_EN',
           port_name='USER_APB_PREADY',
           change_func=partial(self.on_enable_changed_pin, condition_str='(quad=="q0" && (ss_topology_lane_NID=="Raw Serdes" ||  ss_topology_lane_NID=="Raw Serdes" || ss_topology_lane_NID=="Raw Serdes"  ||  ss_topology_lane_NID=="Raw Serdes")) && (APB_EN)')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='APB_EN',
           port_name='USER_APB_PSEL',
           change_func=partial(self.on_enable_changed_pin, condition_str='(quad=="q0" && (ss_topology_lane_NID=="Raw Serdes" ||  ss_topology_lane_NID=="Raw Serdes" || ss_topology_lane_NID=="Raw Serdes"  ||  ss_topology_lane_NID=="Raw Serdes")) && (APB_EN)')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='APB_EN',
           port_name='USER_APB_PWDATA',
           change_func=partial(self.on_enable_changed_pin, condition_str='(quad=="q0" && (ss_topology_lane_NID=="Raw Serdes" ||  ss_topology_lane_NID=="Raw Serdes" || ss_topology_lane_NID=="Raw Serdes"  ||  ss_topology_lane_NID=="Raw Serdes")) && (APB_EN)')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='APB_EN',
           port_name='USER_APB_PWRITE',
           change_func=partial(self.on_enable_changed_pin, condition_str='(quad=="q0" && (ss_topology_lane_NID=="Raw Serdes" ||  ss_topology_lane_NID=="Raw Serdes" || ss_topology_lane_NID=="Raw Serdes"  ||  ss_topology_lane_NID=="Raw Serdes")) && (APB_EN)')) # type: ignore


def get_hidden_ports():
    return [
        "PMA_CMN_EXT_REFCLK1_DETECTED",
        "PMA_CMN_EXT_REFCLK1_DETECTED_CFG",
        "PMA_CMN_EXT_REFCLK1_DETECTED_VALID",
        "PMA_CMN_EXT_REFCLK_DETECTED",
        "PMA_CMN_EXT_REFCLK_DETECTED_CFG",
        "PMA_CMN_EXT_REFCLK_DETECTED_VALID",
        "PMA_CMN_REFCLK1_CORE",
        "PMA_CMN_REFCLK1_PLL",
        "PMA_CMN_REFCLK1_PLL_1",
        "PMA_CMN_REFCLK1_PLL_2",
        "PMA_CMN_REFCLK_CORE",
        "PMA_CMN_REFCLK_PLL",
        "PMA_CMN_REFCLK_PLL_1",
        "PMA_CMN_REFCLK_PLL_2",
        "PMA_TX_RCV_DETECT_EN",
        "RXDATA_VALID",
        "RX_SLIP",
        "TXDATA_VALID",
        "USER_APB_PSLVERR",
    ]

def get_tie_high_ports():
    return [
        "PHY_CMN_RESET_N",
        "PMA_RX_EQ_TRAINING_DATA_VALID",
        "TXDATA_VALID",
    ]

def get_tie_off_unused_ports():
    return [
    ]

def get_additional_params():
    return [
    ]
