from typing import List
from design.db_item import GenericParam
from common_device.property import PropertyMetaData, RangeValidator
from tx375_device.raw_serdes.raw_serdes_prop_id import RawSerdesConfigParamInfo as RawSerdesParamInfo

def build_param_info():
    param_info = RawSerdesParamInfo()

    prop_data_list: List[PropertyMetaData.PropData] = [
        PropertyMetaData.PropData(id=RawSerdesParamInfo.Id.ss_raw_bundle_mode_lane_NID,
                name="ss_raw_bundle_mode_lane_NID",
                data_type=GenericParam.DataType.dstr,
                default="x1",
                valid_setting=["x1","x2","x4","x8"],
                disp_name="Bonding Mode",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=RawSerdesParamInfo.Id.ss_raw_data_rate_lane_NID,
                name="ss_raw_data_rate_lane_NID",
                data_type=GenericParam.DataType.dflo,
                default=5.0,
                valid_setting=[1.25, 1.485, 2.376, 2.5, 2.7, 2.97, 3.125, 4.752, 5, 5.4, 5.94, 6.25, 6.375, 6.75, 8, 8.1, 9.504, 10, 10.3125, 11.88, 12.5],
                disp_name="Data Rate (Gbps)",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=RawSerdesParamInfo.Id.ss_raw_deem_lane_NID,
                name="ss_raw_deem_lane_NID",
                data_type=GenericParam.DataType.dstr,
                default="Off",
                valid_setting=["Off","3.5dB","6dB"],
                disp_name="Deemphasis",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=RawSerdesParamInfo.Id.ss_raw_eq_eval_lane_NID,
                name="ss_raw_eq_eval_lane_NID",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Equalization Evaluation",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=RawSerdesParamInfo.Id.ss_raw_main_c0_lane_NID,
                name="ss_raw_main_c0_lane_NID",
                data_type=GenericParam.DataType.dhex,
                default="0x2d",
                valid_setting=("0x0", "0x3f"),
                disp_name="Main C0",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=RawSerdesParamInfo.Id.ss_raw_mode_lane_NID,
                name="ss_raw_mode_lane_NID",
                data_type=GenericParam.DataType.dstr,
                default="Tx FIFO, Rx FIFO",
                valid_setting=[ "Tx FIFO, Rx FIFO", "Tx FIFO, Rx Register", "Rx FIFO"],
                disp_name="Mode",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=RawSerdesParamInfo.Id.ss_raw_post_c_lane_NID,
                name="ss_raw_post_c_lane_NID",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x3f"),
                disp_name="Post C+1",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=RawSerdesParamInfo.Id.ss_raw_pre_c_lane_NID,
                name="ss_raw_pre_c_lane_NID",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x3f"),
                disp_name="Pre C-1",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=RawSerdesParamInfo.Id.ss_raw_serdes_width_lane_NID,
                name="ss_raw_serdes_width_lane_NID",
                data_type=GenericParam.DataType.dstr,
                default="40 bits",
                valid_setting=["20 bits","32 bits","40 bits","64 bits"],
                disp_name="SerDes Width (Bits)",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=RawSerdesParamInfo.Id.ss_raw_tx_eq_mode_lane_NID,
                name="ss_raw_tx_eq_mode_lane_NID",
                data_type=GenericParam.DataType.dstr,
                default="Deemphasis",
                valid_setting=[ "Deemphasis", "3 taps FIR filter"],
                disp_name="Tx equalization mode",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=RawSerdesParamInfo.Id.ss_topology_lane_NID,
                name="ss_topology_lane_NID",
                data_type=GenericParam.DataType.dstr,
                default="Raw Serdes",
                valid_setting=["PCIe", "10GE", "1GE", "Raw Serdes", "Disabled"],
                disp_name="ss_topology",
                category="Per Lane Parameters - Control Register "),
        ]

    for prop_data in prop_data_list:
        param_info.add_prop_by_data(prop_data.id, prop_data)

    return param_info

def get_hidden_parameters():
    return [
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen",
        "pcr_bypass_cmn_ready",
        "pcr_q0_bypass_cfgtop",
        "pcr_q0_user_phy_reset_n_expose",
        "pcr_q1_bypass_cfgtop",
        "pcr_q1_user_phy_reset_n_expose",
        "pll_ref_clk0",
        "pll_ref_clk1",
        "ref_clk_pin_name",
        "ss_plllc1_refclk_sel",
        "ss_raw_eq_eval_lane_NID",
        "ss_sim_enable",
        "ss_topology_lane_NID",
    ]

def get_removed_parameters():
    return [
    ]

def get_hidden_param_values():
    param2value_map = {
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel": ['Internal'],
        "PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg": ['Refclk 1'],
        "ss_raw_serdes_width_lane_NID": ['32 bits', '64 bits'],
    }
    return param2value_map

def get_display_values():
    return {
        "ss_raw_deem_lane_NID": {'3.5dB': '3.5 dB', '6dB': '6 dB'},
        "ss_raw_mode_lane_NID": {'Tx': 'TX', 'Rx': 'RX'},
        "ss_raw_serdes_width_lane_NID": {'20 bits': '20', '32 bits': '32', '40 bits': '40', '64 bits': '64'},
    }

def get_supported_common_parameters():
    return [
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen",
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel",
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_termen",
        "PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg",
        "pcr_bypass_cmn_ready",
        "pcr_q0_bypass_cfgtop",
        "pcr_q0_user_phy_reset_n_expose",
        "pcr_q1_bypass_cfgtop",
        "pcr_q1_user_phy_reset_n_expose",
        "ss_plllc1_refclk_sel",
        "ss_raw_refclk_freq",
        "ss_sim_enable",
    ]
