from typing import List
from design.db_item import GenericParam
from common_device.property import PropertyMetaData, RangeValidator
from tx375_device.raw_serdes.raw_serdes_pll_cfg_prop_id import RawSerdesPLLConfigParamInfo as RawSerdesPLLParamInfo

def build_param_info():
    param_info = RawSerdesPLLParamInfo()

    prop_data_list: List[PropertyMetaData.PropData] = [
        PropertyMetaData.PropData(id=RawSerdesPLLParamInfo.Id.PMA_CMN__cmn_plllc_clk0_preg__cmn_plllc_clk0outdiv_mode0_preg,
                name="PMA_CMN__cmn_plllc_clk0_preg__cmn_plllc_clk0outdiv_mode0_preg",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x0", "0x7f"),
                disp_name="Common OUTCLK0 Divider",
                category="pll_config"),
        PropertyMetaData.PropData(id=RawSerdesPLLParamInfo.Id.PMA_CMN__cmn_plllc_fbdiv_int_mode0_preg__cmn_plllc_fbdivint_mode0_preg,
                name="PMA_CMN__cmn_plllc_fbdiv_int_mode0_preg__cmn_plllc_fbdivint_mode0_preg",
                data_type=GenericParam.DataType.dhex,
                default="0x20",
                valid_setting=("0x1", "0x1ff"),
                disp_name="Common Feedback Divider",
                category="pll_config"),
        PropertyMetaData.PropData(id=RawSerdesPLLParamInfo.Id.PMA_L_NID__det_standec_e_preg__clkrst_datart_div_mode0_preg,
                name="PMA_L_NID__det_standec_e_preg__clkrst_datart_div_mode0_preg",
                data_type=GenericParam.DataType.dhex,
                default="0x2",
                valid_setting=("0x0", "0x7"),
                disp_name="Lane Word Rate Clock",
                category="pll_config"),
        PropertyMetaData.PropData(id=RawSerdesPLLParamInfo.Id.PMA_L_NID__pllctrl_fbdiv_mode01_preg__pllctrl_fbdiv_mode0_preg,
                name="PMA_L_NID__pllctrl_fbdiv_mode01_preg__pllctrl_fbdiv_mode0_preg",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x1", "0x7f"),
                disp_name="Lane Feedback Divider",
                category="pll_config"),
        PropertyMetaData.PropData(id=RawSerdesPLLParamInfo.Id.PMA_L_NID__pllctrl_gen_d_preg__pllctrl_digdiv_mode0_preg,
                name="PMA_L_NID__pllctrl_gen_d_preg__pllctrl_digdiv_mode0_preg",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x0", "0x7f"),
                disp_name="Lane Digital Divider",
                category="pll_config"),
        PropertyMetaData.PropData(id=RawSerdesPLLParamInfo.Id.PMA_L_NID__pllctrl_subrate_preg__pllctrl_subrate_mode0_preg,
                name="PMA_L_NID__pllctrl_subrate_preg__pllctrl_subrate_mode0_preg",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x0", "0x3"),
                disp_name="Lane Subrate Divider",
                category="pll_config"),
        ]

    for prop_data in prop_data_list:
        param_info.add_prop_by_data(prop_data.id, prop_data)

    return param_info

def get_pll_config_common_param():
    return [
        "PMA_CMN__cmn_plllc_clk0_preg__cmn_plllc_clk0outdiv_mode0_preg",
        "PMA_CMN__cmn_plllc_fbdiv_int_mode0_preg__cmn_plllc_fbdivint_mode0_preg"
    ]
