"""

Copyright (C) 2017-2024 Efinix Inc. All rights reserved.

No portion of this code may be reused, modified or
distributed in any way without the expressed written
consent of Efinix Inc.

Created on May 13, 2024

@author: Shirley Chan
"""
from __future__ import annotations
from typing import TYPE_CHECKING, Dict, List
from PyQt5.QtWidgets import QLabel

from tx375_device.common_quad.design import QuadLaneCommon
from tx375_device.common_quad.quad_prop_id import CommonQuadConfigParamInfo as QuadConfigParamInfo

from tx375_device.raw_serdes.design import RawSerdes
from tx375_device.raw_serdes.quad_param_info import get_hidden_param_values, get_display_values

from common_device.quad.gui.lane_presenter import LaneBasedConfigUIPresenter

if TYPE_CHECKING:
    from enum import Enum

class RawSerdesConfigUIPresenter(LaneBasedConfigUIPresenter):
    def get_hidden_param_values(self) -> Dict[str, List]:
        return get_hidden_param_values()

    def get_param2db2ui_mapping(self) -> Dict[str, Dict[str, str]]:
        return get_display_values()

    def load_preset_info(self, db_item: RawSerdes, cmn_inst: QuadLaneCommon,
                         label_mapping: Dict[Enum, QLabel]):
        for param, lbl in label_mapping.items():
            if isinstance(param, QuadConfigParamInfo.Id):
                inst = cmn_inst
            else:
                inst = db_item

            val = inst.param_group.get_param_value(param.value)
            val = self.convert_db2display_value(param.value, val)
            lbl.setText(str(val))
