from __future__ import annotations
from typing import TYPE_CHECKING
import pt_version

from tx375_device.raw_serdes.design_param_info import RawSerdesDesignParamInfo as RawSerdesParamInfo
from tx375_device.raw_serdes.quad_param_info import RawSerdesParamInfo as AdvParamInfo

from common_device.quad.gui.graph_observer import LaneBasedGraphObserver, BaseCommonQuadGraphObserver


if TYPE_CHECKING:
    from tx375_device.raw_serdes.gui.config import RawSerdesConfig

IS_SHOW_HIDDEN = True if pt_version.PT_DEBUG_VERSION == True else False

class RawSerdesGraphObserver(LaneBasedGraphObserver):
    def __init__(self, config) -> None:
        super().__init__(config)
        self._config: 'RawSerdesConfig'

    def update_specific_widget(self, block_inst, updated_params, updated_pins):
        assert self._config.presenter is not None

        if AdvParamInfo.Id.ss_raw_eq_eval_lane_NID.value in updated_params:
            self.update_eq_tab()

        if AdvParamInfo.Id.ss_raw_data_rate_lane_NID.value in updated_params:
            self.load_preset_info()

    def get_hw_param_id_class(self):
        return AdvParamInfo.Id

    def get_sw_param_id_class(self):
        return RawSerdesParamInfo.Id

    def update_eq_tab(self):
        category = "EQ EVALUATION"
        parent_category = "Pins"

        child_container = self._config.parent_category2sub_tabw.get(parent_category, None)
        assert child_container is not None

        is_page_display = self.is_any_pin_available(category)
        self.set_tab_visible(category, child_container, is_page_display)

    def load_preset_info(self):
        inst = self._config.block_inst
        assert inst is not None
        cmn_inst = self._config.common_inst
        assert cmn_inst is not None
        assert self._config.presenter is not None

        self._config.presenter.load_preset_info(
            inst, cmn_inst, self._config.preset_label_map)


class CommonQuadGraphObserver(BaseCommonQuadGraphObserver):
    def __init__(self, config) -> None:
        super().__init__(config)
        self._config: 'RawSerdesConfig'
