from typing import Dict, List

from common_device.quad.gui.builder import LaneTabBuilder


class RawSerdesTabBuilder(LaneTabBuilder):
    pin_categories = [
        "CLOCK and RESET",
        "CONTROL",
        "DATA INTERFACE",
        "EQ EVALUATION",
        "ERROR and STATUS",
        "POWER UP",
    ]

    param_categories = [
        "Per Lane Parameters - Control Register ",
        "Pins",
        "Common Properties",
    ]

    hidden_categories = {
        "EQ EVALUATION",
        "External Reference Clock Active Detection:SW_COMMON",
    }
    # common used (i.e. all lanes use them)
    common_pin_categories: List[str] = [
        "APB",
        "CLOCK and RESET",
        "ERROR and STATUS",
        "External Reference Clock Active Detection",
    ]
    category2display_name: Dict[str, str] = {
        "Per Lane Parameters - Control Register ": "Control Register",
        "CLOCK and RESET": "Clock and Reset",
        "CONTROL": "Control",
        "DATA INTERFACE": "Data Interface",
        "EQ EVALUATION": "EQ Evaluation",
        "ERROR and STATUS": "Error and Status",
        "POWER UP": "Power Up",
        "Common Parameters": "Config"
    }
    common_categories2display_name = dict()
    for category in common_pin_categories:
        common_categories2display_name[f"{category}:SW_COMMON"] = category2display_name.get(category, category)

    category2display_name.update(common_categories2display_name)

    # Children list order will change tab order
    parent_category2children: Dict[str, List[str]] = {
        "Pins": pin_categories,
        "Common Properties": ["Common Parameters"] + [f"{item}:SW_COMMON" for item in common_pin_categories],
    }
    category2min_height: Dict[str, int] = {}

    skip_categories: List[str] = [
        "ref_clk",
        "Pins",
        "Common Parameters",
    ]
