from enum import Enum, unique
from common_device.property import PropertyMetaData

class QuadPCIEConfigParamInfo(PropertyMetaData):

    @unique
    class Id(Enum):
        ss_topology_lane0 = "ss_topology_lane0"
        ss_topology_lane1 = "ss_topology_lane1"
        ss_topology_lane2 = "ss_topology_lane2"
        ss_topology_lane3 = "ss_topology_lane3"
        ss_sim_enable = "ss_sim_enable"
        PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg = "PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg"
        ss_plllc1_refclk_sel = "ss_plllc1_refclk_sel"
        PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel = "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel"
        PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_termen = "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_termen"
        PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen = "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen"
        ss_refclk_onboard_osc = "ss_refclk_onboard_osc"
        pcr_clear_sticky = "pcr_clear_sticky"
        pcr_q0_user_phy_reset_n_expose = "pcr_q0_user_phy_reset_n_expose"
        pcr_q1_user_phy_reset_n_expose = "pcr_q1_user_phy_reset_n_expose"
        pcr_bypass_cmn_ready = "pcr_bypass_cmn_ready"
        pcr_q0_bypass_cfgtop = "pcr_q0_bypass_cfgtop"
        pcr_q1_bypass_cfgtop = "pcr_q1_bypass_cfgtop"
        ss_pcie_pmclk_divsel = "ss_pcie_pmclk_divsel"
        PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel = "PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel"
        PIPE_CONFIG_CMN__config_reg_0__mode_select = "PIPE_CONFIG_CMN__config_reg_0__mode_select"
        PIPE_CONFIG_CMN__config_reg_0__lane_count_in = "PIPE_CONFIG_CMN__config_reg_0__lane_count_in"
        ss_pcie_MPS = "ss_pcie_MPS"
        i_client_RC__i_pcie_cap__MP = "i_client_RC__i_pcie_cap__MP"
        ss_pcie_sris_en = "ss_pcie_sris_en"
        ss_pcie_gen4_tx_preset = "ss_pcie_gen4_tx_preset"
        ss_pcie_gen3_rx_preset = "ss_pcie_gen3_rx_preset"
        ss_pcie_gen3_tx_preset = "ss_pcie_gen3_tx_preset"
        ss_pcie_aspm = "ss_pcie_aspm"
        i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN = "i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN"
        i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN = "i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN"
        i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN = "i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN"
        i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN = "i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN"
        i_client_PF0__i_L1_PM_cap__L1PrtCmMdReStrTime = "i_client_PF0__i_L1_PM_cap__L1PrtCmMdReStrTime"
        i_client_PF0__i_L1_PM_cap__L1PrtPvrOnScale = "i_client_PF0__i_L1_PM_cap__L1PrtPvrOnScale"
        i_client_PF0__i_L1_PM_cap__R0 = "i_client_PF0__i_L1_PM_cap__R0"
        i_client_PF0__i_L1_PM_ctrl_1__L1CmMdReStrTime = "i_client_PF0__i_L1_PM_ctrl_1__L1CmMdReStrTime"
        i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldSc = "i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldSc"
        i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldVal = "i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldVal"
        i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnSc = "i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnSc"
        i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnVal = "i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnVal"
        i_client_RC__i_link_ctrl_status__ASPMC = "i_client_RC__i_link_ctrl_status__ASPMC"
        i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN = "i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN"
        i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN = "i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN"
        i_client_RC__i_L1_PM_ctrl_1__L1PML11EN = "i_client_RC__i_L1_PM_ctrl_1__L1PML11EN"
        i_client_RC__i_L1_PM_ctrl_1__L1PML12EN = "i_client_RC__i_L1_PM_ctrl_1__L1PML12EN"
        i_client_RC__i_L1_PM_cap__L1PrtCmMdReStrTime = "i_client_RC__i_L1_PM_cap__L1PrtCmMdReStrTime"
        i_client_RC__i_L1_PM_cap__L1PrtPvrOnScale = "i_client_RC__i_L1_PM_cap__L1PrtPvrOnScale"
        i_client_RC__i_L1_PM_cap__R0 = "i_client_RC__i_L1_PM_cap__R0"
        i_client_RC__i_L1_PM_ctrl_1__L1CmMdReStrTime = "i_client_RC__i_L1_PM_ctrl_1__L1CmMdReStrTime"
        i_client_RC__i_L1_PM_ctrl_1__L1ThrshldSc = "i_client_RC__i_L1_PM_ctrl_1__L1ThrshldSc"
        i_client_RC__i_L1_PM_ctrl_1__L1ThrshldVal = "i_client_RC__i_L1_PM_ctrl_1__L1ThrshldVal"
        i_client_RC__i_L1_PM_ctrl_2__L1PwrOnSc = "i_client_RC__i_L1_PM_ctrl_2__L1PwrOnSc"
        i_client_RC__i_L1_PM_ctrl_2__L1PwrOnVal = "i_client_RC__i_L1_PM_ctrl_2__L1PwrOnVal"
        i_client_PF0__i_pcie_dev_ctrl_status__ETFE = "i_client_PF0__i_pcie_dev_ctrl_status__ETFE"
        i_client_PF0__i_link_cap__PN = "i_client_PF0__i_link_cap__PN"
        i_client_PF0__i_link_ctrl_status__SCC = "i_client_PF0__i_link_ctrl_status__SCC"
        i_client_PF0__i_dev_ser_num_0__DSND0 = "i_client_PF0__i_dev_ser_num_0__DSND0"
        i_client_PF0__i_dev_ser_num_1__DSND1 = "i_client_PF0__i_dev_ser_num_1__DSND1"
        i_client_RC__i_pcie_dev_ctrl_status__ETE = "i_client_RC__i_pcie_dev_ctrl_status__ETE"
        i_client_RC__i_link_cap__PN = "i_client_RC__i_link_cap__PN"
        i_client_RC__i_link_ctrl_status__SCC = "i_client_RC__i_link_ctrl_status__SCC"
        i_client_RC__i_slot_capability__SPLS = "i_client_RC__i_slot_capability__SPLS"
        i_client_RC__i_slot_capability__SPLV = "i_client_RC__i_slot_capability__SPLV"
        i_client_RC__i_slot_capability__PSN = "i_client_RC__i_slot_capability__PSN"
        i_client_RC__i_dev_ser_num_0__DSND0 = "i_client_RC__i_dev_ser_num_0__DSND0"
        i_client_RC__i_dev_ser_num_1__DSND1 = "i_client_RC__i_dev_ser_num_1__DSND1"
        i_client_LM__i_vendor_id_reg__VID = "i_client_LM__i_vendor_id_reg__VID"
        i_client_LM__i_vendor_id_reg__SVID = "i_client_LM__i_vendor_id_reg__SVID"
        ss_pcie_pf_num = "ss_pcie_pf_num"
        PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable = "PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable"
        i_client_PF0__i_func_dep_link_numVFs_reg__NVF = "i_client_PF0__i_func_dep_link_numVFs_reg__NVF"
        i_client_PF1__i_func_dep_link_numVFs_reg__NVF = "i_client_PF1__i_func_dep_link_numVFs_reg__NVF"
        i_client_PF2__i_func_dep_link_numVFs_reg__NVF = "i_client_PF2__i_func_dep_link_numVFs_reg__NVF"
        i_client_PF3__i_func_dep_link_numVFs_reg__NVF = "i_client_PF3__i_func_dep_link_numVFs_reg__NVF"
        i_client_RC__i_vendor_id_device_id__DID = "i_client_RC__i_vendor_id_device_id__DID"
        i_client_RC__i_revision_id_class_code__RID = "i_client_RC__i_revision_id_class_code__RID"
        i_client_RC__i_revision_id_class_code__PIB = "i_client_RC__i_revision_id_class_code__PIB"
        i_client_RC__i_revision_id_class_code__SCC = "i_client_RC__i_revision_id_class_code__SCC"
        i_client_RC__i_revision_id_class_code__CC = "i_client_RC__i_revision_id_class_code__CC"
        i_client_LM__i_rc_BAR_config_reg__RCBAR0C = "i_client_LM__i_rc_BAR_config_reg__RCBAR0C"
        i_client_LM__i_rc_BAR_config_reg__RCBAR0A = "i_client_LM__i_rc_BAR_config_reg__RCBAR0A"
        i_client_LM__i_rc_BAR_config_reg__RCBAR1C = "i_client_LM__i_rc_BAR_config_reg__RCBAR1C"
        i_client_LM__i_rc_BAR_config_reg__RCBAR1A = "i_client_LM__i_rc_BAR_config_reg__RCBAR1A"
        i_client_PF0__i_vendor_id_device_id__DID = "i_client_PF0__i_vendor_id_device_id__DID"
        i_client_PF0__i_revision_id_class_code__RID = "i_client_PF0__i_revision_id_class_code__RID"
        i_client_PF0__i_revision_id_class_code__CC = "i_client_PF0__i_revision_id_class_code__CC"
        i_client_PF0__i_revision_id_class_code__SCC = "i_client_PF0__i_revision_id_class_code__SCC"
        i_client_PF0__i_revision_id_class_code__PIB = "i_client_PF0__i_revision_id_class_code__PIB"
        i_client_PF0__i_subsystem_vendor_id_subsystem_i__SID = "i_client_PF0__i_subsystem_vendor_id_subsystem_i__SID"
        i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C = "i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C"
        i_client_LM__i_pf_0_BAR_config_0_reg__BAR0A = "i_client_LM__i_pf_0_BAR_config_0_reg__BAR0A"
        i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C = "i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C"
        i_client_LM__i_pf_0_BAR_config_0_reg__BAR1A = "i_client_LM__i_pf_0_BAR_config_0_reg__BAR1A"
        i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C = "i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C"
        i_client_LM__i_pf_0_BAR_config_0_reg__BAR2A = "i_client_LM__i_pf_0_BAR_config_0_reg__BAR2A"
        i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C = "i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C"
        i_client_LM__i_pf_0_BAR_config_0_reg__BAR3A = "i_client_LM__i_pf_0_BAR_config_0_reg__BAR3A"
        i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C = "i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C"
        i_client_LM__i_pf_0_BAR_config_1_reg__BAR4A = "i_client_LM__i_pf_0_BAR_config_1_reg__BAR4A"
        i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C = "i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C"
        i_client_LM__i_pf_0_BAR_config_1_reg__BAR5A = "i_client_LM__i_pf_0_BAR_config_1_reg__BAR5A"
        ss_pcie_pf0_exp_rom_bar = "ss_pcie_pf0_exp_rom_bar"
        i_client_LM__i_pf_0_BAR_config_1_reg__ERBC = "i_client_LM__i_pf_0_BAR_config_1_reg__ERBC"
        ss_pcie_pf0_legacy_int_pin = "ss_pcie_pf0_legacy_int_pin"
        i_client_PF0__i_msi_ctrl_reg__MMC = "i_client_PF0__i_msi_ctrl_reg__MMC"
        i_client_PF0__i_msix_ctrl__CID = "i_client_PF0__i_msix_ctrl__CID"
        i_client_PF0__i_msix_ctrl__CP = "i_client_PF0__i_msix_ctrl__CP"
        i_client_PF0__i_msix_ctrl__MSIXTS = "i_client_PF0__i_msix_ctrl__MSIXTS"
        i_client_PF0__i_msix_tbl_offset__TO = "i_client_PF0__i_msix_tbl_offset__TO"
        i_client_PF0__i_msix_tbl_offset__BARI = "i_client_PF0__i_msix_tbl_offset__BARI"
        i_client_PF0__i_msix_pending_intrpt__PBAO = "i_client_PF0__i_msix_pending_intrpt__PBAO"
        i_client_PF0__i_msix_pending_intrpt__BARI1 = "i_client_PF0__i_msix_pending_intrpt__BARI1"
        i_client_PF0__i_vendor_specific_header_reg__VI = "i_client_PF0__i_vendor_specific_header_reg__VI"
        ss_pcie_pf0_vf_subsystem_id = "ss_pcie_pf0_vf_subsystem_id"
        i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C = "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C"
        i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0A = "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0A"
        i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C = "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C"
        i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1A = "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1A"
        i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C = "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C"
        i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2A = "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2A"
        i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C = "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C"
        i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3A = "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3A"
        i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C = "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C"
        i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4A = "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4A"
        i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C = "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C"
        i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5A = "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5A"
        ss_pcie_pf0_vf_msi_mul_message_cap = "ss_pcie_pf0_vf_msi_mul_message_cap"
        ss_pcie_pf0_vf_msix_table_size = "ss_pcie_pf0_vf_msix_table_size"
        ss_pcie_pf0_vf_msix_table_offset = "ss_pcie_pf0_vf_msix_table_offset"
        ss_pcie_pf0_vf_msix_bar_ind = "ss_pcie_pf0_vf_msix_bar_ind"
        ss_pcie_pf0_vf_msix_pba_offset = "ss_pcie_pf0_vf_msix_pba_offset"
        ss_pcie_pf0_vf_msix_pba_ind = "ss_pcie_pf0_vf_msix_pba_ind"
        ss_pcie_pf0_vf_tph_en = "ss_pcie_pf0_vf_tph_en"
        ss_pcie_pf0_vf_steering_tag_tab_loc = "ss_pcie_pf0_vf_steering_tag_tab_loc"
        ss_pcie_pf0_vf_steering_tag_tab_size = "ss_pcie_pf0_vf_steering_tag_tab_size"
        ss_pcie_pf0_vf_ats_en = "ss_pcie_pf0_vf_ats_en"
        i_client_PF1__i_vendor_id_device_id__DID = "i_client_PF1__i_vendor_id_device_id__DID"
        i_client_PF1__i_revision_id_class_code__RID = "i_client_PF1__i_revision_id_class_code__RID"
        i_client_PF1__i_revision_id_class_code__CC = "i_client_PF1__i_revision_id_class_code__CC"
        i_client_PF1__i_revision_id_class_code__SCC = "i_client_PF1__i_revision_id_class_code__SCC"
        i_client_PF1__i_revision_id_class_code__PIB = "i_client_PF1__i_revision_id_class_code__PIB"
        i_client_PF1__i_subsystem_vendor_id_subsystem_i__SID = "i_client_PF1__i_subsystem_vendor_id_subsystem_i__SID"
        i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C = "i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C"
        i_client_LM__i_pf_1_BAR_config_0_reg__BAR0A = "i_client_LM__i_pf_1_BAR_config_0_reg__BAR0A"
        i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C = "i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C"
        i_client_LM__i_pf_1_BAR_config_0_reg__BAR1A = "i_client_LM__i_pf_1_BAR_config_0_reg__BAR1A"
        i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C = "i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C"
        i_client_LM__i_pf_1_BAR_config_0_reg__BAR2A = "i_client_LM__i_pf_1_BAR_config_0_reg__BAR2A"
        i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C = "i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C"
        i_client_LM__i_pf_1_BAR_config_0_reg__BAR3A = "i_client_LM__i_pf_1_BAR_config_0_reg__BAR3A"
        i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C = "i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C"
        i_client_LM__i_pf_1_BAR_config_1_reg__BAR4A = "i_client_LM__i_pf_1_BAR_config_1_reg__BAR4A"
        i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C = "i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C"
        i_client_LM__i_pf_1_BAR_config_1_reg__BAR5A = "i_client_LM__i_pf_1_BAR_config_1_reg__BAR5A"
        ss_pcie_pf1_exp_rom_bar = "ss_pcie_pf1_exp_rom_bar"
        i_client_LM__i_pf_1_BAR_config_1_reg__ERBC = "i_client_LM__i_pf_1_BAR_config_1_reg__ERBC"
        ss_pcie_pf1_legacy_int_pin = "ss_pcie_pf1_legacy_int_pin"
        i_client_PF1__i_msi_ctrl_reg__MMC = "i_client_PF1__i_msi_ctrl_reg__MMC"
        i_client_PF1__i_msix_ctrl__CID = "i_client_PF1__i_msix_ctrl__CID"
        i_client_PF1__i_msix_ctrl__CP = "i_client_PF1__i_msix_ctrl__CP"
        i_client_PF1__i_msix_ctrl__MSIXTS = "i_client_PF1__i_msix_ctrl__MSIXTS"
        i_client_PF1__i_msix_tbl_offset__TO = "i_client_PF1__i_msix_tbl_offset__TO"
        i_client_PF1__i_msix_tbl_offset__BARI = "i_client_PF1__i_msix_tbl_offset__BARI"
        i_client_PF1__i_msix_pending_intrpt__PBAO = "i_client_PF1__i_msix_pending_intrpt__PBAO"
        i_client_PF1__i_msix_pending_intrpt__BARI1 = "i_client_PF1__i_msix_pending_intrpt__BARI1"
        i_client_PF1__i_vendor_specific_header_reg__VI = "i_client_PF1__i_vendor_specific_header_reg__VI"
        ss_pcie_pf1_vf_subsystem_id = "ss_pcie_pf1_vf_subsystem_id"
        i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C = "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C"
        i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0A = "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0A"
        i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C = "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C"
        i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1A = "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1A"
        i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C = "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C"
        i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2A = "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2A"
        i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C = "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C"
        i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3A = "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3A"
        i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C = "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C"
        i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4A = "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4A"
        i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C = "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C"
        i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5A = "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5A"
        ss_pcie_pf1_vf_msi_mul_message_cap = "ss_pcie_pf1_vf_msi_mul_message_cap"
        ss_pcie_pf1_vf_msix_table_size = "ss_pcie_pf1_vf_msix_table_size"
        ss_pcie_pf1_vf_msix_table_offset = "ss_pcie_pf1_vf_msix_table_offset"
        ss_pcie_pf1_vf_msix_bar_ind = "ss_pcie_pf1_vf_msix_bar_ind"
        ss_pcie_pf1_vf_msix_pba_offset = "ss_pcie_pf1_vf_msix_pba_offset"
        ss_pcie_pf1_vf_msix_pba_ind = "ss_pcie_pf1_vf_msix_pba_ind"
        ss_pcie_pf1_vf_tph_en = "ss_pcie_pf1_vf_tph_en"
        ss_pcie_pf1_vf_steering_tag_tab_loc = "ss_pcie_pf1_vf_steering_tag_tab_loc"
        ss_pcie_pf1_vf_steering_tag_tab_size = "ss_pcie_pf1_vf_steering_tag_tab_size"
        ss_pcie_pf1_vf_ats_en = "ss_pcie_pf1_vf_ats_en"
        i_client_PF2__i_vendor_id_device_id__DID = "i_client_PF2__i_vendor_id_device_id__DID"
        i_client_PF2__i_revision_id_class_code__RID = "i_client_PF2__i_revision_id_class_code__RID"
        i_client_PF2__i_revision_id_class_code__CC = "i_client_PF2__i_revision_id_class_code__CC"
        i_client_PF2__i_revision_id_class_code__SCC = "i_client_PF2__i_revision_id_class_code__SCC"
        i_client_PF2__i_revision_id_class_code__PIB = "i_client_PF2__i_revision_id_class_code__PIB"
        i_client_PF2__i_subsystem_vendor_id_subsystem_i__SID = "i_client_PF2__i_subsystem_vendor_id_subsystem_i__SID"
        i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C = "i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C"
        i_client_LM__i_pf_2_BAR_config_0_reg__BAR0A = "i_client_LM__i_pf_2_BAR_config_0_reg__BAR0A"
        i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C = "i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C"
        i_client_LM__i_pf_2_BAR_config_0_reg__BAR1A = "i_client_LM__i_pf_2_BAR_config_0_reg__BAR1A"
        i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C = "i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C"
        i_client_LM__i_pf_2_BAR_config_0_reg__BAR2A = "i_client_LM__i_pf_2_BAR_config_0_reg__BAR2A"
        i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C = "i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C"
        i_client_LM__i_pf_2_BAR_config_0_reg__BAR3A = "i_client_LM__i_pf_2_BAR_config_0_reg__BAR3A"
        i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C = "i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C"
        i_client_LM__i_pf_2_BAR_config_1_reg__BAR4A = "i_client_LM__i_pf_2_BAR_config_1_reg__BAR4A"
        i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C = "i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C"
        i_client_LM__i_pf_2_BAR_config_1_reg__BAR5A = "i_client_LM__i_pf_2_BAR_config_1_reg__BAR5A"
        ss_pcie_pf2_exp_rom_bar = "ss_pcie_pf2_exp_rom_bar"
        i_client_LM__i_pf_2_BAR_config_1_reg__ERBC = "i_client_LM__i_pf_2_BAR_config_1_reg__ERBC"
        ss_pcie_pf2_legacy_int_pin = "ss_pcie_pf2_legacy_int_pin"
        i_client_PF2__i_msi_ctrl_reg__MMC = "i_client_PF2__i_msi_ctrl_reg__MMC"
        i_client_PF2__i_msix_ctrl__CID = "i_client_PF2__i_msix_ctrl__CID"
        i_client_PF2__i_msix_ctrl__CP = "i_client_PF2__i_msix_ctrl__CP"
        i_client_PF2__i_msix_ctrl__MSIXTS = "i_client_PF2__i_msix_ctrl__MSIXTS"
        i_client_PF2__i_msix_tbl_offset__TO = "i_client_PF2__i_msix_tbl_offset__TO"
        i_client_PF2__i_msix_tbl_offset__BARI = "i_client_PF2__i_msix_tbl_offset__BARI"
        i_client_PF2__i_msix_pending_intrpt__PBAO = "i_client_PF2__i_msix_pending_intrpt__PBAO"
        i_client_PF2__i_msix_pending_intrpt__BARI1 = "i_client_PF2__i_msix_pending_intrpt__BARI1"
        i_client_PF2__i_vendor_specific_header_reg__VI = "i_client_PF2__i_vendor_specific_header_reg__VI"
        ss_pcie_pf2_vf_subsystem_id = "ss_pcie_pf2_vf_subsystem_id"
        i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C = "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C"
        i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0A = "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0A"
        i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C = "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C"
        i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1A = "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1A"
        i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C = "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C"
        i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2A = "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2A"
        i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C = "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C"
        i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3A = "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3A"
        i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C = "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C"
        i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4A = "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4A"
        i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C = "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C"
        i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5A = "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5A"
        ss_pcie_pf2_vf_msi_mul_message_cap = "ss_pcie_pf2_vf_msi_mul_message_cap"
        ss_pcie_pf2_vf_msix_table_size = "ss_pcie_pf2_vf_msix_table_size"
        ss_pcie_pf2_vf_msix_table_offset = "ss_pcie_pf2_vf_msix_table_offset"
        ss_pcie_pf2_vf_msix_bar_ind = "ss_pcie_pf2_vf_msix_bar_ind"
        ss_pcie_pf2_vf_msix_pba_offset = "ss_pcie_pf2_vf_msix_pba_offset"
        ss_pcie_pf2_vf_msix_pba_ind = "ss_pcie_pf2_vf_msix_pba_ind"
        ss_pcie_pf2_vf_tph_en = "ss_pcie_pf2_vf_tph_en"
        ss_pcie_pf2_vf_steering_tag_tab_loc = "ss_pcie_pf2_vf_steering_tag_tab_loc"
        ss_pcie_pf2_vf_steering_tag_tab_size = "ss_pcie_pf2_vf_steering_tag_tab_size"
        ss_pcie_pf2_vf_ats_en = "ss_pcie_pf2_vf_ats_en"
        i_client_PF3__i_vendor_id_device_id__DID = "i_client_PF3__i_vendor_id_device_id__DID"
        i_client_PF3__i_revision_id_class_code__RID = "i_client_PF3__i_revision_id_class_code__RID"
        i_client_PF3__i_revision_id_class_code__CC = "i_client_PF3__i_revision_id_class_code__CC"
        i_client_PF3__i_revision_id_class_code__SCC = "i_client_PF3__i_revision_id_class_code__SCC"
        i_client_PF3__i_revision_id_class_code__PIB = "i_client_PF3__i_revision_id_class_code__PIB"
        i_client_PF3__i_subsystem_vendor_id_subsystem_i__SID = "i_client_PF3__i_subsystem_vendor_id_subsystem_i__SID"
        i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C = "i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C"
        i_client_LM__i_pf_3_BAR_config_0_reg__BAR0A = "i_client_LM__i_pf_3_BAR_config_0_reg__BAR0A"
        i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C = "i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C"
        i_client_LM__i_pf_3_BAR_config_0_reg__BAR1A = "i_client_LM__i_pf_3_BAR_config_0_reg__BAR1A"
        i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C = "i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C"
        i_client_LM__i_pf_3_BAR_config_0_reg__BAR2A = "i_client_LM__i_pf_3_BAR_config_0_reg__BAR2A"
        i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C = "i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C"
        i_client_LM__i_pf_3_BAR_config_0_reg__BAR3A = "i_client_LM__i_pf_3_BAR_config_0_reg__BAR3A"
        i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C = "i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C"
        i_client_LM__i_pf_3_BAR_config_1_reg__BAR4A = "i_client_LM__i_pf_3_BAR_config_1_reg__BAR4A"
        i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C = "i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C"
        i_client_LM__i_pf_3_BAR_config_1_reg__BAR5A = "i_client_LM__i_pf_3_BAR_config_1_reg__BAR5A"
        ss_pcie_pf3_exp_rom_bar = "ss_pcie_pf3_exp_rom_bar"
        i_client_LM__i_pf_3_BAR_config_1_reg__ERBC = "i_client_LM__i_pf_3_BAR_config_1_reg__ERBC"
        ss_pcie_pf3_legacy_int_pin = "ss_pcie_pf3_legacy_int_pin"
        i_client_PF3__i_msi_ctrl_reg__MMC = "i_client_PF3__i_msi_ctrl_reg__MMC"
        i_client_PF3__i_msix_ctrl__CID = "i_client_PF3__i_msix_ctrl__CID"
        i_client_PF3__i_msix_ctrl__CP = "i_client_PF3__i_msix_ctrl__CP"
        i_client_PF3__i_msix_ctrl__MSIXTS = "i_client_PF3__i_msix_ctrl__MSIXTS"
        i_client_PF3__i_msix_tbl_offset__TO = "i_client_PF3__i_msix_tbl_offset__TO"
        i_client_PF3__i_msix_tbl_offset__BARI = "i_client_PF3__i_msix_tbl_offset__BARI"
        i_client_PF3__i_msix_pending_intrpt__PBAO = "i_client_PF3__i_msix_pending_intrpt__PBAO"
        i_client_PF3__i_msix_pending_intrpt__BARI1 = "i_client_PF3__i_msix_pending_intrpt__BARI1"
        i_client_PF3__i_vendor_specific_header_reg__VI = "i_client_PF3__i_vendor_specific_header_reg__VI"
        ss_pcie_pf3_vf_subsystem_id = "ss_pcie_pf3_vf_subsystem_id"
        i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C = "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C"
        i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0A = "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0A"
        i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C = "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C"
        i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1A = "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1A"
        i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C = "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C"
        i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2A = "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2A"
        i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C = "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C"
        i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3A = "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3A"
        i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C = "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C"
        i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4A = "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4A"
        i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C = "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C"
        i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5A = "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5A"
        ss_pcie_pf3_vf_msi_mul_message_cap = "ss_pcie_pf3_vf_msi_mul_message_cap"
        ss_pcie_pf3_vf_msix_table_size = "ss_pcie_pf3_vf_msix_table_size"
        ss_pcie_pf3_vf_msix_table_offset = "ss_pcie_pf3_vf_msix_table_offset"
        ss_pcie_pf3_vf_msix_bar_ind = "ss_pcie_pf3_vf_msix_bar_ind"
        ss_pcie_pf3_vf_msix_pba_offset = "ss_pcie_pf3_vf_msix_pba_offset"
        ss_pcie_pf3_vf_msix_pba_ind = "ss_pcie_pf3_vf_msix_pba_ind"
        ss_pcie_pf3_vf_tph_en = "ss_pcie_pf3_vf_tph_en"
        ss_pcie_pf3_vf_steering_tag_tab_loc = "ss_pcie_pf3_vf_steering_tag_tab_loc"
        ss_pcie_pf3_vf_steering_tag_tab_size = "ss_pcie_pf3_vf_steering_tag_tab_size"
        ss_pcie_pf3_vf_ats_en = "ss_pcie_pf3_vf_ats_en"


        @classmethod
        def has_member(cls, item: str) -> bool:
            return item in cls._value2member_map_

        @classmethod
        def has_key(cls, item: str) -> bool:
            return item in cls.__members__
