from typing import List
from design.db_item import GenericParam
from common_device.property import PropertyMetaData, RangeValidator
from tx375_device.quad_pcie.quad_pcie_prop_id import QuadPCIEConfigParamInfo as PCIEParamInfo

def build_param_info():
    param_info = PCIEParamInfo()

    prop_data_list: List[PropertyMetaData.PropData] = [
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.PIPE_CONFIG_CMN__config_reg_0__lane_count_in,
                name="PIPE_CONFIG_CMN__config_reg_0__lane_count_in",
                data_type=GenericParam.DataType.dstr,
                default="x4",
                valid_setting=["x4", "x2", "x1"],
                disp_name="Link Width",
                category="Base"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.PIPE_CONFIG_CMN__config_reg_0__mode_select,
                name="PIPE_CONFIG_CMN__config_reg_0__mode_select",
                data_type=GenericParam.DataType.dstr,
                default="Endpoint",
                valid_setting=["Endpoint", "Root Port"],
                disp_name="Mode",
                category="Base"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel,
                name="PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel",
                data_type=GenericParam.DataType.dstr,
                default="Gen4",
                valid_setting=["Gen4", "Gen3",  "Gen2", "Gen1"],
                disp_name="Generation",
                category="Base"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable,
                name="PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Enable SRIOV",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen,
                name="PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen",
                data_type=GenericParam.DataType.dbool,
                default=True,
                disp_name="Enable 50 Ω to ground on-die termination for REFCLK1",
                category="External Clock"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel,
                name="PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel",
                data_type=GenericParam.DataType.dstr,
                default="External",
                valid_setting=[ "External", "Internal"],
                disp_name="Reference Clock Source",
                category="Clock"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_termen,
                name="PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_termen",
                data_type=GenericParam.DataType.dbool,
                default=True,
                disp_name="Enable 50 Ω to ground on-die termination for REFCLK0",
                category="External Clock"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg,
                name="PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg",
                data_type=GenericParam.DataType.dstr,
                default="Refclk 0",
                valid_setting=[ "Refclk 0", "Refclk 1"],
                disp_name="External Reference Clock",
                category="hidden"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_BAR_config_0_reg__BAR0A,
                name="i_client_LM__i_pf_0_BAR_config_0_reg__BAR0A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="BAR0 Aperture",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C,
                name="i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C",
                data_type=GenericParam.DataType.dstr,
                default="32bit non prefetchable memory BAR",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="BAR0 Control",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_BAR_config_0_reg__BAR1A,
                name="i_client_LM__i_pf_0_BAR_config_0_reg__BAR1A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="BAR1 Aperture",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C,
                name="i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="BAR1 Control",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_BAR_config_0_reg__BAR2A,
                name="i_client_LM__i_pf_0_BAR_config_0_reg__BAR2A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="BAR2 Aperture",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C,
                name="i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="BAR2 Control",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_BAR_config_0_reg__BAR3A,
                name="i_client_LM__i_pf_0_BAR_config_0_reg__BAR3A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="BAR3 Aperture",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C,
                name="i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="BAR3 Control",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_BAR_config_1_reg__BAR4A,
                name="i_client_LM__i_pf_0_BAR_config_1_reg__BAR4A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="BAR4 Aperture",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C,
                name="i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="BAR4 Control",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_BAR_config_1_reg__BAR5A,
                name="i_client_LM__i_pf_0_BAR_config_1_reg__BAR5A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="BAR5 Aperture",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C,
                name="i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="BAR5 Control",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_BAR_config_1_reg__ERBC,
                name="i_client_LM__i_pf_0_BAR_config_1_reg__ERBC",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Resizable BAR Enable",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0A,
                name="i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="VF BAR0 Aperture",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C,
                name="i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C",
                data_type=GenericParam.DataType.dstr,
                default="32bit non prefetchable memory BAR",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="VF BAR0 Control",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1A,
                name="i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="VF BAR1 Aperture",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C,
                name="i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="VF BAR1 Control",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2A,
                name="i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="VF BAR2 Aperture",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C,
                name="i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="VF BAR2 Control",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3A,
                name="i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="VF BAR3 Aperture",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C,
                name="i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="VF BAR3 Control",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4A,
                name="i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="VF BAR4 Aperture",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C,
                name="i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="VF BAR4 Control",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5A,
                name="i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="VF BAR5 Aperture",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C,
                name="i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="VF BAR5 Control",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_BAR_config_0_reg__BAR0A,
                name="i_client_LM__i_pf_1_BAR_config_0_reg__BAR0A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="BAR0 Aperture",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C,
                name="i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C",
                data_type=GenericParam.DataType.dstr,
                default="32bit non prefetchable memory BAR",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="BAR0 Control",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_BAR_config_0_reg__BAR1A,
                name="i_client_LM__i_pf_1_BAR_config_0_reg__BAR1A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="BAR1 Aperture",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C,
                name="i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="BAR1 Control",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_BAR_config_0_reg__BAR2A,
                name="i_client_LM__i_pf_1_BAR_config_0_reg__BAR2A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="BAR2 Aperture",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C,
                name="i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="BAR2 Control",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_BAR_config_0_reg__BAR3A,
                name="i_client_LM__i_pf_1_BAR_config_0_reg__BAR3A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="BAR3 Aperture",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C,
                name="i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="BAR3 Control",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_BAR_config_1_reg__BAR4A,
                name="i_client_LM__i_pf_1_BAR_config_1_reg__BAR4A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="BAR4 Aperture",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C,
                name="i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="BAR4 Control",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_BAR_config_1_reg__BAR5A,
                name="i_client_LM__i_pf_1_BAR_config_1_reg__BAR5A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="BAR5 Aperture",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C,
                name="i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="BAR5 Control",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_BAR_config_1_reg__ERBC,
                name="i_client_LM__i_pf_1_BAR_config_1_reg__ERBC",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Resizable BAR Enable",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0A,
                name="i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="VF BAR0 Aperture",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C,
                name="i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C",
                data_type=GenericParam.DataType.dstr,
                default="32bit non prefetchable memory BAR",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="VF BAR0 Control",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1A,
                name="i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="VF BAR1 Aperture",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C,
                name="i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="VF BAR1 Control",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2A,
                name="i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="VF BAR2 Aperture",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C,
                name="i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="VF BAR2 Control",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3A,
                name="i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="VF BAR3 Aperture",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C,
                name="i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="VF BAR3 Control",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4A,
                name="i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="VF BAR4 Aperture",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C,
                name="i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="VF BAR4 Control",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5A,
                name="i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="VF BAR5 Aperture",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C,
                name="i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="VF BAR5 Control",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_BAR_config_0_reg__BAR0A,
                name="i_client_LM__i_pf_2_BAR_config_0_reg__BAR0A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="BAR0 Aperture",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C,
                name="i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C",
                data_type=GenericParam.DataType.dstr,
                default="32bit non prefetchable memory BAR",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="BAR0 Control",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_BAR_config_0_reg__BAR1A,
                name="i_client_LM__i_pf_2_BAR_config_0_reg__BAR1A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="BAR1 Aperture",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C,
                name="i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="BAR1 Control",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_BAR_config_0_reg__BAR2A,
                name="i_client_LM__i_pf_2_BAR_config_0_reg__BAR2A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="BAR2 Aperture",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C,
                name="i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="BAR2 Control",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_BAR_config_0_reg__BAR3A,
                name="i_client_LM__i_pf_2_BAR_config_0_reg__BAR3A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="BAR3 Aperture",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C,
                name="i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="BAR3 Control",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_BAR_config_1_reg__BAR4A,
                name="i_client_LM__i_pf_2_BAR_config_1_reg__BAR4A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="BAR4 Aperture",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C,
                name="i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="BAR4 Control",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_BAR_config_1_reg__BAR5A,
                name="i_client_LM__i_pf_2_BAR_config_1_reg__BAR5A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="BAR5 Aperture",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C,
                name="i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="BAR5 Control",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_BAR_config_1_reg__ERBC,
                name="i_client_LM__i_pf_2_BAR_config_1_reg__ERBC",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Resizable BAR Enable",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0A,
                name="i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="VF BAR0 Aperture",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C,
                name="i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C",
                data_type=GenericParam.DataType.dstr,
                default="32bit non prefetchable memory BAR",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="VF BAR0 Control",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1A,
                name="i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="VF BAR1 Aperture",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C,
                name="i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="VF BAR1 Control",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2A,
                name="i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="VF BAR2 Aperture",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C,
                name="i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="VF BAR2 Control",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3A,
                name="i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="VF BAR3 Aperture",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C,
                name="i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="VF BAR3 Control",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4A,
                name="i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="VF BAR4 Aperture",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C,
                name="i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="VF BAR4 Control",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5A,
                name="i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="VF BAR5 Aperture",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C,
                name="i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="VF BAR5 Control",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_BAR_config_0_reg__BAR0A,
                name="i_client_LM__i_pf_3_BAR_config_0_reg__BAR0A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="BAR0 Aperture",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C,
                name="i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C",
                data_type=GenericParam.DataType.dstr,
                default="32bit non prefetchable memory BAR",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="BAR0 Control",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_BAR_config_0_reg__BAR1A,
                name="i_client_LM__i_pf_3_BAR_config_0_reg__BAR1A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="BAR1 Aperture",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C,
                name="i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="BAR1 Control",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_BAR_config_0_reg__BAR2A,
                name="i_client_LM__i_pf_3_BAR_config_0_reg__BAR2A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="BAR2 Aperture",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C,
                name="i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="BAR2 Control",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_BAR_config_0_reg__BAR3A,
                name="i_client_LM__i_pf_3_BAR_config_0_reg__BAR3A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="BAR3 Aperture",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C,
                name="i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="BAR3 Control",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_BAR_config_1_reg__BAR4A,
                name="i_client_LM__i_pf_3_BAR_config_1_reg__BAR4A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="BAR4 Aperture",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C,
                name="i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="BAR4 Control",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_BAR_config_1_reg__BAR5A,
                name="i_client_LM__i_pf_3_BAR_config_1_reg__BAR5A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="BAR5 Aperture",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C,
                name="i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="BAR5 Control",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_BAR_config_1_reg__ERBC,
                name="i_client_LM__i_pf_3_BAR_config_1_reg__ERBC",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Resizable BAR Enable",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0A,
                name="i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="VF BAR0 Aperture",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C,
                name="i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C",
                data_type=GenericParam.DataType.dstr,
                default="32bit non prefetchable memory BAR",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="VF BAR0 Control",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1A,
                name="i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="VF BAR1 Aperture",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C,
                name="i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="VF BAR1 Control",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2A,
                name="i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="VF BAR2 Aperture",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C,
                name="i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="VF BAR2 Control",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3A,
                name="i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="VF BAR3 Aperture",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C,
                name="i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="VF BAR3 Control",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4A,
                name="i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ]            ,
                disp_name="VF BAR4 Aperture",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C,
                name="i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="VF BAR4 Control",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5A,
                name="i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5A",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=[ "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="VF BAR5 Aperture",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C,
                name="i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="VF BAR5 Control",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_rc_BAR_config_reg__RCBAR0A,
                name="i_client_LM__i_rc_BAR_config_reg__RCBAR0A",
                data_type=GenericParam.DataType.dstr,
                default="4 MB",
                valid_setting=[ "4 B", "8 B", "16 B", "32 B", "64 B", "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "4 GB", "8 GB", "16 GB", "32 GB", "64 GB", "128 GB", "256 GB" ] ,
                disp_name="BAR0 Aperture",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_rc_BAR_config_reg__RCBAR0C,
                name="i_client_LM__i_rc_BAR_config_reg__RCBAR0C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR", "64bit non prefetchable memory BAR", "64bit prefetchable memory BAR" ],
                disp_name="BAR0 Control",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_rc_BAR_config_reg__RCBAR1A,
                name="i_client_LM__i_rc_BAR_config_reg__RCBAR1A",
                data_type=GenericParam.DataType.dstr,
                default="4 MB",
                valid_setting=[ "4 B", "8 B", "16 B", "32 B", "64 B", "128 B", "256 B", "512 B", "1 KB", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB", "32 MB", "64 MB", "128 MB", "256 MB", "512 MB", "1 GB", "2 GB" ],
                disp_name="BAR1 Aperture",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_rc_BAR_config_reg__RCBAR1C,
                name="i_client_LM__i_rc_BAR_config_reg__RCBAR1C",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=[ "Disabled", "32bit IO BAR", "32bit non prefetchable memory BAR", "32bit prefetchable memory BAR" ],
                disp_name="BAR1 Control",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_vendor_id_reg__SVID,
                name="i_client_LM__i_vendor_id_reg__SVID",
                data_type=GenericParam.DataType.dhex,
                default="0x1f7a",
                valid_setting=("0x0", "0xffff"),
                disp_name="Subsystem Vendor ID",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_LM__i_vendor_id_reg__VID,
                name="i_client_LM__i_vendor_id_reg__VID",
                data_type=GenericParam.DataType.dhex,
                default="0x1f7a",
                valid_setting=("0x0", "0xffff"),
                disp_name="Vendor ID",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_L1_PM_cap__L1PrtCmMdReStrTime,
                name="i_client_PF0__i_L1_PM_cap__L1PrtCmMdReStrTime",
                data_type=GenericParam.DataType.dint,
                default=255,
                valid_setting=RangeValidator(0, 255),
                disp_name="Port Common Mode Restore Time (us)",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_L1_PM_cap__L1PrtPvrOnScale,
                name="i_client_PF0__i_L1_PM_cap__L1PrtPvrOnScale",
                data_type=GenericParam.DataType.dstr,
                default="2us",
                valid_setting=["2us", "10us", "100us"],
                disp_name="Port Power On Time Scale",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_L1_PM_cap__R0,
                name="i_client_PF0__i_L1_PM_cap__R0",
                data_type=GenericParam.DataType.dint,
                default=13,
                valid_setting=RangeValidator(0, 31),
                disp_name="Port Power On Time Value",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN,
                name="i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="ASPM L1.1 Substate Enable",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN,
                name="i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="ASPM L1.2 Substate Enable",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_L1_PM_ctrl_1__L1CmMdReStrTime,
                name="i_client_PF0__i_L1_PM_ctrl_1__L1CmMdReStrTime",
                data_type=GenericParam.DataType.dint,
                default=0,
                valid_setting=RangeValidator(0, 255),
                disp_name="Common Mode Restore Time",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN,
                name="i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="PM L1.1 Substate Enable",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN,
                name="i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="PM L1.2 Substate Enable",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldSc,
                name="i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldSc",
                data_type=GenericParam.DataType.dstr,
                default="1ns",
                valid_setting=["1ns", "32ns", "1024ns", "32768ns", "1048576ns","33554422ns"],
                disp_name="LTR L1.2 Threshold Scale",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldVal,
                name="i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldVal",
                data_type=GenericParam.DataType.dint,
                default=0,
                valid_setting=RangeValidator(0, 1023),
                disp_name="LTR L1.2 Threshold Value",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnSc,
                name="i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnSc",
                data_type=GenericParam.DataType.dstr,
                default="2us",
                valid_setting=["2us", "10us", "100us"],
                disp_name="T_POWER_ON Scale",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnVal,
                name="i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnVal",
                data_type=GenericParam.DataType.dint,
                default=5,
                valid_setting=RangeValidator(0, 31),
                disp_name="T_POWER_ON Value",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_dev_ser_num_0__DSND0,
                name="i_client_PF0__i_dev_ser_num_0__DSND0",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xffffffff"),
                disp_name="Device Serial Number (DW1)",
                category="Device Capability"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_dev_ser_num_1__DSND1,
                name="i_client_PF0__i_dev_ser_num_1__DSND1",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xffffffff"),
                disp_name="Device Serial Number (DW2)",
                category="Device Capability"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_func_dep_link_numVFs_reg__NVF,
                name="i_client_PF0__i_func_dep_link_numVFs_reg__NVF",
                data_type=GenericParam.DataType.dint,
                default=0,
                valid_setting=RangeValidator(0, 64),
                disp_name="PF0 VF Count",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_link_cap__PN,
                name="i_client_PF0__i_link_cap__PN",
                data_type=GenericParam.DataType.dint,
                default=0,
                valid_setting=RangeValidator(0, 255),
                disp_name="Link Port Number",
                category="Device Capability"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_link_ctrl_status__SCC,
                name="i_client_PF0__i_link_ctrl_status__SCC",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Enable Slot Clock Configuration",
                category="Device Capability"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_msi_ctrl_reg__MMC,
                name="i_client_PF0__i_msi_ctrl_reg__MMC",
                data_type=GenericParam.DataType.dstr,
                default="1",
                valid_setting=["1", "2", "4", "8", "16", "32"],
                disp_name="MSI Multiple Message Capable",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_msix_ctrl__CID,
                name="i_client_PF0__i_msix_ctrl__CID",
                data_type=GenericParam.DataType.dhex,
                default="0x11",
                valid_setting=("0x0", "0xff"),
                disp_name="MSIX Capability ID",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_msix_ctrl__CP,
                name="i_client_PF0__i_msix_ctrl__CP",
                data_type=GenericParam.DataType.dhex,
                default="0xc0",
                valid_setting=("0x0", "0xff"),
                disp_name="MSIX Capabilities Pointer",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_msix_ctrl__MSIXTS,
                name="i_client_PF0__i_msix_ctrl__MSIXTS",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x7ff"),
                disp_name="MSIX Table Size",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_msix_pending_intrpt__BARI1,
                name="i_client_PF0__i_msix_pending_intrpt__BARI1",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX PBA Indicator",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_msix_pending_intrpt__PBAO,
                name="i_client_PF0__i_msix_pending_intrpt__PBAO",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX PBA Offset",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_msix_tbl_offset__BARI,
                name="i_client_PF0__i_msix_tbl_offset__BARI",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX BAR Indicator",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_msix_tbl_offset__TO,
                name="i_client_PF0__i_msix_tbl_offset__TO",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX Table Offset",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_pcie_dev_ctrl_status__ETFE,
                name="i_client_PF0__i_pcie_dev_ctrl_status__ETFE",
                data_type=GenericParam.DataType.dbool,
                default=True,
                disp_name="Extended Tag Field",
                category="Device Capability"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_revision_id_class_code__CC,
                name="i_client_PF0__i_revision_id_class_code__CC",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Class Code",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_revision_id_class_code__PIB,
                name="i_client_PF0__i_revision_id_class_code__PIB",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Programming Interface Byte",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_revision_id_class_code__RID,
                name="i_client_PF0__i_revision_id_class_code__RID",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Revision ID",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_revision_id_class_code__SCC,
                name="i_client_PF0__i_revision_id_class_code__SCC",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Sub-Class Code",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_subsystem_vendor_id_subsystem_i__SID,
                name="i_client_PF0__i_subsystem_vendor_id_subsystem_i__SID",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xffff"),
                disp_name="Subsystem ID",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_vendor_id_device_id__DID,
                name="i_client_PF0__i_vendor_id_device_id__DID",
                data_type=GenericParam.DataType.dhex,
                default="0x100",
                valid_setting=("0x0", "0xffff"),
                disp_name="Device ID",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF0__i_vendor_specific_header_reg__VI,
                name="i_client_PF0__i_vendor_specific_header_reg__VI",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x0", "0xffff"),
                disp_name="User ID register from Vendor Specific Extended Capability",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_func_dep_link_numVFs_reg__NVF,
                name="i_client_PF1__i_func_dep_link_numVFs_reg__NVF",
                data_type=GenericParam.DataType.dint,
                default=0,
                valid_setting=RangeValidator(0, 64),
                disp_name="PF1 VF Count",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_msi_ctrl_reg__MMC,
                name="i_client_PF1__i_msi_ctrl_reg__MMC",
                data_type=GenericParam.DataType.dstr,
                default="1",
                valid_setting=["1", "2", "4", "8", "16", "32"],
                disp_name="MSI Multiple Message Capable",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_msix_ctrl__CID,
                name="i_client_PF1__i_msix_ctrl__CID",
                data_type=GenericParam.DataType.dhex,
                default="0x11",
                valid_setting=("0x0", "0xff"),
                disp_name="MSIX Capability ID",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_msix_ctrl__CP,
                name="i_client_PF1__i_msix_ctrl__CP",
                data_type=GenericParam.DataType.dhex,
                default="0xc0",
                valid_setting=("0x0", "0xff"),
                disp_name="MSIX Capabilities Pointer",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_msix_ctrl__MSIXTS,
                name="i_client_PF1__i_msix_ctrl__MSIXTS",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x7ff"),
                disp_name="MSIX Table Size",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_msix_pending_intrpt__BARI1,
                name="i_client_PF1__i_msix_pending_intrpt__BARI1",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX PBA Indicator",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_msix_pending_intrpt__PBAO,
                name="i_client_PF1__i_msix_pending_intrpt__PBAO",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX PBA Offset",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_msix_tbl_offset__BARI,
                name="i_client_PF1__i_msix_tbl_offset__BARI",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX BAR Indicator",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_msix_tbl_offset__TO,
                name="i_client_PF1__i_msix_tbl_offset__TO",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX Table Offset",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_revision_id_class_code__CC,
                name="i_client_PF1__i_revision_id_class_code__CC",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Class Code",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_revision_id_class_code__PIB,
                name="i_client_PF1__i_revision_id_class_code__PIB",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Programming Interface Byte",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_revision_id_class_code__RID,
                name="i_client_PF1__i_revision_id_class_code__RID",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Revision ID",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_revision_id_class_code__SCC,
                name="i_client_PF1__i_revision_id_class_code__SCC",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Sub-Class Code",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_subsystem_vendor_id_subsystem_i__SID,
                name="i_client_PF1__i_subsystem_vendor_id_subsystem_i__SID",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xffff"),
                disp_name="Subsystem ID",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_vendor_id_device_id__DID,
                name="i_client_PF1__i_vendor_id_device_id__DID",
                data_type=GenericParam.DataType.dhex,
                default="0x100",
                valid_setting=("0x0", "0xffff"),
                disp_name="Device ID",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF1__i_vendor_specific_header_reg__VI,
                name="i_client_PF1__i_vendor_specific_header_reg__VI",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x0", "0xffff"),
                disp_name="User ID register from Vendor Specific Extended Capability",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_func_dep_link_numVFs_reg__NVF,
                name="i_client_PF2__i_func_dep_link_numVFs_reg__NVF",
                data_type=GenericParam.DataType.dint,
                default=0,
                valid_setting=RangeValidator(0, 64),
                disp_name="PF2 VF Count",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_msi_ctrl_reg__MMC,
                name="i_client_PF2__i_msi_ctrl_reg__MMC",
                data_type=GenericParam.DataType.dstr,
                default="1",
                valid_setting=["1", "2", "4", "8", "16", "32"],
                disp_name="MSI Multiple Message Capable",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_msix_ctrl__CID,
                name="i_client_PF2__i_msix_ctrl__CID",
                data_type=GenericParam.DataType.dhex,
                default="0x11",
                valid_setting=("0x0", "0xff"),
                disp_name="MSIX Capability ID",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_msix_ctrl__CP,
                name="i_client_PF2__i_msix_ctrl__CP",
                data_type=GenericParam.DataType.dhex,
                default="0xc0",
                valid_setting=("0x0", "0xff"),
                disp_name="MSIX Capabilities Pointer",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_msix_ctrl__MSIXTS,
                name="i_client_PF2__i_msix_ctrl__MSIXTS",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x7ff"),
                disp_name="MSIX Table Size",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_msix_pending_intrpt__BARI1,
                name="i_client_PF2__i_msix_pending_intrpt__BARI1",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX PBA Indicator",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_msix_pending_intrpt__PBAO,
                name="i_client_PF2__i_msix_pending_intrpt__PBAO",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX PBA Offset",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_msix_tbl_offset__BARI,
                name="i_client_PF2__i_msix_tbl_offset__BARI",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX BAR Indicator",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_msix_tbl_offset__TO,
                name="i_client_PF2__i_msix_tbl_offset__TO",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX Table Offset",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_revision_id_class_code__CC,
                name="i_client_PF2__i_revision_id_class_code__CC",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Class Code",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_revision_id_class_code__PIB,
                name="i_client_PF2__i_revision_id_class_code__PIB",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Programming Interface Byte",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_revision_id_class_code__RID,
                name="i_client_PF2__i_revision_id_class_code__RID",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Revision ID",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_revision_id_class_code__SCC,
                name="i_client_PF2__i_revision_id_class_code__SCC",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Sub-Class Code",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_subsystem_vendor_id_subsystem_i__SID,
                name="i_client_PF2__i_subsystem_vendor_id_subsystem_i__SID",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xffff"),
                disp_name="Subsystem ID",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_vendor_id_device_id__DID,
                name="i_client_PF2__i_vendor_id_device_id__DID",
                data_type=GenericParam.DataType.dhex,
                default="0x100",
                valid_setting=("0x0", "0xffff"),
                disp_name="Device ID",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF2__i_vendor_specific_header_reg__VI,
                name="i_client_PF2__i_vendor_specific_header_reg__VI",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x0", "0xffff"),
                disp_name="User ID register from Vendor Specific Extended Capability",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_func_dep_link_numVFs_reg__NVF,
                name="i_client_PF3__i_func_dep_link_numVFs_reg__NVF",
                data_type=GenericParam.DataType.dint,
                default=0,
                valid_setting=RangeValidator(0, 64),
                disp_name="PF3 VF Count",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_msi_ctrl_reg__MMC,
                name="i_client_PF3__i_msi_ctrl_reg__MMC",
                data_type=GenericParam.DataType.dstr,
                default="1",
                valid_setting=["1", "2", "4", "8", "16", "32"],
                disp_name="MSI Multiple Message Capable",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_msix_ctrl__CID,
                name="i_client_PF3__i_msix_ctrl__CID",
                data_type=GenericParam.DataType.dhex,
                default="0x11",
                valid_setting=("0x0", "0xff"),
                disp_name="MSIX Capability ID",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_msix_ctrl__CP,
                name="i_client_PF3__i_msix_ctrl__CP",
                data_type=GenericParam.DataType.dhex,
                default="0xc0",
                valid_setting=("0x0", "0xff"),
                disp_name="MSIX Capabilities Pointer",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_msix_ctrl__MSIXTS,
                name="i_client_PF3__i_msix_ctrl__MSIXTS",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x7ff"),
                disp_name="MSIX Table Size",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_msix_pending_intrpt__BARI1,
                name="i_client_PF3__i_msix_pending_intrpt__BARI1",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX PBA Indicator",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_msix_pending_intrpt__PBAO,
                name="i_client_PF3__i_msix_pending_intrpt__PBAO",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX PBA Offset",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_msix_tbl_offset__BARI,
                name="i_client_PF3__i_msix_tbl_offset__BARI",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX BAR Indicator",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_msix_tbl_offset__TO,
                name="i_client_PF3__i_msix_tbl_offset__TO",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX Table Offset",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_revision_id_class_code__CC,
                name="i_client_PF3__i_revision_id_class_code__CC",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Class Code",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_revision_id_class_code__PIB,
                name="i_client_PF3__i_revision_id_class_code__PIB",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Programming Interface Byte",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_revision_id_class_code__RID,
                name="i_client_PF3__i_revision_id_class_code__RID",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Revision ID",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_revision_id_class_code__SCC,
                name="i_client_PF3__i_revision_id_class_code__SCC",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Sub-Class Code",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_subsystem_vendor_id_subsystem_i__SID,
                name="i_client_PF3__i_subsystem_vendor_id_subsystem_i__SID",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xffff"),
                disp_name="Subsystem ID",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_vendor_id_device_id__DID,
                name="i_client_PF3__i_vendor_id_device_id__DID",
                data_type=GenericParam.DataType.dhex,
                default="0x100",
                valid_setting=("0x0", "0xffff"),
                disp_name="Device ID",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_PF3__i_vendor_specific_header_reg__VI,
                name="i_client_PF3__i_vendor_specific_header_reg__VI",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x0", "0xffff"),
                disp_name="User ID register from Vendor Specific Extended Capability",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_L1_PM_cap__L1PrtCmMdReStrTime,
                name="i_client_RC__i_L1_PM_cap__L1PrtCmMdReStrTime",
                data_type=GenericParam.DataType.dint,
                default=255,
                valid_setting=RangeValidator(0, 255),
                disp_name="Port Common Mode Restore Time (us)",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_L1_PM_cap__L1PrtPvrOnScale,
                name="i_client_RC__i_L1_PM_cap__L1PrtPvrOnScale",
                data_type=GenericParam.DataType.dstr,
                default="2us",
                valid_setting=["2us", "10us", "100us"],
                disp_name="Port Power On Time Scale",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_L1_PM_cap__R0,
                name="i_client_RC__i_L1_PM_cap__R0",
                data_type=GenericParam.DataType.dint,
                default=13,
                valid_setting=RangeValidator(0, 31),
                disp_name="Port Power On Time Value",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN,
                name="i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="ASPM L1.1 Substate Enable",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN,
                name="i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="ASPM L1.2 Substate Enable",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_L1_PM_ctrl_1__L1CmMdReStrTime,
                name="i_client_RC__i_L1_PM_ctrl_1__L1CmMdReStrTime",
                data_type=GenericParam.DataType.dint,
                default=0,
                valid_setting=RangeValidator(0, 255),
                disp_name="Common Mode Restore Time",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_L1_PM_ctrl_1__L1PML11EN,
                name="i_client_RC__i_L1_PM_ctrl_1__L1PML11EN",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="PM L1.1 Substate Enable",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_L1_PM_ctrl_1__L1PML12EN,
                name="i_client_RC__i_L1_PM_ctrl_1__L1PML12EN",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="PM L1.2 Substate Enable",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_L1_PM_ctrl_1__L1ThrshldSc,
                name="i_client_RC__i_L1_PM_ctrl_1__L1ThrshldSc",
                data_type=GenericParam.DataType.dstr,
                default="1ns",
                valid_setting=["1ns", "32ns", "1024ns", "32768ns", "1048576ns","33554422ns"],
                disp_name="LTR L1.2 Threshold Scale",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_L1_PM_ctrl_1__L1ThrshldVal,
                name="i_client_RC__i_L1_PM_ctrl_1__L1ThrshldVal",
                data_type=GenericParam.DataType.dint,
                default=0,
                valid_setting=RangeValidator(0, 1023),
                disp_name="LTR L1.2 Threshold Value",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_L1_PM_ctrl_2__L1PwrOnSc,
                name="i_client_RC__i_L1_PM_ctrl_2__L1PwrOnSc",
                data_type=GenericParam.DataType.dstr,
                default="2us",
                valid_setting=["2us", "10us", "100us"],
                disp_name="T_POWER_ON Scale",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_L1_PM_ctrl_2__L1PwrOnVal,
                name="i_client_RC__i_L1_PM_ctrl_2__L1PwrOnVal",
                data_type=GenericParam.DataType.dint,
                default=5,
                valid_setting=RangeValidator(0, 31),
                disp_name="T_POWER_ON Value",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_dev_ser_num_0__DSND0,
                name="i_client_RC__i_dev_ser_num_0__DSND0",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xffffffff"),
                disp_name="Device Serial Number (DW1)",
                category="Device Capability"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_dev_ser_num_1__DSND1,
                name="i_client_RC__i_dev_ser_num_1__DSND1",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xffffffff"),
                disp_name="Device Serial Number (DW2)",
                category="Device Capability"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_link_cap__PN,
                name="i_client_RC__i_link_cap__PN",
                data_type=GenericParam.DataType.dint,
                default=0,
                valid_setting=RangeValidator(0, 255),
                disp_name="Link Port Number",
                category="Device Capability"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_link_ctrl_status__ASPMC,
                name="i_client_RC__i_link_ctrl_status__ASPMC",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=["Disabled", "L0s Entry", "L1 Entry", "L0s and L1 Entry"],
                disp_name="ASPM Enable",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_link_ctrl_status__SCC,
                name="i_client_RC__i_link_ctrl_status__SCC",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Enable Slot Clock Configuration",
                category="Device Capability"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_pcie_cap__MP,
                name="i_client_RC__i_pcie_cap__MP",
                data_type=GenericParam.DataType.dstr,
                default="512 bytes",
                valid_setting=[ "128 bytes", "256 bytes", "512 bytes"],
                disp_name="Maximum Payload Size",
                category="Base"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_pcie_dev_ctrl_status__ETE,
                name="i_client_RC__i_pcie_dev_ctrl_status__ETE",
                data_type=GenericParam.DataType.dbool,
                default=True,
                disp_name="Extended Tag Field",
                category="Device Capability"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_revision_id_class_code__CC,
                name="i_client_RC__i_revision_id_class_code__CC",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Programming Interface Byte",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_revision_id_class_code__PIB,
                name="i_client_RC__i_revision_id_class_code__PIB",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Class Code",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_revision_id_class_code__RID,
                name="i_client_RC__i_revision_id_class_code__RID",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Revision ID",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_revision_id_class_code__SCC,
                name="i_client_RC__i_revision_id_class_code__SCC",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xff"),
                disp_name="Sub-Class Code",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_slot_capability__PSN,
                name="i_client_RC__i_slot_capability__PSN",
                data_type=GenericParam.DataType.dint,
                default=0,
                valid_setting=RangeValidator(0, 8191),
                disp_name="Slot Number",
                category="Device Capability"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_slot_capability__SPLS,
                name="i_client_RC__i_slot_capability__SPLS",
                data_type=GenericParam.DataType.dstr,
                default="1.0x",
                valid_setting=["1.0x", "0.1x", "0.01x", "0.001x"],
                disp_name="Slot Power Limit Scale",
                category="Device Capability"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_slot_capability__SPLV,
                name="i_client_RC__i_slot_capability__SPLV",
                data_type=GenericParam.DataType.dint,
                default=0,
                valid_setting=RangeValidator(0, 255),
                disp_name="Slot Power Limit Value",
                category="Device Capability"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.i_client_RC__i_vendor_id_device_id__DID,
                name="i_client_RC__i_vendor_id_device_id__DID",
                data_type=GenericParam.DataType.dhex,
                default="0x100",
                valid_setting=("0x0", "0xffff"),
                disp_name="Device ID",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.pcr_bypass_cmn_ready,
                name="pcr_bypass_cmn_ready",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="pcr bypass cmn ready",
                category="hidden"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.pcr_clear_sticky,
                name="pcr_clear_sticky",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="pcr clear sticky",
                category="hidden"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.pcr_q0_bypass_cfgtop,
                name="pcr_q0_bypass_cfgtop",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="pcr q0 bypass cfgtop",
                category="hidden"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.pcr_q0_user_phy_reset_n_expose,
                name="pcr_q0_user_phy_reset_n_expose",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="pcr q0 user phy reset n expose",
                category="hidden"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.pcr_q1_bypass_cfgtop,
                name="pcr_q1_bypass_cfgtop",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="pcr q1 bypass cfgtop",
                category="hidden"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.pcr_q1_user_phy_reset_n_expose,
                name="pcr_q1_user_phy_reset_n_expose",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="pcr q1 user phy reset n expose",
                category="hidden"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_MPS,
                name="ss_pcie_MPS",
                data_type=GenericParam.DataType.dstr,
                default="512 bytes",
                valid_setting=[ "128 bytes", "256 bytes", "512 bytes"],
                disp_name="Maximum Payload Size",
                category="Base"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_aspm,
                name="ss_pcie_aspm",
                data_type=GenericParam.DataType.dstr,
                default="Disabled",
                valid_setting=["Disabled", "L0s Entry", "L1 Entry", "L0s and L1 Entry"],
                disp_name="ASPM Enable",
                category="Power Management"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_gen3_rx_preset,
                name="ss_pcie_gen3_rx_preset",
                data_type=GenericParam.DataType.dhex,
                default="0x3",
                valid_setting=("0x0", "0x6"),
                disp_name="Gen3 Equalization RX Preset ",
                category="Base"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_gen3_tx_preset,
                name="ss_pcie_gen3_tx_preset",
                data_type=GenericParam.DataType.dhex,
                default="0x3",
                valid_setting=("0x0", "0xa"),
                disp_name="Gen3 Equalization TX Preset ",
                category="Base"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_gen4_tx_preset,
                name="ss_pcie_gen4_tx_preset",
                data_type=GenericParam.DataType.dhex,
                default="0x2",
                valid_setting=("0x0", "0xa"),
                disp_name="Gen4 Equalization TX Preset ",
                category="Base"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf0_exp_rom_bar,
                name="ss_pcie_pf0_exp_rom_bar",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=["Disabled", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB"],
                disp_name="Expansion ROM BAR Aperture",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf0_legacy_int_pin,
                name="ss_pcie_pf0_legacy_int_pin",
                data_type=GenericParam.DataType.dstr,
                default="NO INT",
                valid_setting=["NO INT", "INTA", "INTB", "INTC", "INTD"],
                disp_name="Interrupt Pin ",
                category="Physical Function 0"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf0_vf_ats_en,
                name="ss_pcie_pf0_vf_ats_en",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="ATS Enable",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf0_vf_msi_mul_message_cap,
                name="ss_pcie_pf0_vf_msi_mul_message_cap",
                data_type=GenericParam.DataType.dstr,
                default="1",
                valid_setting=["1", "2", "4", "8", "16", "32"],
                disp_name="MSI Multiple Message Capable",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf0_vf_msix_bar_ind,
                name="ss_pcie_pf0_vf_msix_bar_ind",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX BAR Indicator",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf0_vf_msix_pba_ind,
                name="ss_pcie_pf0_vf_msix_pba_ind",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX PBA Indicator",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf0_vf_msix_pba_offset,
                name="ss_pcie_pf0_vf_msix_pba_offset",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX PBA Offset",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf0_vf_msix_table_offset,
                name="ss_pcie_pf0_vf_msix_table_offset",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX Table Offset",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf0_vf_msix_table_size,
                name="ss_pcie_pf0_vf_msix_table_size",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x7ff"),
                disp_name="MSIX Table Size",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf0_vf_steering_tag_tab_loc,
                name="ss_pcie_pf0_vf_steering_tag_tab_loc",
                data_type=GenericParam.DataType.dstr,
                default="ST Table in the TPH Requester Capability Structure",
                valid_setting=["ST Table not present", "ST Table in the TPH Requester Capability Structure", "ST values stored in the MSI-X Table in client RAM"],
                disp_name="Steering Tag Table Location",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf0_vf_steering_tag_tab_size,
                name="ss_pcie_pf0_vf_steering_tag_tab_size",
                data_type=GenericParam.DataType.dint,
                default=7,
                valid_setting=RangeValidator(0, 2047),
                disp_name="Steering Tag Table Size",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf0_vf_subsystem_id,
                name="ss_pcie_pf0_vf_subsystem_id",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xffff"),
                disp_name="Subsystem ID",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf0_vf_tph_en,
                name="ss_pcie_pf0_vf_tph_en",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Enable TPH",
                category="Physical Function 0 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf1_exp_rom_bar,
                name="ss_pcie_pf1_exp_rom_bar",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=["Disabled", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB"],
                disp_name="Expansion ROM BAR Aperture",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf1_legacy_int_pin,
                name="ss_pcie_pf1_legacy_int_pin",
                data_type=GenericParam.DataType.dstr,
                default="NO INT",
                valid_setting=["NO INT", "INTA", "INTB", "INTC", "INTD"],
                disp_name="Interrupt Pin ",
                category="Physical Function 1"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf1_vf_ats_en,
                name="ss_pcie_pf1_vf_ats_en",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="ATS Enable",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf1_vf_msi_mul_message_cap,
                name="ss_pcie_pf1_vf_msi_mul_message_cap",
                data_type=GenericParam.DataType.dstr,
                default="1",
                valid_setting=["1", "2", "4", "8", "16", "32"],
                disp_name="MSI Multiple Message Capable",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf1_vf_msix_bar_ind,
                name="ss_pcie_pf1_vf_msix_bar_ind",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX BAR Indicator",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf1_vf_msix_pba_ind,
                name="ss_pcie_pf1_vf_msix_pba_ind",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX PBA Indicator",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf1_vf_msix_pba_offset,
                name="ss_pcie_pf1_vf_msix_pba_offset",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX PBA Offset",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf1_vf_msix_table_offset,
                name="ss_pcie_pf1_vf_msix_table_offset",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX Table Offset",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf1_vf_msix_table_size,
                name="ss_pcie_pf1_vf_msix_table_size",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x7ff"),
                disp_name="MSIX Table Size",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf1_vf_steering_tag_tab_loc,
                name="ss_pcie_pf1_vf_steering_tag_tab_loc",
                data_type=GenericParam.DataType.dstr,
                default="ST Table in the TPH Requester Capability Structure",
                valid_setting=["ST Table not present", "ST Table in the TPH Requester Capability Structure", "ST values stored in the MSI-X Table in client RAM"],
                disp_name="Steering Tag Table Location",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf1_vf_steering_tag_tab_size,
                name="ss_pcie_pf1_vf_steering_tag_tab_size",
                data_type=GenericParam.DataType.dint,
                default=7,
                valid_setting=RangeValidator(0, 2047),
                disp_name="Steering Tag Table Size",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf1_vf_subsystem_id,
                name="ss_pcie_pf1_vf_subsystem_id",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xffff"),
                disp_name="Subsystem ID",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf1_vf_tph_en,
                name="ss_pcie_pf1_vf_tph_en",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Enable TPH",
                category="Physical Function 1 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf2_exp_rom_bar,
                name="ss_pcie_pf2_exp_rom_bar",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=["Disabled", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB"],
                disp_name="Expansion ROM BAR Aperture",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf2_legacy_int_pin,
                name="ss_pcie_pf2_legacy_int_pin",
                data_type=GenericParam.DataType.dstr,
                default="NO INT",
                valid_setting=["NO INT", "INTA", "INTB", "INTC", "INTD"],
                disp_name="Interrupt Pin ",
                category="Physical Function 2"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf2_vf_ats_en,
                name="ss_pcie_pf2_vf_ats_en",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="ATS Enable",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf2_vf_msi_mul_message_cap,
                name="ss_pcie_pf2_vf_msi_mul_message_cap",
                data_type=GenericParam.DataType.dstr,
                default="1",
                valid_setting=["1", "2", "4", "8", "16", "32"],
                disp_name="MSI Multiple Message Capable",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf2_vf_msix_bar_ind,
                name="ss_pcie_pf2_vf_msix_bar_ind",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX BAR Indicator",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf2_vf_msix_pba_ind,
                name="ss_pcie_pf2_vf_msix_pba_ind",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX PBA Indicator",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf2_vf_msix_pba_offset,
                name="ss_pcie_pf2_vf_msix_pba_offset",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX PBA Offset",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf2_vf_msix_table_offset,
                name="ss_pcie_pf2_vf_msix_table_offset",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX Table Offset",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf2_vf_msix_table_size,
                name="ss_pcie_pf2_vf_msix_table_size",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x7ff"),
                disp_name="MSIX Table Size",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf2_vf_steering_tag_tab_loc,
                name="ss_pcie_pf2_vf_steering_tag_tab_loc",
                data_type=GenericParam.DataType.dstr,
                default="ST Table in the TPH Requester Capability Structure",
                valid_setting=["ST Table not present", "ST Table in the TPH Requester Capability Structure", "ST values stored in the MSI-X Table in client RAM"],
                disp_name="Steering Tag Table Location",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf2_vf_steering_tag_tab_size,
                name="ss_pcie_pf2_vf_steering_tag_tab_size",
                data_type=GenericParam.DataType.dint,
                default=7,
                valid_setting=RangeValidator(0, 2047),
                disp_name="Steering Tag Table Size",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf2_vf_subsystem_id,
                name="ss_pcie_pf2_vf_subsystem_id",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xffff"),
                disp_name="Subsystem ID",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf2_vf_tph_en,
                name="ss_pcie_pf2_vf_tph_en",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Enable TPH",
                category="Physical Function 2 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf3_exp_rom_bar,
                name="ss_pcie_pf3_exp_rom_bar",
                data_type=GenericParam.DataType.dstr,
                default="4 KB",
                valid_setting=["Disabled", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB"],
                disp_name="Expansion ROM BAR Aperture",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf3_legacy_int_pin,
                name="ss_pcie_pf3_legacy_int_pin",
                data_type=GenericParam.DataType.dstr,
                default="NO INT",
                valid_setting=["NO INT", "INTA", "INTB", "INTC", "INTD"],
                disp_name="Interrupt Pin ",
                category="Physical Function 3"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf3_vf_ats_en,
                name="ss_pcie_pf3_vf_ats_en",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="ATS Enable",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf3_vf_msi_mul_message_cap,
                name="ss_pcie_pf3_vf_msi_mul_message_cap",
                data_type=GenericParam.DataType.dstr,
                default="1",
                valid_setting=["1", "2", "4", "8", "16", "32"],
                disp_name="MSI Multiple Message Capable",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf3_vf_msix_bar_ind,
                name="ss_pcie_pf3_vf_msix_bar_ind",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX BAR Indicator",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf3_vf_msix_pba_ind,
                name="ss_pcie_pf3_vf_msix_pba_ind",
                data_type=GenericParam.DataType.dstr,
                default="BAR0",
                valid_setting=["BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"],
                disp_name="MSIX PBA Indicator",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf3_vf_msix_pba_offset,
                name="ss_pcie_pf3_vf_msix_pba_offset",
                data_type=GenericParam.DataType.dhex,
                default="0x1",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX PBA Offset",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf3_vf_msix_table_offset,
                name="ss_pcie_pf3_vf_msix_table_offset",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x1fffffff"),
                disp_name="MSIX Table Offset",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf3_vf_msix_table_size,
                name="ss_pcie_pf3_vf_msix_table_size",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0x7ff"),
                disp_name="MSIX Table Size",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf3_vf_steering_tag_tab_loc,
                name="ss_pcie_pf3_vf_steering_tag_tab_loc",
                data_type=GenericParam.DataType.dstr,
                default="ST Table in the TPH Requester Capability Structure",
                valid_setting=["ST Table not present", "ST Table in the TPH Requester Capability Structure", "ST values stored in the MSI-X Table in client RAM"],
                disp_name="Steering Tag Table Location",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf3_vf_steering_tag_tab_size,
                name="ss_pcie_pf3_vf_steering_tag_tab_size",
                data_type=GenericParam.DataType.dint,
                default=7,
                valid_setting=RangeValidator(0, 2047),
                disp_name="Steering Tag Table Size",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf3_vf_subsystem_id,
                name="ss_pcie_pf3_vf_subsystem_id",
                data_type=GenericParam.DataType.dhex,
                default="0x0",
                valid_setting=("0x0", "0xffff"),
                disp_name="Subsystem ID",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf3_vf_tph_en,
                name="ss_pcie_pf3_vf_tph_en",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="TPH Enable",
                category="Physical Function 3 - Virtual Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pf_num,
                name="ss_pcie_pf_num",
                data_type=GenericParam.DataType.dint,
                default=4,
                valid_setting=RangeValidator(1, 4),
                disp_name="Total Physical Functions",
                category="Function"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_pmclk_divsel,
                name="ss_pcie_pmclk_divsel",
                data_type=GenericParam.DataType.dstr,
                default="DIV2",
                valid_setting=["Disabled", "DIV2", "DIV4", "DIV8"],
                disp_name="ss pcie pmclk divsel",
                category="hidden"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_pcie_sris_en,
                name="ss_pcie_sris_en",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="SRIS Enable",
                category="Base"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_plllc1_refclk_sel,
                name="ss_plllc1_refclk_sel",
                data_type=GenericParam.DataType.dstr,
                default="Refclk 1",
                valid_setting=[ "Disabled","Refclk 0", "Refclk 1"],
                disp_name="PLL LC1 Refclk Selection",
                category="hidden"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_refclk_onboard_osc,
                name="ss_refclk_onboard_osc",
                data_type=GenericParam.DataType.dbool,
                default=True,
                disp_name="Reference clock from on-board crystal",
                category="hidden"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_sim_enable,
                name="ss_sim_enable",
                data_type=GenericParam.DataType.dstr,
                default="Speed up",
                valid_setting=["Speed up", "Non-speed up", "Disabled"],
                disp_name="ss sim enable",
                category="hidden"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_topology_lane0,
                name="ss_topology_lane0",
                data_type=GenericParam.DataType.dstr,
                default="PCIe",
                valid_setting=["PCIe", "10GE", "1GE", "Raw Serdes", "Disabled"],
                disp_name="ss topology lane0",
                category="hidden"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_topology_lane1,
                name="ss_topology_lane1",
                data_type=GenericParam.DataType.dstr,
                default="PCIe",
                valid_setting=["PCIe", "10GE", "1GE", "Raw Serdes", "Disabled"],
                disp_name="ss topology lane1",
                category="hidden"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_topology_lane2,
                name="ss_topology_lane2",
                data_type=GenericParam.DataType.dstr,
                default="PCIe",
                valid_setting=["PCIe", "10GE", "1GE", "Raw Serdes", "Disabled"],
                disp_name="ss topology lane2",
                category="hidden"),
        PropertyMetaData.PropData(id=PCIEParamInfo.Id.ss_topology_lane3,
                name="ss_topology_lane3",
                data_type=GenericParam.DataType.dstr,
                default="PCIe",
                valid_setting=["PCIe", "10GE", "1GE", "Raw Serdes", "Disabled"],
                disp_name="ss topology lane3",
                category="hidden"),
        ]

    for prop_data in prop_data_list:
        param_info.add_prop_by_data(prop_data.id, prop_data)

    return param_info

def get_hidden_parameters():
    return [
        "PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable",
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen",
        "i_client_LM__i_pf_0_BAR_config_1_reg__ERBC",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0A",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1A",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2A",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3A",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C",
        "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4A",
        "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C",
        "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5A",
        "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C",
        "i_client_LM__i_pf_1_BAR_config_1_reg__ERBC",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0A",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1A",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2A",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3A",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C",
        "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4A",
        "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C",
        "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5A",
        "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C",
        "i_client_LM__i_pf_2_BAR_config_1_reg__ERBC",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0A",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1A",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2A",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3A",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C",
        "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4A",
        "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C",
        "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5A",
        "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C",
        "i_client_LM__i_pf_3_BAR_config_1_reg__ERBC",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0A",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1A",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2A",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3A",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C",
        "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4A",
        "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C",
        "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5A",
        "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C",
        "i_client_LM__i_rc_BAR_config_reg__RCBAR0A",
        "i_client_LM__i_rc_BAR_config_reg__RCBAR0C",
        "i_client_LM__i_rc_BAR_config_reg__RCBAR1A",
        "i_client_LM__i_rc_BAR_config_reg__RCBAR1C",
        "i_client_PF0__i_L1_PM_cap__L1PrtCmMdReStrTime",
        "i_client_PF0__i_L1_PM_cap__L1PrtPvrOnScale",
        "i_client_PF0__i_L1_PM_cap__R0",
        "i_client_PF0__i_L1_PM_ctrl_1__L1CmMdReStrTime",
        "i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldSc",
        "i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldVal",
        "i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnSc",
        "i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnVal",
        "i_client_PF0__i_func_dep_link_numVFs_reg__NVF",
        "i_client_PF1__i_func_dep_link_numVFs_reg__NVF",
        "i_client_PF2__i_func_dep_link_numVFs_reg__NVF",
        "i_client_PF3__i_func_dep_link_numVFs_reg__NVF",
        "i_client_RC__i_L1_PM_cap__L1PrtCmMdReStrTime",
        "i_client_RC__i_L1_PM_cap__L1PrtPvrOnScale",
        "i_client_RC__i_L1_PM_cap__R0",
        "i_client_RC__i_L1_PM_ctrl_1__L1CmMdReStrTime",
        "i_client_RC__i_L1_PM_ctrl_1__L1ThrshldSc",
        "i_client_RC__i_L1_PM_ctrl_1__L1ThrshldVal",
        "i_client_RC__i_L1_PM_ctrl_2__L1PwrOnSc",
        "i_client_RC__i_L1_PM_ctrl_2__L1PwrOnVal",
        "i_client_RC__i_dev_ser_num_0__DSND0",
        "i_client_RC__i_dev_ser_num_1__DSND1",
        "i_client_RC__i_link_cap__PN",
        "i_client_RC__i_link_ctrl_status__SCC",
        "i_client_RC__i_pcie_dev_ctrl_status__ETE",
        "i_client_RC__i_slot_capability__PSN",
        "i_client_RC__i_slot_capability__SPLS",
        "i_client_RC__i_slot_capability__SPLV",
        "pcr_bypass_cmn_ready",
        "pcr_clear_sticky",
        "pcr_q0_bypass_cfgtop",
        "pcr_q0_user_phy_reset_n_expose",
        "pcr_q1_bypass_cfgtop",
        "pcr_q1_user_phy_reset_n_expose",
        "pll_ref_clk0",
        "pll_ref_clk1",
        "ref_clk_pin_name",
        "ss_pcie_pf0_vf_ats_en",
        "ss_pcie_pf0_vf_msi_mul_message_cap",
        "ss_pcie_pf0_vf_msix_bar_ind",
        "ss_pcie_pf0_vf_msix_pba_ind",
        "ss_pcie_pf0_vf_msix_pba_offset",
        "ss_pcie_pf0_vf_msix_table_offset",
        "ss_pcie_pf0_vf_msix_table_size",
        "ss_pcie_pf0_vf_steering_tag_tab_loc",
        "ss_pcie_pf0_vf_steering_tag_tab_size",
        "ss_pcie_pf0_vf_subsystem_id",
        "ss_pcie_pf0_vf_tph_en",
        "ss_pcie_pf1_vf_ats_en",
        "ss_pcie_pf1_vf_msi_mul_message_cap",
        "ss_pcie_pf1_vf_msix_bar_ind",
        "ss_pcie_pf1_vf_msix_pba_ind",
        "ss_pcie_pf1_vf_msix_pba_offset",
        "ss_pcie_pf1_vf_msix_table_offset",
        "ss_pcie_pf1_vf_msix_table_size",
        "ss_pcie_pf1_vf_steering_tag_tab_loc",
        "ss_pcie_pf1_vf_steering_tag_tab_size",
        "ss_pcie_pf1_vf_subsystem_id",
        "ss_pcie_pf1_vf_tph_en",
        "ss_pcie_pf2_vf_ats_en",
        "ss_pcie_pf2_vf_msi_mul_message_cap",
        "ss_pcie_pf2_vf_msix_bar_ind",
        "ss_pcie_pf2_vf_msix_pba_ind",
        "ss_pcie_pf2_vf_msix_pba_offset",
        "ss_pcie_pf2_vf_msix_table_offset",
        "ss_pcie_pf2_vf_msix_table_size",
        "ss_pcie_pf2_vf_steering_tag_tab_loc",
        "ss_pcie_pf2_vf_steering_tag_tab_size",
        "ss_pcie_pf2_vf_subsystem_id",
        "ss_pcie_pf2_vf_tph_en",
        "ss_pcie_pf3_vf_ats_en",
        "ss_pcie_pf3_vf_msi_mul_message_cap",
        "ss_pcie_pf3_vf_msix_bar_ind",
        "ss_pcie_pf3_vf_msix_pba_ind",
        "ss_pcie_pf3_vf_msix_pba_offset",
        "ss_pcie_pf3_vf_msix_table_offset",
        "ss_pcie_pf3_vf_msix_table_size",
        "ss_pcie_pf3_vf_steering_tag_tab_loc",
        "ss_pcie_pf3_vf_steering_tag_tab_size",
        "ss_pcie_pf3_vf_subsystem_id",
        "ss_pcie_pf3_vf_tph_en",
        "ss_pcie_pmclk_divsel",
        "ss_plllc1_refclk_sel",
        "ss_sim_enable",
        "ss_topology_lane0",
        "ss_topology_lane1",
        "ss_topology_lane2",
        "ss_topology_lane3",
    ]

# Remove the list of params if they are patched (reduce the runtime)
def get_removed_parameters():
    return [
    ]

def get_hidden_param_values():
    param2value_map = {
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel": ['Internal'],
        "PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg": ['Refclk 1'],
    }
    return param2value_map

def get_display_values():
    return {
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_rc_BAR_config_reg__RCBAR0C": {'32bit': '32 bit', '64bit': '64 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
        "i_client_LM__i_rc_BAR_config_reg__RCBAR1C": {'32bit': '32 bit', 'non prefetchable': 'non-prefetchable', 'IO': 'I/O'},
    }
