from functools import partial
from common_device.property import PropertyMetaData
from common_gui.base_dep_graph import DependencyGraph
from design.db_item import GenericPinGroup


class QuadPCIEConfigDependencyGraph(DependencyGraph):
    def build_param_dependency(self, param_info: PropertyMetaData, port_info: GenericPinGroup):
        self.add_param_dependency(
           param_a_name='PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg',
           param_b_name='PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_termen',
           change_func=partial(self.on_parent_param_changed, condition_str='PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg="Refclk 0"'))
        self.add_param_dependency(
           param_a_name='PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg',
           param_b_name='PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen',
           change_func=partial(self.on_parent_param_changed, condition_str='PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg="Refclk 1"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_refclk_onboard_osc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_MPS',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_pcie_cap__MP',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_sris_en',
           change_func=partial(self.on_parent_param_changed, condition_str='(PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_aspm == "Disabled") || (PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port" && i_client_RC__i_link_ctrl_status__ASPMC == "Disabled")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_aspm',
           param_b_name='ss_pcie_sris_en',
           change_func=partial(self.on_parent_param_changed, condition_str='(PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_aspm == "Disabled") || (PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port" && i_client_RC__i_link_ctrl_status__ASPMC == "Disabled")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_sris_en',
           change_func=partial(self.on_parent_param_changed, condition_str='(PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_aspm == "Disabled") || (PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port" && i_client_RC__i_link_ctrl_status__ASPMC == "Disabled")'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_link_ctrl_status__ASPMC',
           param_b_name='ss_pcie_sris_en',
           change_func=partial(self.on_parent_param_changed, condition_str='(PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_aspm == "Disabled") || (PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port" && i_client_RC__i_link_ctrl_status__ASPMC == "Disabled")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_gen4_tx_preset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel=="Gen4"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel',
           param_b_name='ss_pcie_gen4_tx_preset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel=="Gen4"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_gen3_rx_preset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel=="Gen4" || PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel=="Gen3")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel',
           param_b_name='ss_pcie_gen3_rx_preset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel=="Gen4" || PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel=="Gen3")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel',
           param_b_name='ss_pcie_gen3_rx_preset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel=="Gen4" || PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel=="Gen3")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_gen3_tx_preset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel=="Gen4" || PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel=="Gen3")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel',
           param_b_name='ss_pcie_gen3_tx_preset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel=="Gen4" || PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel=="Gen3")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel',
           param_b_name='ss_pcie_gen3_tx_preset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel=="Gen4" || PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel=="Gen3")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_aspm',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='ss_pcie_aspm',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (ss_pcie_aspm=="L1 Entry" || ss_pcie_aspm=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_aspm',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (ss_pcie_aspm=="L1 Entry" || ss_pcie_aspm=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_aspm',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (ss_pcie_aspm=="L1 Entry" || ss_pcie_aspm=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (ss_pcie_aspm=="L1 Entry" || ss_pcie_aspm=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (ss_pcie_aspm=="L1 Entry" || ss_pcie_aspm=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_aspm',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (ss_pcie_aspm=="L1 Entry" || ss_pcie_aspm=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_aspm',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (ss_pcie_aspm=="L1 Entry" || ss_pcie_aspm=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (ss_pcie_aspm=="L1 Entry" || ss_pcie_aspm=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_L1_PM_cap__L1PrtCmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_PF0__i_L1_PM_cap__L1PrtCmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_PF0__i_L1_PM_cap__L1PrtCmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_PF0__i_L1_PM_cap__L1PrtCmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_PF0__i_L1_PM_cap__L1PrtCmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_PF0__i_L1_PM_cap__L1PrtCmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_L1_PM_cap__L1PrtPvrOnScale',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_PF0__i_L1_PM_cap__L1PrtPvrOnScale',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_PF0__i_L1_PM_cap__L1PrtPvrOnScale',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_PF0__i_L1_PM_cap__L1PrtPvrOnScale',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_PF0__i_L1_PM_cap__L1PrtPvrOnScale',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_PF0__i_L1_PM_cap__L1PrtPvrOnScale',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_L1_PM_cap__R0',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_PF0__i_L1_PM_cap__R0',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_PF0__i_L1_PM_cap__R0',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_PF0__i_L1_PM_cap__R0',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_PF0__i_L1_PM_cap__R0',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_PF0__i_L1_PM_cap__R0',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1CmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1CmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1CmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1CmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1CmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1CmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && (((i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_link_ctrl_status__ASPMC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_RC__i_link_ctrl_status__ASPMC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (i_client_RC__i_link_ctrl_status__ASPMC=="L1 Entry" || i_client_RC__i_link_ctrl_status__ASPMC=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_link_ctrl_status__ASPMC',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (i_client_RC__i_link_ctrl_status__ASPMC=="L1 Entry" || i_client_RC__i_link_ctrl_status__ASPMC=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_link_ctrl_status__ASPMC',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (i_client_RC__i_link_ctrl_status__ASPMC=="L1 Entry" || i_client_RC__i_link_ctrl_status__ASPMC=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (i_client_RC__i_link_ctrl_status__ASPMC=="L1 Entry" || i_client_RC__i_link_ctrl_status__ASPMC=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (i_client_RC__i_link_ctrl_status__ASPMC=="L1 Entry" || i_client_RC__i_link_ctrl_status__ASPMC=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_link_ctrl_status__ASPMC',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (i_client_RC__i_link_ctrl_status__ASPMC=="L1 Entry" || i_client_RC__i_link_ctrl_status__ASPMC=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_link_ctrl_status__ASPMC',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (i_client_RC__i_link_ctrl_status__ASPMC=="L1 Entry" || i_client_RC__i_link_ctrl_status__ASPMC=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (i_client_RC__i_link_ctrl_status__ASPMC=="L1 Entry" || i_client_RC__i_link_ctrl_status__ASPMC=="L0s and L1 Entry") && ss_pcie_sris_en !=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1PML11EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1PML12EN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_L1_PM_cap__L1PrtCmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_RC__i_L1_PM_cap__L1PrtCmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_RC__i_L1_PM_cap__L1PrtCmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_RC__i_L1_PM_cap__L1PrtCmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_RC__i_L1_PM_cap__L1PrtCmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_RC__i_L1_PM_cap__L1PrtCmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_L1_PM_cap__L1PrtPvrOnScale',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_RC__i_L1_PM_cap__L1PrtPvrOnScale',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_RC__i_L1_PM_cap__L1PrtPvrOnScale',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_RC__i_L1_PM_cap__L1PrtPvrOnScale',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_RC__i_L1_PM_cap__L1PrtPvrOnScale',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_RC__i_L1_PM_cap__L1PrtPvrOnScale',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_L1_PM_cap__R0',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_RC__i_L1_PM_cap__R0',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_RC__i_L1_PM_cap__R0',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_RC__i_L1_PM_cap__R0',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_RC__i_L1_PM_cap__R0',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_RC__i_L1_PM_cap__R0',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1CmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1CmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1CmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1CmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1CmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1CmMdReStrTime',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ThrshldSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ThrshldSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ThrshldSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ThrshldSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ThrshldSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ThrshldSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ThrshldVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ThrshldVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ThrshldVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ThrshldVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ThrshldVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_1__L1ThrshldVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_L1_PM_ctrl_2__L1PwrOnSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_2__L1PwrOnSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_2__L1PwrOnSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_RC__i_L1_PM_ctrl_2__L1PwrOnSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_2__L1PwrOnSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_2__L1PwrOnSc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_L1_PM_ctrl_2__L1PwrOnVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_2__L1PwrOnVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_2__L1PwrOnVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='ss_pcie_sris_en',
           param_b_name='i_client_RC__i_L1_PM_ctrl_2__L1PwrOnVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML11EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_2__L1PwrOnVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='i_client_RC__i_L1_PM_ctrl_1__L1PML12EN',
           param_b_name='i_client_RC__i_L1_PM_ctrl_2__L1PwrOnVal',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (((i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN==1) && ss_pcie_sris_en !=1) || i_client_RC__i_L1_PM_ctrl_1__L1PML11EN==1 || i_client_RC__i_L1_PM_ctrl_1__L1PML12EN==1)'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_pcie_dev_ctrl_status__ETFE',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_link_cap__PN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_link_ctrl_status__SCC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_dev_ser_num_0__DSND0',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_dev_ser_num_1__DSND1',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_pcie_dev_ctrl_status__ETE',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_link_cap__PN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_link_ctrl_status__SCC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_slot_capability__SPLS',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_slot_capability__SPLV',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_slot_capability__PSN',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_dev_ser_num_0__DSND0',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_dev_ser_num_1__DSND1',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf_num',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_func_dep_link_numVFs_reg__NVF',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_PF0__i_func_dep_link_numVFs_reg__NVF',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_func_dep_link_numVFs_reg__NVF',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_func_dep_link_numVFs_reg__NVF',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_PF1__i_func_dep_link_numVFs_reg__NVF',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_func_dep_link_numVFs_reg__NVF',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_func_dep_link_numVFs_reg__NVF',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_PF2__i_func_dep_link_numVFs_reg__NVF',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_func_dep_link_numVFs_reg__NVF',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_func_dep_link_numVFs_reg__NVF',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_PF3__i_func_dep_link_numVFs_reg__NVF',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_func_dep_link_numVFs_reg__NVF',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_vendor_id_device_id__DID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_revision_id_class_code__RID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_revision_id_class_code__PIB',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_revision_id_class_code__SCC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_RC__i_revision_id_class_code__CC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_rc_BAR_config_reg__RCBAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_rc_BAR_config_reg__RCBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port "'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_rc_BAR_config_reg__RCBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (i_client_LM__i_rc_BAR_config_reg__RCBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_rc_BAR_config_reg__RCBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_rc_BAR_config_reg__RCBAR0C',
           param_b_name='i_client_LM__i_rc_BAR_config_reg__RCBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (i_client_LM__i_rc_BAR_config_reg__RCBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_rc_BAR_config_reg__RCBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_rc_BAR_config_reg__RCBAR0C',
           param_b_name='i_client_LM__i_rc_BAR_config_reg__RCBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (i_client_LM__i_rc_BAR_config_reg__RCBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_rc_BAR_config_reg__RCBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_rc_BAR_config_reg__RCBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (i_client_LM__i_rc_BAR_config_reg__RCBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_rc_BAR_config_reg__RCBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_rc_BAR_config_reg__RCBAR0C',
           param_b_name='i_client_LM__i_rc_BAR_config_reg__RCBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (i_client_LM__i_rc_BAR_config_reg__RCBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_rc_BAR_config_reg__RCBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_rc_BAR_config_reg__RCBAR0C',
           param_b_name='i_client_LM__i_rc_BAR_config_reg__RCBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Root Port " && (i_client_LM__i_rc_BAR_config_reg__RCBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_rc_BAR_config_reg__RCBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_vendor_id_device_id__DID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_vendor_id_device_id__DID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_revision_id_class_code__RID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_revision_id_class_code__RID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_revision_id_class_code__CC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_revision_id_class_code__CC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_revision_id_class_code__SCC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_revision_id_class_code__SCC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_revision_id_class_code__PIB',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_revision_id_class_code__PIB',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_subsystem_vendor_id_subsystem_i__SID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_subsystem_vendor_id_subsystem_i__SID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1  && (i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1  && (i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1  && (i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1  && (i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_0_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf0_exp_rom_bar',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf0_exp_rom_bar',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__ERBC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_BAR_config_1_reg__ERBC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf0_legacy_int_pin',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf0_legacy_int_pin',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_msi_ctrl_reg__MMC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_msi_ctrl_reg__MMC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf0_legacy_int_pin',
           param_b_name='i_client_PF0__i_msi_ctrl_reg__MMC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_msix_ctrl__CID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_msix_ctrl__CID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf0_legacy_int_pin',
           param_b_name='i_client_PF0__i_msix_ctrl__CID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_msix_ctrl__CP',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_msix_ctrl__CP',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf0_legacy_int_pin',
           param_b_name='i_client_PF0__i_msix_ctrl__CP',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_msix_ctrl__MSIXTS',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_msix_ctrl__MSIXTS',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf0_legacy_int_pin',
           param_b_name='i_client_PF0__i_msix_ctrl__MSIXTS',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_msix_tbl_offset__TO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_msix_tbl_offset__TO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf0_legacy_int_pin',
           param_b_name='i_client_PF0__i_msix_tbl_offset__TO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_msix_tbl_offset__BARI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_msix_tbl_offset__BARI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf0_legacy_int_pin',
           param_b_name='i_client_PF0__i_msix_tbl_offset__BARI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_msix_pending_intrpt__PBAO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_msix_pending_intrpt__PBAO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf0_legacy_int_pin',
           param_b_name='i_client_PF0__i_msix_pending_intrpt__PBAO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_msix_pending_intrpt__BARI1',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_msix_pending_intrpt__BARI1',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf0_legacy_int_pin',
           param_b_name='i_client_PF0__i_msix_pending_intrpt__BARI1',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF0__i_vendor_specific_header_reg__VI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF0__i_vendor_specific_header_reg__VI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf0_vf_subsystem_id',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf0_vf_subsystem_id',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf0_vf_subsystem_id',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && (i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf0_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf0_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf0_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf0_legacy_int_pin',
           param_b_name='ss_pcie_pf0_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf0_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf0_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf0_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf0_legacy_int_pin',
           param_b_name='ss_pcie_pf0_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf0_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf0_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf0_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf0_legacy_int_pin',
           param_b_name='ss_pcie_pf0_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf0_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf0_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf0_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf0_legacy_int_pin',
           param_b_name='ss_pcie_pf0_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf0_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf0_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf0_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf0_legacy_int_pin',
           param_b_name='ss_pcie_pf0_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf0_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf0_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf0_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf0_legacy_int_pin',
           param_b_name='ss_pcie_pf0_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1 && ss_pcie_pf0_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf0_vf_tph_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf0_vf_tph_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf0_vf_tph_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf0_vf_steering_tag_tab_loc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf0_vf_steering_tag_tab_loc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf0_vf_steering_tag_tab_loc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf0_vf_steering_tag_tab_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf0_vf_steering_tag_tab_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf0_vf_steering_tag_tab_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf0_vf_ats_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf0_vf_ats_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf0_vf_ats_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=1'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_vendor_id_device_id__DID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_vendor_id_device_id__DID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_revision_id_class_code__RID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_revision_id_class_code__RID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_revision_id_class_code__CC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_revision_id_class_code__CC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_revision_id_class_code__SCC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_revision_id_class_code__SCC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_revision_id_class_code__PIB',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_revision_id_class_code__PIB',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_subsystem_vendor_id_subsystem_i__SID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_subsystem_vendor_id_subsystem_i__SID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2  && (i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2  && (i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2  && (i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2  && (i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_1_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf1_exp_rom_bar',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf1_exp_rom_bar',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__ERBC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_BAR_config_1_reg__ERBC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf1_legacy_int_pin',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf1_legacy_int_pin',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_msi_ctrl_reg__MMC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_msi_ctrl_reg__MMC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf1_legacy_int_pin',
           param_b_name='i_client_PF1__i_msi_ctrl_reg__MMC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_msix_ctrl__CID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_msix_ctrl__CID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf1_legacy_int_pin',
           param_b_name='i_client_PF1__i_msix_ctrl__CID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_msix_ctrl__CP',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_msix_ctrl__CP',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf1_legacy_int_pin',
           param_b_name='i_client_PF1__i_msix_ctrl__CP',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_msix_ctrl__MSIXTS',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_msix_ctrl__MSIXTS',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf1_legacy_int_pin',
           param_b_name='i_client_PF1__i_msix_ctrl__MSIXTS',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_msix_tbl_offset__TO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_msix_tbl_offset__TO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf1_legacy_int_pin',
           param_b_name='i_client_PF1__i_msix_tbl_offset__TO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_msix_tbl_offset__BARI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_msix_tbl_offset__BARI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf1_legacy_int_pin',
           param_b_name='i_client_PF1__i_msix_tbl_offset__BARI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_msix_pending_intrpt__PBAO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_msix_pending_intrpt__PBAO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf1_legacy_int_pin',
           param_b_name='i_client_PF1__i_msix_pending_intrpt__PBAO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_msix_pending_intrpt__BARI1',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_msix_pending_intrpt__BARI1',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf1_legacy_int_pin',
           param_b_name='i_client_PF1__i_msix_pending_intrpt__BARI1',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF1__i_vendor_specific_header_reg__VI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF1__i_vendor_specific_header_reg__VI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf1_vf_subsystem_id',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf1_vf_subsystem_id',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf1_vf_subsystem_id',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && (i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf1_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf1_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf1_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf1_legacy_int_pin',
           param_b_name='ss_pcie_pf1_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf1_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf1_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf1_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf1_legacy_int_pin',
           param_b_name='ss_pcie_pf1_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf1_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf1_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf1_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf1_legacy_int_pin',
           param_b_name='ss_pcie_pf1_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf1_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf1_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf1_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf1_legacy_int_pin',
           param_b_name='ss_pcie_pf1_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf1_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf1_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf1_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf1_legacy_int_pin',
           param_b_name='ss_pcie_pf1_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf1_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf1_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf1_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf1_legacy_int_pin',
           param_b_name='ss_pcie_pf1_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2 && ss_pcie_pf1_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf1_vf_tph_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf1_vf_tph_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf1_vf_tph_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf1_vf_steering_tag_tab_loc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf1_vf_steering_tag_tab_loc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf1_vf_steering_tag_tab_loc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf1_vf_steering_tag_tab_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf1_vf_steering_tag_tab_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf1_vf_steering_tag_tab_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf1_vf_ats_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf1_vf_ats_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf1_vf_ats_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=2'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_vendor_id_device_id__DID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_vendor_id_device_id__DID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_revision_id_class_code__RID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_revision_id_class_code__RID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_revision_id_class_code__CC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_revision_id_class_code__CC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_revision_id_class_code__SCC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_revision_id_class_code__SCC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_revision_id_class_code__PIB',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_revision_id_class_code__PIB',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_subsystem_vendor_id_subsystem_i__SID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_subsystem_vendor_id_subsystem_i__SID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3  && (i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3  && (i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3  && (i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3  && (i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_2_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf2_exp_rom_bar',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf2_exp_rom_bar',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__ERBC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_BAR_config_1_reg__ERBC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf2_legacy_int_pin',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf2_legacy_int_pin',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_msi_ctrl_reg__MMC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_msi_ctrl_reg__MMC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf2_legacy_int_pin',
           param_b_name='i_client_PF2__i_msi_ctrl_reg__MMC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_msix_ctrl__CID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_msix_ctrl__CID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf2_legacy_int_pin',
           param_b_name='i_client_PF2__i_msix_ctrl__CID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_msix_ctrl__CP',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_msix_ctrl__CP',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf2_legacy_int_pin',
           param_b_name='i_client_PF2__i_msix_ctrl__CP',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_msix_ctrl__MSIXTS',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_msix_ctrl__MSIXTS',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf2_legacy_int_pin',
           param_b_name='i_client_PF2__i_msix_ctrl__MSIXTS',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_msix_tbl_offset__TO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_msix_tbl_offset__TO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf2_legacy_int_pin',
           param_b_name='i_client_PF2__i_msix_tbl_offset__TO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_msix_tbl_offset__BARI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_msix_tbl_offset__BARI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf2_legacy_int_pin',
           param_b_name='i_client_PF2__i_msix_tbl_offset__BARI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_msix_pending_intrpt__PBAO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_msix_pending_intrpt__PBAO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf2_legacy_int_pin',
           param_b_name='i_client_PF2__i_msix_pending_intrpt__PBAO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_msix_pending_intrpt__BARI1',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_msix_pending_intrpt__BARI1',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf2_legacy_int_pin',
           param_b_name='i_client_PF2__i_msix_pending_intrpt__BARI1',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF2__i_vendor_specific_header_reg__VI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF2__i_vendor_specific_header_reg__VI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf2_vf_subsystem_id',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf2_vf_subsystem_id',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf2_vf_subsystem_id',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && (i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf2_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf2_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf2_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf2_legacy_int_pin',
           param_b_name='ss_pcie_pf2_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf2_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf2_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf2_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf2_legacy_int_pin',
           param_b_name='ss_pcie_pf2_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf2_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf2_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf2_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf2_legacy_int_pin',
           param_b_name='ss_pcie_pf2_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf2_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf2_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf2_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf2_legacy_int_pin',
           param_b_name='ss_pcie_pf2_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf2_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf2_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf2_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf2_legacy_int_pin',
           param_b_name='ss_pcie_pf2_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf2_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf2_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf2_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf2_legacy_int_pin',
           param_b_name='ss_pcie_pf2_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3 && ss_pcie_pf2_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf2_vf_tph_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf2_vf_tph_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf2_vf_tph_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf2_vf_steering_tag_tab_loc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf2_vf_steering_tag_tab_loc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf2_vf_steering_tag_tab_loc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf2_vf_steering_tag_tab_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf2_vf_steering_tag_tab_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf2_vf_steering_tag_tab_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf2_vf_ats_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf2_vf_ats_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf2_vf_ats_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=3'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_vendor_id_device_id__DID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_vendor_id_device_id__DID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_revision_id_class_code__RID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_revision_id_class_code__RID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_revision_id_class_code__CC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_revision_id_class_code__CC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_revision_id_class_code__SCC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_revision_id_class_code__SCC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_revision_id_class_code__PIB',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_revision_id_class_code__PIB',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_subsystem_vendor_id_subsystem_i__SID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_subsystem_vendor_id_subsystem_i__SID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_0_reg__BAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4  && (i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4  && (i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4  && (i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4  && (i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_1_reg__ERBC',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__BAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C!="Disabled" && i_client_LM__i_pf_3_BAR_config_1_reg__ERBC==0  && (i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf3_exp_rom_bar',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf3_exp_rom_bar',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__ERBC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_BAR_config_1_reg__ERBC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf3_legacy_int_pin',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf3_legacy_int_pin',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_msi_ctrl_reg__MMC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4  && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_msi_ctrl_reg__MMC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4  && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf3_legacy_int_pin',
           param_b_name='i_client_PF3__i_msi_ctrl_reg__MMC',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4  && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_msix_ctrl__CID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_msix_ctrl__CID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf3_legacy_int_pin',
           param_b_name='i_client_PF3__i_msix_ctrl__CID',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_msix_ctrl__CP',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_msix_ctrl__CP',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf3_legacy_int_pin',
           param_b_name='i_client_PF3__i_msix_ctrl__CP',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_msix_ctrl__MSIXTS',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_msix_ctrl__MSIXTS',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf3_legacy_int_pin',
           param_b_name='i_client_PF3__i_msix_ctrl__MSIXTS',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_msix_tbl_offset__TO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_msix_tbl_offset__TO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf3_legacy_int_pin',
           param_b_name='i_client_PF3__i_msix_tbl_offset__TO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_msix_tbl_offset__BARI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_msix_tbl_offset__BARI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf3_legacy_int_pin',
           param_b_name='i_client_PF3__i_msix_tbl_offset__BARI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_msix_pending_intrpt__PBAO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_msix_pending_intrpt__PBAO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf3_legacy_int_pin',
           param_b_name='i_client_PF3__i_msix_pending_intrpt__PBAO',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_msix_pending_intrpt__BARI1',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_msix_pending_intrpt__BARI1',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf3_legacy_int_pin',
           param_b_name='i_client_PF3__i_msix_pending_intrpt__BARI1',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_PF3__i_vendor_specific_header_reg__VI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_PF3__i_vendor_specific_header_reg__VI',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf3_vf_subsystem_id',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf3_vf_subsystem_id',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf3_vf_subsystem_id',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C!="Disabled"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && (i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C',
           param_b_name='i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5A',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C!="Disabled" && (i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit non prefetchable memory BAR" && i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C != "64bit prefetchable memory BAR")'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf3_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf3_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf3_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf3_legacy_int_pin',
           param_b_name='ss_pcie_pf3_vf_msi_mul_message_cap',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf3_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf3_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf3_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf3_legacy_int_pin',
           param_b_name='ss_pcie_pf3_vf_msix_table_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf3_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf3_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf3_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf3_legacy_int_pin',
           param_b_name='ss_pcie_pf3_vf_msix_table_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf3_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf3_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf3_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf3_legacy_int_pin',
           param_b_name='ss_pcie_pf3_vf_msix_bar_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf3_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf3_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf3_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf3_legacy_int_pin',
           param_b_name='ss_pcie_pf3_vf_msix_pba_offset',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf3_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf3_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf3_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf3_legacy_int_pin',
           param_b_name='ss_pcie_pf3_vf_msix_pba_ind',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4 && ss_pcie_pf3_legacy_int_pin == "NO INT"'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf3_vf_tph_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf3_vf_tph_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf3_vf_tph_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf3_vf_steering_tag_tab_loc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf3_vf_steering_tag_tab_loc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf3_vf_steering_tag_tab_loc',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf3_vf_steering_tag_tab_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf3_vf_steering_tag_tab_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf3_vf_steering_tag_tab_size',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__mode_select',
           param_b_name='ss_pcie_pf3_vf_ats_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable',
           param_b_name='ss_pcie_pf3_vf_ats_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))
        self.add_param_dependency(
           param_a_name='ss_pcie_pf_num',
           param_b_name='ss_pcie_pf3_vf_ats_en',
           change_func=partial(self.on_parent_param_changed, condition_str='PIPE_CONFIG_CMN__config_reg_0__mode_select=="Endpoint" && PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable==1 && ss_pcie_pf_num>=4'))

def get_params_with_hidden_conditions():
    return [
        "PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR0A",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR1A",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR2A",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR3A",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C",
        "i_client_LM__i_pf_0_BAR_config_1_reg__BAR4A",
        "i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C",
        "i_client_LM__i_pf_0_BAR_config_1_reg__BAR5A",
        "i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C",
        "i_client_LM__i_pf_0_BAR_config_1_reg__ERBC",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0A",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1A",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2A",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3A",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C",
        "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4A",
        "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C",
        "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5A",
        "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR0A",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR1A",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR2A",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR3A",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C",
        "i_client_LM__i_pf_1_BAR_config_1_reg__BAR4A",
        "i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C",
        "i_client_LM__i_pf_1_BAR_config_1_reg__BAR5A",
        "i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C",
        "i_client_LM__i_pf_1_BAR_config_1_reg__ERBC",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0A",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1A",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2A",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3A",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C",
        "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4A",
        "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C",
        "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5A",
        "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR0A",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR1A",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR2A",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR3A",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C",
        "i_client_LM__i_pf_2_BAR_config_1_reg__BAR4A",
        "i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C",
        "i_client_LM__i_pf_2_BAR_config_1_reg__BAR5A",
        "i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C",
        "i_client_LM__i_pf_2_BAR_config_1_reg__ERBC",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0A",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1A",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2A",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3A",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C",
        "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4A",
        "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C",
        "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5A",
        "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR0A",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR1A",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR2A",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR3A",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C",
        "i_client_LM__i_pf_3_BAR_config_1_reg__BAR4A",
        "i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C",
        "i_client_LM__i_pf_3_BAR_config_1_reg__BAR5A",
        "i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C",
        "i_client_LM__i_pf_3_BAR_config_1_reg__ERBC",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0A",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1A",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2A",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3A",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C",
        "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4A",
        "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C",
        "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5A",
        "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C",
        "i_client_LM__i_rc_BAR_config_reg__RCBAR0A",
        "i_client_LM__i_rc_BAR_config_reg__RCBAR0C",
        "i_client_LM__i_rc_BAR_config_reg__RCBAR1A",
        "i_client_LM__i_rc_BAR_config_reg__RCBAR1C",
        "i_client_PF0__i_L1_PM_cap__L1PrtCmMdReStrTime",
        "i_client_PF0__i_L1_PM_cap__L1PrtPvrOnScale",
        "i_client_PF0__i_L1_PM_cap__R0",
        "i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN",
        "i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN",
        "i_client_PF0__i_L1_PM_ctrl_1__L1CmMdReStrTime",
        "i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN",
        "i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN",
        "i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldSc",
        "i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldVal",
        "i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnSc",
        "i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnVal",
        "i_client_PF0__i_dev_ser_num_0__DSND0",
        "i_client_PF0__i_dev_ser_num_1__DSND1",
        "i_client_PF0__i_func_dep_link_numVFs_reg__NVF",
        "i_client_PF0__i_link_cap__PN",
        "i_client_PF0__i_link_ctrl_status__SCC",
        "i_client_PF0__i_msi_ctrl_reg__MMC",
        "i_client_PF0__i_msix_ctrl__CID",
        "i_client_PF0__i_msix_ctrl__CP",
        "i_client_PF0__i_msix_ctrl__MSIXTS",
        "i_client_PF0__i_msix_pending_intrpt__BARI1",
        "i_client_PF0__i_msix_pending_intrpt__PBAO",
        "i_client_PF0__i_msix_tbl_offset__BARI",
        "i_client_PF0__i_msix_tbl_offset__TO",
        "i_client_PF0__i_pcie_dev_ctrl_status__ETFE",
        "i_client_PF0__i_revision_id_class_code__CC",
        "i_client_PF0__i_revision_id_class_code__PIB",
        "i_client_PF0__i_revision_id_class_code__RID",
        "i_client_PF0__i_revision_id_class_code__SCC",
        "i_client_PF0__i_subsystem_vendor_id_subsystem_i__SID",
        "i_client_PF0__i_vendor_id_device_id__DID",
        "i_client_PF0__i_vendor_specific_header_reg__VI",
        "i_client_PF1__i_func_dep_link_numVFs_reg__NVF",
        "i_client_PF1__i_msi_ctrl_reg__MMC",
        "i_client_PF1__i_msix_ctrl__CID",
        "i_client_PF1__i_msix_ctrl__CP",
        "i_client_PF1__i_msix_ctrl__MSIXTS",
        "i_client_PF1__i_msix_pending_intrpt__BARI1",
        "i_client_PF1__i_msix_pending_intrpt__PBAO",
        "i_client_PF1__i_msix_tbl_offset__BARI",
        "i_client_PF1__i_msix_tbl_offset__TO",
        "i_client_PF1__i_revision_id_class_code__CC",
        "i_client_PF1__i_revision_id_class_code__PIB",
        "i_client_PF1__i_revision_id_class_code__RID",
        "i_client_PF1__i_revision_id_class_code__SCC",
        "i_client_PF1__i_subsystem_vendor_id_subsystem_i__SID",
        "i_client_PF1__i_vendor_id_device_id__DID",
        "i_client_PF1__i_vendor_specific_header_reg__VI",
        "i_client_PF2__i_func_dep_link_numVFs_reg__NVF",
        "i_client_PF2__i_msi_ctrl_reg__MMC",
        "i_client_PF2__i_msix_ctrl__CID",
        "i_client_PF2__i_msix_ctrl__CP",
        "i_client_PF2__i_msix_ctrl__MSIXTS",
        "i_client_PF2__i_msix_pending_intrpt__BARI1",
        "i_client_PF2__i_msix_pending_intrpt__PBAO",
        "i_client_PF2__i_msix_tbl_offset__BARI",
        "i_client_PF2__i_msix_tbl_offset__TO",
        "i_client_PF2__i_revision_id_class_code__CC",
        "i_client_PF2__i_revision_id_class_code__PIB",
        "i_client_PF2__i_revision_id_class_code__RID",
        "i_client_PF2__i_revision_id_class_code__SCC",
        "i_client_PF2__i_subsystem_vendor_id_subsystem_i__SID",
        "i_client_PF2__i_vendor_id_device_id__DID",
        "i_client_PF2__i_vendor_specific_header_reg__VI",
        "i_client_PF3__i_func_dep_link_numVFs_reg__NVF",
        "i_client_PF3__i_msi_ctrl_reg__MMC",
        "i_client_PF3__i_msix_ctrl__CID",
        "i_client_PF3__i_msix_ctrl__CP",
        "i_client_PF3__i_msix_ctrl__MSIXTS",
        "i_client_PF3__i_msix_pending_intrpt__BARI1",
        "i_client_PF3__i_msix_pending_intrpt__PBAO",
        "i_client_PF3__i_msix_tbl_offset__BARI",
        "i_client_PF3__i_msix_tbl_offset__TO",
        "i_client_PF3__i_revision_id_class_code__CC",
        "i_client_PF3__i_revision_id_class_code__PIB",
        "i_client_PF3__i_revision_id_class_code__RID",
        "i_client_PF3__i_revision_id_class_code__SCC",
        "i_client_PF3__i_subsystem_vendor_id_subsystem_i__SID",
        "i_client_PF3__i_vendor_id_device_id__DID",
        "i_client_PF3__i_vendor_specific_header_reg__VI",
        "i_client_RC__i_L1_PM_cap__L1PrtCmMdReStrTime",
        "i_client_RC__i_L1_PM_cap__L1PrtPvrOnScale",
        "i_client_RC__i_L1_PM_cap__R0",
        "i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN",
        "i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN",
        "i_client_RC__i_L1_PM_ctrl_1__L1CmMdReStrTime",
        "i_client_RC__i_L1_PM_ctrl_1__L1PML11EN",
        "i_client_RC__i_L1_PM_ctrl_1__L1PML12EN",
        "i_client_RC__i_L1_PM_ctrl_1__L1ThrshldSc",
        "i_client_RC__i_L1_PM_ctrl_1__L1ThrshldVal",
        "i_client_RC__i_L1_PM_ctrl_2__L1PwrOnSc",
        "i_client_RC__i_L1_PM_ctrl_2__L1PwrOnVal",
        "i_client_RC__i_dev_ser_num_0__DSND0",
        "i_client_RC__i_dev_ser_num_1__DSND1",
        "i_client_RC__i_link_cap__PN",
        "i_client_RC__i_link_ctrl_status__ASPMC",
        "i_client_RC__i_link_ctrl_status__SCC",
        "i_client_RC__i_pcie_cap__MP",
        "i_client_RC__i_pcie_dev_ctrl_status__ETE",
        "i_client_RC__i_revision_id_class_code__CC",
        "i_client_RC__i_revision_id_class_code__PIB",
        "i_client_RC__i_revision_id_class_code__RID",
        "i_client_RC__i_revision_id_class_code__SCC",
        "i_client_RC__i_slot_capability__PSN",
        "i_client_RC__i_slot_capability__SPLS",
        "i_client_RC__i_slot_capability__SPLV",
        "i_client_RC__i_vendor_id_device_id__DID",
        "ss_pcie_MPS",
        "ss_pcie_aspm",
        "ss_pcie_gen3_rx_preset",
        "ss_pcie_gen3_tx_preset",
        "ss_pcie_gen4_tx_preset",
        "ss_pcie_pf0_exp_rom_bar",
        "ss_pcie_pf0_legacy_int_pin",
        "ss_pcie_pf0_vf_ats_en",
        "ss_pcie_pf0_vf_msi_mul_message_cap",
        "ss_pcie_pf0_vf_msix_bar_ind",
        "ss_pcie_pf0_vf_msix_pba_ind",
        "ss_pcie_pf0_vf_msix_pba_offset",
        "ss_pcie_pf0_vf_msix_table_offset",
        "ss_pcie_pf0_vf_msix_table_size",
        "ss_pcie_pf0_vf_steering_tag_tab_loc",
        "ss_pcie_pf0_vf_steering_tag_tab_size",
        "ss_pcie_pf0_vf_subsystem_id",
        "ss_pcie_pf0_vf_tph_en",
        "ss_pcie_pf1_exp_rom_bar",
        "ss_pcie_pf1_legacy_int_pin",
        "ss_pcie_pf1_vf_ats_en",
        "ss_pcie_pf1_vf_msi_mul_message_cap",
        "ss_pcie_pf1_vf_msix_bar_ind",
        "ss_pcie_pf1_vf_msix_pba_ind",
        "ss_pcie_pf1_vf_msix_pba_offset",
        "ss_pcie_pf1_vf_msix_table_offset",
        "ss_pcie_pf1_vf_msix_table_size",
        "ss_pcie_pf1_vf_steering_tag_tab_loc",
        "ss_pcie_pf1_vf_steering_tag_tab_size",
        "ss_pcie_pf1_vf_subsystem_id",
        "ss_pcie_pf1_vf_tph_en",
        "ss_pcie_pf2_exp_rom_bar",
        "ss_pcie_pf2_legacy_int_pin",
        "ss_pcie_pf2_vf_ats_en",
        "ss_pcie_pf2_vf_msi_mul_message_cap",
        "ss_pcie_pf2_vf_msix_bar_ind",
        "ss_pcie_pf2_vf_msix_pba_ind",
        "ss_pcie_pf2_vf_msix_pba_offset",
        "ss_pcie_pf2_vf_msix_table_offset",
        "ss_pcie_pf2_vf_msix_table_size",
        "ss_pcie_pf2_vf_steering_tag_tab_loc",
        "ss_pcie_pf2_vf_steering_tag_tab_size",
        "ss_pcie_pf2_vf_subsystem_id",
        "ss_pcie_pf2_vf_tph_en",
        "ss_pcie_pf3_exp_rom_bar",
        "ss_pcie_pf3_legacy_int_pin",
        "ss_pcie_pf3_vf_ats_en",
        "ss_pcie_pf3_vf_msi_mul_message_cap",
        "ss_pcie_pf3_vf_msix_bar_ind",
        "ss_pcie_pf3_vf_msix_pba_ind",
        "ss_pcie_pf3_vf_msix_pba_offset",
        "ss_pcie_pf3_vf_msix_table_offset",
        "ss_pcie_pf3_vf_msix_table_size",
        "ss_pcie_pf3_vf_steering_tag_tab_loc",
        "ss_pcie_pf3_vf_steering_tag_tab_size",
        "ss_pcie_pf3_vf_subsystem_id",
        "ss_pcie_pf3_vf_tph_en",
        "ss_pcie_pf_num",
        "ss_pcie_sris_en",
        "ss_refclk_onboard_osc",
    ]
def get_endpoint_params():
    return [
        "PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR0A",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR1A",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR2A",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR3A",
        "i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C",
        "i_client_LM__i_pf_0_BAR_config_1_reg__BAR4A",
        "i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C",
        "i_client_LM__i_pf_0_BAR_config_1_reg__BAR5A",
        "i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C",
        "i_client_LM__i_pf_0_BAR_config_1_reg__ERBC",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0A",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1A",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2A",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3A",
        "i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C",
        "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4A",
        "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C",
        "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5A",
        "i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR0A",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR1A",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR2A",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR3A",
        "i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C",
        "i_client_LM__i_pf_1_BAR_config_1_reg__BAR4A",
        "i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C",
        "i_client_LM__i_pf_1_BAR_config_1_reg__BAR5A",
        "i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C",
        "i_client_LM__i_pf_1_BAR_config_1_reg__ERBC",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0A",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1A",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2A",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3A",
        "i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C",
        "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4A",
        "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C",
        "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5A",
        "i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR0A",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR1A",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR2A",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR3A",
        "i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C",
        "i_client_LM__i_pf_2_BAR_config_1_reg__BAR4A",
        "i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C",
        "i_client_LM__i_pf_2_BAR_config_1_reg__BAR5A",
        "i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C",
        "i_client_LM__i_pf_2_BAR_config_1_reg__ERBC",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0A",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1A",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2A",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3A",
        "i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C",
        "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4A",
        "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C",
        "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5A",
        "i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR0A",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR1A",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR2A",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR3A",
        "i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C",
        "i_client_LM__i_pf_3_BAR_config_1_reg__BAR4A",
        "i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C",
        "i_client_LM__i_pf_3_BAR_config_1_reg__BAR5A",
        "i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C",
        "i_client_LM__i_pf_3_BAR_config_1_reg__ERBC",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0A",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1A",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2A",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3A",
        "i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C",
        "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4A",
        "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C",
        "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5A",
        "i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C",
        "i_client_PF0__i_L1_PM_cap__L1PrtCmMdReStrTime",
        "i_client_PF0__i_L1_PM_cap__L1PrtPvrOnScale",
        "i_client_PF0__i_L1_PM_cap__R0",
        "i_client_PF0__i_L1_PM_ctrl_1__L1ASPML11EN",
        "i_client_PF0__i_L1_PM_ctrl_1__L1ASPML12EN",
        "i_client_PF0__i_L1_PM_ctrl_1__L1CmMdReStrTime",
        "i_client_PF0__i_L1_PM_ctrl_1__L1PML11EN",
        "i_client_PF0__i_L1_PM_ctrl_1__L1PML12EN",
        "i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldSc",
        "i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldVal",
        "i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnSc",
        "i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnVal",
        "i_client_PF0__i_dev_ser_num_0__DSND0",
        "i_client_PF0__i_dev_ser_num_1__DSND1",
        "i_client_PF0__i_func_dep_link_numVFs_reg__NVF",
        "i_client_PF0__i_link_cap__PN",
        "i_client_PF0__i_link_ctrl_status__SCC",
        "i_client_PF0__i_msi_ctrl_reg__MMC",
        "i_client_PF0__i_msix_ctrl__CID",
        "i_client_PF0__i_msix_ctrl__CP",
        "i_client_PF0__i_msix_ctrl__MSIXTS",
        "i_client_PF0__i_msix_pending_intrpt__BARI1",
        "i_client_PF0__i_msix_pending_intrpt__PBAO",
        "i_client_PF0__i_msix_tbl_offset__BARI",
        "i_client_PF0__i_msix_tbl_offset__TO",
        "i_client_PF0__i_pcie_dev_ctrl_status__ETFE",
        "i_client_PF0__i_revision_id_class_code__CC",
        "i_client_PF0__i_revision_id_class_code__PIB",
        "i_client_PF0__i_revision_id_class_code__RID",
        "i_client_PF0__i_revision_id_class_code__SCC",
        "i_client_PF0__i_subsystem_vendor_id_subsystem_i__SID",
        "i_client_PF0__i_vendor_id_device_id__DID",
        "i_client_PF0__i_vendor_specific_header_reg__VI",
        "i_client_PF1__i_func_dep_link_numVFs_reg__NVF",
        "i_client_PF1__i_msi_ctrl_reg__MMC",
        "i_client_PF1__i_msix_ctrl__CID",
        "i_client_PF1__i_msix_ctrl__CP",
        "i_client_PF1__i_msix_ctrl__MSIXTS",
        "i_client_PF1__i_msix_pending_intrpt__BARI1",
        "i_client_PF1__i_msix_pending_intrpt__PBAO",
        "i_client_PF1__i_msix_tbl_offset__BARI",
        "i_client_PF1__i_msix_tbl_offset__TO",
        "i_client_PF1__i_revision_id_class_code__CC",
        "i_client_PF1__i_revision_id_class_code__PIB",
        "i_client_PF1__i_revision_id_class_code__RID",
        "i_client_PF1__i_revision_id_class_code__SCC",
        "i_client_PF1__i_subsystem_vendor_id_subsystem_i__SID",
        "i_client_PF1__i_vendor_id_device_id__DID",
        "i_client_PF1__i_vendor_specific_header_reg__VI",
        "i_client_PF2__i_func_dep_link_numVFs_reg__NVF",
        "i_client_PF2__i_msi_ctrl_reg__MMC",
        "i_client_PF2__i_msix_ctrl__CID",
        "i_client_PF2__i_msix_ctrl__CP",
        "i_client_PF2__i_msix_ctrl__MSIXTS",
        "i_client_PF2__i_msix_pending_intrpt__BARI1",
        "i_client_PF2__i_msix_pending_intrpt__PBAO",
        "i_client_PF2__i_msix_tbl_offset__BARI",
        "i_client_PF2__i_msix_tbl_offset__TO",
        "i_client_PF2__i_revision_id_class_code__CC",
        "i_client_PF2__i_revision_id_class_code__PIB",
        "i_client_PF2__i_revision_id_class_code__RID",
        "i_client_PF2__i_revision_id_class_code__SCC",
        "i_client_PF2__i_subsystem_vendor_id_subsystem_i__SID",
        "i_client_PF2__i_vendor_id_device_id__DID",
        "i_client_PF2__i_vendor_specific_header_reg__VI",
        "i_client_PF3__i_func_dep_link_numVFs_reg__NVF",
        "i_client_PF3__i_msi_ctrl_reg__MMC",
        "i_client_PF3__i_msix_ctrl__CID",
        "i_client_PF3__i_msix_ctrl__CP",
        "i_client_PF3__i_msix_ctrl__MSIXTS",
        "i_client_PF3__i_msix_pending_intrpt__BARI1",
        "i_client_PF3__i_msix_pending_intrpt__PBAO",
        "i_client_PF3__i_msix_tbl_offset__BARI",
        "i_client_PF3__i_msix_tbl_offset__TO",
        "i_client_PF3__i_revision_id_class_code__CC",
        "i_client_PF3__i_revision_id_class_code__PIB",
        "i_client_PF3__i_revision_id_class_code__RID",
        "i_client_PF3__i_revision_id_class_code__SCC",
        "i_client_PF3__i_subsystem_vendor_id_subsystem_i__SID",
        "i_client_PF3__i_vendor_id_device_id__DID",
        "i_client_PF3__i_vendor_specific_header_reg__VI",
        "ss_pcie_MPS",
        "ss_pcie_aspm",
        "ss_pcie_pf0_exp_rom_bar",
        "ss_pcie_pf0_legacy_int_pin",
        "ss_pcie_pf0_vf_ats_en",
        "ss_pcie_pf0_vf_msi_mul_message_cap",
        "ss_pcie_pf0_vf_msix_bar_ind",
        "ss_pcie_pf0_vf_msix_pba_ind",
        "ss_pcie_pf0_vf_msix_pba_offset",
        "ss_pcie_pf0_vf_msix_table_offset",
        "ss_pcie_pf0_vf_msix_table_size",
        "ss_pcie_pf0_vf_steering_tag_tab_loc",
        "ss_pcie_pf0_vf_steering_tag_tab_size",
        "ss_pcie_pf0_vf_subsystem_id",
        "ss_pcie_pf0_vf_tph_en",
        "ss_pcie_pf1_exp_rom_bar",
        "ss_pcie_pf1_legacy_int_pin",
        "ss_pcie_pf1_vf_ats_en",
        "ss_pcie_pf1_vf_msi_mul_message_cap",
        "ss_pcie_pf1_vf_msix_bar_ind",
        "ss_pcie_pf1_vf_msix_pba_ind",
        "ss_pcie_pf1_vf_msix_pba_offset",
        "ss_pcie_pf1_vf_msix_table_offset",
        "ss_pcie_pf1_vf_msix_table_size",
        "ss_pcie_pf1_vf_steering_tag_tab_loc",
        "ss_pcie_pf1_vf_steering_tag_tab_size",
        "ss_pcie_pf1_vf_subsystem_id",
        "ss_pcie_pf1_vf_tph_en",
        "ss_pcie_pf2_exp_rom_bar",
        "ss_pcie_pf2_legacy_int_pin",
        "ss_pcie_pf2_vf_ats_en",
        "ss_pcie_pf2_vf_msi_mul_message_cap",
        "ss_pcie_pf2_vf_msix_bar_ind",
        "ss_pcie_pf2_vf_msix_pba_ind",
        "ss_pcie_pf2_vf_msix_pba_offset",
        "ss_pcie_pf2_vf_msix_table_offset",
        "ss_pcie_pf2_vf_msix_table_size",
        "ss_pcie_pf2_vf_steering_tag_tab_loc",
        "ss_pcie_pf2_vf_steering_tag_tab_size",
        "ss_pcie_pf2_vf_subsystem_id",
        "ss_pcie_pf2_vf_tph_en",
        "ss_pcie_pf3_exp_rom_bar",
        "ss_pcie_pf3_legacy_int_pin",
        "ss_pcie_pf3_vf_ats_en",
        "ss_pcie_pf3_vf_msi_mul_message_cap",
        "ss_pcie_pf3_vf_msix_bar_ind",
        "ss_pcie_pf3_vf_msix_pba_ind",
        "ss_pcie_pf3_vf_msix_pba_offset",
        "ss_pcie_pf3_vf_msix_table_offset",
        "ss_pcie_pf3_vf_msix_table_size",
        "ss_pcie_pf3_vf_steering_tag_tab_loc",
        "ss_pcie_pf3_vf_steering_tag_tab_size",
        "ss_pcie_pf3_vf_subsystem_id",
        "ss_pcie_pf3_vf_tph_en",
        "ss_pcie_pf_num",
        "ss_refclk_onboard_osc",
    ]
def get_rootport_params():
    return [
        "i_client_LM__i_rc_BAR_config_reg__RCBAR0A",
        "i_client_LM__i_rc_BAR_config_reg__RCBAR0C",
        "i_client_LM__i_rc_BAR_config_reg__RCBAR1A",
        "i_client_LM__i_rc_BAR_config_reg__RCBAR1C",
        "i_client_RC__i_L1_PM_cap__L1PrtCmMdReStrTime",
        "i_client_RC__i_L1_PM_cap__L1PrtPvrOnScale",
        "i_client_RC__i_L1_PM_cap__R0",
        "i_client_RC__i_L1_PM_ctrl_1__L1ASPML11EN",
        "i_client_RC__i_L1_PM_ctrl_1__L1ASPML12EN",
        "i_client_RC__i_L1_PM_ctrl_1__L1CmMdReStrTime",
        "i_client_RC__i_L1_PM_ctrl_1__L1PML11EN",
        "i_client_RC__i_L1_PM_ctrl_1__L1PML12EN",
        "i_client_RC__i_L1_PM_ctrl_1__L1ThrshldSc",
        "i_client_RC__i_L1_PM_ctrl_1__L1ThrshldVal",
        "i_client_RC__i_L1_PM_ctrl_2__L1PwrOnSc",
        "i_client_RC__i_L1_PM_ctrl_2__L1PwrOnVal",
        "i_client_RC__i_dev_ser_num_0__DSND0",
        "i_client_RC__i_dev_ser_num_1__DSND1",
        "i_client_RC__i_link_cap__PN",
        "i_client_RC__i_link_ctrl_status__ASPMC",
        "i_client_RC__i_link_ctrl_status__SCC",
        "i_client_RC__i_pcie_cap__MP",
        "i_client_RC__i_pcie_dev_ctrl_status__ETE",
        "i_client_RC__i_revision_id_class_code__CC",
        "i_client_RC__i_revision_id_class_code__PIB",
        "i_client_RC__i_revision_id_class_code__RID",
        "i_client_RC__i_revision_id_class_code__SCC",
        "i_client_RC__i_slot_capability__PSN",
        "i_client_RC__i_slot_capability__SPLS",
        "i_client_RC__i_slot_capability__SPLV",
        "i_client_RC__i_vendor_id_device_id__DID",
        "ss_pcie_gen3_rx_preset",
        "ss_pcie_gen3_tx_preset",
        "ss_pcie_gen4_tx_preset",
    ]
