
from __future__ import annotations

from typing import List

from common_device.quad.writer.summary import LaneSummary


from tx375_device.lane1g.design_param_info import Lane1GDesignParamInfo as Lane1GParamInfo
from tx375_device.lane1g.lane1g_prop_id import Lane1GConfigParamInfo as Lane1GConfigParamInfo


class Lane1GSummary(LaneSummary):
    '''
    Class for Summary report generation.
    '''

    def get_custom_order_params(self):
        return [Lane1GParamInfo.Id.ln_1gbe_conn_type]

    def get_exclude_cfg_params(self):
        return [Lane1GConfigParamInfo.Id.ss_topology_lane_NID]

    def get_inst_params(self):
        return [param_id for param_id in Lane1GConfigParamInfo.Id]

    def get_pin_types(self) -> List[str]:
        return ["1GBE_CLK", "1GBE_CLK_X2"]
    
    def get_user_blk_name(self):
        return "Ethernet SGMII"

