from __future__ import annotations
from typing import TYPE_CHECKING, List

from device.block_instance import PinConnection
from tx375_device.lane1g.device_service import QuadLane1GDeviceService
from tx375_device.lane1g.design import Lane1G
from tx375_device.lane1g.lane1g_pin_dep_graph import get_tie_high_ports

from common_device.quad.res_service import QuadResService
from common_device.quad.writer.interface_config import LaneInterfaceConfig

if TYPE_CHECKING:
    from common_device.quad.lane_design import LaneBasedItem

class Lane1GInterfaceConfig(LaneInterfaceConfig):

    def get_device_service(self):
        return QuadLane1GDeviceService(self._device_db, self._name)

    def verify_instance_type(self, ins: LaneBasedItem):
        assert isinstance(ins, Lane1G)

    def get_mode_name(self, res_name):
        """
        Return the mode name associated to the res_name
        """
        _, lane_idx = QuadResService.break_res_name(res_name)

        mode_name = ""
        if lane_idx != -1:
            mode_name = f'LN{lane_idx}_1G'

        return mode_name

    def get_common_pin_class(self):
        from tx375_device.lane1g.gui.builder import Lane1GTabBuilder

        return Lane1GTabBuilder.common_pin_categories

    def get_user_blk_name(self):
        return "Ethernet SGMII"

    def get_lane_tie_high_ports(self) -> List[str]:
        return get_tie_high_ports()

    def is_input_clock_inf_name(self, inf_name) -> bool:
        if inf_name == "1GBE_CLK":
            return True

        return False