from typing import List
from design.db_item import GenericParam
from common_device.property import PropertyMetaData, RangeValidator
from tx375_device.lane1g.lane1g_prop_id import Lane1GConfigParamInfo as Lane1GParamInfo

def build_param_info():
    param_info = Lane1GParamInfo()

    prop_data_list: List[PropertyMetaData.PropData] = [
        PropertyMetaData.PropData(id=Lane1GParamInfo.Id.ID_1G_PCS_L_NID__pcs_control__enable_auto_neg,
                name="1G_PCS_L_NID__pcs_control__enable_auto_neg",
                data_type=GenericParam.DataType.dbool,
                default=True,
                disp_name="Enable SGMII Auto Negotiation (AN)",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=Lane1GParamInfo.Id.ss_1gbe_data_rate_lane_NID,
                name="ss_1gbe_data_rate_lane_NID",
                data_type=GenericParam.DataType.dstr,
                default="10/100/1000 Mbps",
                valid_setting=["10/100/1000 Mbps", "2.5 Gbps"],
                disp_name="Speed",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=Lane1GParamInfo.Id.ss_topology_lane_NID,
                name="ss_topology_lane_NID",
                data_type=GenericParam.DataType.dstr,
                default="1GE",
                valid_setting=["PCIe", "10GE", "1GE", "Raw Serdes", "Disabled"],
                disp_name="ss_topology",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=Lane1GParamInfo.Id.sw_1gbe_activity_lane_NID,
                name="sw_1gbe_activity_lane_NID",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Enable Activity Status for LED",
                category="Per Lane Parameters - Control Register "),
        ]

    for prop_data in prop_data_list:
        param_info.add_prop_by_data(prop_data.id, prop_data)

    return param_info

def get_hidden_parameters():
    return [
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen",
        "pcr_bypass_cmn_ready",
        "pcr_q0_bypass_cfgtop",
        "pcr_q0_user_phy_reset_n_expose",
        "pcr_q1_bypass_cfgtop",
        "pcr_q1_user_phy_reset_n_expose",
        "pll_ref_clk0",
        "pll_ref_clk1",
        "ref_clk_pin_name",
        "ss_plllc1_refclk_sel",
        "ss_sim_enable",
        "ss_topology_lane_NID",
    ]

def get_removed_parameters():
    return [
    ]

def get_hidden_param_values():
    param2value_map = {
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel": ['Internal'],
        "PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg": ['Refclk 1'],
    }
    return param2value_map

def get_display_values():
    return {
    }

def get_supported_common_parameters():
    return [
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen",
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel",
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_termen",
        "PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg",
        "pcr_bypass_cmn_ready",
        "pcr_q0_bypass_cfgtop",
        "pcr_q0_user_phy_reset_n_expose",
        "pcr_q1_bypass_cfgtop",
        "pcr_q1_user_phy_reset_n_expose",
        "ss_1gbe_refclk_freq",
        "ss_plllc1_refclk_sel",
        "ss_sim_enable",
        "sw_1gbe_remove_preamble",
    ]
