from functools import partial
from common_device.property import PropertyMetaData
from common_gui.base_dep_graph import DependencyGraph
from design.db_item import GenericPinGroup


class Lane1GConfigDependencyGraph(DependencyGraph):
    def build_param_dependency(self, param_info: PropertyMetaData, port_info: GenericPinGroup):
        self.add_param_dependency(
           param_a_name='PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg',
           param_b_name='PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_termen',
           change_func=partial(self.on_parent_param_changed, condition_str='PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg="Refclk 0"'))
        self.add_param_dependency(
           param_a_name='PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg',
           param_b_name='PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen',
           change_func=partial(self.on_parent_param_changed, condition_str='PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg="Refclk 1"'))
        self.add_param_dependency(
           param_a_name='ss_1gbe_data_rate_lane_NID',
           param_b_name='1G_PCS_L_NID__pcs_control__enable_auto_neg',
           change_func=partial(self.on_parent_param_changed, condition_str='ss_topology_lane_NID=="1GE" && ss_1gbe_data_rate_lane_NID == "10/100/1000 Mbps"'))

