"""

Copyright (C) 2017-2024 Efinix Inc. All rights reserved.

No portion of this code may be reused, modified or
distributed in any way without the expressed written
consent of Efinix Inc.

Created on April 29, 2024

@author: Shirley Chan
"""

import sys
import os

from yapsy.IPlugin import IPlugin

from common_gui.base_plugin import BasePlugin

from tx375_device.lane1g.gui.control import Lane1GController

sys.path.append(os.path.join(os.path.dirname(__file__), '..'))


class Lane1GPlugin(BasePlugin, IPlugin):
    """
    Plugin controller for Ti375 1G
    """

    _plugin_name = "tx375_lane_1g"

    def __init__(self):
        super().__init__()
        self._plugin_name = "tx375_lane_1g"
        self.controller = Lane1GController()

    def monitor_block_specific_changes(self):
        assert self.app_window is not None
        self.app_window.actionOpen_1g.triggered.connect(self.open_window)

    def stop_monitor_block_specific_changes(self):
        assert self.app_window is not None
        self.app_window.actionOpen_1g.triggered.disconnect(self.open_window)

    def open_window(self):
        return super().open_window()


if __name__ == "__main__":
    pass
