from functools import partial
from common_device.property import PropertyMetaData
from common_gui.base_dep_graph import DependencyGraph
from design.db_item import GenericPinGroup


class Lane1GPinDependencyGraph(DependencyGraph):
    def build_pin_dependency(self, param_info: PropertyMetaData, port_info: GenericPinGroup):
        self.add_param_to_port_dependency(
           param_name='sw_1gbe_activity_lane_NID',
           port_name='LED_TICK_TOGGLE',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && (ss_topology_lane_NID=="1GE" ||  ss_topology_lane_NID=="1GE" || ss_topology_lane_NID=="1GE"  ||  ss_topology_lane_NID=="1GE") && (sw_1gbe_activity_lane_NID==1 || sw_1gbe_activity_lane_NID==1 || sw_1gbe_activity_lane_NID==1 || sw_1gbe_activity_lane_NID==1)')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='1G_PCS_L_NID__pcs_control__enable_auto_neg',
           port_name='PCS_AN_COMPLETE',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="1GE" && 1G_PCS_L_NID__pcs_control__enable_auto_neg==1')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='sw_1gbe_remove_preamble',
           port_name='REM_PRE',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && (ss_topology_lane_NID=="1GE" ||  ss_topology_lane_NID=="1GE" || ss_topology_lane_NID=="1GE"  ||  ss_topology_lane_NID=="1GE") &&  sw_1gbe_remove_preamble==1')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='sw_1gbe_activity_lane_NID',
           port_name='RX_ACTIVITY',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="1GE" && sw_1gbe_activity_lane_NID==1')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='sw_1gbe_activity_lane_NID',
           port_name='TX_ACTIVITY',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="1GE" && sw_1gbe_activity_lane_NID==1')) # type: ignore


def get_hidden_ports():
    return [
        "GMII_COL",
        "GMII_CRS",
        "PHY_CMN_RESET_N",
        "PMA_CMN_EXT_REFCLK1_DETECTED",
        "PMA_CMN_EXT_REFCLK1_DETECTED_CFG",
        "PMA_CMN_EXT_REFCLK1_DETECTED_VALID",
        "PMA_CMN_EXT_REFCLK_DETECTED",
        "PMA_CMN_EXT_REFCLK_DETECTED_CFG",
        "PMA_CMN_EXT_REFCLK_DETECTED_VALID",
        "PMA_CMN_REFCLK1_CORE",
        "PMA_CMN_REFCLK1_PLL",
        "PMA_CMN_REFCLK1_PLL_1",
        "PMA_CMN_REFCLK1_PLL_2",
        "PMA_CMN_REFCLK_CORE",
        "PMA_CMN_REFCLK_PLL",
        "PMA_CMN_REFCLK_PLL_1",
        "PMA_CMN_REFCLK_PLL_2",
        "SGMII_USER_APB_RESET_N",
        "USER_APB_PSLVERR",
    ]

def get_tie_high_ports():
    return [
        "PHY_CMN_RESET_N",
    ]

def get_tie_off_unused_ports():
    return [
    ]

def get_additional_params():
    return [
    ]
