"""

Copyright (C) 2017-2024 Efinix Inc. All rights reserved.

No portion of this code may be reused, modified or
distributed in any way without the expressed written
consent of Efinix Inc.

Created on April 29, 2024

@author: Shirley Chan
"""

import os
from typing import Optional

from PyQt5 import QtWidgets, QtCore

from util.excp import PTException
from util.singleton_logger import Logger
from util.app_setting import AppSetting
from util.app_launcher import AppLauncher
from util.gen_util import freeze_it

from tx375_device.lane1g.gui.Ui_tx375_device_1g_setting import Ui_MainWindow as UIFORM_CLASS

@freeze_it
class Lane1GWindow(QtWidgets.QMainWindow, UIFORM_CLASS):
    """
    Main window for 1G configuration
    """
    _is_show_config = True

    # noinspection PyArgumentList
    def __init__(self, parent: Optional[QtWidgets.QWidget] = None):
        """
        Main window for 1G, holds all the UI objects
        """

        self.design = None

        self.parent: QtWidgets.QWidget = parent # type: ignore
        self.logger = Logger

        QtWidgets.QMainWindow.__init__(self, parent)
        self.setupUi(self)

        self.dw_config.setVisible(Lane1GWindow._is_show_config)
        self.actionShow_Hide_Config.triggered.connect(self.show_config_window)
        self.actionHelp.triggered.connect(self.on_show_help)
        self.statusBar().hide()

        self.browser = AppLauncher()

    def update_design(self, design):
        self.design = design

    def show_config_window(self):

        if self.dw_config.isVisible():
            self.dw_config.hide()
            Lane1GWindow._is_show_config = False
        else:
            self.dw_config.show()
            Lane1GWindow._is_show_config = True

    # noinspection PyArgumentList
    @QtCore.pyqtSlot()
    def on_show_help(self):
        setting = AppSetting()
        help_file = setting.app_path[AppSetting.PathType.sgmii_html_help]
        if os.path.exists(help_file):
            try:
                self.browser.open_in_browser(help_file)
            except PTException:
                msg = "Fail to open help for Ethernet SGMII."
                QtWidgets.QMessageBox.warning(self.parent, "Open Ethernet SGMII help", msg)
                self.logger.warning(msg)

        else:
            msg = "Help file for Ethernet SGMII is missing. Please contact support to fix your installation."
            QtWidgets.QMessageBox.warning(self.parent, "Open Ethernet SGMII help", msg)
            self.logger.warning(msg)


if __name__ == "__main__":
    pass
