from __future__ import annotations
from typing import TYPE_CHECKING

from tx375_device.lane1g.design_param_info import Lane1GDesignParamInfo as Lane1GParamInfo
from tx375_device.lane1g.quad_param_info import Lane1GParamInfo as AdvParamInfo

from common_device.quad.gui.graph_observer import LaneBasedGraphObserver, BaseCommonQuadGraphObserver


if TYPE_CHECKING:
    from tx375_device.lane1g.gui.config import Lane1GConfig


class Lane1GGraphObserver(LaneBasedGraphObserver):

    def __init__(self, config) -> None:
        super().__init__(config)
        self._config: 'Lane1GConfig'

    def get_hw_param_id_class(self):
        return AdvParamInfo.Id

    def get_sw_param_id_class(self):
        return Lane1GParamInfo.Id


class CommonQuadGraphObserver(BaseCommonQuadGraphObserver):

    def __init__(self, config) -> None:
        super().__init__(config)
        self._config: 'Lane1GConfig'
