from __future__ import annotations
from functools import partial

from typing import TYPE_CHECKING

from common_device.quad.dep_graph import LaneBaseDependencyGraph
from tx375_device.common_quad.design_param_info import QuadDesignParamInfo
from tx375_device.lane1g.quad_dep_graph import Lane1GConfigDependencyGraph
from tx375_device.lane1g.lane1g_pin_dep_graph import Lane1GPinDependencyGraph
from tx375_device.lane1g.lane1g_prop_id import Lane1GConfigParamInfo as Lane1GParamInfo


if TYPE_CHECKING:
    from common_device.property import PropertyMetaData
    from design.db_item import GenericPinGroup


class Lane1GDependencyGraph(LaneBaseDependencyGraph, Lane1GConfigDependencyGraph, Lane1GPinDependencyGraph):

    def build_dependency(self, param_info: PropertyMetaData, port_info: GenericPinGroup):
        super().build_param_dependency(param_info, port_info)
        super().build_pin_dependency(param_info, port_info)

        self.add_param_to_port_dependency(
            param_name=QuadDesignParamInfo.Id.phy_reset_en.value,
            port_name='PHY_CMN_RESET_N',
            change_func=partial(
                self.on_enable_changed_pin,
                condition_str=f'{QuadDesignParamInfo.Id.phy_reset_en.value}==1')) # type: ignore
