from typing import Dict, List

from common_device.quad.gui.builder import LaneTabBuilder


class Lane1GTabBuilder(LaneTabBuilder):
    pin_categories = [
        "CLOCK and RESET",
        "CONTROL",
        "ERROR and STATUS",
        "POWER UP",
        "SGMII",
    ]

    param_categories = [
        "Per Lane Parameters - Control Register ",
        "Pin",
        "Common Properties",
    ]

    hidden_categories = {
        "CLOCK and RESET:SW_COMMON",
        "External Reference Clock Active Detection:SW_COMMON",
    }
    # common used (i.e. all lanes use them)
    common_pin_categories: List[str] = [
        "APB",
        "CLOCK and RESET",
        "ERROR and STATUS",
        "External Reference Clock Active Detection",
    ]
    category2display_name: Dict[str, str] = {
        "Per Lane Parameters - Control Register ": "Control Register",
        "CLOCK and RESET": "Clock And Reset",
        "CONTROL": "Control",
        "ERROR and STATUS": "Error and Status",
        "POWER UP": "Power Up",
        "Common Parameters": "Config"
    }
    common_categories2display_name = dict()
    for category in common_pin_categories:
        common_categories2display_name[f"{category}:SW_COMMON"] = category2display_name.get(category, category)

    category2display_name.update(common_categories2display_name)

    # Children list order will change tab order
    parent_category2children: Dict[str, List[str]] = {
        "Pin": pin_categories,
        "Common Properties": ["Common Parameters"] + [f"{item}:SW_COMMON" for item in common_pin_categories],
    }
    category2min_height: Dict[str, int] = {}

    skip_categories: List[str] = [
        "ref_clk",
        "Pin",
        "Common Parameters",
    ]
