
from __future__ import annotations

from typing import List, Any

from common_device.quad.writer.summary import LaneSummary


from tx375_device.lane10g.design_param_info import Lane10GDesignParamInfo as Lane10GParamInfo
from tx375_device.lane10g.lane10g_prop_id import Lane10GConfigParamInfo as Lane10GConfigParamInfo

from tx375_device.lane10g.gui.presenter import Lane10GConfigUIPresenter

class Lane10GSummary(LaneSummary):
    '''
    Class for Summary report generation.
    '''
    def __init__(self, device_db, name, section):
        super().__init__(device_db, name, section)
        self._presenter = Lane10GConfigUIPresenter()    

    def get_custom_order_params(self):
        return [Lane10GParamInfo.Id.ref_clk_frequency,
                Lane10GParamInfo.Id.ln_10gbe_conn_type
                ]

    def get_exclude_cfg_params(self):
        return [Lane10GConfigParamInfo.Id.ss_topology_lane_NID]

    def get_inst_params(self):
        return [param_id for param_id in Lane10GConfigParamInfo.Id]

    def get_pin_types(self) -> List[str]:
        return ["10GBE_CLK"]
    
    def get_user_blk_name(self):
        return "Ethernet XGMII"

    def convert_db_to_display_value(self, param_name: str, value: Any):
        return self._presenter.convert_db2display_value(param_name, value)
