from typing import List
from design.db_item import GenericParam
from common_device.property import PropertyMetaData, RangeValidator
from tx375_device.lane10g.lane10g_prop_id import Lane10GConfigParamInfo as Lane10GParamInfo

def build_param_info():
    param_info = Lane10GParamInfo()

    prop_data_list: List[PropertyMetaData.PropData] = [
        PropertyMetaData.PropData(id=Lane10GParamInfo.Id.ID_10G_PCS_L_NID__control_register__rx_pol_invert,
                name="10G_PCS_L_NID__control_register__rx_pol_invert",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Invert RX Polarity",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=Lane10GParamInfo.Id.ID_10G_PCS_L_NID__control_register__tx_pol_invert,
                name="10G_PCS_L_NID__control_register__tx_pol_invert",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Invert TX Polarity",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=Lane10GParamInfo.Id.ID_10G_PCS_L_NID__control_register__usx_an_enable,
                name="10G_PCS_L_NID__control_register__usx_an_enable",
                data_type=GenericParam.DataType.dbool,
                default=True,
                disp_name="Enable Auto Negotiation (AN) Clause 37",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=Lane10GParamInfo.Id.ID_10G_PCS_L_NID__control_register__usx_an_os_code,
                name="10G_PCS_L_NID__control_register__usx_an_os_code",
                data_type=GenericParam.DataType.dhex,
                default="0x3",
                valid_setting=("0x0", "0xff"),
                disp_name="USXGMII AN Ordered set code",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=Lane10GParamInfo.Id.ID_10G_PCS_L_NID__control_register__usx_speed,
                name="10G_PCS_L_NID__control_register__usx_speed",
                data_type=GenericParam.DataType.dstr,
                default="10GHz",
                valid_setting=["100MHz", "1GHz", "5GHz", "10GHz"],
                disp_name="Speed",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=Lane10GParamInfo.Id.ss_10gbe_L_NID_enable_fec,
                name="ss_10gbe_L_NID_enable_fec",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Enable Forward Error Correction (FEC)",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=Lane10GParamInfo.Id.ss_topology_lane_NID,
                name="ss_topology_lane_NID",
                data_type=GenericParam.DataType.dstr,
                default="10GE",
                valid_setting=["PCIe", "10GE", "1GE", "Raw Serdes", "Disabled"],
                disp_name="ss_topology",
                category="Per Lane Parameters - Control Register "),
        PropertyMetaData.PropData(id=Lane10GParamInfo.Id.sw_10gbe_L_NID_kr_enable,
                name="sw_10gbe_L_NID_kr_enable",
                data_type=GenericParam.DataType.dbool,
                default=True,
                disp_name="Enable KR Base",
                category="CONTROL"),
        ]

    for prop_data in prop_data_list:
        param_info.add_prop_by_data(prop_data.id, prop_data)

    return param_info

def get_hidden_parameters():
    return [
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen",
        "pcr_bypass_cmn_ready",
        "pcr_q0_bypass_cfgtop",
        "pcr_q0_user_phy_reset_n_expose",
        "pcr_q1_bypass_cfgtop",
        "pcr_q1_user_phy_reset_n_expose",
        "pll_ref_clk0",
        "pll_ref_clk1",
        "ref_clk_pin_name",
        "ss_plllc1_refclk_sel",
        "ss_sim_enable",
        "ss_topology_lane_NID",
    ]

def get_removed_parameters():
    return [
    ]

def get_hidden_param_values():
    param2value_map = {
        "10G_PCS_L_NID__control_register__usx_speed": ['100MHz', '1GHz', '5GHz'],
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel": ['Internal'],
        "PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg": ['Refclk 1'],
    }
    return param2value_map

def get_display_values():
    return {
        "10G_PCS_L_NID__control_register__usx_speed": {'10GHz': '10 Gbps', '5GHz': '5 Gbps', '1GHz': '1 Gbps', '100MHz': '100 Mbps'},
    }

def get_supported_common_parameters():
    return [
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen",
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel",
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_termen",
        "PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg",
        "pcr_bypass_cmn_ready",
        "pcr_q0_bypass_cfgtop",
        "pcr_q0_user_phy_reset_n_expose",
        "pcr_q1_bypass_cfgtop",
        "pcr_q1_user_phy_reset_n_expose",
        "ss_plllc1_refclk_sel",
        "ss_sim_enable",
    ]
