from functools import partial
from common_device.property import PropertyMetaData
from common_gui.base_dep_graph import DependencyGraph
from design.db_item import GenericPinGroup


class Lane10GConfigDependencyGraph(DependencyGraph):
    def build_param_dependency(self, param_info: PropertyMetaData, port_info: GenericPinGroup):
        self.add_param_dependency(
           param_a_name='PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg',
           param_b_name='PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_termen',
           change_func=partial(self.on_parent_param_changed, condition_str='PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg="Refclk 0"'))
        self.add_param_dependency(
           param_a_name='PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg',
           param_b_name='PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen',
           change_func=partial(self.on_parent_param_changed, condition_str='PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg="Refclk 1"'))
        self.add_param_dependency(
           param_a_name='10G_PCS_L_NID__control_register__usx_speed',
           param_b_name='10G_PCS_L_NID__control_register__usx_an_enable',
           change_func=partial(self.on_parent_param_changed, condition_str='ss_topology_lane_NID=="10GE" && (10G_PCS_L_NID__control_register__usx_speed!="5GHz")'))
        self.add_param_dependency(
           param_a_name='10G_PCS_L_NID__control_register__usx_an_enable',
           param_b_name='10G_PCS_L_NID__control_register__usx_an_os_code',
           change_func=partial(self.on_parent_param_changed, condition_str='(ss_topology_lane_NID=="10GE") && (10G_PCS_L_NID__control_register__usx_an_enable==1) && (10G_PCS_L_NID__control_register__usx_speed!="5GHz")'))
        self.add_param_dependency(
           param_a_name='10G_PCS_L_NID__control_register__usx_speed',
           param_b_name='10G_PCS_L_NID__control_register__usx_an_os_code',
           change_func=partial(self.on_parent_param_changed, condition_str='(ss_topology_lane_NID=="10GE") && (10G_PCS_L_NID__control_register__usx_an_enable==1) && (10G_PCS_L_NID__control_register__usx_speed!="5GHz")'))

