from functools import partial
from common_device.property import PropertyMetaData
from common_gui.base_dep_graph import DependencyGraph
from design.db_item import GenericPinGroup


class Lane10GPinDependencyGraph(DependencyGraph):
    def build_pin_dependency(self, param_info: PropertyMetaData, port_info: GenericPinGroup):
        self.add_param_to_port_dependency(
           param_name='sw_10gbe_L_NID_kr_enable',
           port_name='KR_FRAME_LOCK',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="10GE" && sw_10gbe_L_NID_kr_enable=1')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='sw_10gbe_L_NID_kr_enable',
           port_name='KR_LOCAL_RX_TRAINED',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="10GE" && sw_10gbe_L_NID_kr_enable=1')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='sw_10gbe_L_NID_kr_enable',
           port_name='KR_RESTART_TRAINING',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="10GE" && sw_10gbe_L_NID_kr_enable=1')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='sw_10gbe_L_NID_kr_enable',
           port_name='KR_SIGNAL_DETECT',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="10GE" && sw_10gbe_L_NID_kr_enable=1')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='sw_10gbe_L_NID_kr_enable',
           port_name='KR_TRAINING',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="10GE" && sw_10gbe_L_NID_kr_enable=1')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='sw_10gbe_L_NID_kr_enable',
           port_name='KR_TRAINING_ENABLE',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="10GE" && sw_10gbe_L_NID_kr_enable=1')) # type: ignore
        self.add_param_to_port_dependency(
           param_name='sw_10gbe_L_NID_kr_enable',
           port_name='KR_TRAINING_FAILURE',
           change_func=partial(self.on_enable_changed_pin, condition_str='quad=="q0" && ss_topology_lane_NID=="10GE" && sw_10gbe_L_NID_kr_enable=1')) # type: ignore


def get_hidden_ports():
    return [
        "10G_USER_APB_RESET_N",
        "CH_RX_FWD_CLK",
        "PHY_CMN_RESET_N",
        "PMA_CMN_EXT_REFCLK1_DETECTED",
        "PMA_CMN_EXT_REFCLK1_DETECTED_CFG",
        "PMA_CMN_EXT_REFCLK1_DETECTED_VALID",
        "PMA_CMN_EXT_REFCLK_DETECTED",
        "PMA_CMN_EXT_REFCLK_DETECTED_CFG",
        "PMA_CMN_EXT_REFCLK_DETECTED_VALID",
        "PMA_CMN_REFCLK1_CORE",
        "PMA_CMN_REFCLK1_PLL",
        "PMA_CMN_REFCLK1_PLL_1",
        "PMA_CMN_REFCLK1_PLL_2",
        "PMA_CMN_REFCLK_CORE",
        "PMA_CMN_REFCLK_PLL",
        "PMA_CMN_REFCLK_PLL_1",
        "PMA_CMN_REFCLK_PLL_2",
        "USER_APB_PSLVERR",
    ]

def get_tie_high_ports():
    return [
        "10G_USER_APB_RESET_N",
        "PHY_CMN_RESET_N",
    ]

def get_tie_off_unused_ports():
    return [
    ]

def get_additional_params():
    return [
    ]
