"""

Copyright (C) 2017-2024 Efinix Inc. All rights reserved.

No portion of this code may be reused, modified or
distributed in any way without the expressed written
consent of Efinix Inc.

Created on Feb 05, 2024

@author: Shirley Chan
"""
from __future__ import annotations
from typing import TYPE_CHECKING, Dict

from tx375_device.lane10g.quad_param_info import get_hidden_param_values, get_display_values

from common_device.quad.gui.lane_presenter import LaneBasedConfigUIPresenter

if TYPE_CHECKING:
    pass


class Lane10GConfigUIPresenter(LaneBasedConfigUIPresenter):
    def get_hidden_param_values(self):        
        # PT-2651: Sped 5G is hidden but should be visible with INI File
        if self.design is not None and self.design.lane_10g_reg is not None:
            return self.design.lane_10g_reg.get_filtered_hidden_param_values()

        return get_hidden_param_values()        

    def get_param2db2ui_mapping(self) -> Dict[str, Dict[str, str]]:
        return get_display_values()
