from __future__ import annotations
from typing import TYPE_CHECKING

from tx375_device.quad_pcie.gui.graph_observer import QuadPCIEGraphObserver
from tx375_device.lane10g.design_param_info import Lane10GDesignParamInfo
from tx375_device.lane10g.quad_param_info import Lane10GParamInfo as AdvParamInfo
from tx375_device.lane10g.gui.builder import Lane10GTabBuilder

from common_device.quad.gui.graph_observer import LaneBasedGraphObserver, BaseCommonQuadGraphObserver


if TYPE_CHECKING:
    from tx375_device.lane10g.gui.config import Lane10GConfig


class Lane10GGraphObserver(LaneBasedGraphObserver):

    def __init__(self, config) -> None:
        super().__init__(config)
        self._config: 'Lane10GConfig'

    def update_specific_widget(self, block_inst, updated_params, updated_pins):
        if AdvParamInfo.Id.sw_10gbe_L_NID_kr_enable.value in updated_params:
            self.update_kr_tab()

    def get_hw_param_id_class(self):
        return AdvParamInfo.Id

    def get_sw_param_id_class(self):
        return Lane10GDesignParamInfo.Id

    def update_kr_tab(self):
        block_inst = self._config.block_inst
        assert block_inst is not None

        # Show/ Hide Tab Page
        parent_category = "CONTROL"

        child_container = self._config.parent_category2sub_tabw.get(parent_category, None)
        assert child_container is not None

        is_any_child_display = False
        for child in Lane10GTabBuilder.parent_category2children.get(parent_category, []):
            is_child_page_display = False
            for pin_type in block_inst.get_pin_type_by_class(child):
                if block_inst.is_pin_available(pin_type):
                    is_child_page_display = True

            self.set_tab_visible(child, child_container, is_child_page_display)
            if is_child_page_display:
                is_any_child_display = True

        child_container.setVisible(is_any_child_display)

        # Update spacing
        container = self._config.category2vl.get(parent_category)
        assert container is not None
        QuadPCIEGraphObserver.update_tab_spacer(container, is_show_spacer=not is_any_child_display)


class CommonQuadGraphObserver(BaseCommonQuadGraphObserver):

    def __init__(self, config) -> None:
        super().__init__(config)
        self._config: 'Lane10GConfig'
