from __future__ import annotations
from functools import partial

from typing import TYPE_CHECKING

from common_device.quad.dep_graph import LaneBaseDependencyGraph
from tx375_device.common_quad.design_param_info import QuadDesignParamInfo
from tx375_device.lane10g.quad_dep_graph import Lane10GConfigDependencyGraph
from tx375_device.lane10g.lane10g_pin_dep_graph import Lane10GPinDependencyGraph
from tx375_device.lane10g.lane10g_prop_id import Lane10GConfigParamInfo as Lane10GParamInfo


if TYPE_CHECKING:
    from common_device.property import PropertyMetaData
    from design.db_item import GenericPinGroup


class Lane10GDependencyGraph(LaneBaseDependencyGraph, Lane10GConfigDependencyGraph, Lane10GPinDependencyGraph):

    def build_dependency(self, param_info: PropertyMetaData, port_info: GenericPinGroup):
        super().build_param_dependency(param_info, port_info)
        super().build_pin_dependency(param_info, port_info)

        self.add_param_to_port_dependency(
            param_name=QuadDesignParamInfo.Id.phy_reset_en.value,
            port_name='PHY_CMN_RESET_N',
            change_func=partial(
                self.on_enable_changed_pin,
                condition_str=f'{QuadDesignParamInfo.Id.phy_reset_en.value}==1')) # type: ignore
