from enum import Enum, unique
from common_device.property import PropertyMetaData

class CommonQuadConfigParamInfo(PropertyMetaData):

    @unique
    class Id(Enum):
        PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg = "PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg"
        ss_plllc1_refclk_sel = "ss_plllc1_refclk_sel"
        PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel = "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel"
        PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_termen = "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_termen"
        PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen = "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen"
        ss_sim_enable = "ss_sim_enable"
        pcr_q0_user_phy_reset_n_expose = "pcr_q0_user_phy_reset_n_expose"
        pcr_q1_user_phy_reset_n_expose = "pcr_q1_user_phy_reset_n_expose"
        pcr_bypass_cmn_ready = "pcr_bypass_cmn_ready"
        pcr_q0_bypass_cfgtop = "pcr_q0_bypass_cfgtop"
        pcr_q1_bypass_cfgtop = "pcr_q1_bypass_cfgtop"

        # 1G Only
        ss_1gbe_refclk_freq = "ss_1gbe_refclk_freq"
        sw_1gbe_remove_preamble = "sw_1gbe_remove_preamble"

        # Raw SERDES only
        ss_raw_refclk_freq = "ss_raw_refclk_freq"


        @classmethod
        def has_member(cls, item: str) -> bool:
            return item in cls._value2member_map_

        @classmethod
        def has_key(cls, item: str) -> bool:
            return item in cls.__members__
