from typing import List
from design.db_item import GenericParam
from common_device.property import PropertyMetaData, RangeValidator
from tx375_device.common_quad.quad_prop_id import CommonQuadConfigParamInfo as CommonQuadParamInfo

def build_param_info():
    param_info = CommonQuadParamInfo()

    prop_data_list: List[PropertyMetaData.PropData] = [
        PropertyMetaData.PropData(id=CommonQuadParamInfo.Id.PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen,
                name="PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen",
                data_type=GenericParam.DataType.dbool,
                default=True,
                disp_name="Enable 50 Ω to ground on-die termination for REFCLK1",
                category="External Clock"),
        PropertyMetaData.PropData(id=CommonQuadParamInfo.Id.PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel,
                name="PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel",
                data_type=GenericParam.DataType.dstr,
                default="External",
                valid_setting=[ "External", "Internal"],
                disp_name="Reference Clock Source",
                category="Clock"),
        PropertyMetaData.PropData(id=CommonQuadParamInfo.Id.PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_termen,
                name="PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_termen",
                data_type=GenericParam.DataType.dbool,
                default=True,
                disp_name="Enable 50 Ω to ground on-die termination for REFCLK0",
                category="External Clock"),
        PropertyMetaData.PropData(id=CommonQuadParamInfo.Id.PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg,
                name="PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg",
                data_type=GenericParam.DataType.dstr,
                default="Refclk 0",
                valid_setting=[ "Refclk 0", "Refclk 1"],
                disp_name="External Reference Clock",
                category="Common Parameters"),
        PropertyMetaData.PropData(id=CommonQuadParamInfo.Id.pcr_bypass_cmn_ready,
                name="pcr_bypass_cmn_ready",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="pcr bypass cmn ready",
                category="Common Parameters"),
        PropertyMetaData.PropData(id=CommonQuadParamInfo.Id.pcr_q0_bypass_cfgtop,
                name="pcr_q0_bypass_cfgtop",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="pcr q0 bypass cfgtop",
                category="Common Parameters"),
        PropertyMetaData.PropData(id=CommonQuadParamInfo.Id.pcr_q0_user_phy_reset_n_expose,
                name="pcr_q0_user_phy_reset_n_expose",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="pcr q0 user phy reset n expose",
                category="Common Parameters"),
        PropertyMetaData.PropData(id=CommonQuadParamInfo.Id.pcr_q1_bypass_cfgtop,
                name="pcr_q1_bypass_cfgtop",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="pcr q1 bypass cfgtop",
                category="Common Parameters"),
        PropertyMetaData.PropData(id=CommonQuadParamInfo.Id.pcr_q1_user_phy_reset_n_expose,
                name="pcr_q1_user_phy_reset_n_expose",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="pcr q1 user phy reset n expose",
                category="Common Parameters"),
        PropertyMetaData.PropData(id=CommonQuadParamInfo.Id.ss_1gbe_refclk_freq,
                name="ss_1gbe_refclk_freq",
                data_type=GenericParam.DataType.dflo,
                default=156.25,
                valid_setting=[62.5, 100, 156.25],
                disp_name="Reference Clock Frequency (MHz)",
                category="Common Parameters"),
        PropertyMetaData.PropData(id=CommonQuadParamInfo.Id.ss_plllc1_refclk_sel,
                name="ss_plllc1_refclk_sel",
                data_type=GenericParam.DataType.dstr,
                default="Refclk 1",
                valid_setting=[ "Disabled","Refclk 0", "Refclk 1"],
                disp_name="PLL LC1 Refclk Selection",
                category="Common Parameters"),
        PropertyMetaData.PropData(id=CommonQuadParamInfo.Id.ss_sim_enable,
                name="ss_sim_enable",
                data_type=GenericParam.DataType.dstr,
                default="Speed up",
                valid_setting=["Speed up", "Non-speed up", "Disabled"],
                disp_name="ss sim enable",
                category="Common Parameters"),
        PropertyMetaData.PropData(id=CommonQuadParamInfo.Id.sw_1gbe_remove_preamble,
                name="sw_1gbe_remove_preamble",
                data_type=GenericParam.DataType.dbool,
                default=False,
                disp_name="Remove 1 Preamble Byte for Even Number of Idles",
                category="Common Parameters"),
        # Raw SERDES parameters
        PropertyMetaData.PropData(id=CommonQuadParamInfo.Id.ss_raw_refclk_freq,
                name="ss_raw_refclk_freq",
                data_type=GenericParam.DataType.dflo,
                default=156.25,
                valid_setting=[50, 75, 90, 100, 148.5, 156.25],
                disp_name="Reference Clock Frequency (MHz)",
                category="Common Parameters"),                
    ]

    for prop_data in prop_data_list:
        param_info.add_prop_by_data(prop_data.id, prop_data)

    return param_info

def get_hidden_parameters():
    return [
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk1_termen",
        "pcr_bypass_cmn_ready",
        "pcr_q0_bypass_cfgtop",
        "pcr_q0_user_phy_reset_n_expose",
        "pcr_q1_bypass_cfgtop",
        "pcr_q1_user_phy_reset_n_expose",
        "pll_ref_clk0",
        "pll_ref_clk1",
        "ref_clk_pin_name",
        "ss_plllc1_refclk_sel",
        "ss_sim_enable",
        "ss_topology_lane_NID",
    ]

def get_removed_parameters():
    return [
    ]

# Should be hide by protocal
def get_hidden_param_values():
    param2value_map = {
        "PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel": ['Internal'],
        "PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg": ['Refclk 1'],
    }
    return param2value_map
