'''
Copyright (C) 2017-2021 Efinix Inc. All rights reserved.

No portion of this code may be reused, modified or
distributed in any way without the expressed written
consent of Efinix Inc.

Created on Nov 1, 2021

@author: maryam
'''
import sys
import os
import decimal

import device.db_interface as devdb_int
import design.db as des_db

import tx60_device.pll.writer.summary as pll_sum

sys.path.append(os.path.join(os.path.dirname(__file__), '..'))


class PLLSummaryV3Complex(pll_sum.PLLSummaryComplex):
    '''
    Class for Summary report generation.
    '''

    def _get_out_clk_names(self, pll_obj, clk_obj):
        clkout_names = []

        if clk_obj is not None and pll_obj is not None:
            if clk_obj.conn_type == "rclk":
                clkout_names.append(clk_obj.name)

                if clk_obj.clkmux_buf_name != "":
                    # Check that this is a valid connection although
                    # rule already check for it.
                    dbi = devdb_int.DeviceDBService(self.get_device())
                    plldev_service = dbi.get_block_service(self.get_device().get_pll_type())

                    clkout_pin_name = "CLKOUT{}".format(clk_obj.number)

                    if plldev_service is not None and \
                            plldev_service.is_pll_clkout_pin_support_mult_clkout_conn(pll_obj.pll_def, clkout_pin_name):
                        clkout_names.append(clk_obj.clkmux_buf_name)

            else:
                clkout_names.append(clk_obj.name)

        return clkout_names

    def _get_clkout_constraints(self, design, sdc_cmds, pll_obj, clk_obj, clkout_period):

        clkout_names = self._get_out_clk_names(pll_obj, clk_obj)

        if clk_obj is not None and pll_obj is not None:
            for clk_name in clkout_names:

                if not self.is_pll_clk_driving_ddr(design, pll_obj, clk_obj):
                    sdc_clkout_period = self.round_clk_period(
                        clkout_period * 1000, clk_obj)

                    period_in_ns = clkout_period * 1000
                    clkout_waveform = pll_obj.get_output_clock_sdc_waveform(
                        clk_obj, period_in_ns)

                    if clkout_waveform != "":
                        sdc = "create_clock -waveform {" + \
                            clkout_waveform + "} -period " + \
                            str(sdc_clkout_period) + \
                            " -name " + clk_name + " [get_ports {" + clk_name + "}]"
                    else:
                        sdc = "create_clock -period " + \
                            str(sdc_clkout_period) + \
                            " -name " + clk_name + " [get_ports {" + clk_name + "}]"

                    if sdc != "":
                        sdc_cmds.append(sdc)

    def is_pll_clk_driving_ddr(self, design, pll_obj, clk_obj):
        is_ddr_clk = False

        if design is not None and design.ddr_reg is not None:
            if design.ddr_reg.get_inst_count() > 0:

                dbi = devdb_int.DeviceDBService(design.device_db)
                ddr_service = dbi.get_block_service(devdb_int.DeviceDBService.BlockType.DDR_ADV)

                if pll_obj.is_pll_ddr_clock(design.pll_reg, ddr_service, design.ddr_reg, clk_obj):
                    is_ddr_clk = True

        return is_ddr_clk


