#############################################################################
#                                  FORMAT                                   #
# # GUI param                                                               #
# value check (if type hex use function hex_check())                        #
# if pass value check:                                                      #
#      register A to set                                                    #
#      register B to set                                                    #
#      ...                                                                  #
#                                                                           #
#############################################################################
import pprint

#----------------------------------------------------------------------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
#----------------------------------------- Set Topology Function ------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
def param2reg_conv(quad,user_registers,f):

	# ss_topology_lane<0-3>		
	topo_lane0 = user_registers["ss_topology_lane0"]		
	topo_lane1 = user_registers["ss_topology_lane1"]		
	topo_lane2 = user_registers["ss_topology_lane2"]		
	topo_lane3 = user_registers["ss_topology_lane3"]
	topology = topo_lane0 + "_" + topo_lane1 + "_" + topo_lane2 + "_" + topo_lane3

	# Set the serdes registes per topologies
	if (topology == "PCIe_PCIe_PCIe_PCIe"):
		set_defval_pcie(user_registers,f)
		mode = "PCIe"
		user_registers, f = topo_pcie(quad,user_registers,f)
	#MIX1G10G only
	elif (topology == "1GE_Disabled_10GE_Disabled" or topology == "1GE_1GE_10GE_10GE" or topology == "Disabled_1GE_Disabled_10GE" or topology == "1GE_Disabled_Disabled_10GE" or topology == "Disabled_1GE_10GE_Disabled"):
		set_defval_mix_cmn(user_registers,f)
		mode = "mix1G10G"

	#10G only
	elif (topology == "10GE_10GE_10GE_10GE" or topology == "10GE_10GE_10GE_Disabled" or topology == "10GE_10GE_Disabled_10GE" or topology == "10GE_10GE_Disabled_Disabled" or topology == "10GE_Disabled_10GE_10GE" or topology == "10GE_Disabled_10GE_Disabled" or topology == "10GE_Disabled_Disabled_10GE" or topology == "10GE_Disabled_Disabled_Disabled" or topology == "Disabled_10GE_10GE_10GE" or topology == "Disabled_10GE_10GE_Disabled" or topology == "Disabled_10GE_Disabled_10GE" or topology == "Disabled_10GE_Disabled_Disabled" or topology == "Disabled_Disabled_10GE_10GE" or topology == "Disabled_Disabled_10GE_Disabled" or topology == "Disabled_Disabled_Disabled_10GE"):
		set_defval_10gbe_cmn(user_registers,f)
		mode = "10G"

	#1G only
	elif (topology == "1GE_1GE_1GE_1GE" or topology == "1GE_1GE_1GE_Disabled" or topology == "1GE_1GE_Disabled_1GE" or topology == "1GE_1GE_Disabled_Disabled" or topology == "1GE_Disabled_1GE_1GE" or topology == "1GE_Disabled_1GE_Disabled" or topology == "1GE_Disabled_Disabled_1GE" or topology == "1GE_Disabled_Disabled_Disabled" or topology == "Disabled_1GE_1GE_1GE" or topology == "Disabled_1GE_1GE_Disabled" or topology == "Disabled_1GE_Disabled_1GE" or topology == "Disabled_1GE_Disabled_Disabled" or topology == "Disabled_Disabled_1GE_1GE" or topology == "Disabled_Disabled_1GE_Disabled" or topology == "Disabled_Disabled_Disabled_1GE"):
		set_defval_1gbe_cmn(user_registers,f)
		user_registers, f = topo_1gbe_cmn(quad,user_registers,f)
		mode = "1G"

	#RAW only
	elif (topology == "Raw Serdes_Raw Serdes_Raw Serdes_Raw Serdes" or topology == "Raw Serdes_Raw Serdes_Raw Serdes_Disabled" or topology == "Raw Serdes_Raw Serdes_Disabled_Raw Serdes" or topology == "Raw Serdes_Raw Serdes_Disabled_Disabled" or topology == "Raw Serdes_Disabled_Raw Serdes_Raw Serdes" or topology == "Raw Serdes_Disabled_Raw Serdes_Disabled" or topology == "Raw Serdes_Disabled_Disabled_Raw Serdes" or topology == "Raw Serdes_Disabled_Disabled_Disabled" or topology == "Disabled_Raw Serdes_Raw Serdes_Raw Serdes" or topology == "Disabled_Raw Serdes_Raw Serdes_Disabled" or topology == "Disabled_Raw Serdes_Disabled_Raw Serdes" or topology == "Disabled_Raw Serdes_Disabled_Disabled" or topology == "Disabled_Disabled_Raw Serdes_Raw Serdes" or topology == "Disabled_Disabled_Raw Serdes_Disabled" or topology == "Disabled_Disabled_Disabled_Raw Serdes"):
		set_defval_raw_cmn(user_registers,f)
		user_registers, f = topo_raw_cmn(quad,user_registers,f)
		mode = "RAW"

	else:
		f['design_errors'].append("ERROR: Undefined topology combination") 
		mode = "Disabled"

	if (mode != "Disabled"):
		#Lane0
		if (topo_lane0 == "10GE"):
			set_defval_10gbe_lane0(user_registers,f)
			user_registers, f = topo_10gbe_lane0(quad,user_registers,f)			
		elif (topo_lane0 == "1GE"):
			set_defval_1gbe_lane0(user_registers,f)
			user_registers, f = topo_1gbe_lane0(quad,user_registers,f)
		elif (topo_lane0 == "Raw Serdes"):
			set_defval_raw_lane0(user_registers,f)
			user_registers, f = topo_raw_lane0(quad,user_registers,f)			

		#Lane1
		if (topo_lane1 == "10GE"):
			set_defval_10gbe_lane1(user_registers,f)
			user_registers, f = topo_10gbe_lane1(quad,user_registers,f)			
		elif (topo_lane1 == "1GE"):
			set_defval_1gbe_lane1(user_registers,f)
			user_registers, f = topo_1gbe_lane1(quad,user_registers,f)
		elif (topo_lane1 == "Raw Serdes"):
			set_defval_raw_lane1(user_registers,f)
			user_registers, f = topo_raw_lane1(quad,user_registers,f)			

		#Lane2
		if (topo_lane2 == "10GE"):
			set_defval_10gbe_lane2(user_registers,f)
			user_registers, f = topo_10gbe_lane2(quad,user_registers,f)			
		elif (topo_lane2 == "1GE"):
			set_defval_1gbe_lane2(user_registers,f)
			user_registers, f = topo_1gbe_lane2(quad,user_registers,f)
		elif (topo_lane2 == "Raw Serdes"):
			set_defval_raw_lane2(user_registers,f)
			user_registers, f = topo_raw_lane2(quad,user_registers,f)			

		#Lane3
		if (topo_lane3 == "10GE"):
			set_defval_10gbe_lane3(user_registers,f)
			user_registers, f = topo_10gbe_lane3(quad,user_registers,f)			
		elif (topo_lane3 == "1GE"):
			set_defval_1gbe_lane3(user_registers,f)
			user_registers, f = topo_1gbe_lane3(quad,user_registers,f)
		elif (topo_lane3 == "Raw Serdes"):
			set_defval_raw_lane3(user_registers,f)
			user_registers, f = topo_raw_lane3(quad,user_registers,f)			
	
	return user_registers,f,mode

#----------------------------------------------------------------------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
#------------------------------------------- 10GE Functions -----------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
def topo_10gbe_lane0(quad,user_registers,f):
	# ss_10gbe_L0_enable_fec
	if user_registers['ss_10gbe_L0_enable_fec'] not in ["0", "1"]:
		f['design_warnings'].append("ERROR: The selected value of ss_10gbe_L0_enable_fec is out of range.")
	else:
		if user_registers['ss_10gbe_L0_enable_fec'] == "1":
			user_registers['10G_PCS_L0__control_register__fec_enable'] = "1"
			user_registers['10G_PCS_L0__control_register__fec_err_ind'] = "1"
		else:
			user_registers['10G_PCS_L0__control_register__fec_enable'] = "0"
			user_registers['10G_PCS_L0__control_register__fec_err_ind'] = "0"

	if ("5" in user_registers['10G_PCS_L0__control_register__usx_speed']):
		user_registers['10G_PCS_L0__control_register__usx_an_enable'] = "0"
		user_registers['10G_PCS_L1__control_register__usx_an_os_code'] = "0x3"
		user_registers['PMA_CMN__cmn_plllc_clk2_preg__cmn_plllc_clk2_en_preg'] = "0x1"
		user_registers['PMA_CMN__cmn_plllc_clk2_preg__cmn_plllc_clk2outdivfrac_preg'] = "0x0"
		user_registers['PMA_CMN__cmn_plllc_clk2_preg__cmn_plllc_clk2outdivint_preg'] = "0x3E"
		user_registers['PMA_CMN__cmn_plllc_clk1_preg__cmn_plllc_clk1outdiv_preg'] = "0x38"
		user_registers['PMA_L0__pllctrl_subrate_preg__pllctrl_subrate_mode0_preg'] = "0x1"
		user_registers['PMA_L0__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x800"
		user_registers['PMA_L0__det_standec_e_preg__clkrst_datart_div_mode0_preg'] = "0x2"
		user_registers['PMA_L0__det_standec_a_preg__ser_gt8g_mode0_preg'] = "0x0"
		user_registers['PMA_L0__det_standec_d_preg__clkrst_fullrt_divsel_mode0_preg'] = "0x1"
		user_registers['PMA_L0__dfe_ecmp_ratesel_preg__ecmp_ratesel_mode0_preg'] = "0x1"
		user_registers['PMA_L0__dfe_smp_ratesel_preg__smp_ratesel_mode0_preg'] = "0x1"
		user_registers['PIPE_CONFIG_L0__config_reg_3__mac_div_sel1_p_0'] = "0x1"
		user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel1'] = "0x1"
		user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel3'] = "0x0"
	else:
		# Link Down, Full Duplex
		if user_registers['10G_PCS_L0__control_register__usx_an_enable'] == "1":
			if user_registers['10G_PCS_L0__control_register__usx_speed'] == "10GHz":
				user_registers['10G_PCS_L0__usxgmii_an_adv_register__usx_an_adv'] = "0x1601" 
			elif user_registers['10G_PCS_L0__control_register__usx_speed'] == "1GHz":
				user_registers['10G_PCS_L0__usxgmii_an_adv_register__usx_an_adv'] = "0x1401" 
			elif user_registers['10G_PCS_L0__control_register__usx_speed'] == "100MHz":
				user_registers['10G_PCS_L0__usxgmii_an_adv_register__usx_an_adv'] = "0x1201" 
		
	return user_registers,f

def topo_10gbe_lane1(quad,user_registers,f):
	# ss_10gbe_L1_enable_fec
	if user_registers['ss_10gbe_L1_enable_fec'] not in ["0", "1"]:
		f['design_warnings'].append("ERROR: The selected value of ss_10gbe_L1_enable_fec is out of range.")
	else:
		if user_registers['ss_10gbe_L1_enable_fec'] == "1":
			user_registers['10G_PCS_L1__control_register__fec_enable'] = "1"
			user_registers['10G_PCS_L1__control_register__fec_err_ind'] = "1"
		else:
			user_registers['10G_PCS_L1__control_register__fec_enable'] = "0"
			user_registers['10G_PCS_L1__control_register__fec_err_ind'] = "0"

	if ("5" in user_registers['10G_PCS_L1__control_register__usx_speed']):
		user_registers['10G_PCS_L1__control_register__usx_an_enable'] = "0"
		user_registers['10G_PCS_L1__control_register__usx_an_os_code'] = "0x3"
		user_registers['PMA_CMN__cmn_plllc_clk2_preg__cmn_plllc_clk2_en_preg'] = "0x1"
		user_registers['PMA_CMN__cmn_plllc_clk2_preg__cmn_plllc_clk2outdivfrac_preg'] = "0x0"
		user_registers['PMA_CMN__cmn_plllc_clk2_preg__cmn_plllc_clk2outdivint_preg'] = "0x3E"
		user_registers['PMA_CMN__cmn_plllc_clk1_preg__cmn_plllc_clk1outdiv_preg'] = "0x38"
		user_registers['PMA_L1__pllctrl_subrate_preg__pllctrl_subrate_mode0_preg'] = "0x1"
		user_registers['PMA_L1__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x800"
		user_registers['PMA_L1__det_standec_e_preg__clkrst_datart_div_mode0_preg'] = "0x2"
		user_registers['PMA_L1__det_standec_a_preg__ser_gt8g_mode0_preg'] = "0x0"
		user_registers['PMA_L1__det_standec_d_preg__clkrst_fullrt_divsel_mode0_preg'] = "0x1"
		user_registers['PMA_L1__dfe_ecmp_ratesel_preg__ecmp_ratesel_mode0_preg'] = "0x1"
		user_registers['PMA_L1__dfe_smp_ratesel_preg__smp_ratesel_mode0_preg'] = "0x1"
		user_registers['PIPE_CONFIG_L1__config_reg_5__mac_div_sel1_p_1'] = "0x1"
		user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel1'] = "0x1"
		user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel3'] = "0x0"
	else:
		# Link Down, Full Duplex
		if user_registers['10G_PCS_L1__control_register__usx_an_enable'] == "1":
			if user_registers['10G_PCS_L1__control_register__usx_speed'] == "10GHz":
				user_registers['10G_PCS_L1__usxgmii_an_adv_register__usx_an_adv'] = "0x1601" 
			elif user_registers['10G_PCS_L1__control_register__usx_speed'] == "1GHz":
				user_registers['10G_PCS_L1__usxgmii_an_adv_register__usx_an_adv'] = "0x1401" 
			elif user_registers['10G_PCS_L1__control_register__usx_speed'] == "100MHz":
				user_registers['10G_PCS_L1__usxgmii_an_adv_register__usx_an_adv'] = "0x1201" 

	return user_registers,f

def topo_10gbe_lane2(quad,user_registers,f):
	# ss_10gbe_L2_enable_fec
	if user_registers['ss_10gbe_L2_enable_fec'] not in ["0", "1"]:
		f['design_warnings'].append("ERROR: The selected value of ss_10gbe_L2_enable_fec is out of range.")
	else:
		if user_registers['ss_10gbe_L2_enable_fec'] == "1":
			user_registers['10G_PCS_L2__control_register__fec_enable'] = "1"
			user_registers['10G_PCS_L2__control_register__fec_err_ind'] = "1"
		else:
			user_registers['10G_PCS_L2__control_register__fec_enable'] = "0"
			user_registers['10G_PCS_L2__control_register__fec_err_ind'] = "0"

	if ("5" in user_registers['10G_PCS_L2__control_register__usx_speed']):
		user_registers['10G_PCS_L2__control_register__usx_an_enable'] = "0"
		user_registers['10G_PCS_L2__control_register__usx_an_os_code'] = "0x3"
		user_registers['PMA_CMN__cmn_plllc_clk2_preg__cmn_plllc_clk2_en_preg'] = "0x1"
		user_registers['PMA_CMN__cmn_plllc_clk2_preg__cmn_plllc_clk2outdivfrac_preg'] = "0x0"
		user_registers['PMA_CMN__cmn_plllc_clk2_preg__cmn_plllc_clk2outdivint_preg'] = "0x3E"
		user_registers['PMA_CMN__cmn_plllc_clk1_preg__cmn_plllc_clk1outdiv_preg'] = "0x38"
		user_registers['PMA_L2__pllctrl_subrate_preg__pllctrl_subrate_mode0_preg'] = "0x1"
		user_registers['PMA_L2__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x800"
		user_registers['PMA_L2__det_standec_e_preg__clkrst_datart_div_mode0_preg'] = "0x2"
		user_registers['PMA_L2__det_standec_a_preg__ser_gt8g_mode0_preg'] = "0x0"
		user_registers['PMA_L2__det_standec_d_preg__clkrst_fullrt_divsel_mode0_preg'] = "0x1"
		user_registers['PMA_L2__dfe_ecmp_ratesel_preg__ecmp_ratesel_mode0_preg'] = "0x1"
		user_registers['PMA_L2__dfe_smp_ratesel_preg__smp_ratesel_mode0_preg'] = "0x1"
		user_registers['PIPE_CONFIG_L2__config_reg_7__mac_div_sel1_p_2'] = "0x1"
		user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel1'] = "0x1"
		user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel3'] = "0x0"
	else:
		# Link Down, Full Duplex
		if user_registers['10G_PCS_L2__control_register__usx_an_enable'] == "1":
			if user_registers['10G_PCS_L2__control_register__usx_speed'] == "10GHz":
				user_registers['10G_PCS_L2__usxgmii_an_adv_register__usx_an_adv'] = "0x1601" 
			elif user_registers['10G_PCS_L2__control_register__usx_speed'] == "1GHz":
				user_registers['10G_PCS_L2__usxgmii_an_adv_register__usx_an_adv'] = "0x1401" 
			elif user_registers['10G_PCS_L2__control_register__usx_speed'] == "100MHz":
				user_registers['10G_PCS_L2__usxgmii_an_adv_register__usx_an_adv'] = "0x1201"

	return user_registers,f

def topo_10gbe_lane3(quad,user_registers,f):
	# ss_10gbe_L3_enable_fec
	if user_registers['ss_10gbe_L3_enable_fec'] not in ["0", "1"]:
		f['design_warnings'].append("ERROR: The selected value of ss_10gbe_L3_enable_fec is out of range.")
	else:
		if user_registers['ss_10gbe_L3_enable_fec'] == "1":
			user_registers['10G_PCS_L3__control_register__fec_enable'] = "1"
			user_registers['10G_PCS_L3__control_register__fec_err_ind'] = "1"
		else:
			user_registers['10G_PCS_L3__control_register__fec_enable'] = "0"
			user_registers['10G_PCS_L3__control_register__fec_err_ind'] = "0"

	if ("5" in user_registers['10G_PCS_L3__control_register__usx_speed']):
		user_registers['10G_PCS_L3__control_register__usx_an_enable'] = "0"
		user_registers['10G_PCS_L3__control_register__usx_an_os_code'] = "0x3"
		user_registers['PMA_CMN__cmn_plllc_clk2_preg__cmn_plllc_clk2_en_preg'] = "0x1"
		user_registers['PMA_CMN__cmn_plllc_clk2_preg__cmn_plllc_clk2outdivfrac_preg'] = "0x0"
		user_registers['PMA_CMN__cmn_plllc_clk2_preg__cmn_plllc_clk2outdivint_preg'] = "0x3E"
		user_registers['PMA_CMN__cmn_plllc_clk1_preg__cmn_plllc_clk1outdiv_preg'] = "0x38"
		user_registers['PMA_L3__pllctrl_subrate_preg__pllctrl_subrate_mode0_preg'] = "0x1"
		user_registers['PMA_L3__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x800"
		user_registers['PMA_L3__det_standec_e_preg__clkrst_datart_div_mode0_preg'] = "0x2"
		user_registers['PMA_L3__det_standec_a_preg__ser_gt8g_mode0_preg'] = "0x0"
		user_registers['PMA_L3__det_standec_d_preg__clkrst_fullrt_divsel_mode0_preg'] = "0x1"
		user_registers['PMA_L3__dfe_ecmp_ratesel_preg__ecmp_ratesel_mode0_preg'] = "0x1"
		user_registers['PMA_L3__dfe_smp_ratesel_preg__smp_ratesel_mode0_preg'] = "0x1"
		user_registers['PIPE_CONFIG_L3__config_reg_9__mac_div_sel1_p_3'] = "0x1"
		user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel1'] = "0x1"
		user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel3'] = "0x0"
	else:
		# Link Down, Full Duplex
		if user_registers['10G_PCS_L3__control_register__usx_an_enable'] == "1":
			if user_registers['10G_PCS_L3__control_register__usx_speed'] == "10GHz":
				user_registers['10G_PCS_L3__usxgmii_an_adv_register__usx_an_adv'] = "0x1601" 
			elif user_registers['10G_PCS_L3__control_register__usx_speed'] == "1GHz":
				user_registers['10G_PCS_L3__usxgmii_an_adv_register__usx_an_adv'] = "0x1401" 
			elif user_registers['10G_PCS_L3__control_register__usx_speed'] == "100MHz":
				user_registers['10G_PCS_L3__usxgmii_an_adv_register__usx_an_adv'] = "0x1201" 

	return user_registers,f

#----------------------------------------------------------------------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
#------------------------------------------- 1GE Functions -----------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
def topo_1gbe_cmn(quad,user_registers,f):
	#ss_1gbe_refclk_freq
	if float(user_registers['ss_1gbe_refclk_freq']) not in [156.25, 100, 62.5]:
		f['design_warnings'].append("ERROR: The selected value of ss_1gbe_refclk_freq is out of range.")
	else: 
		if float(user_registers['ss_1gbe_refclk_freq']) == 156.25:
			user_registers['PMA_CMN__cmn_refrcv_preg__cmn_refrcv_bwval_preg'] = "0x3"
			user_registers['PMA_CMN__cmn_plllc_fbdiv_int_mode0_preg__cmn_plllc_fbdivint_mode0_preg'] = "0x01C"
			user_registers['PMA_CMN__cmn_plllc_clk0_preg__cmn_plllc_clk0outdiv_mode0_preg'] = "0x3"
		elif float(user_registers['ss_1gbe_refclk_freq']) == 100:
			user_registers['PMA_CMN__cmn_refrcv_preg__cmn_refrcv_bwval_preg'] = "0x1"
			user_registers['PMA_CMN__cmn_plllc_fbdiv_int_mode0_preg__cmn_plllc_fbdivint_mode0_preg'] = "0x032"
			user_registers['PMA_CMN__cmn_plllc_clk0_preg__cmn_plllc_clk0outdiv_mode0_preg'] = "0x04"
		elif float(user_registers['ss_1gbe_refclk_freq']) == 62.5:
			user_registers['PMA_CMN__cmn_refrcv_preg__cmn_refrcv_bwval_preg'] = "0x1"
			user_registers['PMA_CMN__cmn_plllc_fbdiv_int_mode0_preg__cmn_plllc_fbdivint_mode0_preg'] = "0x046"
			user_registers['PMA_CMN__cmn_plllc_clk0_preg__cmn_plllc_clk0outdiv_mode0_preg'] = "0x03"		
	return user_registers,f

def topo_1gbe_lane0(quad,user_registers,f):
	if ("2.5" in user_registers['ss_1gbe_data_rate_lane0']):
		user_registers['PMA_L0__det_standec_d_preg__clkrst_fullrt_divsel_mode0_preg'] = "0x1"
		user_registers['PMA_L0__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode0_preg'] = "0x0"
		user_registers['1G_PCS_L0__pcs_control__enable_auto_neg'] = "0"
		user_registers['PMA_L0__pllctrl_fbdiv_mode01_preg__pllctrl_fbdiv_mode0_preg'] = "0x6"
		user_registers['PMA_L0__pllctrl_gen_d_preg__pllctrl_digdiv_mode0_preg'] = "0x06"
		user_registers['PMA_L0__det_standec_e_preg__clkrst_datart_div_mode0_preg'] = "0x2"
	else:
		user_registers['PMA_L0__pllctrl_fbdiv_mode01_preg__pllctrl_fbdiv_mode0_preg'] = "0x04"
		user_registers['PMA_L0__pllctrl_gen_d_preg__pllctrl_digdiv_mode0_preg'] = "0x06"
		user_registers['PMA_L0__det_standec_e_preg__clkrst_datart_div_mode0_preg'] = "0x3"
		if '1G_PCS_L0__pcs_control__enable_auto_neg' in user_registers and int(user_registers['1G_PCS_L0__pcs_control__enable_auto_neg']) == 1:
			user_registers['1G_PCS_L0__an_advertised_abilities__sgmii_mode'] = "0x1"
			user_registers['1G_PCS_L0__sgmii_cfg1__sgmii_an_mode'] = "0x1"
			user_registers['1G_PCS_L0__sgmii_cfg1__an_link_timeout_val'] = "0x186A0"
			user_registers['PIPE_CONFIG_CMN__config_reg_16__cfg_sgmii_clkdiv_en_p0'] = "0x1"
	return user_registers,f
def topo_1gbe_lane1(quad,user_registers,f):
	if ("2.5" in user_registers['ss_1gbe_data_rate_lane1']):
		user_registers['PMA_L1__det_standec_d_preg__clkrst_fullrt_divsel_mode0_preg'] = "0x1"
		user_registers['PMA_L1__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode0_preg'] = "0x0"
		user_registers['1G_PCS_L1__pcs_control__enable_auto_neg'] = "0"
		user_registers['PMA_L1__pllctrl_fbdiv_mode01_preg__pllctrl_fbdiv_mode0_preg'] = "0x6"
		user_registers['PMA_L1__pllctrl_gen_d_preg__pllctrl_digdiv_mode0_preg'] = "0x06"
		user_registers['PMA_L1__det_standec_e_preg__clkrst_datart_div_mode0_preg'] = "0x2"
	else:
		user_registers['PMA_L1__pllctrl_fbdiv_mode01_preg__pllctrl_fbdiv_mode0_preg'] = "0x04"
		user_registers['PMA_L1__pllctrl_gen_d_preg__pllctrl_digdiv_mode0_preg'] = "0x06"
		user_registers['PMA_L1__det_standec_e_preg__clkrst_datart_div_mode0_preg'] = "0x3"
		if '1G_PCS_L1__pcs_control__enable_auto_neg' in user_registers and int(user_registers['1G_PCS_L1__pcs_control__enable_auto_neg']) == 1:
			user_registers['1G_PCS_L1__an_advertised_abilities__sgmii_mode'] = "0x1"
			user_registers['1G_PCS_L1__sgmii_cfg1__sgmii_an_mode'] = "0x1"
			user_registers['1G_PCS_L1__sgmii_cfg1__an_link_timeout_val'] = "0x186A0"
			user_registers['PIPE_CONFIG_CMN__config_reg_16__cfg_sgmii_clkdiv_en_p1'] = "0x1"
	return user_registers,f
def topo_1gbe_lane2(quad,user_registers,f):
	if ("2.5" in user_registers['ss_1gbe_data_rate_lane2']):
		user_registers['PMA_L2__det_standec_d_preg__clkrst_fullrt_divsel_mode0_preg'] = "0x1"
		user_registers['PMA_L2__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode0_preg'] = "0x0"
		user_registers['1G_PCS_L2__pcs_control__enable_auto_neg'] = "0"
		user_registers['PMA_L2__pllctrl_fbdiv_mode01_preg__pllctrl_fbdiv_mode0_preg'] = "0x6"
		user_registers['PMA_L2__pllctrl_gen_d_preg__pllctrl_digdiv_mode0_preg'] = "0x06"
		user_registers['PMA_L2__det_standec_e_preg__clkrst_datart_div_mode0_preg'] = "0x2"
	else:
		user_registers['PMA_L2__pllctrl_fbdiv_mode01_preg__pllctrl_fbdiv_mode0_preg'] = "0x04"
		user_registers['PMA_L2__pllctrl_gen_d_preg__pllctrl_digdiv_mode0_preg'] = "0x06"
		user_registers['PMA_L2__det_standec_e_preg__clkrst_datart_div_mode0_preg'] = "0x3"
		if '1G_PCS_L2__pcs_control__enable_auto_neg' in user_registers and int(user_registers['1G_PCS_L2__pcs_control__enable_auto_neg']) == 1:
			user_registers['1G_PCS_L2__an_advertised_abilities__sgmii_mode'] = "0x1"
			user_registers['1G_PCS_L2__sgmii_cfg1__sgmii_an_mode'] = "0x1"
			user_registers['1G_PCS_L2__sgmii_cfg1__an_link_timeout_val'] = "0x186A0"
			user_registers['PIPE_CONFIG_CMN__config_reg_16__cfg_sgmii_clkdiv_en_p2'] = "0x1"
	return user_registers,f
def topo_1gbe_lane3(quad,user_registers,f):
	if ("2.5" in user_registers['ss_1gbe_data_rate_lane3']):
		user_registers['PMA_L3__det_standec_d_preg__clkrst_fullrt_divsel_mode0_preg'] = "0x1"
		user_registers['PMA_L3__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode0_preg'] = "0x0"
		user_registers['1G_PCS_L3__pcs_control__enable_auto_neg'] = "0"
		user_registers['PMA_L3__pllctrl_fbdiv_mode01_preg__pllctrl_fbdiv_mode0_preg'] = "0x6"
		user_registers['PMA_L3__pllctrl_gen_d_preg__pllctrl_digdiv_mode0_preg'] = "0x06"
		user_registers['PMA_L3__det_standec_e_preg__clkrst_datart_div_mode0_preg'] = "0x2"
	else:
		user_registers['PMA_L3__pllctrl_fbdiv_mode01_preg__pllctrl_fbdiv_mode0_preg'] = "0x04"
		user_registers['PMA_L3__pllctrl_gen_d_preg__pllctrl_digdiv_mode0_preg'] = "0x06"
		user_registers['PMA_L3__det_standec_e_preg__clkrst_datart_div_mode0_preg'] = "0x3"
		if '1G_PCS_L3__pcs_control__enable_auto_neg' in user_registers and int(user_registers['1G_PCS_L3__pcs_control__enable_auto_neg']) == 1:
			user_registers['1G_PCS_L3__an_advertised_abilities__sgmii_mode'] = "0x1"
			user_registers['1G_PCS_L3__sgmii_cfg1__sgmii_an_mode'] = "0x1"
			user_registers['1G_PCS_L3__sgmii_cfg1__an_link_timeout_val'] = "0x186A0"
			user_registers['PIPE_CONFIG_CMN__config_reg_16__cfg_sgmii_clkdiv_en_p3'] = "0x1"
	return user_registers,f
#----------------------------------------------------------------------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
#------------------------------------------- RAW Functions -----------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
def topo_raw_cmn(quad,user_registers,f):
	if 'ss_raw_refclk_freq' in user_registers:
		refclk = user_registers['ss_raw_refclk_freq'] 
		refclk_freq = float(refclk[:-3]) if "MHz" in refclk else float(refclk)
		if refclk_freq <= 50:
			user_registers['PMA_CMN__cmn_refrcv_preg__cmn_refrcv_bwval_preg'] = "0x0"
		elif refclk_freq <= 100:
			user_registers['PMA_CMN__cmn_refrcv_preg__cmn_refrcv_bwval_preg'] = "0x1"
		elif refclk_freq <= 150:
			user_registers['PMA_CMN__cmn_refrcv_preg__cmn_refrcv_bwval_preg'] = "0x2"
		else:
			user_registers['PMA_CMN__cmn_refrcv_preg__cmn_refrcv_bwval_preg'] = "0x3"

	return user_registers,f

def topo_raw_lane0(quad,user_registers,f):
	
	topo_lane0 = user_registers["ss_topology_lane0"]		
	topo_lane1 = user_registers["ss_topology_lane1"]		
	topo_lane2 = user_registers["ss_topology_lane2"]		
	topo_lane3 = user_registers["ss_topology_lane3"]
	data_rate = float(user_registers["ss_raw_data_rate_lane0"])

	if 'PMA_L0__det_standec_e_preg__clkrst_datart_div_mode0_preg' in user_registers:
		if user_registers['PMA_L0__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x0":
			user_registers['PMA_L0__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x198"
		elif user_registers['PMA_L0__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x1":
			user_registers['PMA_L0__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x330"
		elif user_registers['PMA_L0__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x2":
			user_registers['PMA_L0__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x660"
		elif user_registers['PMA_L0__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x3":
			user_registers['PMA_L0__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0xCC0"
		else:
			user_registers['PMA_L0__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x1980"
	else:
		user_registers['PMA_L0__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0xCC0"

	if user_registers['ss_raw_serdes_width_lane0'] not in ["20 bits","32 bits","40 bits","64 bits"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_serdes_width_lane0 is out of range.")
	elif user_registers['ss_raw_serdes_width_lane0'] == "20 bits" or user_registers['ss_raw_serdes_width_lane0'] == "40 bits":
		user_registers['PIPE_CONFIG_L0__config_reg_3__pma_xcvr_data_width_p_0'] = "0x5"
		if user_registers['ss_raw_serdes_width_lane0'] == "20 bits": #STD_PCS_L0__config_reg_0 = 0x80C4
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_pcs_ch0_mode'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ser_en_0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_deser_en_0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_rx_word_swap_0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_bitslip_en_0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_core_if_width_0'] = "0x0"
		else: #STD_PCS_L0__config_reg_0 = 0xC80C0
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_pcs_ch0_mode'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ser_en_0'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_deser_en_0'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_rx_word_swap_0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_bitslip_en_0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_core_if_width_0'] = "0x0"
	elif user_registers['ss_raw_serdes_width_lane0'] == "32 bits" or user_registers['ss_raw_serdes_width_lane0'] == "64 bits":
		user_registers['PIPE_CONFIG_L0__config_reg_3__pma_xcvr_data_width_p_0'] = "0x2"
		if user_registers['ss_raw_serdes_width_lane0'] == "32 bits": #STD_PCS_L0__config_reg_0 = 0x80C4
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_pcs_ch0_mode'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ser_en_0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_deser_en_0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_rx_word_swap_0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_bitslip_en_0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_core_if_width_0'] = "0x0"
		else: #STD_PCS_L0__config_reg_0 = 0xC80C0
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ch0_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_pcs_ch0_mode'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_ser_en_0'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_deser_en_0'] = "0x1"
			user_registers['STD_PCS_L0__config_reg_0__cfg_rx_word_swap_0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_bitslip_en_0'] = "0x0"
			user_registers['STD_PCS_L0__config_reg_0__cfg_core_if_width_0'] = "0x0"


	if user_registers['ss_raw_bundle_mode_lane0'] not in ["x1","x2","x4","x8 (Rx only)"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_bundle_mode_lane0 is out of range.")
	elif user_registers['ss_raw_bundle_mode_lane0'] == "x2":
		user_registers['PIPE_CONFIG_CMN__config_reg_22__cfg_bonding_mode_tx0'] = "0x1"

	elif user_registers['ss_raw_bundle_mode_lane0'] == "x4" or user_registers['ss_raw_bundle_mode_lane0'] == "x8 (Rx only)":
		user_registers['PIPE_CONFIG_CMN__config_reg_22__cfg_bonding_mode_tx0'] = "0x2"

	if user_registers['ss_raw_eq_eval_lane0'] not in ["0","1"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_eq_eval_lane0 is out of range.")

	# Raw settings different from 10G default settings - overwrite here...
	user_registers['STD_PCS_L0__config_reg_1__cfg_bypass_pcfifo_tx0'] = "0"
	user_registers['STD_PCS_L0__config_reg_1__Reserved_4_1'] = "0"
	user_registers['STD_PCS_L0__config_reg_1__Reserved_8_5'] = "0"
	user_registers['STD_PCS_L0__config_reg_1__cfg_ps_clksel_tx0'] = "0"
	user_registers['STD_PCS_L0__config_reg_1__Reserved_10'] = "0"
	user_registers['STD_PCS_L0__config_reg_1__cfg_timing_flop_en_tx0'] = "1"
	user_registers['STD_PCS_L0__config_reg_1__cfg_pcs_mode_sel_tx0'] = "0"
	user_registers['STD_PCS_L0__config_reg_1__Reserved_17_14'] = "0"
	user_registers['STD_PCS_L0__config_reg_1__Reserved_21_18'] = "0"
	user_registers['STD_PCS_L0__config_reg_1__Reserved_23'] = "0"
	user_registers['STD_PCS_L0__config_reg_1__cfg_timing_flop_en_rx0'] = "1"
	user_registers['STD_PCS_L0__config_reg_1__cfg_pcs_mode_sel_rx0'] = "1"
	if user_registers['ss_raw_mode_lane0'] == 'Tx FIFO, Rx Register':
		user_registers['STD_PCS_L0__config_reg_1__cfg_bypass_pcfifo_rx0'] = "1"
		user_registers['STD_PCS_L0__config_reg_1__cfg_ps_clksel_rx0'] = "1"
	else:
		user_registers['STD_PCS_L0__config_reg_1__cfg_bypass_pcfifo_rx0'] = "0"
		user_registers['STD_PCS_L0__config_reg_1__cfg_ps_clksel_rx0'] = "0"		
	user_registers['PIPE_CONFIG_L0__config_reg_4__phy_link_cfg_ln_0'] = "0"
	user_registers['PIPE_CONFIG_L0__config_reg_4__phy_p00_mode'] = "0x3"
	user_registers['PIPE_CONFIG_L0__config_reg_4__phy_p00_eth_mode'] = "0"
	user_registers['PIPE_CONFIG_L0__config_reg_4__phy_p00_eth_mode_en'] = "0"        

	if user_registers['ss_raw_tx_eq_mode_lane0'] not in ["Deemphasis", "3 taps FIR filter"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_tx_eq_mode_lane0 is out of range.")
	elif user_registers['ss_raw_tx_eq_mode_lane0'] == "Deemphasis":
		user_registers['PMA_L0__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode0_preg'] = "0"
		user_registers['PMA_L0__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode1_preg'] = "0"
		user_registers['PMA_L0__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode2_preg'] = "0"
		user_registers['PMA_L0__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode3_preg'] = "0"
		if user_registers['ss_raw_deem_lane0'] == "Off":
			user_registers['PIPE_CONFIG_L0__config_reg_11__pma_tx_deemphasis_ln_0'] = "0x2"
		elif user_registers['ss_raw_deem_lane0'] == "3.5dB":
			user_registers['PIPE_CONFIG_L0__config_reg_11__pma_tx_deemphasis_ln_0'] = "0x1"
		elif user_registers['ss_raw_deem_lane0'] == "6dB":
			user_registers['PIPE_CONFIG_L0__config_reg_11__pma_tx_deemphasis_ln_0'] = "0x0"
	elif user_registers['ss_raw_tx_eq_mode_lane0'] == "3 taps FIR filter":
		main_c0_bin = (bin(int(user_registers['ss_raw_main_c0_lane0'], 16)))[2:]
		if (len(main_c0_bin) < 6):
			diff = 6 - len(main_c0_bin)
			for i in range(diff):
				main_c0_bin = '0' + main_c0_bin
		pre_c_bin = (bin(int(user_registers['ss_raw_pre_c_lane0'], 16)))[2:]
		if (len(pre_c_bin) < 6):
			diff = 6 - len(pre_c_bin)
			for i in range(diff):
				pre_c_bin = '0' + pre_c_bin
		post_c_bin = (bin(int(user_registers['ss_raw_post_c_lane0'], 16)))[2:]
		if (len(post_c_bin) < 6):
			diff = 6 - len(post_c_bin)
			for i in range(diff):
				post_c_bin = '0' + post_c_bin
		deem_value = post_c_bin + main_c0_bin + pre_c_bin
		user_registers['PIPE_CONFIG_L0__config_reg_11__pma_tx_deemphasis_ln_0'] = hex(int(deem_value, 2))

	if (data_rate > 8):
		user_registers['PMA_L0__det_standec_a_preg__ser_gt8g_mode0_preg'] = "0x1"
  
	if (data_rate >= 8):
		user_registers['PMA_L0__deq_vga_ratesel_preg__vga_ratesel_mode0_preg'] = "0x3"
  
	if (data_rate > 11.4 and ("20" in user_registers['ss_raw_serdes_width_lane0'] or "40" in user_registers['ss_raw_serdes_width_lane0'])):
		user_registers['PMA_L0__deq_epipwr_ctrl_preg__epion_time_preg'] = "0x1F4"
  
	if (data_rate == 10 and ("32" in user_registers['ss_raw_serdes_width_lane0'] or "64" in user_registers['ss_raw_serdes_width_lane0'])):
		user_registers['PMA_L0__dfe_ecmp_ratesel_preg__ecmp_ratesel_mode0_preg'] = "0x1"
		user_registers['PMA_L0__dfe_smp_ratesel_preg__smp_ratesel_mode0_preg'] = "0x1"
  
	if (data_rate >= 10 and ("32" in user_registers['ss_raw_serdes_width_lane0'] or "64" in user_registers['ss_raw_serdes_width_lane0'])):
		user_registers['PIPE_CONFIG_L0__config_reg_11__pma_tx_vmargin_ln_0'] = "0x0"
	else:
		user_registers['PIPE_CONFIG_L0__config_reg_11__pma_tx_vmargin_ln_0'] = "0x3"
	user_registers['PIPE_CONFIG_L0__config_reg_11__pma_tx_low_power_swing_en_ln_0'] = "0x0"
	user_registers['PIPE_CONFIG_L0__config_reg_11__pma_rx_termination_ln_0'] = "0x1"
	user_registers['PIPE_CONFIG_L0__config_reg_11__pipe_l00_rx_polarity'] = "0x0"
	user_registers['PIPE_CONFIG_L0__config_reg_11__pma_tx_get_local_init_coef_ln_0'] = "0x0"
	user_registers['PIPE_CONFIG_L0__config_reg_11__pma_tx_get_local_preset_coef_ln_0'] = "0x0"
	user_registers['PIPE_CONFIG_L0__config_reg_11__pma_tx_local_preset_index_ln_0'] = "0x0"

	return user_registers,f

def topo_raw_lane1(quad,user_registers,f):
	
	topo_lane0 = user_registers["ss_topology_lane0"]		
	topo_lane1 = user_registers["ss_topology_lane1"]		
	topo_lane2 = user_registers["ss_topology_lane2"]		
	topo_lane3 = user_registers["ss_topology_lane3"]
	data_rate = float(user_registers["ss_raw_data_rate_lane1"])

	if 'PMA_L1__det_standec_e_preg__clkrst_datart_div_mode0_preg' in user_registers:
		if user_registers['PMA_L1__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x0":
			user_registers['PMA_L1__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x198"
		elif user_registers['PMA_L1__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x1":
			user_registers['PMA_L1__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x330"
		elif user_registers['PMA_L1__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x2":
			user_registers['PMA_L1__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x660"
		elif user_registers['PMA_L1__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x3":
			user_registers['PMA_L1__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0xCC0"
		else:
			user_registers['PMA_L1__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x1980"
	else:
		user_registers['PMA_L1__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0xCC0"

	if user_registers['ss_raw_serdes_width_lane1'] not in ["20 bits","32 bits","40 bits","64 bits"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_serdes_width_lane1 is out of range.")
	elif user_registers['ss_raw_serdes_width_lane1'] == "20 bits" or user_registers['ss_raw_serdes_width_lane1'] == "40 bits":
		user_registers['PIPE_CONFIG_L1__config_reg_5__pma_xcvr_data_width_p_1'] = "0x5"
		if user_registers['ss_raw_serdes_width_lane1'] == "20 bits": #STD_PCS_L1__config_reg_2 = 0x80C4
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_pcs_ch1_mode'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ser_en_1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_deser_en_1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_rx_word_swap_1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_bitslip_en_1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_core_if_width_1'] = "0x0"
		else: #STD_PCS_L1__config_reg_2 = 0xC80C0
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_pcs_ch1_mode'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ser_en_1'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_deser_en_1'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_rx_word_swap_1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_bitslip_en_1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_core_if_width_1'] = "0x0"
	elif user_registers['ss_raw_serdes_width_lane1'] == "32 bits" or user_registers['ss_raw_serdes_width_lane1'] == "64 bits":
		user_registers['PIPE_CONFIG_L1__config_reg_5__pma_xcvr_data_width_p_1'] = "0x2"
		if user_registers['ss_raw_serdes_width_lane1'] == "32 bits": #STD_PCS_L1__config_reg_2 = 0x80C4
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_pcs_ch1_mode'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ser_en_1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_deser_en_1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_rx_word_swap_1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_bitslip_en_1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_core_if_width_1'] = "0x0"
		else: #STD_PCS_L1__config_reg_2 = 0xC80C0
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ch1_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_pcs_ch1_mode'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_ser_en_1'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_deser_en_1'] = "0x1"
			user_registers['STD_PCS_L1__config_reg_2__cfg_rx_word_swap_1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_bitslip_en_1'] = "0x0"
			user_registers['STD_PCS_L1__config_reg_2__cfg_core_if_width_1'] = "0x0"



	if user_registers['ss_raw_bundle_mode_lane1'] not in ["x1","x2","x4","x8 (Rx only)"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_bundle_mode_lane1 is out of range.")
	elif user_registers['ss_raw_bundle_mode_lane1'] == "x2":
		user_registers['PIPE_CONFIG_CMN__config_reg_22__cfg_bonding_mode_tx1'] = "0x1"

	elif user_registers['ss_raw_bundle_mode_lane1'] == "x4" or user_registers['ss_raw_bundle_mode_lane1'] == "x8 (Rx only)":
		user_registers['PIPE_CONFIG_CMN__config_reg_22__cfg_bonding_mode_tx1'] = "0x2"

	if user_registers['ss_raw_eq_eval_lane1'] not in ["0","1"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_eq_eval_lane1 is out of range.")

	# Raw settings different from 10G default settings - overwrite here...
	user_registers['STD_PCS_L1__config_reg_3__cfg_bypass_pcfifo_tx1'] = "0"
	user_registers['STD_PCS_L1__config_reg_3__Reserved_4_1'] = "0"
	user_registers['STD_PCS_L1__config_reg_3__Reserved_8_5'] = "0"
	user_registers['STD_PCS_L1__config_reg_3__cfg_ps_clksel_tx1'] = "0"
	user_registers['STD_PCS_L1__config_reg_3__Reserved_10'] = "0"
	user_registers['STD_PCS_L1__config_reg_3__cfg_timing_flop_en_tx1'] = "1"
	user_registers['STD_PCS_L1__config_reg_3__cfg_pcs_mode_sel_tx1'] = "0"
	user_registers['STD_PCS_L1__config_reg_3__Reserved_17_14'] = "0"
	user_registers['STD_PCS_L1__config_reg_3__Reserved_21_18'] = "0"
	user_registers['STD_PCS_L1__config_reg_3__Reserved_23'] = "0"
	user_registers['STD_PCS_L1__config_reg_3__cfg_timing_flop_en_rx1'] = "1"
	user_registers['STD_PCS_L1__config_reg_3__cfg_pcs_mode_sel_rx1'] = "1"
	if user_registers['ss_raw_mode_lane1'] == 'Tx FIFO, Rx Register':
		user_registers['STD_PCS_L1__config_reg_3__cfg_bypass_pcfifo_rx1'] = "1"
		user_registers['STD_PCS_L1__config_reg_3__cfg_ps_clksel_rx1'] = "1"
	else:
		user_registers['STD_PCS_L1__config_reg_3__cfg_bypass_pcfifo_rx1'] = "0"
		user_registers['STD_PCS_L1__config_reg_3__cfg_ps_clksel_rx1'] = "0"
	user_registers['PIPE_CONFIG_L1__config_reg_6__phy_link_cfg_ln_1'] = "0x1"
	user_registers['PIPE_CONFIG_L1__config_reg_6__phy_p01_mode'] = "0x3"
	user_registers['PIPE_CONFIG_L1__config_reg_6__phy_p01_eth_mode'] = "0"
	user_registers['PIPE_CONFIG_L1__config_reg_6__phy_p01_eth_mode_en'] = "0"
        
	if user_registers['ss_raw_tx_eq_mode_lane1'] not in ["Deemphasis", "3 taps FIR filter"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_tx_eq_mode_lane1 is out of range.")
	elif user_registers['ss_raw_tx_eq_mode_lane1'] == "Deemphasis":
		user_registers['PMA_L1__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode0_preg'] = "0"
		user_registers['PMA_L1__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode1_preg'] = "0"
		user_registers['PMA_L1__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode2_preg'] = "0"
		user_registers['PMA_L1__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode3_preg'] = "0"
		if user_registers['ss_raw_deem_lane1'] == "Off":
			user_registers['PIPE_CONFIG_L1__config_reg_12__pma_tx_deemphasis_ln_1'] = "0x2"
		elif user_registers['ss_raw_deem_lane1'] == "3.5dB":
			user_registers['PIPE_CONFIG_L1__config_reg_12__pma_tx_deemphasis_ln_1'] = "0x1"
		elif user_registers['ss_raw_deem_lane1'] == "6dB":
			user_registers['PIPE_CONFIG_L1__config_reg_12__pma_tx_deemphasis_ln_1'] = "0x0"
	elif user_registers['ss_raw_tx_eq_mode_lane1'] == "3 taps FIR filter":
		main_c0_bin = (bin(int(user_registers['ss_raw_main_c0_lane1'], 16)))[2:]
		if (len(main_c0_bin) < 6):
			diff = 6 - len(main_c0_bin)
			for i in range(diff):
				main_c0_bin = '0' + main_c0_bin
		pre_c_bin = (bin(int(user_registers['ss_raw_pre_c_lane1'], 16)))[2:]
		if (len(pre_c_bin) < 6):
			diff = 6 - len(pre_c_bin)
			for i in range(diff):
				pre_c_bin = '0' + pre_c_bin
		post_c_bin = (bin(int(user_registers['ss_raw_post_c_lane1'], 16)))[2:]
		if (len(post_c_bin) < 6):
			diff = 6 - len(post_c_bin)
			for i in range(diff):
				post_c_bin = '0' + post_c_bin
		deem_value = post_c_bin + main_c0_bin + pre_c_bin
		user_registers['PIPE_CONFIG_L1__config_reg_12__pma_tx_deemphasis_ln_1'] = hex(int(deem_value, 2))

	if (data_rate > 8):
		user_registers['PMA_L1__det_standec_a_preg__ser_gt8g_mode0_preg'] = "0x1"
  
	if (data_rate >= 8):
		user_registers['PMA_L1__deq_vga_ratesel_preg__vga_ratesel_mode0_preg'] = "0x3"
  
	if (data_rate > 11.4 and ("20" in user_registers['ss_raw_serdes_width_lane1'] or "40" in user_registers['ss_raw_serdes_width_lane1'])):
		user_registers['PMA_L1__deq_epipwr_ctrl_preg__epion_time_preg'] = "0x1F4"
  
	if (data_rate == 10 and ("32" in user_registers['ss_raw_serdes_width_lane1'] or "64" in user_registers['ss_raw_serdes_width_lane1'])):
		user_registers['PMA_L1__dfe_ecmp_ratesel_preg__ecmp_ratesel_mode0_preg'] = "0x1"
		user_registers['PMA_L1__dfe_smp_ratesel_preg__smp_ratesel_mode0_preg'] = "0x1"
  
	if (data_rate >= 10 and ("32" in user_registers['ss_raw_serdes_width_lane1'] or "64" in user_registers['ss_raw_serdes_width_lane1'])):
		user_registers['PIPE_CONFIG_L1__config_reg_12__pma_tx_vmargin_ln_1'] = "0x0"
	else:
		user_registers['PIPE_CONFIG_L1__config_reg_12__pma_tx_vmargin_ln_1'] = "0x3"
	user_registers['PIPE_CONFIG_L1__config_reg_12__pma_tx_low_power_swing_en_ln_1'] = "0x0"
	user_registers['PIPE_CONFIG_L1__config_reg_12__pma_rx_termination_ln_1'] = "0x1"
	user_registers['PIPE_CONFIG_L1__config_reg_12__pipe_l01_rx_polarity'] = "0x0"
	user_registers['PIPE_CONFIG_L1__config_reg_12__pma_tx_get_local_init_coef_ln_1'] = "0x0"
	user_registers['PIPE_CONFIG_L1__config_reg_12__pma_tx_get_local_preset_coef_ln_1'] = "0x0"
	user_registers['PIPE_CONFIG_L1__config_reg_12__pma_tx_local_preset_index_ln_1'] = "0x0"


	return user_registers,f

def topo_raw_lane2(quad,user_registers,f):
	
	topo_lane0 = user_registers["ss_topology_lane0"]		
	topo_lane1 = user_registers["ss_topology_lane1"]		
	topo_lane2 = user_registers["ss_topology_lane2"]		
	topo_lane3 = user_registers["ss_topology_lane3"]
	data_rate = float(user_registers["ss_raw_data_rate_lane2"])

	if 'PMA_L2__det_standec_e_preg__clkrst_datart_div_mode0_preg' in user_registers:
		if user_registers['PMA_L2__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x0":
			user_registers['PMA_L2__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x198"
		elif user_registers['PMA_L2__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x1":
			user_registers['PMA_L2__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x330"
		elif user_registers['PMA_L2__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x2":
			user_registers['PMA_L2__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x660"
		elif user_registers['PMA_L2__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x3":
			user_registers['PMA_L2__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0xCC0"
		else:
			user_registers['PMA_L2__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x1980"
	else:
		user_registers['PMA_L2__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0xCC0"

	if user_registers['ss_raw_serdes_width_lane2'] not in ["20 bits","32 bits","40 bits","64 bits"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_serdes_width_lane2 is out of range.")
	elif user_registers['ss_raw_serdes_width_lane2'] == "20 bits" or user_registers['ss_raw_serdes_width_lane2'] == "40 bits":
		user_registers['PIPE_CONFIG_L2__config_reg_7__pma_xcvr_data_width_p_2'] = "0x5"
		if user_registers['ss_raw_serdes_width_lane2'] == "20 bits": #STD_PCS_L2__config_reg_4 = 0x80C4
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_pcs_ch2_mode'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ser_en_2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_deser_en_2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_rx_word_swap_2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_bitslip_en_2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_core_if_width_2'] = "0x0"
		else: #STD_PCS_L2__config_reg_4 = 0xC80C0
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_pcs_ch2_mode'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ser_en_2'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_deser_en_2'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_rx_word_swap_2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_bitslip_en_2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_core_if_width_2'] = "0x0"
	elif user_registers['ss_raw_serdes_width_lane2'] == "32 bits" or user_registers['ss_raw_serdes_width_lane2'] == "64 bits":
		user_registers['PIPE_CONFIG_L2__config_reg_7__pma_xcvr_data_width_p_2'] = "0x2"
		if user_registers['ss_raw_serdes_width_lane2'] == "32 bits": #STD_PCS_L2__config_reg_4 = 0x80C4
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_pcs_ch2_mode'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ser_en_2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_deser_en_2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_rx_word_swap_2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_bitslip_en_2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_core_if_width_2'] = "0x0"
		else: #STD_PCS_L2__config_reg_4 = 0xC80C0
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ch2_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_pcs_ch2_mode'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_ser_en_2'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_deser_en_2'] = "0x1"
			user_registers['STD_PCS_L2__config_reg_4__cfg_rx_word_swap_2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_bitslip_en_2'] = "0x0"
			user_registers['STD_PCS_L2__config_reg_4__cfg_core_if_width_2'] = "0x0"


	if user_registers['ss_raw_bundle_mode_lane2'] not in ["x1","x2","x4","x8 (Rx only)"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_bundle_mode_lane2 is out of range.")
	elif user_registers['ss_raw_bundle_mode_lane2'] == "x2":
		user_registers['PIPE_CONFIG_CMN__config_reg_22__cfg_bonding_mode_tx2'] = "0x1"

	elif user_registers['ss_raw_bundle_mode_lane2'] == "x4" or user_registers['ss_raw_bundle_mode_lane2'] == "x8 (Rx only)":
		user_registers['PIPE_CONFIG_CMN__config_reg_22__cfg_bonding_mode_tx2'] = "0x2"

	if user_registers['ss_raw_eq_eval_lane2'] not in ["0","1"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_eq_eval_lane2 is out of range.")

	# Raw settings different from 10G default settings - overwrite here...
	user_registers['STD_PCS_L2__config_reg_5__cfg_bypass_pcfifo_tx2'] = "0"
	user_registers['STD_PCS_L2__config_reg_5__Reserved_4_1'] = "0"
	user_registers['STD_PCS_L2__config_reg_5__Reserved_8_5'] = "0"
	user_registers['STD_PCS_L2__config_reg_5__cfg_ps_clksel_tx2'] = "0"
	user_registers['STD_PCS_L2__config_reg_5__Reserved_10'] = "0"
	user_registers['STD_PCS_L2__config_reg_5__cfg_timing_flop_en_tx2'] = "1"
	user_registers['STD_PCS_L2__config_reg_5__cfg_pcs_mode_sel_tx2'] = "0"
	user_registers['STD_PCS_L2__config_reg_5__Reserved_17_14'] = "0"
	user_registers['STD_PCS_L2__config_reg_5__Reserved_21_18'] = "0"
	user_registers['STD_PCS_L2__config_reg_5__Reserved_23'] = "0"
	user_registers['STD_PCS_L2__config_reg_5__cfg_timing_flop_en_rx2'] = "1"
	user_registers['STD_PCS_L2__config_reg_5__cfg_pcs_mode_sel_rx2'] = "1"
	if user_registers['ss_raw_mode_lane2'] == 'Tx FIFO, Rx Register':
		user_registers['STD_PCS_L2__config_reg_5__cfg_bypass_pcfifo_rx2'] = "1"
		user_registers['STD_PCS_L2__config_reg_5__cfg_ps_clksel_rx2'] = "1"
	else:
		user_registers['STD_PCS_L2__config_reg_5__cfg_bypass_pcfifo_rx2'] = "0"
		user_registers['STD_PCS_L2__config_reg_5__cfg_ps_clksel_rx2'] = "0"
	user_registers['PIPE_CONFIG_L2__config_reg_8__phy_link_cfg_ln_2'] = "0x2"
	user_registers['PIPE_CONFIG_L2__config_reg_8__phy_p02_mode'] = "0x3"
	user_registers['PIPE_CONFIG_L2__config_reg_8__phy_p02_eth_mode'] = "0"
	user_registers['PIPE_CONFIG_L2__config_reg_8__phy_p02_eth_mode_en'] = "0"

	if user_registers['ss_raw_tx_eq_mode_lane2'] not in ["Deemphasis", "3 taps FIR filter"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_tx_eq_mode_lane2 is out of range.")
	elif user_registers['ss_raw_tx_eq_mode_lane2'] == "Deemphasis":
		user_registers['PMA_L2__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode0_preg'] = "0"
		user_registers['PMA_L2__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode1_preg'] = "0"
		user_registers['PMA_L2__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode2_preg'] = "0"
		user_registers['PMA_L2__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode3_preg'] = "0"
		if user_registers['ss_raw_deem_lane2'] == "Off":
			user_registers['PIPE_CONFIG_L2__config_reg_13__pma_tx_deemphasis_ln_2'] = "0x2"
		elif user_registers['ss_raw_deem_lane2'] == "3.5dB":
			user_registers['PIPE_CONFIG_L2__config_reg_13__pma_tx_deemphasis_ln_2'] = "0x1"
		elif user_registers['ss_raw_deem_lane2'] == "6dB":
			user_registers['PIPE_CONFIG_L2__config_reg_13__pma_tx_deemphasis_ln_2'] = "0x0"
	elif user_registers['ss_raw_tx_eq_mode_lane2'] == "3 taps FIR filter":
		main_c0_bin = (bin(int(user_registers['ss_raw_main_c0_lane2'], 16)))[2:]
		if (len(main_c0_bin) < 6):
			diff = 6 - len(main_c0_bin)
			for i in range(diff):
				main_c0_bin = '0' + main_c0_bin
		pre_c_bin = (bin(int(user_registers['ss_raw_pre_c_lane2'], 16)))[2:]
		if (len(pre_c_bin) < 6):
			diff = 6 - len(pre_c_bin)
			for i in range(diff):
				pre_c_bin = '0' + pre_c_bin
		post_c_bin = (bin(int(user_registers['ss_raw_post_c_lane2'], 16)))[2:]
		if (len(post_c_bin) < 6):
			diff = 6 - len(post_c_bin)
			for i in range(diff):
				post_c_bin = '0' + post_c_bin
		deem_value = post_c_bin + main_c0_bin + pre_c_bin
		user_registers['PIPE_CONFIG_L2__config_reg_13__pma_tx_deemphasis_ln_2'] = hex(int(deem_value, 2))

	if (data_rate > 8):
		user_registers['PMA_L2__det_standec_a_preg__ser_gt8g_mode0_preg'] = "0x1"
  
	if (data_rate >= 8):
		user_registers['PMA_L2__deq_vga_ratesel_preg__vga_ratesel_mode0_preg'] = "0x3"

	if (data_rate > 11.4 and ("20" in user_registers['ss_raw_serdes_width_lane2'] or "40" in user_registers['ss_raw_serdes_width_lane2'])):
		user_registers['PMA_L2__deq_epipwr_ctrl_preg__epion_time_preg'] = "0x1F4"
  
	if (data_rate == 10 and ("32" in user_registers['ss_raw_serdes_width_lane2'] or "64" in user_registers['ss_raw_serdes_width_lane2'])):
		user_registers['PMA_L2__dfe_ecmp_ratesel_preg__ecmp_ratesel_mode0_preg'] = "0x1"
		user_registers['PMA_L2__dfe_smp_ratesel_preg__smp_ratesel_mode0_preg'] = "0x1"
  
	if (data_rate >= 10 and ("32" in user_registers['ss_raw_serdes_width_lane2'] or "64" in user_registers['ss_raw_serdes_width_lane2'])):
		user_registers['PIPE_CONFIG_L2__config_reg_13__pma_tx_vmargin_ln_2'] = "0x0"
	else:
		user_registers['PIPE_CONFIG_L2__config_reg_13__pma_tx_vmargin_ln_2'] = "0x3"
	user_registers['PIPE_CONFIG_L2__config_reg_13__pma_tx_low_power_swing_en_ln_2'] = "0x0"
	user_registers['PIPE_CONFIG_L2__config_reg_13__pma_rx_termination_ln_2'] = "0x1"
	user_registers['PIPE_CONFIG_L2__config_reg_13__pipe_l02_rx_polarity'] = "0x0"
	user_registers['PIPE_CONFIG_L2__config_reg_13__pma_tx_get_local_init_coef_ln_2'] = "0x0"
	user_registers['PIPE_CONFIG_L2__config_reg_13__pma_tx_get_local_preset_coef_ln_2'] = "0x0"
	user_registers['PIPE_CONFIG_L2__config_reg_13__pma_tx_local_preset_index_ln_2'] = "0x0"

	return user_registers,f

def topo_raw_lane3(quad,user_registers,f):
	
	topo_lane0 = user_registers["ss_topology_lane0"]		
	topo_lane1 = user_registers["ss_topology_lane1"]		
	topo_lane2 = user_registers["ss_topology_lane2"]		
	topo_lane3 = user_registers["ss_topology_lane3"]
	data_rate = float(user_registers["ss_raw_data_rate_lane3"])

	if 'PMA_L3__det_standec_e_preg__clkrst_datart_div_mode0_preg' in user_registers:
		if user_registers['PMA_L3__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x0":
			user_registers['PMA_L3__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x198"
		elif user_registers['PMA_L3__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x1":
			user_registers['PMA_L3__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x330"
		elif user_registers['PMA_L3__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x2":
			user_registers['PMA_L3__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x660"
		elif user_registers['PMA_L3__det_standec_e_preg__clkrst_datart_div_mode0_preg'] == "0x3":
			user_registers['PMA_L3__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0xCC0"
		else:
			user_registers['PMA_L3__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0x1980"
	else:
		user_registers['PMA_L3__cpical_tmrval_mode0_preg__cpical_tmrval_mode0_preg'] = "0xCC0"
 
	if user_registers['ss_raw_serdes_width_lane3'] not in ["20 bits","32 bits","40 bits","64 bits"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_serdes_width_lane3 is out of range.")
	elif user_registers['ss_raw_serdes_width_lane3'] == "20 bits" or user_registers['ss_raw_serdes_width_lane3'] == "40 bits":
		user_registers['PIPE_CONFIG_L3__config_reg_9__pma_xcvr_data_width_p_3'] = "0x5"
		if user_registers['ss_raw_serdes_width_lane3'] == "20 bits": #STD_PCS_L3__config_reg_6 = 0x80C4
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_pcs_ch3_mode'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ser_en_3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_deser_en_3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_rx_word_swap_3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_bitslip_en_3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_core_if_width_3'] = "0x0"
		else: #STD_PCS_L3__config_reg_6 = 0xC80C0
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_pcs_ch3_mode'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ser_en_3'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_deser_en_3'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_rx_word_swap_3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_bitslip_en_3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_core_if_width_3'] = "0x0"
	elif user_registers['ss_raw_serdes_width_lane3'] == "32 bits" or user_registers['ss_raw_serdes_width_lane3'] == "64 bits":
		user_registers['PIPE_CONFIG_L3__config_reg_9__pma_xcvr_data_width_p_3'] = "0x2"
		if user_registers['ss_raw_serdes_width_lane3'] == "32 bits": #STD_PCS_L3__config_reg_6 = 0x80C4
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_top_clksel2'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_pcs_ch3_mode'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ser_en_3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_deser_en_3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_rx_word_swap_3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_bitslip_en_3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_core_if_width_3'] = "0x0"
		else: #STD_PCS_L3__config_reg_6 = 0xC80C0
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_bot_clksel3'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_tx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_top_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_top_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_top_clksel2'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel0'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel1'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel2'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_bot_clksel3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ch3_rx_fwd_clksel'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_pcs_ch3_mode'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_ser_en_3'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_deser_en_3'] = "0x1"
			user_registers['STD_PCS_L3__config_reg_6__cfg_rx_word_swap_3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_bitslip_en_3'] = "0x0"
			user_registers['STD_PCS_L3__config_reg_6__cfg_core_if_width_3'] = "0x0"


	if user_registers['ss_raw_bundle_mode_lane3'] not in ["x1","x2","x4","x8 (Rx only)"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_bundle_mode_lane3 is out of range.")
	elif user_registers['ss_raw_bundle_mode_lane3'] == "x2":
		user_registers['PIPE_CONFIG_CMN__config_reg_22__cfg_bonding_mode_tx3'] = "0x1"

	elif user_registers['ss_raw_bundle_mode_lane3'] == "x4" or user_registers['ss_raw_bundle_mode_lane3'] == "x8 (Rx only)":
		user_registers['PIPE_CONFIG_CMN__config_reg_22__cfg_bonding_mode_tx3'] = "0x2"

	if user_registers['ss_raw_eq_eval_lane3'] not in ["0","1"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_eq_eval_lane3 is out of range.")

	# Raw settings different from 10G default settings - overwrite here...
	user_registers['STD_PCS_L3__config_reg_7__cfg_bypass_pcfifo_tx3'] = "0"
	user_registers['STD_PCS_L3__config_reg_7__Reserved_4_1'] = "0"
	user_registers['STD_PCS_L3__config_reg_7__Reserved_8_5'] = "0"
	user_registers['STD_PCS_L3__config_reg_7__cfg_ps_clksel_tx3'] = "0"
	user_registers['STD_PCS_L3__config_reg_7__Reserved_10'] = "0"
	user_registers['STD_PCS_L3__config_reg_7__cfg_timing_flop_en_tx3'] = "1"
	user_registers['STD_PCS_L3__config_reg_7__cfg_pcs_mode_sel_tx3'] = "0"
	user_registers['STD_PCS_L3__config_reg_7__Reserved_17_14'] = "0"
	user_registers['STD_PCS_L3__config_reg_7__Reserved_21_18'] = "0"
	user_registers['STD_PCS_L3__config_reg_7__Reserved_23'] = "0"
	user_registers['STD_PCS_L3__config_reg_7__cfg_timing_flop_en_rx3'] = "1"
	user_registers['STD_PCS_L3__config_reg_7__cfg_pcs_mode_sel_rx3'] = "1"
	if user_registers['ss_raw_mode_lane3'] == 'Tx FIFO, Rx Register':
		user_registers['STD_PCS_L3__config_reg_7__cfg_bypass_pcfifo_rx3'] = "1"
		user_registers['STD_PCS_L3__config_reg_7__cfg_ps_clksel_rx3'] = "1"
	else:
		user_registers['STD_PCS_L3__config_reg_7__cfg_bypass_pcfifo_rx3'] = "0"
		user_registers['STD_PCS_L3__config_reg_7__cfg_ps_clksel_rx3'] = "0"
	user_registers['PIPE_CONFIG_L3__config_reg_10__phy_link_cfg_ln_3'] = "0x3"
	user_registers['PIPE_CONFIG_L3__config_reg_10__phy_p03_mode'] = "0x3"
	user_registers['PIPE_CONFIG_L3__config_reg_10__phy_p03_eth_mode'] = "0"
	user_registers['PIPE_CONFIG_L3__config_reg_10__phy_p03_eth_mode_en'] = "0"

	if user_registers['ss_raw_tx_eq_mode_lane3'] not in ["Deemphasis", "3 taps FIR filter"]:
		f['design_warnings'].append("ERROR: The selected value of ss_raw_tx_eq_mode_lane3 is out of range.")
	elif user_registers['ss_raw_tx_eq_mode_lane3'] == "Deemphasis":
		user_registers['PMA_L3__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode0_preg'] = "0"
		user_registers['PMA_L3__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode1_preg'] = "0"
		user_registers['PMA_L3__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode2_preg'] = "0"
		user_registers['PMA_L3__det_standec_a_preg__tx_deemphasis_ctrl_sel_mode3_preg'] = "0"
		if user_registers['ss_raw_deem_lane3'] == "Off":
			user_registers['PIPE_CONFIG_L3__config_reg_14__pma_tx_deemphasis_ln_3'] = "0x2"
		elif user_registers['ss_raw_deem_lane3'] == "3.5dB":
			user_registers['PIPE_CONFIG_L3__config_reg_14__pma_tx_deemphasis_ln_3'] = "0x1"
		elif user_registers['ss_raw_deem_lane3'] == "6dB":
			user_registers['PIPE_CONFIG_L3__config_reg_14__pma_tx_deemphasis_ln_3'] = "0x0"
	elif user_registers['ss_raw_tx_eq_mode_lane3'] == "3 taps FIR filter":
		main_c0_bin = (bin(int(user_registers['ss_raw_main_c0_lane3'], 16)))[2:]
		if (len(main_c0_bin) < 6):
			diff = 6 - len(main_c0_bin)
			for i in range(diff):
				main_c0_bin = '0' + main_c0_bin
		pre_c_bin = (bin(int(user_registers['ss_raw_pre_c_lane3'], 16)))[2:]
		if (len(pre_c_bin) < 6):
			diff = 6 - len(pre_c_bin)
			for i in range(diff):
				pre_c_bin = '0' + pre_c_bin
		post_c_bin = (bin(int(user_registers['ss_raw_post_c_lane3'], 16)))[2:]
		if (len(post_c_bin) < 6):
			diff = 6 - len(post_c_bin)
			for i in range(diff):
				post_c_bin = '0' + post_c_bin
		deem_value = post_c_bin + main_c0_bin + pre_c_bin
		user_registers['PIPE_CONFIG_L3__config_reg_14__pma_tx_deemphasis_ln_3'] = hex(int(deem_value, 2))

	if (data_rate > 8):
		user_registers['PMA_L3__det_standec_a_preg__ser_gt8g_mode0_preg'] = "0x1"
  
	if (data_rate >= 8):
		user_registers['PMA_L3__deq_vga_ratesel_preg__vga_ratesel_mode0_preg'] = "0x3"

	if (data_rate > 11.4 and ("20" in user_registers['ss_raw_serdes_width_lane3'] or "40" in user_registers['ss_raw_serdes_width_lane3'])):
		user_registers['PMA_L3__deq_epipwr_ctrl_preg__epion_time_preg'] = "0x1F4"
    
	if (data_rate == 10 and ("32" in user_registers['ss_raw_serdes_width_lane3'] or "64" in user_registers['ss_raw_serdes_width_lane3'])):
		user_registers['PMA_L3__dfe_ecmp_ratesel_preg__ecmp_ratesel_mode0_preg'] = "0x1"
		user_registers['PMA_L3__dfe_smp_ratesel_preg__smp_ratesel_mode0_preg'] = "0x1"

	if (data_rate >= 10 and ("32" in user_registers['ss_raw_serdes_width_lane3'] or "64" in user_registers['ss_raw_serdes_width_lane3'])):
		user_registers['PIPE_CONFIG_L3__config_reg_14__pma_tx_vmargin_ln_3'] = "0x0"
	else:
		user_registers['PIPE_CONFIG_L3__config_reg_14__pma_tx_vmargin_ln_3'] = "0x3"
	user_registers['PIPE_CONFIG_L3__config_reg_14__pma_tx_low_power_swing_en_ln_3'] = "0x0"
	user_registers['PIPE_CONFIG_L3__config_reg_14__pma_rx_termination_ln_3'] = "0x1"
	user_registers['PIPE_CONFIG_L3__config_reg_14__pipe_l03_rx_polarity'] = "0x0"
	user_registers['PIPE_CONFIG_L3__config_reg_14__pma_tx_get_local_init_coef_ln_3'] = "0x0"
	user_registers['PIPE_CONFIG_L3__config_reg_14__pma_tx_get_local_preset_coef_ln_3'] = "0x0"
	user_registers['PIPE_CONFIG_L3__config_reg_14__pma_tx_local_preset_index_ln_3'] = "0x0"


	return user_registers,f
#----------------------------------------------------------------------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
#------------------------------------------- PCIE Functions -----------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
def topo_pcie(quad,user_registers,f):
	# q0 only parameters
	if quad == "q0" or quad == "q2":
		#-----------------------------------------------------------#
		#------------------------- Common --------------------------#
		#-----------------------------------------------------------#
		# ss_pmclk_divsel (Internal Parameter)
		if user_registers['ss_pcie_pmclk_divsel'] not in ["Disabled", "DIV2", "DIV4", "DIV8"]:
			f['design_warnings'].append("ERROR: The selected value of ss_pcie_pmclk_divsel is out of range.")
		else:
			if user_registers['ss_pcie_pmclk_divsel'] == "DIV2":
				user_registers['pcr_pmclk_divsel'] = "1"
				user_registers['i_client_LM__i_pm_clk_frequency_reg__PMCLKFRQ'] = "40"
			elif user_registers['ss_pcie_pmclk_divsel'] == "DIV4":
				user_registers['pcr_pmclk_divsel'] = "2"
				user_registers['i_client_LM__i_pm_clk_frequency_reg__PMCLKFRQ'] = "20"
			elif user_registers['ss_pcie_pmclk_divsel'] == "DIV8":
				user_registers['pcr_pmclk_divsel'] = "3"
				user_registers['i_client_LM__i_pm_clk_frequency_reg__PMCLKFRQ'] = "10"
			else:
				user_registers['pcr_pmclk_divsel'] = "0"
				user_registers['i_client_LM__i_pm_clk_frequency_reg__PMCLKFRQ'] = "0"


		# ss_pcie_sris_en
		if user_registers['ss_pcie_sris_en'] not in ["0", "1"]:
			f['design_warnings'].append("ERROR: The selected value of ss_pcie_sris_en is out of range.")
		elif user_registers['ss_pcie_sris_en'] == "1":
			user_registers['PIPE_CONFIG_CMN__config_reg_0__sris_enable'] = "1"
			lane_count = int(user_registers['PIPE_CONFIG_CMN__config_reg_0__lane_count_in'][1:])
			for x in range(lane_count):
				register_name = 'PMA_L' + str(x) + '__clkpathctrl_tmr_preg__clkpathctrl_sscen_preg'
				user_registers[register_name] = "0"
				register_name = 'PMA_L' + str(x) + '__rx_creq_fltr_a_mode3_preg__creq_crfltr_accumsat2_mode3_preg'
				user_registers[register_name] = "0x3"
				register_name = 'PMA_L' + str(x) + '__rx_creq_fltr_a_mode3_preg__creq_crfltr_gain2_mode3_preg'
				user_registers[register_name] = "0x3"
				register_name = 'PMA_L' + str(x) + '__rx_creq_fltr_a_mode3_preg__creq_crfltr_leakfreq_mode3_preg'
				user_registers[register_name] = "0x3"


      #end of Common
		#-----------------------------------------------------------#
		#------------------------- EP only -------------------------#
		#-----------------------------------------------------------#
		if user_registers['PIPE_CONFIG_CMN__config_reg_0__mode_select'] == "Endpoint":

			# ss_pcie_MPS
			if user_registers['ss_pcie_MPS'] not in ["128 bytes", "256 bytes", "512 bytes"]:
				f['design_warnings'].append("ERROR: The selected value of ss_pcie_MPS is out of range.")
			else:
				pf_num = int(user_registers['ss_pcie_pf_num'])
				for x in range(pf_num):
					tab_name = 'i_client_PF' + str(x)
					register_name = tab_name + '__i_pcie_dev_cap__MPS'
					user_registers[register_name] = user_registers['ss_pcie_MPS']

			# ss_pcie_pf_num
			if user_registers['ss_pcie_pf_num'] not in ["1","2","3","4"]:
				f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf_num is out of range.")
			else:
				pf_num = int(user_registers['ss_pcie_pf_num'])
				for x in range(pf_num):
					register_name = 'i_client_LM__i_pf_config_reg__F' + str(x) + 'E'
					user_registers[register_name] = "1"
				for x in range(pf_num, 4):
					register_name = 'i_client_LM__i_pf_config_reg__F' + str(x) + 'E'
					user_registers[register_name] = "0"


			# ss_pcie_aspm
			if user_registers['ss_pcie_aspm'] not in ["L0s Entry", "L1 Entry", "Disabled", "L0s and L1 Entry"]:
				f['design_warnings'].append("ERROR: The selected value of ss_pcie_aspm is out of range.")
			else:			
				if user_registers['ss_pcie_aspm'] != "Disabled" and user_registers['ss_pcie_sris_en'] == "1":
					f['user_errors'].append("ERROR: When SRIS is enabled, ASPM should be disabled.")
				pf_num = int(user_registers['ss_pcie_pf_num'])
				for x in range(pf_num):
					register_name = 'i_client_PF' + str(x) + '__i_link_ctrl_status__ASPMC'
					user_registers[register_name] = user_registers['ss_pcie_aspm']
				for x in range(pf_num, 4):
					register_name = 'i_client_PF' + str(x) + '__i_link_ctrl_status__ASPMC'
					user_registers[register_name] = "Disabled"

			#------------------------- PF0 only -------------------------#
			if user_registers['ss_pcie_pf_num'] == "1" or user_registers['ss_pcie_pf_num'] == "2" or  user_registers['ss_pcie_pf_num'] == "3" or  user_registers['ss_pcie_pf_num'] == "4" :
				'''# ss_pcie_pf0_msi_addr
				if user_registers['i_client_PF0__i_msi_ctrl_reg__ME'] == "1":
					msi_addr = int(user_registers['ss_pcie_pf0_msi_addr'],16)
					binary_value=bin(msi_addr)[2:].zfill(64)
					user_registers['i_client_PF0__i_msi_msg_hi_addr__MAH'] = hex(int(binary_value[:32],2))
					user_registers['i_client_PF0__i_msi_msg_low_addr__MAL'] = hex(int(binary_value[32:64],2))
				'''

				#ss_pcie_pf0_legacy_int_pin
				if user_registers['ss_pcie_pf0_legacy_int_pin'] not in ["NO INT", "INTA", "INTB", "INTC", "INTD"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf0_legacy_int_pin is out of range.")
				else:
					if user_registers['ss_pcie_pf0_legacy_int_pin'] == "NO INT":
						user_registers['i_client_PF0__i_command_status__IMD'] = "0"
					else:
						user_registers['i_client_PF0__i_command_status__IMD'] = "1"
						user_registers['i_client_PF0__i_intrpt_line_intrpt_pin__IPR'] = user_registers['ss_pcie_pf0_legacy_int_pin']

				#ss_pcie_pf0_exp_rom_bar
				if user_registers['ss_pcie_pf0_exp_rom_bar'] not in ["Disabled", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf0_exp_rom_bar is out of range.")
				else:
					if user_registers['ss_pcie_pf0_exp_rom_bar'] == "Disabled":
						user_registers['i_client_LM__i_pf_0_BAR_config_1_reg__ERBE'] = "0"
						user_registers['i_client_LM__i_pf_0_BAR_config_1_reg__ERBA'] = "4 KB"
					else:
						user_registers['i_client_LM__i_pf_0_BAR_config_1_reg__ERBE'] = "1"
						user_registers['i_client_LM__i_pf_0_BAR_config_1_reg__ERBA'] = user_registers['ss_pcie_pf0_exp_rom_bar']
      	#end of PF0 only
			#------------------------- PF0-VF only -------------------------#
				if user_registers['PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable'] == "1":
					user_registers['i_client_PF0__i_SRIOV_ctrl_status_reg__VFE'] = "1"
					user_registers['i_client_PF0__i_SRIOV_ctrl_status_reg__VFMSE'] = "1"
					pf0_vf_count = int(user_registers['i_client_PF0__i_func_dep_link_numVFs_reg__NVF'])
					if not (pf0_vf_count >= 0 and pf0_vf_count <= 64):
						f['user_errors'].append("ERROR: The selected value of PF0 VF Count is out of range. There is only a total of 64 VFs shared by all enabled PFs.")
						return user_registers,f
					elif (pf0_vf_count >= 16):
						user_registers['i_client_PF0__i_initial_total_VFs_reg__IVF'] = str(pf0_vf_count)
						user_registers['i_client_PF0__i_initial_total_VFs_reg__TVF'] = str(pf0_vf_count)
						

				else:
					pf0_vf_count = 0

				#ss_pcie_pf0_vf_subsystem_id
				if int(user_registers['ss_pcie_pf0_vf_subsystem_id'],16) > 0xFFFF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf0_vf_subsystem_id is out of range.")
				else:
					for x in range (pf0_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_subsystem_vendor_id_subsystem_i__SID'
						user_registers[register_name] = user_registers['ss_pcie_pf0_vf_subsystem_id']

				#ss_pcie_pf0_vf_msi_64_addr
				if user_registers['ss_pcie_pf0_vf_msi_64_addr'] not in ["0","1"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf0_vf_msi_64_addr is out of range.")
				else:
					for x in range (pf0_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msi_ctrl_reg__AC64'
						user_registers[register_name] = user_registers['ss_pcie_pf0_vf_msi_64_addr']

				#ss_pcie_pf0_vf_msi_mul_message_cap
				if user_registers['ss_pcie_pf0_vf_msi_mul_message_cap'] not in ["1","2","4","8","16","32"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf0_vf_msi_mul_message_cap is out of range.")
				else:
					for x in range (pf0_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msi_ctrl_reg__MMC'
						user_registers[register_name] = user_registers['ss_pcie_pf0_vf_msi_mul_message_cap']

				#ss_pcie_pf0_vf_msix_table_size
				if int(user_registers['ss_pcie_pf0_vf_msix_table_size'],16) > 0x7FF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf0_vf_msix_table_size is out of range.")
				else:
					for x in range (pf0_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_ctrl__MSIXTS'
						user_registers[register_name] = user_registers['ss_pcie_pf0_vf_msix_table_size']

				#ss_pcie_pf0_vf_msix_table_offset
				if int(user_registers['ss_pcie_pf0_vf_msix_table_offset'],16) > 0x1FFFFFFF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf0_vf_msix_table_offset is out of range.")
				else:
					for x in range (pf0_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_tbl_offset__TO'
						user_registers[register_name] = user_registers['ss_pcie_pf0_vf_msix_table_offset']

				#ss_pcie_pf0_vf_msix_bar_ind
				if user_registers['ss_pcie_pf0_vf_msix_bar_ind'] not in ["BAR0","BAR1","BAR2","BAR3","BAR4","BAR5"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf0_vf_msix_bar_ind is out of range.")
				else:
					for x in range (pf0_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_tbl_offset__BARI'
						user_registers[register_name] = user_registers['ss_pcie_pf0_vf_msix_bar_ind']

				#ss_pcie_pf0_vf_msix_pba_offset
				if int(user_registers['ss_pcie_pf0_vf_msix_pba_offset'],16) > 0x1FFFFFFF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf0_vf_msix_pba_offset is out of range.")
				else:
					for x in range (pf0_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_pending_intrpt__PO'
						user_registers[register_name] = user_registers['ss_pcie_pf0_vf_msix_pba_offset']

				#ss_pcie_pf0_vf_msix_pba_ind
				if user_registers['ss_pcie_pf0_vf_msix_pba_ind'] not in ["BAR0","BAR1","BAR2","BAR3","BAR4","BAR5"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf0_vf_msix_pba_ind is out of range.")
				else:
					for x in range (pf0_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_pending_intrpt__BARI'
						user_registers[register_name] = user_registers['ss_pcie_pf0_vf_msix_pba_ind']

				#ss_pcie_pf0_vf_tph_en
				if user_registers['ss_pcie_pf0_vf_tph_en'] not in ["0","1"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf0_vf_tph_en is out of range.")
				else:
					for x in range (pf0_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_TPH_req_ctrl_reg__TRE'
						user_registers[register_name] = user_registers['ss_pcie_pf0_vf_tph_en']

				#ss_pcie_pf0_vf_steering_tag_tab_loc
				if user_registers['ss_pcie_pf0_vf_steering_tag_tab_loc'] not in ["ST Table not present", "ST Table in the TPH Requester Capability Structure", "ST values stored in the MSI-X Table in client RAM"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf0_vf_steering_tag_tab_loc is out of range.")
				else:
					for x in range (pf0_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_TPH_req_cap_reg__STTL'
						user_registers[register_name] = user_registers['ss_pcie_pf0_vf_steering_tag_tab_loc']

				#ss_pcie_pf0_vf_steering_tag_tab_size
				if int(user_registers['ss_pcie_pf0_vf_steering_tag_tab_size']) > 2047:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf0_vf_steering_tag_tab_size is out of range.")
				else:
					for x in range (pf0_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_TPH_req_cap_reg__STTS'
						user_registers[register_name] = user_registers['ss_pcie_pf0_vf_steering_tag_tab_size']

				#ss_pcie_pf0_vf_ats_en
				if user_registers['ss_pcie_pf0_vf_ats_en'] not in ["0","1"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf0_vf_ats_en is out of range.")
				else:
					for x in range (pf0_vf_count):
						register_name = 'i_client_VF' + str(x) + '__ats_cap_control__ATSEN'
						user_registers[register_name] = user_registers['ss_pcie_pf0_vf_ats_en']

     		#end of PF0-VF only

			#------------------------- PF1 only -------------------------#
			if user_registers['ss_pcie_pf_num'] == "2" or  user_registers['ss_pcie_pf_num'] == "3" or  user_registers['ss_pcie_pf_num'] == "4" :
				#ss_pcie_pf1_legacy_int_pin
				if user_registers['ss_pcie_pf1_legacy_int_pin'] not in ["NO INT", "INTA", "INTB", "INTC", "INTD"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf1_legacy_int_pin is out of range.")
				else:
					if user_registers['ss_pcie_pf1_legacy_int_pin'] == "NO INT":
						user_registers['i_client_PF1__i_command_status__IMD'] = "0"
					else:
						user_registers['i_client_PF1__i_command_status__IMD'] = "1"
						user_registers['i_client_PF1__i_intrpt_line_intrpt_pin__IPR'] = user_registers['ss_pcie_pf1_legacy_int_pin']

				#ss_pcie_pf1_exp_rom_bar
				if user_registers['ss_pcie_pf1_exp_rom_bar'] not in ["Disabled", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf1_exp_rom_bar is out of range.")
				else:
					if user_registers['ss_pcie_pf1_exp_rom_bar'] == "Disabled":
						user_registers['i_client_LM__i_pf_1_BAR_config_1_reg__ERBE'] = "0"
						user_registers['i_client_LM__i_pf_1_BAR_config_1_reg__ERBA'] = "4 KB"
					else:
						user_registers['i_client_LM__i_pf_1_BAR_config_1_reg__ERBE'] = "1"
						user_registers['i_client_LM__i_pf_1_BAR_config_1_reg__ERBA'] = user_registers['ss_pcie_pf1_exp_rom_bar']
      	#end of PF1 only
			#------------------------- PF1-VF only -------------------------#
				if user_registers['PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable'] == "1":
					user_registers['i_client_PF1__i_SRIOV_ctrl_status_reg__VFE'] = "1"
					user_registers['i_client_PF1__i_SRIOV_ctrl_status_reg__VFMSE'] = "1"
					pf1_vf_count = int(user_registers['i_client_PF1__i_func_dep_link_numVFs_reg__NVF']) + pf0_vf_count
					if not (pf1_vf_count >= 0 and pf1_vf_count <= 64):
						f['user_errors'].append("ERROR: The selected value of PF1 VF Count is out of range. There is only a total of 64 VFs shared by all enabled PFs.")
						return user_registers,f
					elif (pf1_vf_count >= 16):
						user_registers['i_client_PF1__i_initial_total_VFs_reg__IVF'] = str(pf1_vf_count)
						user_registers['i_client_PF1__i_initial_total_VFs_reg__TVF'] = str(pf1_vf_count)
				else:
					pf1_vf_count = 0

				#ss_pcie_pf1_vf_subsystem_id
				if int(user_registers['ss_pcie_pf1_vf_subsystem_id'],16) > 0xFFFF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf1_vf_subsystem_id is out of range.")
				else:
					for x in range (pf0_vf_count, pf1_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_subsystem_vendor_id_subsystem_i__SID'
						user_registers[register_name] = user_registers['ss_pcie_pf1_vf_subsystem_id']

				#ss_pcie_pf1_vf_msi_64_addr
				if user_registers['ss_pcie_pf1_vf_msi_64_addr'] not in ["0","1"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf1_vf_msi_64_addr is out of range.")
				else:
					for x in range (pf0_vf_count, pf1_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msi_ctrl_reg__AC64'
						user_registers[register_name] = user_registers['ss_pcie_pf1_vf_msi_64_addr']

				#ss_pcie_pf1_vf_msi_mul_message_cap
				if user_registers['ss_pcie_pf1_vf_msi_mul_message_cap'] not in ["1","2","4","8","16","32"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf1_vf_msi_mul_message_cap is out of range.")
				else:
					for x in range (pf0_vf_count, pf1_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msi_ctrl_reg__MMC'
						user_registers[register_name] = user_registers['ss_pcie_pf1_vf_msi_mul_message_cap']

				#ss_pcie_pf1_vf_msix_table_size
				if int(user_registers['ss_pcie_pf1_vf_msix_table_size'],16) > 0x7FF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf1_vf_msix_table_size is out of range.")
				else:
					for x in range (pf0_vf_count, pf1_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_ctrl__MSIXTS'
						user_registers[register_name] = user_registers['ss_pcie_pf1_vf_msix_table_size']

				#ss_pcie_pf1_vf_msix_table_offset
				if int(user_registers['ss_pcie_pf1_vf_msix_table_offset'],16) > 0x1FFFFFFF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf1_vf_msix_table_offset is out of range.")
				else:
					for x in range (pf0_vf_count, pf1_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_tbl_offset__TO'
						user_registers[register_name] = user_registers['ss_pcie_pf1_vf_msix_table_offset']

				#ss_pcie_pf1_vf_msix_bar_ind
				if user_registers['ss_pcie_pf1_vf_msix_bar_ind'] not in ["BAR0","BAR1","BAR2","BAR3","BAR4","BAR5"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf1_vf_msix_bar_ind is out of range.")
				else:
					for x in range (pf0_vf_count, pf1_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_tbl_offset__BARI'
						user_registers[register_name] = user_registers['ss_pcie_pf1_vf_msix_bar_ind']

				#ss_pcie_pf1_vf_msix_pba_offset
				if int(user_registers['ss_pcie_pf1_vf_msix_pba_offset'],16) > 0x1FFFFFFF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf1_vf_msix_pba_offset is out of range.")
				else:
					for x in range (pf0_vf_count, pf1_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_pending_intrpt__PO'
						user_registers[register_name] = user_registers['ss_pcie_pf1_vf_msix_pba_offset']

				#ss_pcie_pf1_vf_msix_pba_ind
				if user_registers['ss_pcie_pf1_vf_msix_pba_ind'] not in ["BAR0","BAR1","BAR2","BAR3","BAR4","BAR5"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf1_vf_msix_pba_ind is out of range.")
				else:
					for x in range (pf0_vf_count, pf1_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_pending_intrpt__BARI'
						user_registers[register_name] = user_registers['ss_pcie_pf1_vf_msix_pba_ind']

				#ss_pcie_pf1_vf_tph_en
				if user_registers['ss_pcie_pf1_vf_tph_en'] not in ["0","1"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf1_vf_tph_en is out of range.")
				else:
					for x in range (pf0_vf_count, pf1_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_TPH_req_ctrl_reg__TRE'
						user_registers[register_name] = user_registers['ss_pcie_pf1_vf_tph_en']

				#ss_pcie_pf1_vf_steering_tag_tab_loc
				if user_registers['ss_pcie_pf1_vf_steering_tag_tab_loc'] not in ["ST Table not present", "ST Table in the TPH Requester Capability Structure", "ST values stored in the MSI-X Table in client RAM"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf1_vf_steering_tag_tab_loc is out of range.")
				else:
					for x in range (pf0_vf_count, pf1_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_TPH_req_cap_reg__STTL'
						user_registers[register_name] = user_registers['ss_pcie_pf1_vf_steering_tag_tab_loc']

				#ss_pcie_pf1_vf_steering_tag_tab_size
				if int(user_registers['ss_pcie_pf1_vf_steering_tag_tab_size']) > 2047:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf1_vf_steering_tag_tab_size is out of range.")
				else:
					for x in range (pf0_vf_count, pf1_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_TPH_req_cap_reg__STTS'
						user_registers[register_name] = user_registers['ss_pcie_pf1_vf_steering_tag_tab_size']

				#ss_pcie_pf1_vf_ats_en
				if user_registers['ss_pcie_pf1_vf_ats_en'] not in ["0","1"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf1_vf_ats_en is out of range.")
				else:
					for x in range (pf0_vf_count, pf1_vf_count):
						register_name = 'i_client_VF' + str(x) + '__ats_cap_control__ATSEN'
						user_registers[register_name] = user_registers['ss_pcie_pf1_vf_ats_en']

     		#end of PF1-VF only

			#------------------------- PF2 only -------------------------#
			if user_registers['ss_pcie_pf_num'] == "3" or  user_registers['ss_pcie_pf_num'] == "4" :
				#ss_pcie_pf2_legacy_int_pin
				if user_registers['ss_pcie_pf2_legacy_int_pin'] not in ["NO INT", "INTA", "INTB", "INTC", "INTD"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf2_legacy_int_pin is out of range.")
				else:
					if user_registers['ss_pcie_pf2_legacy_int_pin'] == "NO INT":
						user_registers['i_client_PF2__i_command_status__IMD'] = "0"
					else:
						user_registers['i_client_PF2__i_command_status__IMD'] = "1"
						user_registers['i_client_PF2__i_intrpt_line_intrpt_pin__IPR'] = user_registers['ss_pcie_pf2_legacy_int_pin']

				#ss_pcie_pf2_exp_rom_bar
				if user_registers['ss_pcie_pf2_exp_rom_bar'] not in ["Disabled", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf2_exp_rom_bar is out of range.")
				else:
					if user_registers['ss_pcie_pf2_exp_rom_bar'] == "Disabled":
						user_registers['i_client_LM__i_pf_2_BAR_config_1_reg__ERBE'] = "0"
						user_registers['i_client_LM__i_pf_2_BAR_config_1_reg__ERBA'] = "4 KB"
					else:
						user_registers['i_client_LM__i_pf_2_BAR_config_1_reg__ERBE'] = "1"
						user_registers['i_client_LM__i_pf_2_BAR_config_1_reg__ERBA'] = user_registers['ss_pcie_pf2_exp_rom_bar']
      	#end of PF2 only

			#------------------------- PF2-VF only -------------------------#
				if user_registers['PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable'] == "1":
					user_registers['i_client_PF2__i_SRIOV_ctrl_status_reg__VFE'] = "1"
					user_registers['i_client_PF2__i_SRIOV_ctrl_status_reg__VFMSE'] = "1"
					pf2_vf_count = int(user_registers['i_client_PF2__i_func_dep_link_numVFs_reg__NVF']) + pf1_vf_count
					if not (pf2_vf_count >= 0 and pf2_vf_count <= 64):
						f['user_errors'].append("ERROR: The selected value of PF2 VF Count is out of range. There is only a total of 64 VFs shared by all enabled PFs.")
						return user_registers,f
					elif (pf2_vf_count >= 16):
						user_registers['i_client_PF2__i_initial_total_VFs_reg__IVF'] = str(pf2_vf_count)
						user_registers['i_client_PF2__i_initial_total_VFs_reg__TVF'] = str(pf2_vf_count)
				else:
					pf2_vf_count = 0

				#ss_pcie_pf2_vf_subsystem_id
				if int(user_registers['ss_pcie_pf2_vf_subsystem_id'],16) > 0xFFFF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf2_vf_subsystem_id is out of range.")
				else:
					for x in range (pf1_vf_count, pf2_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_subsystem_vendor_id_subsystem_i__SID'
						user_registers[register_name] = user_registers['ss_pcie_pf2_vf_subsystem_id']

				#ss_pcie_pf2_vf_msi_64_addr
				if user_registers['ss_pcie_pf2_vf_msi_64_addr'] not in ["0","1"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf2_vf_msi_64_addr is out of range.")
				else:
					for x in range (pf1_vf_count, pf2_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msi_ctrl_reg__AC64'
						user_registers[register_name] = user_registers['ss_pcie_pf2_vf_msi_64_addr']

				#ss_pcie_pf2_vf_msi_mul_message_cap
				if user_registers['ss_pcie_pf2_vf_msi_mul_message_cap'] not in ["1","2","4","8","16","32"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf2_vf_msi_mul_message_cap is out of range.")
				else:
					for x in range (pf1_vf_count, pf2_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msi_ctrl_reg__MMC'
						user_registers[register_name] = user_registers['ss_pcie_pf2_vf_msi_mul_message_cap']

				#ss_pcie_pf2_vf_msix_table_size
				if int(user_registers['ss_pcie_pf2_vf_msix_table_size'],16) > 0x7FF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf2_vf_msix_table_size is out of range.")
				else:
					for x in range (pf1_vf_count, pf2_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_ctrl__MSIXTS'
						user_registers[register_name] = user_registers['ss_pcie_pf2_vf_msix_table_size']

				#ss_pcie_pf2_vf_msix_table_offset
				if int(user_registers['ss_pcie_pf2_vf_msix_table_offset'],16) > 0x1FFFFFFF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf2_vf_msix_table_offset is out of range.")
				else:
					for x in range (pf1_vf_count, pf2_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_tbl_offset__TO'
						user_registers[register_name] = user_registers['ss_pcie_pf2_vf_msix_table_offset']

				#ss_pcie_pf2_vf_msix_bar_ind
				if user_registers['ss_pcie_pf2_vf_msix_bar_ind'] not in ["BAR0","BAR1","BAR2","BAR3","BAR4","BAR5"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf2_vf_msix_bar_ind is out of range.")
				else:
					for x in range (pf1_vf_count, pf2_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_tbl_offset__BARI'
						user_registers[register_name] = user_registers['ss_pcie_pf2_vf_msix_bar_ind']

				#ss_pcie_pf2_vf_msix_pba_offset
				if int(user_registers['ss_pcie_pf2_vf_msix_pba_offset'],16) > 0x1FFFFFFF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf2_vf_msix_pba_offset is out of range.")
				else:
					for x in range (pf1_vf_count, pf2_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_pending_intrpt__PO'
						user_registers[register_name] = user_registers['ss_pcie_pf2_vf_msix_pba_offset']

				#ss_pcie_pf2_vf_msix_pba_ind
				if user_registers['ss_pcie_pf2_vf_msix_pba_ind'] not in ["BAR0","BAR1","BAR2","BAR3","BAR4","BAR5"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf2_vf_msix_pba_ind is out of range.")
				else:
					for x in range (pf1_vf_count, pf2_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_pending_intrpt__BARI'
						user_registers[register_name] = user_registers['ss_pcie_pf2_vf_msix_pba_ind']

				#ss_pcie_pf2_vf_tph_en
				if user_registers['ss_pcie_pf2_vf_tph_en'] not in ["0","1"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf2_vf_tph_en is out of range.")
				else:
					for x in range (pf1_vf_count, pf2_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_TPH_req_ctrl_reg__TRE'
						user_registers[register_name] = user_registers['ss_pcie_pf2_vf_tph_en']

				#ss_pcie_pf2_vf_steering_tag_tab_loc
				if user_registers['ss_pcie_pf2_vf_steering_tag_tab_loc'] not in ["ST Table not present", "ST Table in the TPH Requester Capability Structure", "ST values stored in the MSI-X Table in client RAM"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf2_vf_steering_tag_tab_loc is out of range.")
				else:
					for x in range (pf1_vf_count, pf2_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_TPH_req_cap_reg__STTL'
						user_registers[register_name] = user_registers['ss_pcie_pf2_vf_steering_tag_tab_loc']

				#ss_pcie_pf2_vf_steering_tag_tab_size
				if int(user_registers['ss_pcie_pf2_vf_steering_tag_tab_size']) > 2047:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf2_vf_steering_tag_tab_size is out of range.")
				else:
					for x in range (pf1_vf_count, pf2_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_TPH_req_cap_reg__STTS'
						user_registers[register_name] = user_registers['ss_pcie_pf2_vf_steering_tag_tab_size']

				#ss_pcie_pf2_vf_ats_en
				if user_registers['ss_pcie_pf2_vf_ats_en'] not in ["0","1"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf2_vf_ats_en is out of range.")
				else:
					for x in range (pf1_vf_count, pf2_vf_count):
						register_name = 'i_client_VF' + str(x) + '__ats_cap_control__ATSEN'
						user_registers[register_name] = user_registers['ss_pcie_pf2_vf_ats_en']

     		#end of PF2-VF only

			#------------------------- PF3 only -------------------------#
			if user_registers['ss_pcie_pf_num'] == "4" :
				#ss_pcie_pf3_legacy_int_pin
				if user_registers['ss_pcie_pf3_legacy_int_pin'] not in ["NO INT", "INTA", "INTB", "INTC", "INTD"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf3_legacy_int_pin is out of range.")
				else:
					if user_registers['ss_pcie_pf3_legacy_int_pin'] == "NO INT":
						user_registers['i_client_PF3__i_command_status__IMD'] = "0"
					else:
						user_registers['i_client_PF3__i_command_status__IMD'] = "1"
						user_registers['i_client_PF3__i_intrpt_line_intrpt_pin__IPR'] = user_registers['ss_pcie_pf3_legacy_int_pin']

				#ss_pcie_pf3_exp_rom_bar
				if user_registers['ss_pcie_pf3_exp_rom_bar'] not in ["Disabled", "2 KB", "4 KB", "8 KB", "16 KB", "32 KB", "64 KB", "128 KB", "256 KB", "512 KB", "1 MB", "2 MB", "4 MB", "8 MB", "16 MB"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf3_exp_rom_bar is out of range.")
				else:
					if user_registers['ss_pcie_pf3_exp_rom_bar'] == "Disabled":
						user_registers['i_client_LM__i_pf_3_BAR_config_1_reg__ERBE'] = "0"
						user_registers['i_client_LM__i_pf_3_BAR_config_1_reg__ERBA'] = "4 KB"
					else:
						user_registers['i_client_LM__i_pf_3_BAR_config_1_reg__ERBE'] = "1"
						user_registers['i_client_LM__i_pf_3_BAR_config_1_reg__ERBA'] = user_registers['ss_pcie_pf3_exp_rom_bar']
      	#end of PF3 only

			#------------------------- PF3-VF only -------------------------#
				if user_registers['PIPE_CONFIG_CMN__config_reg_0__sr_iov_enable'] == "1":
					user_registers['i_client_PF3__i_SRIOV_ctrl_status_reg__VFE'] = "1"
					user_registers['i_client_PF3__i_SRIOV_ctrl_status_reg__VFMSE'] = "1"
					pf3_vf_count = int(user_registers['i_client_PF3__i_func_dep_link_numVFs_reg__NVF']) + pf2_vf_count
					if not (pf3_vf_count >= 0 and pf3_vf_count <= 64):
						f['user_errors'].append("ERROR: The selected value of PF3 VF Count is out of range. There is only a total of 64 VFs shared by all enabled PFs.")
						return user_registers,f
					elif (pf3_vf_count >= 16):
						user_registers['i_client_PF3__i_initial_total_VFs_reg__IVF'] = str(pf3_vf_count)
						user_registers['i_client_PF3__i_initial_total_VFs_reg__TVF'] = str(pf3_vf_count)
				else:
					pf3_vf_count = 0

				#ss_pcie_pf3_vf_subsystem_id
				if int(user_registers['ss_pcie_pf3_vf_subsystem_id'],16) > 0xFFFF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf3_vf_subsystem_id is out of range.")
				else:
					for x in range (pf2_vf_count, pf3_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_subsystem_vendor_id_subsystem_i__SID'
						user_registers[register_name] = user_registers['ss_pcie_pf3_vf_subsystem_id']

				#ss_pcie_pf3_vf_msi_64_addr
				if user_registers['ss_pcie_pf3_vf_msi_64_addr'] not in ["0","1"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf3_vf_msi_64_addr is out of range.")
				else:
					for x in range (pf2_vf_count, pf3_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msi_ctrl_reg__AC64'
						user_registers[register_name] = user_registers['ss_pcie_pf3_vf_msi_64_addr']

				#ss_pcie_pf3_vf_msi_mul_message_cap
				if user_registers['ss_pcie_pf3_vf_msi_mul_message_cap'] not in ["1","2","4","8","16","32"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf3_vf_msi_mul_message_cap is out of range.")
				else:
					for x in range (pf2_vf_count, pf3_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msi_ctrl_reg__MMC'
						user_registers[register_name] = user_registers['ss_pcie_pf3_vf_msi_mul_message_cap']

				#ss_pcie_pf3_vf_msix_table_size
				if int(user_registers['ss_pcie_pf3_vf_msix_table_size'],16) > 0x7FF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf3_vf_msix_table_size is out of range.")
				else:
					for x in range (pf2_vf_count, pf3_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_ctrl__MSIXTS'
						user_registers[register_name] = user_registers['ss_pcie_pf3_vf_msix_table_size']

				#ss_pcie_pf3_vf_msix_table_offset
				if int(user_registers['ss_pcie_pf3_vf_msix_table_offset'],16) > 0x1FFFFFFF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf3_vf_msix_table_offset is out of range.")
				else:
					for x in range (pf2_vf_count, pf3_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_tbl_offset__TO'
						user_registers[register_name] = user_registers['ss_pcie_pf3_vf_msix_table_offset']

				#ss_pcie_pf3_vf_msix_bar_ind
				if user_registers['ss_pcie_pf3_vf_msix_bar_ind'] not in ["BAR0","BAR1","BAR2","BAR3","BAR4","BAR5"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf3_vf_msix_bar_ind is out of range.")
				else:
					for x in range (pf2_vf_count, pf3_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_tbl_offset__BARI'
						user_registers[register_name] = user_registers['ss_pcie_pf3_vf_msix_bar_ind']

				#ss_pcie_pf3_vf_msix_pba_offset
				if int(user_registers['ss_pcie_pf3_vf_msix_pba_offset'],16) > 0x1FFFFFFF:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf3_vf_msix_pba_offset is out of range.")
				else:
					for x in range (pf2_vf_count, pf3_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_pending_intrpt__PO'
						user_registers[register_name] = user_registers['ss_pcie_pf3_vf_msix_pba_offset']

				#ss_pcie_pf3_vf_msix_pba_ind
				if user_registers['ss_pcie_pf3_vf_msix_pba_ind'] not in ["BAR0","BAR1","BAR2","BAR3","BAR4","BAR5"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf3_vf_msix_pba_ind is out of range.")
				else:
					for x in range (pf2_vf_count, pf3_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_msix_pending_intrpt__BARI'
						user_registers[register_name] = user_registers['ss_pcie_pf3_vf_msix_pba_ind']

				#ss_pcie_pf3_vf_tph_en
				if user_registers['ss_pcie_pf3_vf_tph_en'] not in ["0","1"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf3_vf_tph_en is out of range.")
				else:
					for x in range (pf2_vf_count, pf3_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_TPH_req_ctrl_reg__TRE'
						user_registers[register_name] = user_registers['ss_pcie_pf3_vf_tph_en']

				#ss_pcie_pf3_vf_steering_tag_tab_loc
				if user_registers['ss_pcie_pf3_vf_steering_tag_tab_loc'] not in ["ST Table not present", "ST Table in the TPH Requester Capability Structure", "ST values stored in the MSI-X Table in client RAM"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf3_vf_steering_tag_tab_loc is out of range.")
				else:
					for x in range (pf2_vf_count, pf3_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_TPH_req_cap_reg__STTL'
						user_registers[register_name] = user_registers['ss_pcie_pf3_vf_steering_tag_tab_loc']

				#ss_pcie_pf3_vf_steering_tag_tab_size
				if int(user_registers['ss_pcie_pf3_vf_steering_tag_tab_size']) > 2047:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf3_vf_steering_tag_tab_size is out of range.")
				else:
					for x in range (pf2_vf_count, pf3_vf_count):
						register_name = 'i_client_VF' + str(x) + '__i_TPH_req_cap_reg__STTS'
						user_registers[register_name] = user_registers['ss_pcie_pf3_vf_steering_tag_tab_size']

				#ss_pcie_pf3_vf_ats_en
				if user_registers['ss_pcie_pf3_vf_ats_en'] not in ["0","1"]:
					f['design_warnings'].append("ERROR: The selected value of ss_pcie_pf3_vf_ats_en is out of range.")
				else:
					for x in range (pf2_vf_count, pf3_vf_count):
						register_name = 'i_client_VF' + str(x) + '__ats_cap_control__ATSEN'
						user_registers[register_name] = user_registers['ss_pcie_pf3_vf_ats_en']

     		#end of PF3-VF only

      #end of EP only
		#-----------------------------------------------------------#
		#------------------------- RP only -------------------------#
		#-----------------------------------------------------------#

		if user_registers['PIPE_CONFIG_CMN__config_reg_0__mode_select'] == "Root Port":
			if 'i_client_RC__i_link_ctrl_status__ASPMC' in user_registers:			
				if user_registers['i_client_RC__i_link_ctrl_status__ASPMC'] != "Disabled" and user_registers['ss_pcie_sris_en'] == "1":
					f['user_errors'].append("ERROR: When SRIS is enabled, ASPM should be disabled.")
			# ss_pcie_gen3_tx_preset
			if int(user_registers['ss_pcie_gen3_tx_preset'],16) > 0xA:
				f['design_errors'].append("ERROR: The selected value of ss_pcie_gen3_tx_preset is out of range.")
			else:
				user_registers['i_client_RC__i_lane_equalization_control_0__UPTP0'] = user_registers['ss_pcie_gen3_tx_preset']
				user_registers['i_client_RC__i_lane_equalization_control_0__UPTP1'] = user_registers['ss_pcie_gen3_tx_preset']
				user_registers['i_client_RC__i_lane_equalization_control_1__UPTP0'] = user_registers['ss_pcie_gen3_tx_preset']
				user_registers['i_client_RC__i_lane_equalization_control_1__UPTP1'] = user_registers['ss_pcie_gen3_tx_preset']
				user_registers['i_client_RC__i_lane_equalization_control_0__DNTP0'] = user_registers['ss_pcie_gen3_tx_preset']
				user_registers['i_client_RC__i_lane_equalization_control_0__DNTP1'] = user_registers['ss_pcie_gen3_tx_preset']
				user_registers['i_client_RC__i_lane_equalization_control_1__DNTP0'] = user_registers['ss_pcie_gen3_tx_preset']
				user_registers['i_client_RC__i_lane_equalization_control_1__DNTP1'] = user_registers['ss_pcie_gen3_tx_preset']

			# ss_pcie_gen3_rx_preset
			if int(user_registers['ss_pcie_gen3_rx_preset'],16) > 0x6:
				f['design_errors'].append("ERROR: The selected value of ss_pcie_gen3_rx_preset is out of range.")
			else:
				user_registers['i_client_RC__i_lane_equalization_control_0__UPRPH0'] = user_registers['ss_pcie_gen3_rx_preset']
				user_registers['i_client_RC__i_lane_equalization_control_0__UPRPH1'] = user_registers['ss_pcie_gen3_rx_preset']
				user_registers['i_client_RC__i_lane_equalization_control_1__UPRPH0'] = user_registers['ss_pcie_gen3_rx_preset']
				user_registers['i_client_RC__i_lane_equalization_control_1__UPRPH1'] = user_registers['ss_pcie_gen3_rx_preset']
				user_registers['i_client_RC__i_lane_equalization_control_0__DNRPH0'] = user_registers['ss_pcie_gen3_rx_preset']
				user_registers['i_client_RC__i_lane_equalization_control_0__DNRPH1'] = user_registers['ss_pcie_gen3_rx_preset']
				user_registers['i_client_RC__i_lane_equalization_control_1__DNRPH0'] = user_registers['ss_pcie_gen3_rx_preset']
				user_registers['i_client_RC__i_lane_equalization_control_1__DNRPH1'] = user_registers['ss_pcie_gen3_rx_preset']

			# ss_pcie_gen4_tx_preset
			if int(user_registers['ss_pcie_gen4_tx_preset'],16) > 0xA:
				f['design_errors'].append("ERROR: The selected value of ss_pcie_gen4_tx_preset is out of range.")
			else:
				user_registers['i_client_RC__i_pl_16gts_lane_equalization_control_reg0__UPTP016'] = user_registers['ss_pcie_gen4_tx_preset']
				user_registers['i_client_RC__i_pl_16gts_lane_equalization_control_reg0__UPTP116'] = user_registers['ss_pcie_gen4_tx_preset']
				user_registers['i_client_RC__i_pl_16gts_lane_equalization_control_reg0__UPTP216'] = user_registers['ss_pcie_gen4_tx_preset']
				user_registers['i_client_RC__i_pl_16gts_lane_equalization_control_reg0__UPTP316'] = user_registers['ss_pcie_gen4_tx_preset']
				user_registers['i_client_RC__i_pl_16gts_lane_equalization_control_reg0__DPTP016'] = user_registers['ss_pcie_gen4_tx_preset']
				user_registers['i_client_RC__i_pl_16gts_lane_equalization_control_reg0__DPTP116'] = user_registers['ss_pcie_gen4_tx_preset']
				user_registers['i_client_RC__i_pl_16gts_lane_equalization_control_reg0__DPTP216'] = user_registers['ss_pcie_gen4_tx_preset']
				user_registers['i_client_RC__i_pl_16gts_lane_equalization_control_reg0__DPTP316'] = user_registers['ss_pcie_gen4_tx_preset']

			#RC BAR0 and BAR1 Control
			if user_registers['i_client_LM__i_rc_BAR_config_reg__RCBAR0C'] == "Disabled" and user_registers['i_client_LM__i_rc_BAR_config_reg__RCBAR1C'] == "Disabled":
				user_registers['i_client_LM__i_rc_BAR_config_reg__RCBCE'] = "0"
			else:
				user_registers['i_client_LM__i_rc_BAR_config_reg__RCBCE'] = "1"

			# PF Number
			user_registers['i_client_LM__i_pf_config_reg__F1E'] = "0"
			user_registers['i_client_LM__i_pf_config_reg__F2E'] = "0"
			user_registers['i_client_LM__i_pf_config_reg__F3E'] = "0"


      #end of RP only
	#pprint.pprint(user_registers)
	return user_registers,f

def hex_check(param, value, bit_width, f):
	value = str(value)
	bin_value = ''

	value = value.split("'h",1)[1] if "'h" in value else value.split("x",1)[1]
	# Code to convert hex to binary
	bin_value = bin(int(value, 16))
	bin_value = bin_value[2:] # remove 0b

	# Check if contains only binary number
	b = {'0','1'}
	test_value = set(bin_value)
	if not (test_value == b or test_value == {'0'} or test_value == {'1'}):
		f['design_warnings'].append("ERROR: Unexpected value type in ", param, value)

	# Check if exceeds bit width
	if (len(bin_value) > bit_width): 
		f['design_warnings'].append("ERROR: ", param, " value ", value, " exceeds bit width.")

	return f


#----------------------------------------------------------------------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
#----------------------------------------- Set Default Functions ------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
#----------------------------------------------------------------------------------------------------------------------#
def set_defval_pcie(user_registers,f):
   # Import user input
	from efx_serdes.input_defval.defval_pcie import defval_pcie
	for pname in defval_pcie:
		if pname not in user_registers:
			user_registers[pname] = defval_pcie[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_pcie[pname] + "\""
			f['design_warnings'].append(msg)
	return user_registers,f

def set_defval_10gbe_cmn(user_registers,f): 
   # Import user input
	from efx_serdes.input_defval.defval_10gbe_cmn import defval_10gbe_cmn
	for pname in defval_10gbe_cmn:
		if pname not in user_registers:
			user_registers[pname] = defval_10gbe_cmn[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_10gbe_cmn[pname] + "\""
			f['design_warnings'].append(msg)
	return user_registers,f

def set_defval_10gbe_lane0(user_registers,f): 
   # Import user input
	from efx_serdes.input_defval.defval_10gbe_lane0 import defval_10gbe_lane0
	for pname in defval_10gbe_lane0:
		if pname not in user_registers:
			user_registers[pname] = defval_10gbe_lane0[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_10gbe_lane0[pname] + "\""
			f['design_warnings'].append(msg)
	return user_registers,f

def set_defval_10gbe_lane1(user_registers,f): 
   # Import user input
	from efx_serdes.input_defval.defval_10gbe_lane1 import defval_10gbe_lane1
	for pname in defval_10gbe_lane1:
		if pname not in user_registers:
			user_registers[pname] = defval_10gbe_lane1[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_10gbe_lane1[pname] + "\""
			f['design_warnings'].append(msg)
	return user_registers,f

def set_defval_10gbe_lane2(user_registers,f): 
   # Import user input
	from efx_serdes.input_defval.defval_10gbe_lane2 import defval_10gbe_lane2
	for pname in defval_10gbe_lane2:
		if pname not in user_registers:
			user_registers[pname] = defval_10gbe_lane2[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_10gbe_lane2[pname] + "\""
			f['design_warnings'].append(msg)
	return user_registers,f

def set_defval_10gbe_lane3(user_registers,f): 
   # Import user input
	from efx_serdes.input_defval.defval_10gbe_lane3 import defval_10gbe_lane3
	for pname in defval_10gbe_lane3:
		if pname not in user_registers:
			user_registers[pname] = defval_10gbe_lane3[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_10gbe_lane3[pname] + "\""
			f['design_warnings'].append(msg)
	return user_registers,f

def set_defval_1gbe_cmn(user_registers,f): 
   # Import user input
	from efx_serdes.input_defval.defval_1gbe_cmn import defval_1gbe_cmn
	for pname in defval_1gbe_cmn:
		if pname not in user_registers:
			user_registers[pname] = defval_1gbe_cmn[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_1gbe_cmn[pname] + "\""
			f['design_warnings'].append(msg)
	return user_registers,f

def set_defval_1gbe_lane0(user_registers,f): 
   # Import user input
	from efx_serdes.input_defval.defval_1gbe_lane0 import defval_1gbe_lane0
	for pname in defval_1gbe_lane0:
		if pname not in user_registers:
			user_registers[pname] = defval_1gbe_lane0[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_1gbe_lane0[pname] + "\""
			f['design_warnings'].append(msg)
	return user_registers,f

def set_defval_1gbe_lane1(user_registers,f): 
   # Import user input
	from efx_serdes.input_defval.defval_1gbe_lane1 import defval_1gbe_lane1
	for pname in defval_1gbe_lane1:
		if pname not in user_registers:
			user_registers[pname] = defval_1gbe_lane1[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_1gbe_lane1[pname] + "\""
			f['design_warnings'].append(msg)
	return user_registers,f

def set_defval_1gbe_lane2(user_registers,f): 
   # Import user input
	from efx_serdes.input_defval.defval_1gbe_lane2 import defval_1gbe_lane2
	for pname in defval_1gbe_lane2:
		if pname not in user_registers:
			user_registers[pname] = defval_1gbe_lane2[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_1gbe_lane2[pname] + "\""
			f['design_warnings'].append(msg)
	return user_registers,f

def set_defval_1gbe_lane3(user_registers,f): 
   # Import user input
	from efx_serdes.input_defval.defval_1gbe_lane3 import defval_1gbe_lane3
	for pname in defval_1gbe_lane3:
		if pname not in user_registers:
			user_registers[pname] = defval_1gbe_lane3[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_1gbe_lane3[pname] + "\""
			f['design_warnings'].append(msg)
	return user_registers,f
def set_defval_raw_cmn(user_registers,f): 
   # Import user input
	from efx_serdes.input_defval.defval_raw_cmn import defval_raw_cmn
	for pname in defval_raw_cmn:
		if pname not in user_registers:
			user_registers[pname] = defval_raw_cmn[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_raw_cmn[pname] + "\""
			f['design_warnings'].append(msg)
	return user_registers,f

def set_defval_raw_lane0(user_registers,f): 
   # Import user input
	from efx_serdes.input_defval.defval_raw_lane0 import defval_raw_lane0
	for pname in defval_raw_lane0:
		if pname not in user_registers:
			user_registers[pname] = defval_raw_lane0[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_raw_lane0[pname] + "\""
			f['design_warnings'].append(msg)
	return user_registers,f

def set_defval_raw_lane1(user_registers,f): 
   # Import user input
	from efx_serdes.input_defval.defval_raw_lane1 import defval_raw_lane1
	for pname in defval_raw_lane1:
		if pname not in user_registers:
			user_registers[pname] = defval_raw_lane1[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_raw_lane1[pname] + "\""
			f['design_warnings'].append(msg)
	return user_registers,f

def set_defval_raw_lane2(user_registers,f): 
   # Import user input
	from efx_serdes.input_defval.defval_raw_lane2 import defval_raw_lane2
	for pname in defval_raw_lane2:
		if pname not in user_registers:
			user_registers[pname] = defval_raw_lane2[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_raw_lane2[pname] + "\""
			f['design_warnings'].append(msg)
	return user_registers,f

def set_defval_raw_lane3(user_registers,f): 
   # Import user input
	from efx_serdes.input_defval.defval_raw_lane3 import defval_raw_lane3
	for pname in defval_raw_lane3:
		if pname not in user_registers:
			user_registers[pname] = defval_raw_lane3[pname]
			msg = "WARNING: " + pname + " is not found. Using default value " + "\"" + defval_raw_lane3[pname] + "\""
			f['design_warnings'].append(msg)
