# Purpose: Extract Address, Register Name, OP bits, Register value from master_<cmn/pcie/10G/1G>.xlsx
#	   Output csv file with reg_name, op_bit, addr, reg_value
# 	   This script might need to append the value from each field to form a 32-bit register value

# TODO
# /1. get input topology to read from specific tabs/files - Done 
# /2. get input pf/vf_num to auto generate register set with auto increment addr
#	- prefer not to auto-gen, but remain all PF1-3/VF1-63 registers in xlsx
#	- then the script just detect if register value different from default value, if yes then program, if not then ignore
# /3. take in user settings - Done
# /4. Output files - phy_cfg.csv, core_cfg.csv
# 5. Integrate HW scripts - to be discussed
# /6. user input value format - 'b/'h/0x or all? - current assume just 0101, no 'b - to be revisit
# /7. Extract reg_info, handle space before and after = / ;
# 8. Output error to file

import openpyxl
import argparse
import os

def gen_config_csv(input_master_ram,user_input,work_path='.',output_path='.'):
	print("\nINFO: Generating register list for PCR programming...")
	global flr_reload, sticky, csv_output, data_width
	global mask_1, mask_2, mask_3, mask_4
	global tab_name, address, reg_name, op_bit, field, msb,lsb
	global reset_bitvalue, default_value, default_bitvalue, user_bitvalue

	output_dir = work_path
	

	if not os.path.exists(work_path):
		os.makedirs(work_path)

	if not os.path.exists(output_path):
		os.makedirs(output_path)

	# initialization
	flr_reload = 0
	sticky = 0
	csv_output = 0
	data_width = 32
	mask_1,mask_2,mask_3,mask_4 = ('','','','')
	address,reg_name,op_bit,field = ('','','','')
	msb = data_width - 1
	lsb = 0
	reset_bitvalue = ''
	default_value = ''
	default_bitvalue = ''
	user_bitvalue = ''
	errors = {}
	errors['user_errors'] = []
	errors['user_warnings'] = []
	errors['design_errors'] = []
	errors['design_warnings'] = []

	if 'q0' in user_input or 'q1' in user_input:
		quads = ['q0','q1']

	elif 'q2' in user_input or 'q3' in user_input:
		quads = ['q2','q3']
	else:
		errors['design_errors'].append("ERROR: No quad (q0/q1/q2/q3) is found in user_registers.")
		if (len(errors['user_errors']) > 0) or (len(errors['design_errors']) > 0):
			return errors
		
	for quad in quads:
		default_col_list = {}
		default_col_list['CMN'] = ''
		default_col_list['L0'] = ''
		default_col_list['L1'] = ''
		default_col_list['L2'] = ''
		default_col_list['L3'] = ''

		if not quad in user_input:
			# unused quad
			print("INFO: Generating settings to turn off",quad,"...")
			user_data = {}
			files = ['master_cmn']

			out_f = output_dir + '/' + quad + '_phy_cfg.csv'
			open(out_f, 'w', encoding='utf-8').close()
			out_f = output_dir + '/' + quad + '_pcie.csv'
			open(out_f, 'w', encoding='utf-8').close()

			for filename in files:
				if "cmn" in filename:
					print("INFO: Generating for PHY registers...", end="")
				elif "10G" in filename:
					print("INFO: Generating for 10G PCS registers...", end="")
				elif "1G" in filename:
					print("INFO: Generating for 1G PCS registers...", end="")
				elif "pcie" in filename:
					print("INFO: Generating for PCIe registers...", end="")

				output_file = 'pcie' if 'master_pcie' in filename else 'phy_cfg'
				output_file = output_dir + '/' + quad + '_' + output_file + '.csv'
					
				tab_list = input_master_ram[filename].keys()
				for x in default_col_list:
					default_col_list[x] = 'unused_quad'

				errors = gen_config_csv_with_df_col_name(user_data,output_file,input_master_ram[filename],tab_list,default_col_list,0,4,0,errors)
				print(" Completed!")
		else:
			print("INFO: Generating for",quad,"...")
			user_data = user_input[quad]
			if "ss_topology_lane0" in user_data and "ss_topology_lane1" in user_data and "ss_topology_lane2" in user_data and "ss_topology_lane3" in user_data:		
				topo_lane0 = user_data["ss_topology_lane0"]		
				topo_lane1 = user_data["ss_topology_lane1"]		
				topo_lane2 = user_data["ss_topology_lane2"]		
				topo_lane3 = user_data["ss_topology_lane3"]		
				
				rp_mode = int(user_data["PIPE_CONFIG_CMN__config_reg_0__mode_select"]) if "PIPE_CONFIG_CMN__config_reg_0__mode_select" in user_data else 0
				pf_num = int(user_data["ss_pcie_pf_num"]) if "ss_pcie_pf_num" in user_data else 0 
				su_mode = 1 if user_data["ss_sim_enable"] == "Speed up" else 0 #TODO - simulation GUI param name
				mode,errors = set_mode(topo_lane0,topo_lane1,topo_lane2,topo_lane3,errors)
				if (len(errors['user_errors']) > 0) or (len(errors['design_errors']) > 0):
					return errors
				error = 0
				warning = 0
				files,errors = get_files(mode,errors)
				if (len(errors['user_errors']) > 0) or (len(errors['design_errors']) > 0):
					return errors

				out_f = output_dir + '/' + quad + '_phy_cfg.csv'
				outfile = open(out_f, 'w', encoding='utf-8')
				# Fix for PT-2578 Update SCF to insert additional configuration step in late REFCLK scenario
				if "ss_refclk_onboard_osc" in user_data and int(user_data["ss_refclk_onboard_osc"]) == 0:
					for times in range(20):
						outfile_line = 'config_reg_2,0100,0x600008,0x00000224\n'
						outfile.write(outfile_line)
				outfile.close()

				out_f = output_dir + '/' + quad + '_pcie.csv'
				open(out_f, 'w', encoding='utf-8').close()

				if (su_mode):
					out_f = output_dir + '/' + quad + '_phy_cfg_su.csv'
					outfile = open(out_f, 'w', encoding='utf-8')
					# Fix for PT-2578 Update SCF to insert additional configuration step in late REFCLK scenario
					if "ss_refclk_onboard_osc" in user_data and int(user_data["ss_refclk_onboard_osc"]) == 0:
						for times in range(20):
							outfile_line = 'config_reg_2,0100,0x600008,0x00000224\n'
							outfile.write(outfile_line)
					outfile.close()
					out_f = output_dir + '/' + quad + '_pcie_su.csv'
					open(out_f, 'w', encoding='utf-8').close()
						
				for filename in files:
					if "cmn" in filename:
						print("INFO: Generating for PHY registers...", end="")
					elif "10G" in filename:
						print("INFO: Generating for 10G PCS registers...", end="")
					elif "1G" in filename:
						print("INFO: Generating for 1G PCS registers...", end="")
					elif "pcie" in filename:
						print("INFO: Generating for PCIe registers...", end="")

					output_file = 'pcie' if 'master_pcie' in filename else 'phy_cfg'
					output_file = output_dir + '/' + quad + '_' + output_file + '.csv'
						
					tab_list,errors = get_tabs(mode,rp_mode,pf_num,topo_lane0,topo_lane1,topo_lane2,topo_lane3,input_master_ram[filename].keys(),errors)
					if (len(errors['user_errors']) > 0) or (len(errors['design_errors']) > 0):
						return errors
					for x in mode:
						default_col_list[x] = 'default_' + mode[x]
						if (mode[x] == 'PCIe'):
							default_col_list[x] = default_col_list[x] + '_RC' if rp_mode else default_col_list[x] + '_EP'
						elif (mode[x] == '1G'):
							if (x == 'CMN'):
								default_col_list[x] = 'default_3G'
							else:
								data_rate_param = "ss_1gbe_data_rate_lane" + x[-1]
								if ("2.5" in user_data[data_rate_param]):
									default_col_list[x] = 'default_3G'
								else:
									default_col_list[x] = 'default_1G'
						elif (mode[x] == 'RAW'):
							if (x == 'CMN'): # TODO - update when different data rate across different lanes is supported
								if (mode['L0'] == 'RAW'):
									data_rate_param = "ss_raw_data_rate_lane0"
									serdes_width_param = "ss_raw_serdes_width_lane0"
								elif (mode['L1'] == 'RAW'):
									data_rate_param = "ss_raw_data_rate_lane1"
									serdes_width_param = "ss_raw_serdes_width_lane1"
								elif (mode['L2'] == 'RAW'):
									data_rate_param = "ss_raw_data_rate_lane2"
									serdes_width_param = "ss_raw_serdes_width_lane2"
								elif (mode['L3'] == 'RAW'):
									data_rate_param = "ss_raw_data_rate_lane3"
									serdes_width_param = "ss_raw_serdes_width_lane3"
							else:
								data_rate_param = "ss_raw_data_rate_lane" + x[-1]
								serdes_width_param = "ss_raw_serdes_width_lane" + x[-1]
							if data_rate_param in user_data:
								data_rate = float(user_data[data_rate_param])
								serdes_width = user_data[serdes_width_param]
								if ("20" in serdes_width or "40" in serdes_width):
									if (data_rate <= 2.7):
										default_col_list[x] = 'default_1G'
									elif (data_rate < 4.7):
										default_col_list[x] = 'default_3G'
									elif (data_rate <= 8.1):
										default_col_list[x] = 'default_5G'
									else:
										default_col_list[x] = 'default_10G_20b'
								elif (data_rate <= 11.4):
									default_col_list[x] = 'default_10G'
								else:
									default_col_list[x] = 'default_12p5G'
							else:
								err_msg = "ERROR: " + data_rate_param + " parameter is not found."
								errors['design_errors'].append(err_msg)
								if (len(errors['user_errors']) > 0) or (len(errors['design_errors']) > 0):
									return errors								

					errors = gen_config_csv_with_df_col_name(user_data,output_file,input_master_ram[filename],tab_list,default_col_list,0,pf_num,rp_mode,errors)

					# Generate another set for speed up mode
					if (su_mode):
						output_file = 'pcie' if 'master_pcie' in filename else 'phy_cfg'
						output_file = output_dir + '/' + quad + '_' + output_file + '_su.csv'
						errors = gen_config_csv_with_df_col_name(user_data,output_file,input_master_ram[filename],tab_list,default_col_list,1,pf_num,rp_mode,errors)
								

					print(" Completed!")

			else:
				errors['design_warnings'].append("WARNING: " + quad + " is not set. topology/mode_select parameter is not found.")
				out_f = output_dir + '/' + quad + '_phy_cfg.csv'
				open(out_f, 'w', encoding='utf-8').close()
				out_f = output_dir + '/' + quad + '_pcie.csv'
				open(out_f, 'w', encoding='utf-8').close()


	print("INFO: Register list generation completed.")
	return errors

def load_user_data(register_values):

	#Initiate a dictionary to store the reg_name and value from user
	user_registers = {}

	for reg in register_values:
    		user_registers[reg["name"]] =  reg["value"]

	return user_registers 

def set_mode(topo_lane0,topo_lane1,topo_lane2,topo_lane3,errors):

	topology = topo_lane0 + "_" + topo_lane1 + "_" + topo_lane2 + "_" + topo_lane3
	mode = {}
	mode['CMN'] = ''
	mode['L0'] = ''
	mode['L1'] = ''
	mode['L2'] = ''
	mode['L3'] = ''

	# TODO - revisit topology values
	#PCIe
	if (topology == "PCIe_PCIe_PCIe_PCIe"):
		mode['CMN'] = "PCIe"

	#MIX1G10G only
	elif (topology == "1GE_Disabled_10GE_Disabled" or topology == "1GE_1GE_10GE_10GE" or topology == "Disabled_1GE_Disabled_10GE" or topology == "1GE_Disabled_Disabled_10GE" or topology == "Disabled_1GE_10GE_Disabled"):
		mode['CMN'] = "mix1G10G"

	#10G only
	elif (topology == "10GE_10GE_10GE_10GE" or topology == "10GE_10GE_10GE_Disabled" or topology == "10GE_10GE_Disabled_10GE" or topology == "10GE_10GE_Disabled_Disabled" or topology == "10GE_Disabled_10GE_10GE" or topology == "10GE_Disabled_10GE_Disabled" or topology == "10GE_Disabled_Disabled_10GE" or topology == "10GE_Disabled_Disabled_Disabled" or topology == "Disabled_10GE_10GE_10GE" or topology == "Disabled_10GE_10GE_Disabled" or topology == "Disabled_10GE_Disabled_10GE" or topology == "Disabled_10GE_Disabled_Disabled" or topology == "Disabled_Disabled_10GE_10GE" or topology == "Disabled_Disabled_10GE_Disabled" or topology == "Disabled_Disabled_Disabled_10GE"):
		mode['CMN'] = "10G"

	#1G only
	elif (topology == "1GE_1GE_1GE_1GE" or topology == "1GE_1GE_1GE_Disabled" or topology == "1GE_1GE_Disabled_1GE" or topology == "1GE_1GE_Disabled_Disabled" or topology == "1GE_Disabled_1GE_1GE" or topology == "1GE_Disabled_1GE_Disabled" or topology == "1GE_Disabled_Disabled_1GE" or topology == "1GE_Disabled_Disabled_Disabled" or topology == "Disabled_1GE_1GE_1GE" or topology == "Disabled_1GE_1GE_Disabled" or topology == "Disabled_1GE_Disabled_1GE" or topology == "Disabled_1GE_Disabled_Disabled" or topology == "Disabled_Disabled_1GE_1GE" or topology == "Disabled_Disabled_1GE_Disabled" or topology == "Disabled_Disabled_Disabled_1GE"):
		mode['CMN'] = "1G"

	#RAW only
	elif (topology == "Raw Serdes_Raw Serdes_Raw Serdes_Raw Serdes" or topology == "Raw Serdes_Raw Serdes_Raw Serdes_Disabled" or topology == "Raw Serdes_Raw Serdes_Disabled_Raw Serdes" or topology == "Raw Serdes_Raw Serdes_Disabled_Disabled" or topology == "Raw Serdes_Disabled_Raw Serdes_Raw Serdes" or topology == "Raw Serdes_Disabled_Raw Serdes_Disabled" or topology == "Raw Serdes_Disabled_Disabled_Raw Serdes" or topology == "Raw Serdes_Disabled_Disabled_Disabled" or topology == "Disabled_Raw Serdes_Raw Serdes_Raw Serdes" or topology == "Disabled_Raw Serdes_Raw Serdes_Disabled" or topology == "Disabled_Raw Serdes_Disabled_Raw Serdes" or topology == "Disabled_Raw Serdes_Disabled_Disabled" or topology == "Disabled_Disabled_Raw Serdes_Raw Serdes" or topology == "Disabled_Disabled_Raw Serdes_Disabled" or topology == "Disabled_Disabled_Disabled_Raw Serdes"):
		mode['CMN'] = "RAW"

	else:
		errors['design_errors'].append("ERROR: Undefined topology combination") 
		mode['CMN'] = "Disabled"

	
	if (topo_lane0 == "PCIe"):
		mode['L0'] = "PCIe"
	elif (topo_lane0 == "10GE"):
		mode['L0'] = "10G"
	elif (topo_lane0 == "1GE"):
		mode['L0'] = "1G"
	elif (topo_lane0 == "Raw Serdes"):
		mode['L0'] = "RAW"
	elif (topo_lane0 == "Disabled"):
		mode['L0'] = "Disabled"

	if (topo_lane1 == "PCIe"):
		mode['L1'] = "PCIe"
	elif (topo_lane1 == "10GE"):
		mode['L1'] = "10G"
	elif (topo_lane1 == "1GE"):
		mode['L1'] = "1G"
	elif (topo_lane1 == "Raw Serdes"):
		mode['L1'] = "RAW"
	elif (topo_lane1 == "Disabled"):
		mode['L1'] = "Disabled"
	
	if (topo_lane2 == "PCIe"):
		mode['L2'] = "PCIe"
	elif (topo_lane2 == "10GE"):
		mode['L2'] = "10G"
	elif (topo_lane2 == "1GE"):
		mode['L2'] = "1G"
	elif (topo_lane2 == "Raw Serdes"):
		mode['L2'] = "RAW"
	elif (topo_lane2 == "Disabled"):
		mode['L2'] = "Disabled"

	if (topo_lane3 == "PCIe"):
		mode['L3'] = "PCIe"
	elif (topo_lane3 == "10GE"):
		mode['L3'] = "10G"
	elif (topo_lane3 == "1GE"):
		mode['L3'] = "1G"
	elif (topo_lane3 == "Raw Serdes"):
		mode['L3'] = "RAW"
	elif (topo_lane3 == "Disabled"):
		mode['L3'] = "Disabled"

	return mode,errors

def get_files(mode,errors):

	files = ['master_cmn']
	if (mode['CMN'] == "mix1G10G" or mode['L0'] == "mix1G10G" or mode['L1'] == "mix1G10G" or mode['L2'] == "mix1G10G" or mode['L3'] == "mix1G10G"):
		files.append('master_10G')
		files.append('master_1G')
	if (mode['CMN'] == "10G" or mode['L0'] == "10G" or mode['L1'] == "10G" or mode['L2'] == "10G" or mode['L3'] == "10G"):
		files.append('master_10G')
	if (mode['CMN'] == "1G" or mode['L0'] == "1G" or mode['L1'] == "1G" or mode['L2'] == "1G" or mode['L3'] == "1G"):
		files.append('master_1G')
	if (mode['CMN'] == "PCIe" or mode['L0'] == "PCIe" or mode['L1'] == "PCIe" or mode['L2'] == "PCIe" or mode['L3'] == "PCIe"):
		files.append('master_pcie')

	return files,errors

def get_tabs(mode,rp_mode,pf_num,topo_lane0,topo_lane1,topo_lane2,topo_lane3,tab_list,errors):

	topology = topo_lane0 + "_" + topo_lane1 + "_" + topo_lane2 + "_" + topo_lane3
	filtered_tab_list = []
	for tab in tab_list:
		if topology == "PCIe_PCIe_PCIe_PCIe" and "i_client_" in tab:
			if ("PF" in tab) and not rp_mode:
				filtered_tab_list.append(tab)
			elif ("VF" in tab) and not rp_mode:
				filtered_tab_list.append(tab)
			elif ("RC" in tab) and rp_mode:
				filtered_tab_list.append(tab)
			elif ("atu" in tab) or ("LM" in tab):
				filtered_tab_list.append(tab)
			elif not(("PF" in tab) or ("VF" in tab) or ("RC" in tab) or ("atu" in tab) or ("LM" in tab)):
				errors['design_errors'].append("ERROR: Undefined tab name: " + tab)
		elif "CMN" in tab:
			filtered_tab_list.append(tab)
		elif ("L0" in tab) and topo_lane0 != "Disabled":
			filtered_tab_list.append(tab)
		elif ("L1" in tab) and topo_lane1 != "Disabled":
			filtered_tab_list.append(tab)
		elif ("L2" in tab) and topo_lane2 != "Disabled":
			filtered_tab_list.append(tab)
		elif ("L3" in tab) and topo_lane3 != "Disabled":
			filtered_tab_list.append(tab)
		elif not(("CMN" in tab) or ("L0" in tab) or ("L1" in tab) or ("L2" in tab) or ("L3" in tab) or ("i_pcie_RC" in tab)):
			errors['design_errors'].append("ERROR: Undefined tab name: " + tab)	
	return filtered_tab_list,errors

def value_to_bin(errors,value, tab_name, reg_name, field, msb, lsb, bit_width):
	value = str(value)
	bin_value = ''

	bin_bit_format = str(bit_width) + "'b"
	if "'b" in value: # value in binary format
		bin_value = value.split("'b",1)[1]
	elif "'h" in value or "0x" in value: # value in hex format
		value = value.split("'h",1)[1] if "'h" in value else value.split("x",1)[1]
		# Code to convert hex to binary
		bin_value = bin(int(value, 16))
		bin_value = bin_value[2:] # remove 0b
	elif "'d" in value or value.isnumeric(): # value in decimal format
		value = value.split("'d",1)[1] if "'d" in value else value
		bin_value = bin(int(value))
		bin_value = bin_value[2:] # remove 0b
	else:
		errors['design_errors'].append('ERROR: Wrong value format: ' + tab_name + ' ' + reg_name + ' ' + field + ' ' + value)

	# Check if contains only binary number
	b = {'0','1'}
	test_value = set(bin_value)
	if not (test_value == b or test_value == {'0'} or test_value == {'1'}):
		errors['design_errors'].append("ERROR: Unexpected value type: " + tab_name + ' ' + reg_name + ' ' + field + ' ' + value)

	# Check if exceeds bit width
	if (len(bin_value) > bit_width): 
		errors['design_errors'].append("ERROR: Value exceeds bit width: " + tab_name + ' ' + reg_name + ' ' + field + ' ' + value)

	# Pad zero
	if (len(bin_value) < bit_width):
		diff = bit_width - len(bin_value)
		for i in range(diff):
			bin_value = '0' + bin_value

	return bin_value,errors

def bin_to_hex (bin):
    #Convert 4 bits binary in str to hex in str
        if bin == "0000":
            return "0"
        elif bin == "0001":
            return "1"
        elif bin == "0010":
            return "2"
        elif bin == "0011":
            return "3"
        elif bin == "0100":
            return "4"
        elif bin == "0101":
            return "5"
        elif bin == "0110":
            return "6"
        elif bin == "0111":
            return "7"
        elif bin == "1000":
            return "8"
        elif bin == "1001":
            return "9"
        elif bin == "1010":
            return "A"
        elif bin == "1011":
            return "B"
        elif bin == "1100":
            return "C"
        elif bin == "1101":
            return "D"
        elif bin == "1110":
            return "E"
        elif bin == "1111":
            return "F"
        else:
            return 'X'
            print("ERROR: Non binary pattern detected: " + bin )

def gen_config_csv_with_df_col_name(user_data,output_file,workbook,tab_list,default_col_list,su_mode,pf_num,rp_mode,errors):
	global flr_reload, sticky, csv_output, data_width
	global mask_1, mask_2, mask_3, mask_4
	global tab_name, address, reg_name, op_bit, field, msb,lsb
	global reset_bitvalue, default_value, default_bitvalue, user_bitvalue

	outfile = open(output_file, 'a', encoding='utf-8')
	skip_pf = 0

	su_default_col_list = {}
	su_default_col_list['CMN'] = ''
	su_default_col_list['L0'] = ''
	su_default_col_list['L1'] = ''
	su_default_col_list['L2'] = ''
	su_default_col_list['L3'] = ''
	if su_mode:
		for x in default_col_list:
			su_default_col_list[x] = default_col_list[x] + '_su'
	for tab in tab_list:
		if ('L0' in tab):
			default_col_name = default_col_list['L0']
			su_default_col_name = su_default_col_list['L0']
		elif ('L1' in tab):
			default_col_name = default_col_list['L1']
			su_default_col_name = su_default_col_list['L1']
		elif ('L2' in tab):
			default_col_name = default_col_list['L2']
			su_default_col_name = su_default_col_list['L2']
		elif ('L3' in tab):
			default_col_name = default_col_list['L3']
			su_default_col_name = su_default_col_list['L3']
		else:
			default_col_name = default_col_list['CMN']
			su_default_col_name = su_default_col_list['CMN']

		tab_name = tab 

		outfile.write("// " + tab_name + "\n")

		if not (("PF" in tab) and not rp_mode and int(tab[11:]) >= pf_num):
			# skip for disabled PF
			for reg_name in workbook[tab]:
				reg_dict = workbook[tab][reg_name]
				address = reg_dict['addr']
				default_value = reg_dict[default_col_name] if default_col_name in reg_dict else None
				if su_mode:
					default_value = reg_dict[su_default_col_name] if su_default_col_name in reg_dict else default_value
				data_width = reg_dict['data_width']
				op_bit = reg_dict['op_bit']
				flr_reload = reg_dict['FLR'] if 'FLR' in reg_dict else 0
				sticky = reg_dict['sticky'] if 'sticky' in reg_dict else 0
				mask_1 = reg_dict['mask_1'] if 'mask_1' in reg_dict else 0
				mask_2 = reg_dict['mask_2'] if 'mask_2' in reg_dict else 0
				mask_3 = reg_dict['mask_3'] if 'mask_3' in reg_dict else 0
				mask_4 = reg_dict['mask_4'] if 'mask_4' in reg_dict else 0

				for field in workbook[tab][reg_name]['field']:
					field_dict = workbook[tab][reg_name]['field'][field]
					msb = field_dict['msb']
					lsb = field_dict['lsb']
					access = field_dict['access']
					bit_width = int(msb) - int(lsb) + 1
					rst_bit,errors = value_to_bin(errors,field_dict['reset_value'], tab_name, reg_name, field, msb, lsb, bit_width)

					if su_mode and su_default_col_name in field_dict:
						df_bit,errors = value_to_bin(errors,field_dict[su_default_col_name], tab_name, reg_name, field, msb, lsb, bit_width)			
					elif default_col_name in field_dict:
						df_bit,errors = value_to_bin(errors,field_dict[default_col_name], tab_name, reg_name, field, msb, lsb, bit_width)			
					else:
						df_bit = rst_bit

					user_json_key = tab_name + '__' + reg_name + '__' + field
					if user_json_key in user_data:
						user_bit = str(bit_width) + "'b" + str(user_data[user_json_key]) # TODO - revisit input data format
						user_bit,errors = value_to_bin(errors,user_bit, tab_name, reg_name, field, msb, lsb, bit_width) # data format checking
						if (len(user_bit) < bit_width):
							err_msg = "ERROR: Expected bit width of " + user_json_key + " is " + str(bit_width) + ". Current value is " + user_bit + "."
							errors['user_errors'].append(err_msg)

						elif (len(user_bit) > bit_width): 
							err_msg = "ERROR: Expected bit width of " + user_json_key + " is " + str(bit_width) + ". Current value is " + user_bit + "."
							errors['user_errors'].append(err_msg)
					else:
						if (default_value is not None):
							bin_df_value,errors = value_to_bin(errors,default_value, tab_name, reg_name, field, msb, lsb, data_width)
							reversed_value = bin_df_value[::-1]
							user_bit = reversed_value[lsb:msb+1][::-1]
							#print(',,',user_bit,default_value)
						else:
							user_bit = df_bit
					#print(reg_name, field, msb, lsb, bit_width,access,default_value,user_bit,df_bit,rst_bit)
					# TODO: add back read-only with waiver handling
					#if access != "RW" and (user_bit != rst_bit or df_bit != rst_bit) and field != 'deq_vgalut_addr_13_6':
						# deq_vgalut_addr_13_6 is special hacking, set this bit to 1 to allow to program 0x0 ram entry, following Cadence csv
						#err_msg = "WARNING: Attempting to write to read-only register: " + user_json_key + "."
						#errors['design_warnings'].append(err_msg)


					reset_bitvalue = rst_bit + reset_bitvalue
					default_bitvalue = df_bit + default_bitvalue
					user_bitvalue = user_bit + user_bitvalue
				
				if (default_value is not None):
					bin_df_value,errors = value_to_bin(errors,default_value, tab_name, reg_name, field, msb, lsb, data_width)
					if default_bitvalue != bin_df_value and default_bitvalue != reset_bitvalue:
						errors['design_errors'].append("ERROR: Default values mismatch: " + tab_name + ' ' + reg_name + ' ' + default_value + ' ' + default_bitvalue)	
				if (len(user_bitvalue) != data_width):
					errors['design_errors'].append("ERROR: " + reg_name + " data width is " + str(data_width) + ", but user_bitvalue is " + str(len(user_bitvalue)))	
				if (len(reset_bitvalue) != data_width):
					errors['design_errors'].append("ERROR: " + reg_name + " data width is " + str(data_width) + ", but reset_bitvalue is " + str(len(reset_bitvalue)))	
				if (len(default_bitvalue) != data_width):
					errors['design_errors'].append("ERROR: " + reg_name + " data width is " + str(data_width) + ", but default_bitvalue is " + str(len(default_bitvalue)))

				# output : user_value > default_value (if same as reset value, no need to program) > sticky/FLR register needs to be reloaded
				csv_output = 0
				if user_bitvalue != reset_bitvalue or user_bitvalue != default_bitvalue:
					csv_output = 1
					hex_user_bitvalue = ''
					for j in range(int(data_width/4)):
						hex_user_bitvalue = hex_user_bitvalue + bin_to_hex(user_bitvalue[j*4:((j*4)+4)])
					out_value = '0x' + hex_user_bitvalue
				elif (default_value is not None):
					bin_df_value,errors = value_to_bin(errors,default_value, tab_name, reg_name, field, msb, lsb, data_width)
					if bin_df_value == default_bitvalue and bin_df_value != reset_bitvalue: 
						csv_output = 1
						hex_default_value = ''
						for j in range(int(data_width/4)):
							hex_default_value = hex_default_value + bin_to_hex(bin_df_value[j*4:((j*4)+4)])
						out_value = '0x' + hex_default_value
				elif default_bitvalue != reset_bitvalue:
					csv_output = 1
					hex_default_bitvalue = ''
					for j in range(int(data_width/4)):
						hex_default_bitvalue = hex_default_bitvalue + bin_to_hex(default_bitvalue[j*4:((j*4)+4)])
					out_value = '0x' + hex_default_bitvalue
				elif flr_reload or sticky:
					csv_output = 1
					hex_reset_bitvalue = ''
					for j in range(int(data_width/4)):
						hex_reset_bitvalue = hex_reset_bitvalue + bin_to_hex(reset_bitvalue[j*4:((j*4)+4)])
					out_value = '0x' + hex_reset_bitvalue



				if csv_output:
					if (flr_reload and sticky): # 4 RAM entry
						op_bit = '0011'
						output_value = '0x' + mask_1 + '00' + out_value[8:10]
						outfile_line = reg_name + ',' + op_bit + ',' + address + ',' + output_value + '\n'
						outfile.write(outfile_line)	
						op_bit = '0111'
						output_value = '0x' + mask_2 + '00' + out_value[6:8]
						outfile_line = reg_name + ',' + op_bit + ',' + address + ',' + output_value + '\n'
						outfile.write(outfile_line)	
						op_bit = '1011'
						output_value = '0x' + mask_3 + '00' + out_value[4:6]
						outfile_line = reg_name + ',' + op_bit + ',' + address + ',' + output_value + '\n'
						outfile.write(outfile_line)
						op_bit = '1111'
						output_value = '0x' + mask_4 + '00' + out_value[2:4]
						outfile_line = reg_name + ',' + op_bit + ',' + address + ',' + output_value + '\n'
						outfile.write(outfile_line)
					elif (flr_reload or sticky): # 2 RAM entry
						op_bit = '0101' if sticky else '0110'
						output_value = '0x' + mask_1 + out_value[6:10]
						outfile_line = reg_name + ',' + op_bit + ',' + address + ',' + output_value + '\n'
						outfile.write(outfile_line)
						op_bit = '1001' if sticky else '1010'
						output_value = '0x' + mask_2 + out_value[2:6]
						outfile_line = reg_name + ',' + op_bit + ',' + address + ',' + output_value + '\n'
						outfile.write(outfile_line)						
					else: # 1 RAM entry
						output_value = out_value
						outfile_line = reg_name + ',' + op_bit + ',' + address + ',' + output_value + '\n'
						outfile.write(outfile_line)

				# reset parameter value
				flr_reload = 0
				sticky = 0
				csv_output = 0
				mask_1,mask_2,mask_3,mask_4 = ('','','','')
				address,reg_name,op_bit,field = ('','','','')
				msb = data_width - 1
				lsb = 0
				reset_bitvalue = ''
				default_value = ''
				default_bitvalue = ''
				user_bitvalue = ''


	outfile.close()
	return errors


if __name__ == '__main__':
    main()
