from __future__ import annotations
from typing import List, Optional

from api_service.common.object_db import APIObject
from api_service.internal.int_lane1g import IntLane1GAPI

from api_service.property.gen_prop import (
    AdvPresenter,
)
from api_service.property.inspector.block_inspect import BlockPropInspector
from api_service.property.lane1g_prop_id import Lane1GPropId
from api_service.property.api_options.lane1g_api_options import enum2api_ops_map
from api_service.property.lane_based_prop import LaneBasedProp

from design.db import PeriDesign

from common_device.quad.lane_design import LaneBasedItem

from tx375_device.lane1g.design import Lane1G
from tx375_device.lane1g.design_param_info import Lane1GDesignParamInfo
from tx375_device.lane1g.quad_param_info import get_hidden_parameters, get_hidden_param_values, get_supported_common_parameters as get_hw_support_cmn_params
from tx375_device.lane1g.lane1g_pin_dep_graph import get_hidden_ports

from common_device.quad.res_service import QuadType

class Lane1GProp(LaneBasedProp):

    quad_type = QuadType.lane_1g

    def get_lane_inst_class(self):
        return Lane1G

    def get_iblock(self):
        return IntLane1GAPI()

    def get_prop_id_class(self):
        return Lane1GPropId

    def get_hidden_ports(self):
        return get_hidden_ports()

    def get_hidden_parameters(self):
        return get_hidden_parameters() + ['phy_reset_en']

    def get_hidden_param_values(self):
        return get_hidden_param_values()

    def get_hw_support_cmn_params(self):
        return get_hw_support_cmn_params()

    def get_hw_lane_param_id_class(self):
        return Lane1GDesignParamInfo.Id

    def get_prop_id_str2api_options(self):
        return enum2api_ops_map

    def _build_presenter(self):
        self.prs = Lane1GPresenter()

    @staticmethod
    def build_prop(block_type: Optional[APIObject.ObjectType] = None,
                   db_inst: Optional[LaneBasedItem] = None,
                   design_db: Optional[PeriDesign] = None):
        if design_db is not None:
            if design_db.is_block_supported(PeriDesign.BlockType.lane_1g):
                return Lane1GProp(block_type, db_inst, design_db)

        else:
            return Lane1GProp(block_type, db_inst, design_db)

        raise NotImplementedError

    def build_inspector(self) -> BlockPropInspector:
        from api_service.property.inspector.lane1g_inspector import Lane1GPropInspector
        return Lane1GPropInspector(self, self._iblock) # type: ignore

    # TODO: check after import all properties from ISF file
    def check_properties(self, inst):
        assert isinstance(inst, LaneBasedItem)

        err_msg_list: List = []

        return err_msg_list


class Lane1GPresenter(AdvPresenter):
    def __init__(self):
        super().__init__()
