from __future__ import annotations
from typing import Iterable, List, Optional

from api_service.common.object_db import APIObject
from api_service.internal.int_lane10g import IntLane10GAPI

from api_service.property.gen_prop import AdvPresenter
from api_service.property.inspector.block_inspect import BlockPropInspector
from api_service.property.lane10g_prop_id import Lane10GPropId
from api_service.property.api_options.lane10g_api_options import enum2api_ops_map
from api_service.property.lane_based_prop import LaneBasedProp

from design.db import PeriDesign

from tx375_device.lane10g.design import Lane10G
from tx375_device.lane10g.design_param_info import Lane10GDesignParamInfo
from tx375_device.lane10g.quad_param_info import get_hidden_parameters, get_hidden_param_values, get_supported_common_parameters as get_hw_support_cmn_params
from tx375_device.lane10g.lane10g_pin_dep_graph import get_hidden_ports

from common_device.quad.res_service import QuadType

class Lane10GProp(LaneBasedProp):
    quad_type = QuadType.lane_10g

    def get_lane_inst_class(self):
        return Lane10G

    def get_iblock(self):
        return IntLane10GAPI()

    def get_prop_id_class(self):
        return Lane10GPropId

    def get_hidden_ports(self):
        return get_hidden_ports()

    def get_hidden_parameters(self):
        return get_hidden_parameters() + ['alt_fwd_conn_type', 'phy_reset_en']

    def get_hidden_param_values(self):
        if self._design_db is not None and self._design_db.lane_10g_reg is not None:
            return self._design_db.lane_10g_reg.get_filtered_hidden_param_values()
        
        return get_hidden_param_values()

    def get_hw_support_cmn_params(self):
        return get_hw_support_cmn_params()

    def get_hw_lane_param_id_class(self):
        return Lane10GDesignParamInfo.Id

    def get_prop_id_str2api_options(self):
        return enum2api_ops_map

    def _build_presenter(self):
        self.prs = Lane10GPresenter()

    @staticmethod
    def build_prop(block_type: Optional[APIObject.ObjectType] = None,
                   db_inst: Optional[Lane10G] = None,
                   design_db: Optional[PeriDesign] = None):
        if design_db is not None:
            if design_db.is_block_supported(PeriDesign.BlockType.lane_10g):
                return Lane10GProp(block_type, db_inst, design_db)

        else:
            return Lane10GProp(block_type, db_inst, design_db)

        raise NotImplementedError

    def build_inspector(self) -> BlockPropInspector:
        from api_service.property.inspector.lane10g_inspector import Lane10GPropInspector
        return Lane10GPropInspector(self, self._iblock)

    # TODO: check after import all properties from ISF file
    def check_properties(self, inst):
        assert isinstance(inst, Lane10G)

        err_msg_list: List = []

        return err_msg_list


class Lane10GPresenter(AdvPresenter):
    def __init__(self):
        super().__init__()
