from __future__ import annotations

import os
from typing import Dict, TYPE_CHECKING

import pt_version

from design.db_item import PeriDesignItem

from api_service.property.gen_prop import BaseProp
from api_service.property.inspector.block_inspect import BlockPropInspector
from api_service.property.raw_serdes_prop_id import RawSerdesPropId
from tx375_device.raw_serdes.quad_param_info import get_hidden_parameters
# from tx375_device.raw_serdes.quad_pin_dep_graph import get_hidden_ports

if TYPE_CHECKING:
    from api_service.property.raw_serdes_prop import RawSerdesProp
    from api_service.internal.int_raw_serdes import IntRawSerdesAPI


class RawSerdesPropInspector(BlockPropInspector):

    def __init__(self, block_prop: RawSerdesProp, block_api: IntRawSerdesAPI):
        super().__init__(block_prop, block_api)
        self.readonly_prop = [
            BaseProp.BasePropId.name,
            BaseProp.BasePropId.resource,

            # Name should be read-only property
            RawSerdesPropId.common_inst_name,

            # Preset related properties
            RawSerdesPropId.ss_raw_data_rate_lane_NID,
            RawSerdesPropId.ss_raw_serdes_width_lane_NID,
            RawSerdesPropId.ss_raw_refclk_freq,
        ]

        if pt_version.PT_DEBUG_VERSION is False:
            for param_str in get_hidden_parameters(): #+ get_hidden_ports():
                if RawSerdesPropId.has_member(param_str.upper()):
                    prop_id = RawSerdesPropId(param_str.upper())
                    self.readonly_prop.append(prop_id)

    def get_all_config_prop(self, block_inst: PeriDesignItem) -> Dict:
        exclude_prop = self.readonly_prop.copy()
        filter_prop_map = self._gen_filter_prop(block_inst, exclude_prop)
        return {**filter_prop_map}
