from __future__ import annotations

import os
from typing import Dict, TYPE_CHECKING

import pt_version

from design.db_item import PeriDesignItem

from api_service.property.gen_prop import BaseProp
from api_service.property.inspector.block_inspect import BlockPropInspector
from api_service.property.lane10g_prop_id import Lane10GPropId
from tx375_device.lane10g.quad_param_info import get_hidden_parameters
# from tx375_device.lane10g.quad_pin_dep_graph import get_hidden_ports

if TYPE_CHECKING:
    from api_service.property.lane10g_prop import Lane10GProp
    from api_service.internal.int_lane10g import IntLane10GAPI


class Lane10GPropInspector(BlockPropInspector):

    def __init__(self, block_prop: Lane10GProp, block_api: IntLane10GAPI):
        super().__init__(block_prop, block_api)
        self.readonly_prop = [
            BaseProp.BasePropId.name,
            BaseProp.BasePropId.resource,

            # Name should be read-only property
            Lane10GPropId.common_inst_name,
        ]

        if pt_version.PT_DEBUG_VERSION is False:
            for param_str in get_hidden_parameters(): #+ get_hidden_ports():
                if Lane10GPropId.has_member(param_str.upper()):
                    prop_id = Lane10GPropId(param_str.upper())
                    self.readonly_prop.append(prop_id)

    def get_all_config_prop(self, block_inst: PeriDesignItem) -> Dict:
        exclude_prop = self.readonly_prop.copy()
        filter_prop_map = self._gen_filter_prop(block_inst, exclude_prop)
        return {**filter_prop_map}
