from common_device.property import RangeValidator, OptionValidator

enum2api_ops_map = {
	"PIPE_CONFIG_CMN__config_reg_0__lane_count_in": OptionValidator(['x4', 'x2', 'x1']),
	"PIPE_CONFIG_CMN__config_reg_0__mode_select": OptionValidator(['Endpoint', 'Root Port']),
	"PIPE_CONFIG_CMN__config_reg_0__pcie_generation_sel": OptionValidator(['Gen4', 'Gen3', 'Gen2', 'Gen1']),
	"PIPE_CONFIG_CMN__config_reg_2__pma_cmn_refclk_sel": OptionValidator(['External', 'Internal']),
	"PMA_CMN__cmn_plllc_gen_preg__cmn_plllc_pfdclk1_sel_preg": OptionValidator(['Refclk 0', 'Refclk 1']),
	"fpga_div2_clk_conn_type": OptionValidator(['gclk', 'rclk']),
	"i_client_LM__i_pf_0_BAR_config_0_reg__BAR0A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_0_BAR_config_0_reg__BAR0C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_0_BAR_config_0_reg__BAR1A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_0_BAR_config_0_reg__BAR1C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_0_BAR_config_0_reg__BAR2A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_0_BAR_config_0_reg__BAR2C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_0_BAR_config_0_reg__BAR3A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_0_BAR_config_0_reg__BAR3C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_0_BAR_config_1_reg__BAR4A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_0_BAR_config_1_reg__BAR4C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_0_BAR_config_1_reg__BAR5A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_0_BAR_config_1_reg__BAR5C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR0C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR1C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR2C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_0_vf_BAR_config_0_reg__VFBAR3C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR4C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_0_vf_BAR_config_1_reg__VFBAR5C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_1_BAR_config_0_reg__BAR0A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_1_BAR_config_0_reg__BAR0C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_1_BAR_config_0_reg__BAR1A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_1_BAR_config_0_reg__BAR1C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_1_BAR_config_0_reg__BAR2A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_1_BAR_config_0_reg__BAR2C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_1_BAR_config_0_reg__BAR3A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_1_BAR_config_0_reg__BAR3C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_1_BAR_config_1_reg__BAR4A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_1_BAR_config_1_reg__BAR4C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_1_BAR_config_1_reg__BAR5A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_1_BAR_config_1_reg__BAR5C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR0C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR1C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR2C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_1_vf_BAR_config_0_reg__VFBAR3C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR4C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_1_vf_BAR_config_1_reg__VFBAR5C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_2_BAR_config_0_reg__BAR0A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_2_BAR_config_0_reg__BAR0C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_2_BAR_config_0_reg__BAR1A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_2_BAR_config_0_reg__BAR1C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_2_BAR_config_0_reg__BAR2A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_2_BAR_config_0_reg__BAR2C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_2_BAR_config_0_reg__BAR3A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_2_BAR_config_0_reg__BAR3C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_2_BAR_config_1_reg__BAR4A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_2_BAR_config_1_reg__BAR4C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_2_BAR_config_1_reg__BAR5A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_2_BAR_config_1_reg__BAR5C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR0C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR1C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR2C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_2_vf_BAR_config_0_reg__VFBAR3C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR4C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_2_vf_BAR_config_1_reg__VFBAR5C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_3_BAR_config_0_reg__BAR0A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_3_BAR_config_0_reg__BAR0C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_3_BAR_config_0_reg__BAR1A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_3_BAR_config_0_reg__BAR1C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_3_BAR_config_0_reg__BAR2A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_3_BAR_config_0_reg__BAR2C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_3_BAR_config_0_reg__BAR3A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_3_BAR_config_0_reg__BAR3C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_3_BAR_config_1_reg__BAR4A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_3_BAR_config_1_reg__BAR4C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_3_BAR_config_1_reg__BAR5A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_3_BAR_config_1_reg__BAR5C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR0C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR1C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR2C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_3_vf_BAR_config_0_reg__VFBAR3C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR4C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5A": OptionValidator(['128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_pf_3_vf_BAR_config_1_reg__VFBAR5C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_rc_BAR_config_reg__RCBAR0A": OptionValidator(['4 B', '8 B', '16 B', '32 B', '64 B', '128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB', '4 GB', '8 GB', '16 GB', '32 GB', '64 GB', '128 GB', '256 GB']),
	"i_client_LM__i_rc_BAR_config_reg__RCBAR0C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR', '64 bit non-prefetchable memory BAR', '64 bit prefetchable memory BAR'],
	"i_client_LM__i_rc_BAR_config_reg__RCBAR1A": OptionValidator(['4 B', '8 B', '16 B', '32 B', '64 B', '128 B', '256 B', '512 B', '1 KB', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB', '32 MB', '64 MB', '128 MB', '256 MB', '512 MB', '1 GB', '2 GB']),
	"i_client_LM__i_rc_BAR_config_reg__RCBAR1C": ['Disabled', '32 bit I/O BAR', '32 bit non-prefetchable memory BAR', '32 bit prefetchable memory BAR'],
	"i_client_LM__i_vendor_id_reg__SVID": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"i_client_LM__i_vendor_id_reg__VID": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"i_client_PF0__i_L1_PM_cap__L1PrtCmMdReStrTime": RangeValidator(0, 255),
	"i_client_PF0__i_L1_PM_cap__L1PrtPvrOnScale": OptionValidator(['2us', '10us', '100us']),
	"i_client_PF0__i_L1_PM_cap__R0": RangeValidator(0, 31),
	"i_client_PF0__i_L1_PM_ctrl_1__L1CmMdReStrTime": RangeValidator(0, 255),
	"i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldSc": OptionValidator(['1ns', '32ns', '1024ns', '32768ns', '1048576ns', '33554422ns']),
	"i_client_PF0__i_L1_PM_ctrl_1__L1ThrshldVal": RangeValidator(0, 1023),
	"i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnSc": OptionValidator(['2us', '10us', '100us']),
	"i_client_PF0__i_L1_PM_ctrl_2__L1PwrOnVal": RangeValidator(0, 31),
	"i_client_PF0__i_dev_ser_num_0__DSND0": RangeValidator(int("0x0", 16), int("0xffffffff", 16)),
	"i_client_PF0__i_dev_ser_num_1__DSND1": RangeValidator(int("0x0", 16), int("0xffffffff", 16)),
	"i_client_PF0__i_func_dep_link_numVFs_reg__NVF": RangeValidator(0, 64),
	"i_client_PF0__i_link_cap__PN": RangeValidator(0, 255),
	"i_client_PF0__i_msi_ctrl_reg__MMC": OptionValidator(['1', '2', '4', '8', '16', '32']),
	"i_client_PF0__i_msix_ctrl__CID": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF0__i_msix_ctrl__CP": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF0__i_msix_ctrl__MSIXTS": RangeValidator(int("0x0", 16), int("0x7ff", 16)),
	"i_client_PF0__i_msix_pending_intrpt__BARI1": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"i_client_PF0__i_msix_pending_intrpt__PBAO": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"i_client_PF0__i_msix_tbl_offset__BARI": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"i_client_PF0__i_msix_tbl_offset__TO": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"i_client_PF0__i_revision_id_class_code__CC": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF0__i_revision_id_class_code__PIB": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF0__i_revision_id_class_code__RID": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF0__i_revision_id_class_code__SCC": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF0__i_subsystem_vendor_id_subsystem_i__SID": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"i_client_PF0__i_vendor_id_device_id__DID": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"i_client_PF0__i_vendor_specific_header_reg__VI": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"i_client_PF1__i_func_dep_link_numVFs_reg__NVF": RangeValidator(0, 64),
	"i_client_PF1__i_msi_ctrl_reg__MMC": OptionValidator(['1', '2', '4', '8', '16', '32']),
	"i_client_PF1__i_msix_ctrl__CID": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF1__i_msix_ctrl__CP": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF1__i_msix_ctrl__MSIXTS": RangeValidator(int("0x0", 16), int("0x7ff", 16)),
	"i_client_PF1__i_msix_pending_intrpt__BARI1": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"i_client_PF1__i_msix_pending_intrpt__PBAO": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"i_client_PF1__i_msix_tbl_offset__BARI": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"i_client_PF1__i_msix_tbl_offset__TO": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"i_client_PF1__i_revision_id_class_code__CC": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF1__i_revision_id_class_code__PIB": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF1__i_revision_id_class_code__RID": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF1__i_revision_id_class_code__SCC": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF1__i_subsystem_vendor_id_subsystem_i__SID": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"i_client_PF1__i_vendor_id_device_id__DID": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"i_client_PF1__i_vendor_specific_header_reg__VI": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"i_client_PF2__i_func_dep_link_numVFs_reg__NVF": RangeValidator(0, 64),
	"i_client_PF2__i_msi_ctrl_reg__MMC": OptionValidator(['1', '2', '4', '8', '16', '32']),
	"i_client_PF2__i_msix_ctrl__CID": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF2__i_msix_ctrl__CP": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF2__i_msix_ctrl__MSIXTS": RangeValidator(int("0x0", 16), int("0x7ff", 16)),
	"i_client_PF2__i_msix_pending_intrpt__BARI1": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"i_client_PF2__i_msix_pending_intrpt__PBAO": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"i_client_PF2__i_msix_tbl_offset__BARI": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"i_client_PF2__i_msix_tbl_offset__TO": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"i_client_PF2__i_revision_id_class_code__CC": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF2__i_revision_id_class_code__PIB": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF2__i_revision_id_class_code__RID": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF2__i_revision_id_class_code__SCC": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF2__i_subsystem_vendor_id_subsystem_i__SID": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"i_client_PF2__i_vendor_id_device_id__DID": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"i_client_PF2__i_vendor_specific_header_reg__VI": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"i_client_PF3__i_func_dep_link_numVFs_reg__NVF": RangeValidator(0, 64),
	"i_client_PF3__i_msi_ctrl_reg__MMC": OptionValidator(['1', '2', '4', '8', '16', '32']),
	"i_client_PF3__i_msix_ctrl__CID": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF3__i_msix_ctrl__CP": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF3__i_msix_ctrl__MSIXTS": RangeValidator(int("0x0", 16), int("0x7ff", 16)),
	"i_client_PF3__i_msix_pending_intrpt__BARI1": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"i_client_PF3__i_msix_pending_intrpt__PBAO": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"i_client_PF3__i_msix_tbl_offset__BARI": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"i_client_PF3__i_msix_tbl_offset__TO": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"i_client_PF3__i_revision_id_class_code__CC": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF3__i_revision_id_class_code__PIB": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF3__i_revision_id_class_code__RID": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF3__i_revision_id_class_code__SCC": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_PF3__i_subsystem_vendor_id_subsystem_i__SID": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"i_client_PF3__i_vendor_id_device_id__DID": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"i_client_PF3__i_vendor_specific_header_reg__VI": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"i_client_RC__i_L1_PM_cap__L1PrtCmMdReStrTime": RangeValidator(0, 255),
	"i_client_RC__i_L1_PM_cap__L1PrtPvrOnScale": OptionValidator(['2us', '10us', '100us']),
	"i_client_RC__i_L1_PM_cap__R0": RangeValidator(0, 31),
	"i_client_RC__i_L1_PM_ctrl_1__L1CmMdReStrTime": RangeValidator(0, 255),
	"i_client_RC__i_L1_PM_ctrl_1__L1ThrshldSc": OptionValidator(['1ns', '32ns', '1024ns', '32768ns', '1048576ns', '33554422ns']),
	"i_client_RC__i_L1_PM_ctrl_1__L1ThrshldVal": RangeValidator(0, 1023),
	"i_client_RC__i_L1_PM_ctrl_2__L1PwrOnSc": OptionValidator(['2us', '10us', '100us']),
	"i_client_RC__i_L1_PM_ctrl_2__L1PwrOnVal": RangeValidator(0, 31),
	"i_client_RC__i_dev_ser_num_0__DSND0": RangeValidator(int("0x0", 16), int("0xffffffff", 16)),
	"i_client_RC__i_dev_ser_num_1__DSND1": RangeValidator(int("0x0", 16), int("0xffffffff", 16)),
	"i_client_RC__i_link_cap__PN": RangeValidator(0, 255),
	"i_client_RC__i_link_ctrl_status__ASPMC": OptionValidator(['Disabled', 'L0s Entry', 'L1 Entry', 'L0s and L1 Entry']),
	"i_client_RC__i_pcie_cap__MP": OptionValidator(['128 bytes', '256 bytes', '512 bytes']),
	"i_client_RC__i_revision_id_class_code__CC": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_RC__i_revision_id_class_code__PIB": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_RC__i_revision_id_class_code__RID": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_RC__i_revision_id_class_code__SCC": RangeValidator(int("0x0", 16), int("0xff", 16)),
	"i_client_RC__i_slot_capability__PSN": RangeValidator(0, 8191),
	"i_client_RC__i_slot_capability__SPLS": OptionValidator(['1.0x', '0.1x', '0.01x', '0.001x']),
	"i_client_RC__i_slot_capability__SPLV": RangeValidator(0, 255),
	"i_client_RC__i_vendor_id_device_id__DID": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"perstn_source": OptionValidator(['PERSTN0', 'PERSTN1']),
	"pll_ref_clk0": OptionValidator(['PMA_CMN_REFCLK_PLL_1', 'PMA_CMN_REFCLK_PLL_2', 'PMA_CMN_REFCLK1_PLL_1', 'PMA_CMN_REFCLK1_PLL_2']),
	"pll_ref_clk1": OptionValidator(['PMA_CMN_REFCLK_PLL_1', 'PMA_CMN_REFCLK_PLL_2', 'PMA_CMN_REFCLK1_PLL_1', 'PMA_CMN_REFCLK1_PLL_2']),
	"pmclk_conn_type": OptionValidator(['gclk', 'rclk']),
	"pmclk_source": OptionValidator(['osc', 'pll']),
	"ref_clk_frequency": RangeValidator(100.0, 100.0),
	"ss_pcie_MPS": OptionValidator(['128 bytes', '256 bytes', '512 bytes']),
	"ss_pcie_aspm": OptionValidator(['Disabled', 'L0s Entry', 'L1 Entry', 'L0s and L1 Entry']),
	"ss_pcie_gen3_rx_preset": RangeValidator(int("0x0", 16), int("0x6", 16)),
	"ss_pcie_gen3_tx_preset": RangeValidator(int("0x0", 16), int("0xa", 16)),
	"ss_pcie_gen4_tx_preset": RangeValidator(int("0x0", 16), int("0xa", 16)),
	"ss_pcie_pf0_exp_rom_bar": OptionValidator(['Disabled', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB']),
	"ss_pcie_pf0_legacy_int_pin": OptionValidator(['NO INT', 'INTA', 'INTB', 'INTC', 'INTD']),
	"ss_pcie_pf0_vf_msi_mul_message_cap": OptionValidator(['1', '2', '4', '8', '16', '32']),
	"ss_pcie_pf0_vf_msix_bar_ind": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"ss_pcie_pf0_vf_msix_pba_ind": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"ss_pcie_pf0_vf_msix_pba_offset": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"ss_pcie_pf0_vf_msix_table_offset": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"ss_pcie_pf0_vf_msix_table_size": RangeValidator(int("0x0", 16), int("0x7ff", 16)),
	"ss_pcie_pf0_vf_steering_tag_tab_loc": OptionValidator(['ST Table not present', 'ST Table in the TPH Requester Capability Structure', 'ST values stored in the MSI-X Table in client RAM']),
	"ss_pcie_pf0_vf_steering_tag_tab_size": RangeValidator(0, 2047),
	"ss_pcie_pf0_vf_subsystem_id": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"ss_pcie_pf1_exp_rom_bar": OptionValidator(['Disabled', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB']),
	"ss_pcie_pf1_legacy_int_pin": OptionValidator(['NO INT', 'INTA', 'INTB', 'INTC', 'INTD']),
	"ss_pcie_pf1_vf_msi_mul_message_cap": OptionValidator(['1', '2', '4', '8', '16', '32']),
	"ss_pcie_pf1_vf_msix_bar_ind": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"ss_pcie_pf1_vf_msix_pba_ind": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"ss_pcie_pf1_vf_msix_pba_offset": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"ss_pcie_pf1_vf_msix_table_offset": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"ss_pcie_pf1_vf_msix_table_size": RangeValidator(int("0x0", 16), int("0x7ff", 16)),
	"ss_pcie_pf1_vf_steering_tag_tab_loc": OptionValidator(['ST Table not present', 'ST Table in the TPH Requester Capability Structure', 'ST values stored in the MSI-X Table in client RAM']),
	"ss_pcie_pf1_vf_steering_tag_tab_size": RangeValidator(0, 2047),
	"ss_pcie_pf1_vf_subsystem_id": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"ss_pcie_pf2_exp_rom_bar": OptionValidator(['Disabled', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB']),
	"ss_pcie_pf2_legacy_int_pin": OptionValidator(['NO INT', 'INTA', 'INTB', 'INTC', 'INTD']),
	"ss_pcie_pf2_vf_msi_mul_message_cap": OptionValidator(['1', '2', '4', '8', '16', '32']),
	"ss_pcie_pf2_vf_msix_bar_ind": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"ss_pcie_pf2_vf_msix_pba_ind": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"ss_pcie_pf2_vf_msix_pba_offset": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"ss_pcie_pf2_vf_msix_table_offset": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"ss_pcie_pf2_vf_msix_table_size": RangeValidator(int("0x0", 16), int("0x7ff", 16)),
	"ss_pcie_pf2_vf_steering_tag_tab_loc": OptionValidator(['ST Table not present', 'ST Table in the TPH Requester Capability Structure', 'ST values stored in the MSI-X Table in client RAM']),
	"ss_pcie_pf2_vf_steering_tag_tab_size": RangeValidator(0, 2047),
	"ss_pcie_pf2_vf_subsystem_id": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"ss_pcie_pf3_exp_rom_bar": OptionValidator(['Disabled', '2 KB', '4 KB', '8 KB', '16 KB', '32 KB', '64 KB', '128 KB', '256 KB', '512 KB', '1 MB', '2 MB', '4 MB', '8 MB', '16 MB']),
	"ss_pcie_pf3_legacy_int_pin": OptionValidator(['NO INT', 'INTA', 'INTB', 'INTC', 'INTD']),
	"ss_pcie_pf3_vf_msi_mul_message_cap": OptionValidator(['1', '2', '4', '8', '16', '32']),
	"ss_pcie_pf3_vf_msix_bar_ind": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"ss_pcie_pf3_vf_msix_pba_ind": OptionValidator(['BAR0', 'BAR1', 'BAR2', 'BAR3', 'BAR4', 'BAR5']),
	"ss_pcie_pf3_vf_msix_pba_offset": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"ss_pcie_pf3_vf_msix_table_offset": RangeValidator(int("0x0", 16), int("0x1fffffff", 16)),
	"ss_pcie_pf3_vf_msix_table_size": RangeValidator(int("0x0", 16), int("0x7ff", 16)),
	"ss_pcie_pf3_vf_steering_tag_tab_loc": OptionValidator(['ST Table not present', 'ST Table in the TPH Requester Capability Structure', 'ST values stored in the MSI-X Table in client RAM']),
	"ss_pcie_pf3_vf_steering_tag_tab_size": RangeValidator(0, 2047),
	"ss_pcie_pf3_vf_subsystem_id": RangeValidator(int("0x0", 16), int("0xffff", 16)),
	"ss_pcie_pf_num": RangeValidator(1, 4),
	"ss_pcie_pmclk_divsel": OptionValidator(['Disabled', 'DIV2', 'DIV4', 'DIV8']),
	"ss_plllc1_refclk_sel": OptionValidator(['Disabled', 'Refclk 0', 'Refclk 1']),
	"ss_sim_enable": OptionValidator(['Speed up', 'Non-speed up', 'Disabled']),
	"ss_topology_lane0": OptionValidator(['PCIe', '10GE', '1GE', 'Raw Serdes', 'Disabled']),
	"ss_topology_lane1": OptionValidator(['PCIe', '10GE', '1GE', 'Raw Serdes', 'Disabled']),
	"ss_topology_lane2": OptionValidator(['PCIe', '10GE', '1GE', 'Raw Serdes', 'Disabled']),
	"ss_topology_lane3": OptionValidator(['PCIe', '10GE', '1GE', 'Raw Serdes', 'Disabled']),
}
