from __future__ import annotations
from typing import List, Tuple

from api_service.internal.int_gen_block import IntLaneBasedAPI
from design.db import PeriDesign

from tx375_device.raw_serdes.design import RawSerdes, RawSerdesRegistry


class IntRawSerdesAPI(IntLaneBasedAPI):

    def set_design(self, design: PeriDesign):
        self.design = design
        self.blk_reg: RawSerdesRegistry = self.design.get_block_reg(
            PeriDesign.BlockType.raw_serdes) # type: ignore

    def get_all_preset_info(self, inst: RawSerdes) -> List[str]:
        preset_list: List[str] = []
        pll_cfg = inst.pll_cfg
        assert pll_cfg is not None

        preset_list = pll_cfg.get_all_preset_names()
        return preset_list

    def get_preset_info(self, inst: RawSerdes) -> Tuple[str, str]:
        preset_list = self.get_all_preset_info(inst)
        preset_info = self.blk_reg.get_pll_config_base_param_values(inst)
        check_info = "-".join([str(info)for info in preset_info])

        # Ensure that preset information is valid
        if check_info in preset_list:
            return ("", check_info)
        else:
            return ("", "")

