"""
Copyright (C) 2017-2019 Efinix Inc. All rights reserved.

No portion of this code may be reused, modified or
distributed in any way without the expressed written
consent of Efinix Inc.

Created on Nov 4, 2019

@author: yasmin
"""

import os
import sys

from util.gen_util import freeze_it
from util.excp import MsgLevel

from design.db import PeriDesign
import common_device.jtag.jtag_design as jpd

from api_service.internal.int_gen_block import IntBlockAPI


@freeze_it
class IntJTAGAPI(IntBlockAPI):
    """
    Provides high level JTAG API related operation.

    The function here, may or may not match directly with user API.
    As much as possible, modules outside from peri_block should use the API
    here and only access raw registry level API when needed.

    """

    def __init__(self, design: PeriDesign = None, is_verbose: bool = False):
        super(IntJTAGAPI, self).__init__(is_verbose)
        self.design = design
        if self.design is None:
            self.blk_reg = None
        else:
            self.blk_reg = self.design.jtag_reg

    @staticmethod
    def build_jtag_api(design: PeriDesign = None, is_verbose: bool = False):
        """
        :param design: Design db
        :param is_verbose: True, print detail messaging, False, normal
        :return: JTAG API interface
        """
        return IntJTAGAPI(design, is_verbose)

    def set_design(self, design):
        """
        For testing?
        :param design:
        :return:
        """
        super().set_design(design)
        self.blk_reg = self.design.jtag_reg

    def create_block(self, name, is_register=True):
        """
        Create a new block db instance

        :param name: Unique instance name
        :param is_register: True, register in registry else create standalone block
        :return: Block instance if successful else None
        ..notes:
          To support is_register, override this function.
        """
        if self.blk_reg is None:
            return None

        block = self.blk_reg.get_inst_by_name(name)
        if block is None:
            if name == "":
                inst_name = self.blk_reg.gen_unique_inst_name()
                if inst_name is None:
                    if self.is_verbose:
                        self.msg_svc.write(MsgLevel.warning, "Fail to create block, fail auto-gen unique instance name")
                    return None
            else:
                inst_name = name

            block = self.blk_reg.create_instance(inst_name, True, True)
            if block is not None:
                # Need to have the pins first before we can automate the pin name
                block.build_generic_pin()
                block.generate_pin_name()

        return block



if __name__ == "__main__":
    pass
