module `IP_MODULE_NAME(efx_mac10gbe) #(
	parameter CUT_THRU_STORE_FWD			= 1'b1,
	parameter INTER_PACKET_GAP				= 4'd12,
	parameter MTU_FRAME_LENGTH				= 14'd1518,
	parameter MAC_SOURCE_ADDRESS			= 48'h0000_0000_0000,
	parameter ENABLE_BROADCAST_FILTER	= 1'b1,
	parameter REG_WIDTH						= 6'd32,
	parameter TXFIFO_DEPTH					= 13'd4096,
	parameter AXIS_DATA_WIDTH				= 7'd64,
	parameter DETECT_LINK_FAULT				= 1'b1
) (
	input  logic		mac_reset_n,
	input  logic		mac10gbe_clk,
	input  logic		init_clk,
	input  logic		init_rst_n,
	input  logic		PMA_CMN_READY,
	input  logic		PMA_XCVR_PLLCLK_EN_ACK,
	input  logic [3:0]		PMA_XCVR_POWER_STATE_ACK,
	input  logic		PMA_RX_SIGNAL_DETECT,
	output logic		PMA_XCVR_PLLCLK_EN,
	output logic [3:0]		PMA_XCVR_POWER_STATE_REQ,
	output logic		phy_init_done,
	input  logic [AXIS_DATA_WIDTH-1:0]		tx_axis_mac_tdata,
	input  logic		tx_axis_mac_tvalid,
	input  logic		tx_axis_mac_tlast,
	input  logic [AXIS_DATA_WIDTH/8-1:0]		tx_axis_mac_tkeep,
	input  logic		tx_axis_mac_tuser,
	output logic		tx_axis_mac_tready,
	output logic [AXIS_DATA_WIDTH-1:0]		rx_axis_mac_tdata,
	output logic		rx_axis_mac_tvalid,
	output logic		rx_axis_mac_tlast,
	output logic [AXIS_DATA_WIDTH/8-1:0]		rx_axis_mac_tkeep,
	output logic		rx_axis_mac_tuser,
	input  logic		rx_pause_ignore,
	input  logic		tx_pause_gen,
	output logic		tx_pause_busy,
	input  logic [15:0]		tx_pause_quant,
	input  logic [47:0]		rx_address_filtering_mask,
	input  logic		cnt_rst_n,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_transmitted_good,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_pause_mac_ctrl,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_error_txfifo_overflow,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_is_fe,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_received_good,
	output logic [13:0]					rpt_rx_frame_length,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_error_fcs,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_pause_mac_ctrl,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_errors,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_received_total,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_undersized,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_oversized,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_mismatched_length,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_filtered_by_address,
	output logic [63:0]		XGMII_TXD,
	output logic [7:0]		XGMII_TXC,
	input  logic [63:0]		XGMII_RXD,
	input  logic [7:0]		XGMII_RXC
);
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2021.1"
`pragma protect key_keyowner = "Synopsys" , key_keyname = "SNPS-VCS-RSA-2"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 128 )
`pragma protect key_block
OAyGDti+iK/vmvZbzyuoIw8ZkNySxiYzJ8yoGvVxcbhjQf2wYOz/WwFC55MDoAKG
Km1NyD6/SaFE3qt9JHlzc0M4+fX3TlciMmeZmkgVrgRyKPwHLxRSagl9xDx2YIp2
tTINteJh/XrEMFelTI9/ggsParvM2gPeLR4lpU2rjGo=
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 2928 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
