module `IP_MODULE_NAME(efx_mac10gbe) #(
	parameter CUT_THRU_STORE_FWD			= 1'b1,
	parameter INTER_PACKET_GAP				= 4'd12,
	parameter MTU_FRAME_LENGTH				= 14'd1518,
	parameter MAC_SOURCE_ADDRESS			= 48'h0000_0000_0000,
	parameter ENABLE_BROADCAST_FILTER	= 1'b1,
	parameter REG_WIDTH						= 6'd32,
	parameter TXFIFO_DEPTH					= 13'd4096,
	parameter AXIS_DATA_WIDTH				= 7'd64,
	parameter DETECT_LINK_FAULT				= 1'b1
) (
	input  logic		mac_reset_n,
	input  logic		mac10gbe_clk,
	input  logic		init_clk,
	input  logic		init_rst_n,
	input  logic		PMA_CMN_READY,
	input  logic		PMA_XCVR_PLLCLK_EN_ACK,
	input  logic [3:0]		PMA_XCVR_POWER_STATE_ACK,
	input  logic		PMA_RX_SIGNAL_DETECT,
	output logic		PMA_XCVR_PLLCLK_EN,
	output logic [3:0]		PMA_XCVR_POWER_STATE_REQ,
	output logic		phy_init_done,
	input  logic [AXIS_DATA_WIDTH-1:0]		tx_axis_mac_tdata,
	input  logic		tx_axis_mac_tvalid,
	input  logic		tx_axis_mac_tlast,
	input  logic [AXIS_DATA_WIDTH/8-1:0]		tx_axis_mac_tkeep,
	input  logic		tx_axis_mac_tuser,
	output logic		tx_axis_mac_tready,
	output logic [AXIS_DATA_WIDTH-1:0]		rx_axis_mac_tdata,
	output logic		rx_axis_mac_tvalid,
	output logic		rx_axis_mac_tlast,
	output logic [AXIS_DATA_WIDTH/8-1:0]		rx_axis_mac_tkeep,
	output logic		rx_axis_mac_tuser,
	input  logic		rx_pause_ignore,
	input  logic		tx_pause_gen,
	output logic		tx_pause_busy,
	input  logic [15:0]		tx_pause_quant,
	input  logic [47:0]		rx_address_filtering_mask,
	input  logic		cnt_rst_n,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_transmitted_good,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_pause_mac_ctrl,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_error_txfifo_overflow,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_is_fe,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_received_good,
	output logic [13:0]					rpt_rx_frame_length,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_error_fcs,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_pause_mac_ctrl,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_errors,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_received_total,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_undersized,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_oversized,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_mismatched_length,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_filtered_by_address,
	output logic [63:0]		XGMII_TXD,
	output logic [7:0]		XGMII_TXC,
	input  logic [63:0]		XGMII_RXD,
	input  logic [7:0]		XGMII_RXC
);
//pragma protect begin_protected
//pragma protect key_keyowner=Cadence Design Systems.
//pragma protect key_keyname=CDS_KEY
//pragma protect key_method=RC5
//pragma protect key_block
lpkUpEczsRdimL55Jm8qc/Okl9S1YgW4UQ9obdRNEyIT2YjE8Modlqs77KtZ+wki
EEIxLehU7poLMocBZjqy3BmIFPIFh2Mj8R7NZ+YEfRZ6DgM2TV9MUmZgpUKwemfq
BYckU3UV5oMVg+U/EzeYulMgkgXPBCIWMex00Ol4qehaNW1yuCJSvA==
//pragma protect end_key_block
//pragma protect digest_block
WoBlGpG/Ox1svQm3qUI6uyB0I9w=
//pragma protect end_digest_block
//pragma protect data_block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//pragma protect end_data_block
//pragma protect digest_block
Fb+tnDUgPPUv1GrfYvJX5plGIpw=
//pragma protect end_digest_block
//pragma protect end_protected
