module `IP_MODULE_NAME(efx_mac10gbe) #(
	parameter CUT_THRU_STORE_FWD			= 1'b1,
	parameter INTER_PACKET_GAP				= 4'd12,
	parameter MTU_FRAME_LENGTH				= 14'd1518,
	parameter MAC_SOURCE_ADDRESS			= 48'h0000_0000_0000,
	parameter ENABLE_BROADCAST_FILTER	= 1'b1,
	parameter REG_WIDTH						= 6'd32,
	parameter TXFIFO_DEPTH					= 13'd4096,
	parameter AXIS_DATA_WIDTH				= 7'd64,
	parameter DETECT_LINK_FAULT				= 1'b1
) (
	input  logic		mac_reset_n,
	input  logic		mac10gbe_clk,
	input  logic		init_clk,
	input  logic		init_rst_n,
	input  logic		PMA_CMN_READY,
	input  logic		PMA_XCVR_PLLCLK_EN_ACK,
	input  logic [3:0]		PMA_XCVR_POWER_STATE_ACK,
	input  logic		PMA_RX_SIGNAL_DETECT,
	output logic		PMA_XCVR_PLLCLK_EN,
	output logic [3:0]		PMA_XCVR_POWER_STATE_REQ,
	output logic		phy_init_done,
	input  logic [AXIS_DATA_WIDTH-1:0]		tx_axis_mac_tdata,
	input  logic		tx_axis_mac_tvalid,
	input  logic		tx_axis_mac_tlast,
	input  logic [AXIS_DATA_WIDTH/8-1:0]		tx_axis_mac_tkeep,
	input  logic		tx_axis_mac_tuser,
	output logic		tx_axis_mac_tready,
	output logic [AXIS_DATA_WIDTH-1:0]		rx_axis_mac_tdata,
	output logic		rx_axis_mac_tvalid,
	output logic		rx_axis_mac_tlast,
	output logic [AXIS_DATA_WIDTH/8-1:0]		rx_axis_mac_tkeep,
	output logic		rx_axis_mac_tuser,
	input  logic		rx_pause_ignore,
	input  logic		tx_pause_gen,
	output logic		tx_pause_busy,
	input  logic [15:0]		tx_pause_quant,
	input  logic [47:0]		rx_address_filtering_mask,
	input  logic		cnt_rst_n,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_transmitted_good,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_pause_mac_ctrl,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_error_txfifo_overflow,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_is_fe,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_received_good,
	output logic [13:0]					rpt_rx_frame_length,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_error_fcs,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_pause_mac_ctrl,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_errors,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_received_total,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_undersized,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_oversized,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_mismatched_length,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_filtered_by_address,
	output logic [63:0]		XGMII_TXD,
	output logic [7:0]		XGMII_TXC,
	input  logic [63:0]		XGMII_RXD,
	input  logic [7:0]		XGMII_RXC
);
//pragma protect
//pragma protect begin
`protected

    MTI!#d~7!QTz??ZvuaSfjO(V=WrWS|)=Zdh?p7["Yo,k>oCk*x;]pjBiOm$?2[;xh=xAW$u;J@t[
    x$+>*#^U1@GFEAQWsU^rf[b_dV@jWi${E}'+7Ph}_xUkV$}!{2\fO'}],5'zeE[_x*R@ZTUp~aW=
    A]WATX'E*@U[p?lX=2j@^O#a5I!El#$wZjXpj'<@BBlzKDV@,nZKD5w!}X,[(oke~sp3AoC7w[XY
    kj~-Z5H1owUAH]Wz@rCH;RWvK^ne'EeYo5^Iu2IuHnr=EXs?Jb^=por!7kCC[RUO$k]QRO3tww1n
    |9Q+CGr>=,Qe!a?7Eu*{AT$@e$ZCiH>zI?1C?uZx}7Eo--IIoiS;D?B1vnY?UHscBnp\_aJX3*}*
    _GWmY/BGJ[]7JW'2KE+1;=UU@K(s_zX}G;={j}5-Ux*-x>_=oweI@7i,eX$7B1;m=ee_RxZmj*ji
    ''iUp*>'V]pIDu[EKC]Ba*w[=BXavJG~]{aSvK~^[Q>seW;Q>[XIsI_wj]urf2v1Z$7UQ?+ZwOn~
    AtRL'n5~xCpv8oZxik1mp=5vz'Z{'-1*uVY2*41ll#^,o572IrY?n=->;TRK{m7~COTO!l$nCV"Y
    HB!.>VOBGD#_*[7?RoATR2s@)rm+\Gw1'p_eKrJeGb\V#IsOe{=;;TF|[~HZyf,}eshs'W{n=r?C
    ,wQvwmROKX*O\s]eGe+2l'}U}*HpX-{7DWk1@!Y>^Y=v0NBI*z!1$WZQx]a1V2]J_W_vmE:}+15r
    j+?ej\]rCsVI'QvUD>'GIY$B!rvKaej\ou2D[7#%"u[!KTQ@aYXrOOxB]:2l@W][3;o<nB-V?BsQ
    V7;}kO$B}s#zHQ=Hl;,Q{Wdon[Y1TYR+QlrwC=$eG?Ue72z*T+sIJ'UN\+z<r2[lZDoE2[@v{ama
    uxnH_t(,+-;-1<Qr2j_z^aBDQAzX,-awI\lGD;Z[>*rB+]QA=Xj~+JZ@A{Arzj#]'_AVsI31vHl3
    za_<$<kAawKd]^$rQQK}xCn<!X]\?DnkE>zxla@{[5r,$OTZI5~XB+ZOJ1Gl*jasQQVuC<D'EM$+
    H3\IB=>EzE*1Ii/$lT${a<?!oQZ$wVI&uxnEZ$<?[]ml'QO^tkXpHi[AXi-2@~&T++Bz*Yz,-VDa
    Bx[7OCTi*,p<1>\VQa*^n-#p\A^\^]Oh*Q>nli+=\#GQ+O3?%1E-_.saD^\cWpEl]n2J'KAjulB~
    R$@K3=n^vF,EXU';Q=WG]Rf.V7UBDABIG~RW,{_i3s<umzQ25b\~Bv31DxeR<3zn~!lx'ZXG1KQ*
    vR7J2[|,AY[r\5D@'?\-X<1e$lmuoR='3P2E_m^W;#{{O+$-UXtnVT=H[kW{l!z?Y=p-7Zl[J=@<
    z+?cXj{w'uWwiw_[DWZ2bECUXIZOWpE1*\_apLeKXorK7@E!Z5_kI>e2G;-AQ3jR*<7Jz<_b^#Xu
    M>oI;U5[@:}xG}#TlE{V_Ba+TpH[n?=nA=-ru-<H3s<B_-]zXTQpoEl~~QUQ5rP\YBJATI#=k;J]
    !}Z+o-^e^kx}^$es7*~~zp=RKaKbivDX^mz,5?s2tQI-xe,EXIjRm3TKBV+KA3T'woAHw$1XYwz+
    G3*eAY>UvKU@ksDC=l,B^,-{125^^=J*W+wCiIH73eHpm^m~$$j{@}wEa^2W_R,xl7$xo\@^K5}2
    ]<R$50XQK#FZ5m^Q-3>=evx\w-UEr-vY[Q_XY^7PBLQ1U-iYp^5I"qH>!x7R#Ba_1!'3mxKsuv^[
    \$U>j{&\RwB$}oa5v~]];pD*wmxxs>Ke25_TOnrRYu$3^v$Ov]EE*[jIr5<Gx<]B>m_@5{lVDEv7
    \=sHp]__X7Bsg=gp<\,Exn[_me}xwZ557
`endprotected
//pragma protect end
