module `IP_MODULE_NAME(efx_mac10gbe) #(
	parameter CUT_THRU_STORE_FWD			= 1'b1,
	parameter INTER_PACKET_GAP				= 4'd12,
	parameter MTU_FRAME_LENGTH				= 14'd1518,
	parameter MAC_SOURCE_ADDRESS			= 48'h0000_0000_0000,
	parameter ENABLE_BROADCAST_FILTER	= 1'b1,
	parameter REG_WIDTH						= 6'd32,
	parameter TXFIFO_DEPTH					= 13'd4096,
	parameter AXIS_DATA_WIDTH				= 7'd64,
	parameter DETECT_LINK_FAULT				= 1'b1
) (
	input  logic		mac_reset_n,
	input  logic		mac10gbe_clk,
	input  logic		init_clk,
	input  logic		init_rst_n,
	input  logic		PMA_CMN_READY,
	input  logic		PMA_XCVR_PLLCLK_EN_ACK,
	input  logic [3:0]		PMA_XCVR_POWER_STATE_ACK,
	input  logic		PMA_RX_SIGNAL_DETECT,
	output logic		PMA_XCVR_PLLCLK_EN,
	output logic [3:0]		PMA_XCVR_POWER_STATE_REQ,
	output logic		phy_init_done,
	input  logic [AXIS_DATA_WIDTH-1:0]		tx_axis_mac_tdata,
	input  logic		tx_axis_mac_tvalid,
	input  logic		tx_axis_mac_tlast,
	input  logic [AXIS_DATA_WIDTH/8-1:0]		tx_axis_mac_tkeep,
	input  logic		tx_axis_mac_tuser,
	output logic		tx_axis_mac_tready,
	output logic [AXIS_DATA_WIDTH-1:0]		rx_axis_mac_tdata,
	output logic		rx_axis_mac_tvalid,
	output logic		rx_axis_mac_tlast,
	output logic [AXIS_DATA_WIDTH/8-1:0]		rx_axis_mac_tkeep,
	output logic		rx_axis_mac_tuser,
	input  logic		rx_pause_ignore,
	input  logic		tx_pause_gen,
	output logic		tx_pause_busy,
	input  logic [15:0]		tx_pause_quant,
	input  logic [47:0]		rx_address_filtering_mask,
	input  logic		cnt_rst_n,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_transmitted_good,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_pause_mac_ctrl,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_error_txfifo_overflow,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_is_fe,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_received_good,
	output logic [13:0]					rpt_rx_frame_length,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_error_fcs,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_pause_mac_ctrl,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_errors,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_received_total,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_undersized,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_oversized,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_mismatched_length,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_filtered_by_address,
	output logic [63:0]		XGMII_TXD,
	output logic [7:0]		XGMII_TXC,
	input  logic [63:0]		XGMII_RXD,
	input  logic [7:0]		XGMII_RXC
);
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2021.1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
SxT1bJeL5YEOsOAFRHu/UYc19U6M2QNIe+IoRp/4bAE/5Z2er4GfqD1ghElthhHx
489MT1YTZuUxEVioMSHTAHChw+HT+HF/+UaJx3ZKUo5DtYbqWCSLHv2NcXD+yGhM
TNCjS1aTFpQ4FIB3KT3JtOy5ptjW1Irt3vBHuOy12IVEK52OakpY+UkQR8TaLxKI
1LkrZdbRn4h0hJaeaKpC+HQBwJAFPv1q/s+ziWqh0ezU56urpy1FvC/T89m1Szno
P2qyWf+9GSoUexQmswhwd6+KjyctMxXR4QzJw7Z9Sc6HZVY3o+2P0sVYVTdcX4Q8
R4JE9Pjw+eNSgQWRZOrGJA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 2928 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
