module `IP_MODULE_NAME(efx_mac10gbe) #(
	parameter CUT_THRU_STORE_FWD			= 1'b1,
	parameter INTER_PACKET_GAP				= 4'd12,
	parameter MTU_FRAME_LENGTH				= 14'd1518,
	parameter MAC_SOURCE_ADDRESS			= 48'h0000_0000_0000,
	parameter ENABLE_BROADCAST_FILTER	= 1'b1,
	parameter REG_WIDTH						= 6'd32,
	parameter TXFIFO_DEPTH					= 13'd4096,
	parameter AXIS_DATA_WIDTH				= 7'd64,
	parameter DETECT_LINK_FAULT				= 1'b1
) (
	input  logic		mac_reset_n,
	input  logic		mac10gbe_clk,
	input  logic		init_clk,
	input  logic		init_rst_n,
	input  logic		PMA_CMN_READY,
	input  logic		PMA_XCVR_PLLCLK_EN_ACK,
	input  logic [3:0]		PMA_XCVR_POWER_STATE_ACK,
	input  logic		PMA_RX_SIGNAL_DETECT,
	output logic		PMA_XCVR_PLLCLK_EN,
	output logic [3:0]		PMA_XCVR_POWER_STATE_REQ,
	output logic		phy_init_done,
	input  logic [AXIS_DATA_WIDTH-1:0]		tx_axis_mac_tdata,
	input  logic		tx_axis_mac_tvalid,
	input  logic		tx_axis_mac_tlast,
	input  logic [AXIS_DATA_WIDTH/8-1:0]		tx_axis_mac_tkeep,
	input  logic		tx_axis_mac_tuser,
	output logic		tx_axis_mac_tready,
	output logic [AXIS_DATA_WIDTH-1:0]		rx_axis_mac_tdata,
	output logic		rx_axis_mac_tvalid,
	output logic		rx_axis_mac_tlast,
	output logic [AXIS_DATA_WIDTH/8-1:0]		rx_axis_mac_tkeep,
	output logic		rx_axis_mac_tuser,
	input  logic		rx_pause_ignore,
	input  logic		tx_pause_gen,
	output logic		tx_pause_busy,
	input  logic [15:0]		tx_pause_quant,
	input  logic [47:0]		rx_address_filtering_mask,
	input  logic		cnt_rst_n,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_transmitted_good,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_pause_mac_ctrl,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_error_txfifo_overflow,
	output logic [REG_WIDTH-1:0]		cnt_tx_frame_is_fe,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_received_good,
	output logic [13:0]					rpt_rx_frame_length,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_error_fcs,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_pause_mac_ctrl,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_errors,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_received_total,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_undersized,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_oversized,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_mismatched_length,
	output logic [REG_WIDTH-1:0]		cnt_rx_frame_filtered_by_address,
	output logic [63:0]		XGMII_TXD,
	output logic [7:0]		XGMII_TXC,
	input  logic [63:0]		XGMII_RXD,
	input  logic [7:0]		XGMII_RXC
);
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2021.1"
`pragma protect key_keyowner = "Aldec" , key_keyname = "ALDEC15_001"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
wZcRnM/MHXjNgXi9kD/eNXl3UP5bq2xk585erwQtxbJpqD/vnSv0Em/ae2fnieOY
wGbG8K43SO7yC4mqR/lT0mtNgAv4k+Q2y/CEh/h/RNN8es4yOakqe1H+OsK6ksfO
luUhnIv0aufGXo68ewShQRcab5i9Notz452grKsqBBesMQDN7SN+ro+qzJuyIZkW
++CeeOsV9rJaTz4OWH+40POkWUUomIHAzqO0u7GPWs03RmApA4l95rkW08PaoLvJ
Uk3z1B4sm8HMdfwiQyRySYUNPPDcs8lMVOT81VmHPqwOuY8eWEKIVaJbClD/Z73U
sAV7SDzJE3Oq3TYA/G4GOA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 2928 )
`pragma protect data_block
Ff0zxX3Nz/roqBghD1AJZKGtUT6Ot4lHE3z2JAMJ4VtbFzeAtS201oezL4Vu8pd0
3LBgtUtnEQZClFEpKtrvOLxY5wtHX8AZE3KhD+hzeLYSOUYpErlOVCWhZxgzG228
wS8qPV4hApEVkuUOQWIAXXxfHt7JTq2OE971mdJrjWZWssP+kIVUn1s0ZDzx1VcB
gbNYrtSwmULEXgcC7SvP5G6kV0opWT6XSWGlkH4YUQJ4ct6HAoOODrLrk5+n5e20
9pFwSXGn90XWeznwoDJTlNJI/tMifEuFXuJSTyiLRQCRzInY3UvvBBNAA5CtP4N1
lINzX+Je19KJfIuMI97nTJW36ZVgc4HzvOf12pbgYQW7Sbxvl20mm89Zw6yBkr6R
gFv0mgBRbGyESx7is8yXRAtRkZZ7aplm80R8KzuYpOu0eutIGyxD0v2U0LU9MC/f
JQhZuNUfLUSH6RzaSJlFTESP0iTq+psZdXvUAf2ViR2jpHSSJWSoLTCQVIpEgCaK
/WMrIvp7fYxMOhR8CzRyEKr56JEi1UnMua71wlr16e7cCOSmWbQQCXbUxdEdPRZV
3IcxEg/WExVLOFhVSsKU0vBeMk4oD0LATibiBA7CbIgYzoQjZdVHiaXhO+gV8bX5
cL6EiFQd7n3WDdLMXzjyxVc/FVX+wDsIpB00Jpx019dl5JpxX8tJ1QnTNQQjhPYi
QDTvyGZYZG/965dKwnXOa1/I74ohH0xPF7aIZK5muY1+p+ZVOvk9b145qIeNv8Ih
vejfHHDw0P2vc40AH1TjHy/DLts69vmSPGjHyJEniqOD127rKG8RiS9feo3Sj0mm
uWfyYipSllH+S1fvN+5DhsjpCdg4I4PVSxchgP9b6QyQRImtR3jmtVjjOZ6tvzjA
FCETWOmq/MQEqnHG7ZHnnBtR+Lw+mUSmIcF3yVw70zYmq3RtBOjifYTW3hxF4t3k
TleAqjqeU1algjCYC9Ql/R90Tlpq+hEJWo1EnzT0gPuu+FTo5u256IY/nE+TWJwe
Iqt0ma8WFMZhn8jv9KbFgUDIzm8HsLZeeemtOAiGXhmA9p6uZUg7aqHGRq5lRsOY
EQVf7TMpnD2lY0HtY76LAE3TIdf3q8JePVr+gnkQwP5s6jFsx/tdAAeyoisok5D+
303t0jrfI2e6mZhNIm7Z6Y1nz0ygf3vNS9WCQnGA2D0HH2EPUk23I4FflvCVTjkV
zw+0YvYwA9ouEWTjK8sCX6pqJdN0aMTTOeLqfelWkv7VLi953kd8eIQ+ImbtfqUR
/Jq96IW7YmL4t9ge9/6xai2UryYFE04PBxE+URzruw11Uy6mc8h8Cn4hrmmrR+hZ
fEWA700dlL55uKxkIXGRBOH6azT7sTZmgR+tHkOxO9L+8oYCIO4a21lgEJFAVcbw
3KJIemSwKeFwgryh4seYeQcTnPTHUfMtHV0o5xlHg2PFp/ojNKUD2R/0IXiJj/4K
cyKvuCSx2rtJ9dOWpwyxS3Xb0jedV5sny0czc+RGSy1bfER533raWdZrAyH7LpgO
Ggvevr7lpcqJb24QQk69Y+tZmTLixhRuW85cMH1lRRvcnSojppdWLGy1eMNt6S9E
DEAnF01AwTzThDJG27bgUQnz97bWMnNsNtEUSfxzEuyo4eHZeqjFj0CVSWc6Yriz
G7wKcgddCCCOVh91ikoNZPqmkUadspmzW7HqFsIZ5NQfxqYXYqkodGr3XrdoLiWg
Z1gfnJwaVUhwIfYRFJKRQiBZtg8QB7zZyMxeIRy+oTwoUoyAviBBXJx2Ye8hW6Iu
CcPMHrfL3vBQxbAgzxmGwarYUyTO3lGwdrsOtnq+zEmOpZMiney+VKRJa1e4+Qf/
PGAvT2Px9tRNo68RjHLxF2CfYyChWv953vh6+h4MGYcp/vcHyoL7o0RpE+Vu8FFb
Y0pTtwb/ZjS4ZO+4z++icm4vA3J9C08Se5+SnB2M0bPRCCTThQeDWgWMwkIdPJaQ
AG04RcXfChX8J1eLavsGr6fnUIxo6BGUlb5FcZ7krVDeTw81dcBGOzqNr8BtQDnH
wkllIOSaEyHpXNmlqdzy9oecovAKNOQPwBpdJsobjP+neYeUwhEEf6MmsdtHfnAJ
cNNutWw/HZncpLTbuDnPcf5X+zSpICcm8LrFQrylnXR8MfkVk7gpblGH4AOKjWgC
6PxSjCyaOazdMLpwCuJA/LrPfLToUJXvtdo9M4wz7b6b8Bcvi01kjGXF4Dpin5o3
dioTWToqbo8EunJutvPdhO9XL8TnT3Zs9BSZykkS70WJXabk1B/2KSCVofFjpIhm
IoF/SJ6lYf9ZRz7KlTGCRYx7BqXNy7mybbsZGO1rjl8ASpVR/274QlutLSG7sYnG
jq/fJcs1CJ5+0oT88cs2QAPiDfGow4VFl08hT582+8qasHviHUyupd9bvuuBeOx4
DAmkX63ImcKm4ayairWtKaJyZJqHdKixqJmOzdni8FJYCIggjL3ETHyetLuRxX/z
VSWug6kAO5JAZt74pwz898i0BQQzlki4uVfmGjZybu6jNenBKN5oqpVtskfwllFp
RPtM1Y8uudz/FAeWmyrpQwwawd9RCKtutAEDuL18svJUUhz7BnEdHbft4++Gjn+Z
BDSZ31Dh0cBkVm2MKLx1lDtgtsn/URmIGD6auvs3XXRZuhjG5C9laaytVs2tPo6P
WIFrBsZKa8+YHDIYvHuq03ap4NP5GRvxfbdosY9usO2TEY09W4ozOuRjtARkmikZ
ZQYs2Ay3oK4RHBxRsvXqH4D9h6IV3jXE5NvLAUV4QB8b8d5X76t3ivSPwPnGwCpM
t3Ui8hIeU3idXvVui43heJlgTIcB+R9OFuvBsgxZtLSdlj5wTf9K2v2TUopBzKgu
jqaSfLwHb7K+nNOxSQinlWLIJF17l09XbRhP8tf9JdzrTj2CCaNy9enTWgEYhQkc
M6xA3tU1nUuPc0f7DJczNW9d5Z/rbP0T+NYs2Tzk81i+vrES2rJwPL67nc5SWbx3
JFZuo4KOGMTCz79qLYbfZAGN+e+xmZOl9GxETFmxQPDDBEeb4cZCqS8ExlEp2/Rw
oknEGzQKfwapjkJGxjJJFzIpVws2+jln+rdv5litgwYZ/AzDyjOnY6NSKnmpvWfn
N7R2RIn1/0Ry0byMfFyuPY/DCCAdwy24c6uHm8Qhoeerd2gxDxXlpkFDixeEPChD
gLZ+ZQv/i35AgKZImtoc8oA4tJEScPoJWSH1d9boj4hSnIiInacLqjfxsRdJJSGQ
e2DpMRlKR9Euk5YMIBHelvzbIo+Rr4tS2gcX4DvgrFNLjIW25DSf+6cbWMOIlaFo
9GzmvOIjrTYLcRhB6Fu5qUUO4hW6TmFGe32DYrKKS/e49IiTYacLzOHRSauKuDqV
R3PlrIdl/m3D3bja20i5+S1I3n4CJxnpG1um+1JPmRL29utXXKHH1Tu+ukHsXMQP
zL/EtTdQN0Ey7XJhT4OnGq28TvNQmbuYfvgS9IMBCOxp56lghDbfIrf+6RcyAGYG
4lzrN4eoA1snfBdrsIaiJKZMmRckWZnn+ZZWUMYaz0zA5IFtLcTzGCRQfQ3HL+vS
erUHWBp9j77oaUosKmwgk8qndlpWllOgPtIFu4gGcD7iuuuH5rm7TFhdLcleTPZn
BbG9jb9Py5prO0jLsqaD1wISEjz1/CQMgdsz8egRdpS1e1A8zfTf1viIDHdOD5Uw
ZkzX+pgPcUSG1rViywgNVLeRjRBI0c0E48uY3upbtmajSMOC9lIUswpaeUJ6342e
9Sf5LB8v+gAgT9OuKPmDv8bsJObHqqwcFgjOcjz19xX7tB6Rre701bc30aTdERIh
41RjDw2yrIyx4wF1C0qoSrV9/CYLWDDW+64nbLssv9ZuNJOlQQUKWI8vFKkZgOr0
`pragma protect end_protected

//pragma protect end
