module `IP_MODULE_NAME(hbram_top) #(
    parameter       MHZ            	= 200,
    parameter       RAM_DBW        	= 16,
    parameter       RAM_ABW        	= 32,
    parameter [0:0] CR0_DPD        	= 1'b1,
    parameter [2:0] CR0_ODS        	= 3'b000,
    parameter [3:0] CR0_ILC        	= 4'b0010,
    parameter [0:0] CR0_FLE        	= 1'b1,
    parameter [0:0] CR0_HBE        	= 1'b1,
    parameter [1:0] CR0_WBL        	= 2'b11,
    parameter [0:0] CR1_MCT        	= 1'b1,
    parameter [0:0] CR1_HSE        	= 1'b1,
    parameter [2:0] CR1_PAR        	= 3'b000,
    parameter       AXI_IF         	= 1,
    parameter       AXI_DBW        	= 128,
    parameter       AXI_SBW        	= AXI_DBW/8,
    parameter       AXI_AWR_DEPTH  	= 16,
    parameter       AXI_W_DEPTH    	= 256,
    parameter       AXI_R_DEPTH    	= 256,
    parameter       DDIN_MODE      	= "",
    parameter [4:0] CAL_CLK_CH     	= 5'b00001,
    parameter [4:0] CAL_CLK_CH_LO  	= 5'b00001,
    parameter [4:0] CAL_CLK_CH_HI  	= 5'b00010,
    parameter       CAL_MODE       	= 2,
    parameter       CAL_DQ_STEPS   	= 8,
    parameter       CAL_RWDS_STEPS 	= 8,
    parameter       CAL_BYTES      	= 12'h100,
    parameter       TCSM           	= 4000000,
    parameter       TVCS           	= 150000000,
    parameter       TRH            	= 200000,
    parameter       TRTR           	= 40000,
    parameter       PLL_MANUAL     	= 0,
    parameter		DUAL_RAM 	   	= 0,
    parameter 		INDIVI_DUAL_CAL	= 0,
    parameter [15:0] CFG_CR1 		= {9'h1ff, CR1_MCT, CR1_HSE, CR1_PAR, 2'b01},
	parameter [15:0] CFG_CR0 		= {CR0_DPD, CR0_ODS, 4'b1111, CR0_ILC, CR0_FLE, CR0_HBE, CR0_WBL},
	parameter 		 PERIODIC_CAL	= 0,
	parameter		 PRD_CAL_USER_SIGNAL = 0,
	parameter 		 ONE_SEC 		= MHZ * 1000000,
	parameter 		 ONE_MIN 		= 60,
	parameter 		 ONE_HOUR 		= 60,
	parameter 		 ONE_DAY 		= 24,
	parameter 		 RECAL_DAYS 	= 2,
	parameter 		 RECAL_HOURS 	= 23,
	parameter		 RWDS_OUT_MODE	= 0,
	parameter		 DQ_FILTER		= 1
) (
    input  wire                 rst,
    input  wire                 ram_clk,
    input  wire                 ram_clk_cal,
    input  wire                 ram_clk_cal_2,
    input  wire                 io_axi_clk,
    input  wire                 io_arw_valid,
    input  wire [31:0]          io_arw_payload_addr,
    input  wire [7:0]           io_arw_payload_id,
    input  wire [7:0]           io_arw_payload_len,
    input  wire [2:0]           io_arw_payload_size,
    input  wire [1:0]           io_arw_payload_burst,
    input  wire [1:0]           io_arw_payload_lock,
    input  wire                 io_arw_payload_write,
    output wire                 io_arw_ready,
    input  wire [7:0]           io_w_payload_id,
    input  wire                 io_w_valid,
    input  wire [AXI_DBW-1:0]   io_w_payload_data,
    input  wire [AXI_SBW-1:0]   io_w_payload_strb,
    input  wire                 io_w_payload_last,
    output wire                 io_w_ready,
    input  wire                 io_b_ready,
    output wire                 io_b_valid,
    output wire [7:0]           io_b_payload_id,
    input  wire                 io_r_ready,
    output wire                 io_r_valid,
    output wire [AXI_DBW-1:0]   io_r_payload_data,
    output wire [7:0]           io_r_payload_id,
    output wire [1:0]           io_r_payload_resp,
    output wire                 io_r_payload_last,
    input  wire                 native_clk,
    input  wire                 native_ram_rdwr,
    input  wire                 native_ram_en,
    input  wire [10:0]          native_ram_burst_len,
    input  wire [31:0]          native_ram_address,
    input  wire [AXI_DBW-1:0]   native_wr_data,
    input  wire [AXI_SBW-1:0]   native_wr_datamask,
    input  wire                 native_wr_en,
    output wire                 native_wr_buf_ready,
    output wire [AXI_DBW-1:0]   native_rd_data,
    output wire                 native_rd_valid,
    output wire                 native_ctrl_idle,
    input  wire                 dyn_pll_phase_en,
    input  wire [2:0]           dyn_pll_phase_sel,
    output wire                 hbc_cal_SHIFT_ENA,
    output wire [2:0]           hbc_cal_SHIFT,
    output wire [4:0]           hbc_cal_SHIFT_SEL,
    output wire [2:0]           hbc_cal_SHIFT_HI,
    output wire [2:0]           hbc_cal_SHIFT_LO,
    output wire [26:0]          hbc_cal_debug_info,
    output wire                 hbc_rst_n,
    output wire                 hbc_cs_n,
    output wire                 hbc_ck_p_HI,
    output wire                 hbc_ck_p_LO,
    output wire                 hbc_ck_n_HI,
    output wire                 hbc_ck_n_LO,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_HI,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_LO,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_HI,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_LO,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OE,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_HI,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_LO,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_HI,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_LO,
    output wire [RAM_DBW-1:0]   hbc_dq_OE,
    output wire                 hbc_rst_n_2,
    output wire                 hbc_cs_n_2,
    output wire                 hbc_ck_p_HI_2,
    output wire                 hbc_ck_p_LO_2,
    output wire                 hbc_ck_n_HI_2,
    output wire                 hbc_ck_n_LO_2,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_HI_2,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_LO_2,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_HI_2,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_LO_2,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_LO_2,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_HI_2,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OE_2,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_HI_2,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_LO_2,
    output wire [RAM_DBW-1:0]   hbc_dq_OE_2,
    output wire                 hbc_cal_pass,
    input wire					prd_user_ack,
    output wire					prd_user_req
);
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2021.1"
`pragma protect key_keyowner = "Synopsys" , key_keyname = "SNPS-VCS-RSA-2"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 128 )
`pragma protect key_block
G7SmDXF7kLYt24deHDybd3p3Zka7QvypTRXwqS1XFm9VCEk+9BuaW1h9NixUKhOe
htDsJ+U3ZBgsr/yXPHavX1fo32GouSsFTVxV0yTjzGeDstdXIg1SthFzkQYtJCND
Jr9meN+XGMP1EAAxQtJW477j0tb7KEplnIuSXDxdpLo=
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9616 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
