module `IP_MODULE_NAME(hbram_top) #(
    parameter       MHZ            	= 200,
    parameter       RAM_DBW        	= 16,
    parameter       RAM_ABW        	= 32,
    parameter [0:0] CR0_DPD        	= 1'b1,
    parameter [2:0] CR0_ODS        	= 3'b000,
    parameter [3:0] CR0_ILC        	= 4'b0010,
    parameter [0:0] CR0_FLE        	= 1'b1,
    parameter [0:0] CR0_HBE        	= 1'b1,
    parameter [1:0] CR0_WBL        	= 2'b11,
    parameter [0:0] CR1_MCT        	= 1'b1,
    parameter [0:0] CR1_HSE        	= 1'b1,
    parameter [2:0] CR1_PAR        	= 3'b000,
    parameter       AXI_IF         	= 1,
    parameter       AXI_DBW        	= 128,
    parameter       AXI_SBW        	= AXI_DBW/8,
    parameter       AXI_AWR_DEPTH  	= 16,
    parameter       AXI_W_DEPTH    	= 256,
    parameter       AXI_R_DEPTH    	= 256,
    parameter       DDIN_MODE      	= "",
    parameter [4:0] CAL_CLK_CH     	= 5'b00001,
    parameter [4:0] CAL_CLK_CH_LO  	= 5'b00001,
    parameter [4:0] CAL_CLK_CH_HI  	= 5'b00010,
    parameter       CAL_MODE       	= 2,
    parameter       CAL_DQ_STEPS   	= 8,
    parameter       CAL_RWDS_STEPS 	= 8,
    parameter       CAL_BYTES      	= 12'h100,
    parameter       TCSM           	= 4000000,
    parameter       TVCS           	= 150000000,
    parameter       TRH            	= 200000,
    parameter       TRTR           	= 40000,
    parameter       PLL_MANUAL     	= 0,
    parameter		DUAL_RAM 	   	= 0,
    parameter 		INDIVI_DUAL_CAL	= 0,
    parameter [15:0] CFG_CR1 		= {9'h1ff, CR1_MCT, CR1_HSE, CR1_PAR, 2'b01},
	parameter [15:0] CFG_CR0 		= {CR0_DPD, CR0_ODS, 4'b1111, CR0_ILC, CR0_FLE, CR0_HBE, CR0_WBL},
	parameter 		 PERIODIC_CAL	= 0,
	parameter		 PRD_CAL_USER_SIGNAL = 0,
	parameter 		 ONE_SEC 		= MHZ * 1000000,
	parameter 		 ONE_MIN 		= 60,
	parameter 		 ONE_HOUR 		= 60,
	parameter 		 ONE_DAY 		= 24,
	parameter 		 RECAL_DAYS 	= 2,
	parameter 		 RECAL_HOURS 	= 23,
	parameter		 RWDS_OUT_MODE	= 0,
	parameter		 DQ_FILTER		= 1
) (
    input  wire                 rst,
    input  wire                 ram_clk,
    input  wire                 ram_clk_cal,
    input  wire                 ram_clk_cal_2,
    input  wire                 io_axi_clk,
    input  wire                 io_arw_valid,
    input  wire [31:0]          io_arw_payload_addr,
    input  wire [7:0]           io_arw_payload_id,
    input  wire [7:0]           io_arw_payload_len,
    input  wire [2:0]           io_arw_payload_size,
    input  wire [1:0]           io_arw_payload_burst,
    input  wire [1:0]           io_arw_payload_lock,
    input  wire                 io_arw_payload_write,
    output wire                 io_arw_ready,
    input  wire [7:0]           io_w_payload_id,
    input  wire                 io_w_valid,
    input  wire [AXI_DBW-1:0]   io_w_payload_data,
    input  wire [AXI_SBW-1:0]   io_w_payload_strb,
    input  wire                 io_w_payload_last,
    output wire                 io_w_ready,
    input  wire                 io_b_ready,
    output wire                 io_b_valid,
    output wire [7:0]           io_b_payload_id,
    input  wire                 io_r_ready,
    output wire                 io_r_valid,
    output wire [AXI_DBW-1:0]   io_r_payload_data,
    output wire [7:0]           io_r_payload_id,
    output wire [1:0]           io_r_payload_resp,
    output wire                 io_r_payload_last,
    input  wire                 native_clk,
    input  wire                 native_ram_rdwr,
    input  wire                 native_ram_en,
    input  wire [10:0]          native_ram_burst_len,
    input  wire [31:0]          native_ram_address,
    input  wire [AXI_DBW-1:0]   native_wr_data,
    input  wire [AXI_SBW-1:0]   native_wr_datamask,
    input  wire                 native_wr_en,
    output wire                 native_wr_buf_ready,
    output wire [AXI_DBW-1:0]   native_rd_data,
    output wire                 native_rd_valid,
    output wire                 native_ctrl_idle,
    input  wire                 dyn_pll_phase_en,
    input  wire [2:0]           dyn_pll_phase_sel,
    output wire                 hbc_cal_SHIFT_ENA,
    output wire [2:0]           hbc_cal_SHIFT,
    output wire [4:0]           hbc_cal_SHIFT_SEL,
    output wire [2:0]           hbc_cal_SHIFT_HI,
    output wire [2:0]           hbc_cal_SHIFT_LO,
    output wire [26:0]          hbc_cal_debug_info,
    output wire                 hbc_rst_n,
    output wire                 hbc_cs_n,
    output wire                 hbc_ck_p_HI,
    output wire                 hbc_ck_p_LO,
    output wire                 hbc_ck_n_HI,
    output wire                 hbc_ck_n_LO,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_HI,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_LO,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_HI,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_LO,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OE,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_HI,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_LO,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_HI,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_LO,
    output wire [RAM_DBW-1:0]   hbc_dq_OE,
    output wire                 hbc_rst_n_2,
    output wire                 hbc_cs_n_2,
    output wire                 hbc_ck_p_HI_2,
    output wire                 hbc_ck_p_LO_2,
    output wire                 hbc_ck_n_HI_2,
    output wire                 hbc_ck_n_LO_2,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_HI_2,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_LO_2,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_HI_2,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_LO_2,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_LO_2,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_HI_2,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OE_2,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_HI_2,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_LO_2,
    output wire [RAM_DBW-1:0]   hbc_dq_OE_2,
    output wire                 hbc_cal_pass,
    input wire					prd_user_ack,
    output wire					prd_user_req
);
//pragma protect begin_protected
//pragma protect key_keyowner=Cadence Design Systems.
//pragma protect key_keyname=CDS_KEY
//pragma protect key_method=RC5
//pragma protect key_block
lTHrmIVfco7hiwZSqnx+MfocylsFIc/9pdZ6jcKzWgwtuGVFPwu2BG1UZ257OEEd
rdWY0aEV4PSLaChxY04vZj+p3waMBreuRHlg9PFa3VBNISEqVZiJAp9NcqdZle7h
5KYCB82yCBjHn5aXnrVoJKKGSAyNGBE4+HeXgvjXdJ7emVAcXK41Aw==
//pragma protect end_key_block
//pragma protect digest_block
LcOojxgnnRP/caflu5t+4Mv7y1E=
//pragma protect end_digest_block
//pragma protect data_block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//pragma protect end_data_block
//pragma protect digest_block
46bWdZzbF6xrwa23I8svLRpSIec=
//pragma protect end_digest_block
//pragma protect end_protected
