module `IP_MODULE_NAME(hbram_top) #(
    parameter       MHZ            	= 200,
    parameter       RAM_DBW        	= 16,
    parameter       RAM_ABW        	= 32,
    parameter [0:0] CR0_DPD        	= 1'b1,
    parameter [2:0] CR0_ODS        	= 3'b000,
    parameter [3:0] CR0_ILC        	= 4'b0010,
    parameter [0:0] CR0_FLE        	= 1'b1,
    parameter [0:0] CR0_HBE        	= 1'b1,
    parameter [1:0] CR0_WBL        	= 2'b11,
    parameter [0:0] CR1_MCT        	= 1'b1,
    parameter [0:0] CR1_HSE        	= 1'b1,
    parameter [2:0] CR1_PAR        	= 3'b000,
    parameter       AXI_IF         	= 1,
    parameter       AXI_DBW        	= 128,
    parameter       AXI_SBW        	= AXI_DBW/8,
    parameter       AXI_AWR_DEPTH  	= 16,
    parameter       AXI_W_DEPTH    	= 256,
    parameter       AXI_R_DEPTH    	= 256,
    parameter       DDIN_MODE      	= "",
    parameter [4:0] CAL_CLK_CH     	= 5'b00001,
    parameter [4:0] CAL_CLK_CH_LO  	= 5'b00001,
    parameter [4:0] CAL_CLK_CH_HI  	= 5'b00010,
    parameter       CAL_MODE       	= 2,
    parameter       CAL_DQ_STEPS   	= 8,
    parameter       CAL_RWDS_STEPS 	= 8,
    parameter       CAL_BYTES      	= 12'h100,
    parameter       TCSM           	= 4000000,
    parameter       TVCS           	= 150000000,
    parameter       TRH            	= 200000,
    parameter       TRTR           	= 40000,
    parameter       PLL_MANUAL     	= 0,
    parameter		DUAL_RAM 	   	= 0,
    parameter 		INDIVI_DUAL_CAL	= 0,
    parameter [15:0] CFG_CR1 		= {9'h1ff, CR1_MCT, CR1_HSE, CR1_PAR, 2'b01},
	parameter [15:0] CFG_CR0 		= {CR0_DPD, CR0_ODS, 4'b1111, CR0_ILC, CR0_FLE, CR0_HBE, CR0_WBL},
	parameter 		 PERIODIC_CAL	= 0,
	parameter		 PRD_CAL_USER_SIGNAL = 0,
	parameter 		 ONE_SEC 		= MHZ * 1000000,
	parameter 		 ONE_MIN 		= 60,
	parameter 		 ONE_HOUR 		= 60,
	parameter 		 ONE_DAY 		= 24,
	parameter 		 RECAL_DAYS 	= 2,
	parameter 		 RECAL_HOURS 	= 23,
	parameter		 RWDS_OUT_MODE	= 0,
	parameter		 DQ_FILTER		= 1
) (
    input  wire                 rst,
    input  wire                 ram_clk,
    input  wire                 ram_clk_cal,
    input  wire                 ram_clk_cal_2,
    input  wire                 io_axi_clk,
    input  wire                 io_arw_valid,
    input  wire [31:0]          io_arw_payload_addr,
    input  wire [7:0]           io_arw_payload_id,
    input  wire [7:0]           io_arw_payload_len,
    input  wire [2:0]           io_arw_payload_size,
    input  wire [1:0]           io_arw_payload_burst,
    input  wire [1:0]           io_arw_payload_lock,
    input  wire                 io_arw_payload_write,
    output wire                 io_arw_ready,
    input  wire [7:0]           io_w_payload_id,
    input  wire                 io_w_valid,
    input  wire [AXI_DBW-1:0]   io_w_payload_data,
    input  wire [AXI_SBW-1:0]   io_w_payload_strb,
    input  wire                 io_w_payload_last,
    output wire                 io_w_ready,
    input  wire                 io_b_ready,
    output wire                 io_b_valid,
    output wire [7:0]           io_b_payload_id,
    input  wire                 io_r_ready,
    output wire                 io_r_valid,
    output wire [AXI_DBW-1:0]   io_r_payload_data,
    output wire [7:0]           io_r_payload_id,
    output wire [1:0]           io_r_payload_resp,
    output wire                 io_r_payload_last,
    input  wire                 native_clk,
    input  wire                 native_ram_rdwr,
    input  wire                 native_ram_en,
    input  wire [10:0]          native_ram_burst_len,
    input  wire [31:0]          native_ram_address,
    input  wire [AXI_DBW-1:0]   native_wr_data,
    input  wire [AXI_SBW-1:0]   native_wr_datamask,
    input  wire                 native_wr_en,
    output wire                 native_wr_buf_ready,
    output wire [AXI_DBW-1:0]   native_rd_data,
    output wire                 native_rd_valid,
    output wire                 native_ctrl_idle,
    input  wire                 dyn_pll_phase_en,
    input  wire [2:0]           dyn_pll_phase_sel,
    output wire                 hbc_cal_SHIFT_ENA,
    output wire [2:0]           hbc_cal_SHIFT,
    output wire [4:0]           hbc_cal_SHIFT_SEL,
    output wire [2:0]           hbc_cal_SHIFT_HI,
    output wire [2:0]           hbc_cal_SHIFT_LO,
    output wire [26:0]          hbc_cal_debug_info,
    output wire                 hbc_rst_n,
    output wire                 hbc_cs_n,
    output wire                 hbc_ck_p_HI,
    output wire                 hbc_ck_p_LO,
    output wire                 hbc_ck_n_HI,
    output wire                 hbc_ck_n_LO,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_HI,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_LO,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_HI,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_LO,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OE,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_HI,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_LO,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_HI,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_LO,
    output wire [RAM_DBW-1:0]   hbc_dq_OE,
    output wire                 hbc_rst_n_2,
    output wire                 hbc_cs_n_2,
    output wire                 hbc_ck_p_HI_2,
    output wire                 hbc_ck_p_LO_2,
    output wire                 hbc_ck_n_HI_2,
    output wire                 hbc_ck_n_LO_2,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_HI_2,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_LO_2,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_HI_2,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_LO_2,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_LO_2,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_HI_2,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OE_2,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_HI_2,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_LO_2,
    output wire [RAM_DBW-1:0]   hbc_dq_OE_2,
    output wire                 hbc_cal_pass,
    input wire					prd_user_ack,
    output wire					prd_user_req
);
//pragma protect
//pragma protect begin
`protected

    MTI!#}1B,]V_WIVUU<_\x*+IYt=<<7IRUUoxN|%^Yku35c~j=e!V;<$nf\;p73EW~IA_sYa3+Ike
    ~#]r@[J@ll+m_rIL[$apBx\InQm}53U@B\uENE;7$||1KV^YV^D^^TV7k+Os?}sok5?iRiRk<A?w
    D_vlQWGIk\#\7Zm\~}A\IAa*OEXj$#-A<A;1xC{smJ=!5J-2'KWR@Zz~U{#{{+G$'C{{}CHA[Xac
    v^J,j+HUJ{R<}~A@!{AHCUJDX'eijiK%HeelQ,<>ERX]u{I@}=Ej7ZE@@\!^>5DkpCm'ae^a'?]r
    Z=pYuj'!GV#{=v\?$ufo@+YEW>V^r#!zW]<AT7{}>KJu\k!!R~07A,ivI'OxP;[^?)7B@2ql*XCC
    ms=K]IYY-}u31CD6W$R<$_}3!]u>m1*$Xz~#ei{JN>A^Y7_VARY*wk'$K3ODn^8WrH<*_{H<r#_6
    AO1T3xkVR+XVvHDkall![i{7zABr>vK}~eG-QGix5WQ?x\ZI['e*O+z2X>GDrvXahCo7i7QDO$!\
    =5D\B3D^BswJ$ev3^ApaQK&$-B7azYR]ZKX$-<Yl>[u'@JuAsxk'G-nlXnTc|F^k}D-BB@,TpVaT
    R@pX<{$@Qk=ow?;5A]%-R\G^V?;7[*R@G>Ov*v!7{J={p,-GXA'XwGD9cCv27N^l?>UUe?daQ$<I
    m[{2BOG#E-o0@}-ADeAU=uEX>>RrVnHB[#E'MV_7\Vxi?N0>\>G]},X@}G=$sxQlXIiR#O12[n^^
    a5KzV>!)_aj\?,wWY+_$O;XDYYuo1ua-WXBxN^u1#H}pk5J;[=AI}I!YzvR[K^IYm_aN|wsixv^p
    p~_>5ilv~}ZURo>np<[+!X$BONoH3_NQ3SLOO$O^vT*7kx+aBY{E~O^nH~D3X,Z+7i#vo~pBQYnq
    p_s5{jQ+RJ$G}Os1\_1$IWH;]o'IO'l1CCsI}+RK-7d5n,p#[EikBnXw]n^#5~[p$m?8eJ>BBwzA
    zI_=V'V!_zk_enVDT7pu2'm[{jOWUz-7p}E2Gz[K,;jm=QH;%p{!>2YKuz2[eAa}x^uusM@1Own$
    -O!Ton\*A*rD'*Uz>-R^r]Q*aeo#X#I-X@xe5oZ{IxqV_;V7DV,Jz2u?D#H9,v@]\zpQ:E2OV7Z<
    <V%]l<5,mQWCpOWa^A<^OGwZCX7wR->ON2>TZ@j\]@UQkI~{7jPXQsWx!s\H5;H*!DJJsx'D+@a7
    {vo1.$Y<eo5a^I_!XvIj{KVov~$>OmH~nse-+G*J*c{T+K<l\]oa<{{Bezs,e@oAZEEK-Bkvk2XU
    Oi}lORkX+xSa*'H2[ZW-la@~Dl[x3~B1-!@\u1oCUBojB2aVQ5\5eouGq.~DQ#_npm?+l3[aXj<}
    E1,wZ*o@vp3au+e2Aun1,_3e}WZ>lO[GnWAxp$$\#o]*7{^{_EVk;KDe^m]G^\Gjln:Gnw@Be#T>
    U<1*s]j}D_~=vUQs#A@vi]$[3G5ArIm~1=}#GG5Yjumaao]*j_i1pY?^@XCWCIu;e'wlWE7]j+Ix
    3vKfDYzz5&zA5JHowu~a@,@pE2Ds]jwaDe2nxE#OH>DsKpW<UBjIo@6+eH'GtW<*#&r1UQ5RCH~_
    A!4AoDKx[:n'#@1eAGI*==pW]2557z[!jJ}]v*sa,Q#wI2PCr1?InDi3}*<SAO#H6!-]poW;]">E
    l\As?r0Vx$2]_^E}C]2m=~z'Asi[I~{~**{G!{KW_T'sJe~]VVeuH$WO'$T,@I<bInX?x7@XlHK^
    N*Jp}}>vY@<sn1_o7Cn@m/S'[3v9jHKWJIx^iEYpAhmT+p4|HXDw<+[JPCD<anY$p};'GPpzZ5EX
    ~$A<T\r-1Z52>5@t=ZXEElEe?[Y<G[ZvG\*!RJ=K*]3J5<>{a1aQDmIQvw<a@Dm@GNp-$_'[XrG_
    v$+a5-R-1Y#>mE\;<IQDl>Ij-\Ho<R~wpsv@@~#w>eG'AGUvp?SpBpK6;]<^wC\!vAl3g*$<uxj]
    uEev$EC*]LErA1x_2=vs;n'Q_@RADRHv\>Oj-l@XmVZY5CU[12zo#uD-H_$E}Ann*r,E-[zG*^$s
    $vlJRkjs'xzH{p=aI\wrBRHo'Huwn#Z_nr~,uv<r_z53^TWhs2REARrEEk}YEHJa|CeWoI$r^Ci\
    @]$KzIzesVVK-5Xn@K^E1vp+2^j-JWVevV;J{IE@kDA'=2=uXTD\mpWVnB}]zAsD;J>3A3nTIwXz
    Y}yYp'?YCGClj}ui7,C]vII{5ZYEk1[Gw=pmoR};5_Tv5Bw%mtan~[KG5ZBzRZ/z*n^'p$oKHAJ0
    Rz@Bs5AA_QzZ[1GIs'E,KvT>V]\G%,-{@(Q7n>vuA7}1Em*}{Zxa5<][rKBx@kqr[J*tov--[pO-
    1<,~Plwp-^Du=-ep\{$Tm31{A6.<lJ?V*TDx,Olx*Jw\U{^O,^5Y@pVQiVY>{<vvQ7plHrjJ5U!-
    CnzJ5>[O+\mo5nW1^5>iH-#KXvvozk@s5^I@A*QQaXU.(jCvrJ=T=rE}'ux~G'$puR=,zH\pvARO
    1DV+lo+n5>+DKXe#e{]WQ,5}=1?]seA+#DIa<jBX*cE2}Zu7v,DO2$ExOW2<m^/Y+WwVn~spJAGw
    A{s=Y~xjVAazW;eT}zo'{=XAO5\;{2V<6G]Am*-Y}f>=QUp@pm$7ku#U*zBU@2I3xBW]{!]k>!tT
    &rzO^s!^R'5X;W^Y!V#A7$s[v\'$EeY7GiCX]#ax!]\#IG}]H[rnKIaVRCY>OQ$r,iQ+s>o>$,Z7
    C5JB#xl-pZQA,Y3!;o@jDqO$;A2a>o}Qz~v>+GGX*xwRKeUaa3Cna#>DDnAYJs5H!\qI*j5uO_\T
    $X>Xnm@EWQpKBTrKr+~}wK1\*I<Qs_Ar4nQi]KU$Yt%?s5#f}O{-xT\GpYD<n1>7o}IHVU^]"Q27
    #9?O<[IQ^@EV#?mzpA?h3oVv+UT}U}+Gp]i@{awz|_iH]3^ent#[>kl!{*3YnYMGIi-l~X$I-\3P
    j@w12]5-s52u0#oi$$jnnp-[?
`endprotected
//pragma protect end
