module `IP_MODULE_NAME(hbram_top) #(
    parameter       MHZ            	= 200,
    parameter       RAM_DBW        	= 16,
    parameter       RAM_ABW        	= 32,
    parameter [0:0] CR0_DPD        	= 1'b1,
    parameter [2:0] CR0_ODS        	= 3'b000,
    parameter [3:0] CR0_ILC        	= 4'b0010,
    parameter [0:0] CR0_FLE        	= 1'b1,
    parameter [0:0] CR0_HBE        	= 1'b1,
    parameter [1:0] CR0_WBL        	= 2'b11,
    parameter [0:0] CR1_MCT        	= 1'b1,
    parameter [0:0] CR1_HSE        	= 1'b1,
    parameter [2:0] CR1_PAR        	= 3'b000,
    parameter       AXI_IF         	= 1,
    parameter       AXI_DBW        	= 128,
    parameter       AXI_SBW        	= AXI_DBW/8,
    parameter       AXI_AWR_DEPTH  	= 16,
    parameter       AXI_W_DEPTH    	= 256,
    parameter       AXI_R_DEPTH    	= 256,
    parameter       DDIN_MODE      	= "",
    parameter [4:0] CAL_CLK_CH     	= 5'b00001,
    parameter [4:0] CAL_CLK_CH_LO  	= 5'b00001,
    parameter [4:0] CAL_CLK_CH_HI  	= 5'b00010,
    parameter       CAL_MODE       	= 2,
    parameter       CAL_DQ_STEPS   	= 8,
    parameter       CAL_RWDS_STEPS 	= 8,
    parameter       CAL_BYTES      	= 12'h100,
    parameter       TCSM           	= 4000000,
    parameter       TVCS           	= 150000000,
    parameter       TRH            	= 200000,
    parameter       TRTR           	= 40000,
    parameter       PLL_MANUAL     	= 0,
    parameter		DUAL_RAM 	   	= 0,
    parameter 		INDIVI_DUAL_CAL	= 0,
    parameter [15:0] CFG_CR1 		= {9'h1ff, CR1_MCT, CR1_HSE, CR1_PAR, 2'b01},
	parameter [15:0] CFG_CR0 		= {CR0_DPD, CR0_ODS, 4'b1111, CR0_ILC, CR0_FLE, CR0_HBE, CR0_WBL},
	parameter 		 PERIODIC_CAL	= 0,
	parameter		 PRD_CAL_USER_SIGNAL = 0,
	parameter 		 ONE_SEC 		= MHZ * 1000000,
	parameter 		 ONE_MIN 		= 60,
	parameter 		 ONE_HOUR 		= 60,
	parameter 		 ONE_DAY 		= 24,
	parameter 		 RECAL_DAYS 	= 2,
	parameter 		 RECAL_HOURS 	= 23,
	parameter		 RWDS_OUT_MODE	= 0,
	parameter		 DQ_FILTER		= 1
) (
    input  wire                 rst,
    input  wire                 ram_clk,
    input  wire                 ram_clk_cal,
    input  wire                 ram_clk_cal_2,
    input  wire                 io_axi_clk,
    input  wire                 io_arw_valid,
    input  wire [31:0]          io_arw_payload_addr,
    input  wire [7:0]           io_arw_payload_id,
    input  wire [7:0]           io_arw_payload_len,
    input  wire [2:0]           io_arw_payload_size,
    input  wire [1:0]           io_arw_payload_burst,
    input  wire [1:0]           io_arw_payload_lock,
    input  wire                 io_arw_payload_write,
    output wire                 io_arw_ready,
    input  wire [7:0]           io_w_payload_id,
    input  wire                 io_w_valid,
    input  wire [AXI_DBW-1:0]   io_w_payload_data,
    input  wire [AXI_SBW-1:0]   io_w_payload_strb,
    input  wire                 io_w_payload_last,
    output wire                 io_w_ready,
    input  wire                 io_b_ready,
    output wire                 io_b_valid,
    output wire [7:0]           io_b_payload_id,
    input  wire                 io_r_ready,
    output wire                 io_r_valid,
    output wire [AXI_DBW-1:0]   io_r_payload_data,
    output wire [7:0]           io_r_payload_id,
    output wire [1:0]           io_r_payload_resp,
    output wire                 io_r_payload_last,
    input  wire                 native_clk,
    input  wire                 native_ram_rdwr,
    input  wire                 native_ram_en,
    input  wire [10:0]          native_ram_burst_len,
    input  wire [31:0]          native_ram_address,
    input  wire [AXI_DBW-1:0]   native_wr_data,
    input  wire [AXI_SBW-1:0]   native_wr_datamask,
    input  wire                 native_wr_en,
    output wire                 native_wr_buf_ready,
    output wire [AXI_DBW-1:0]   native_rd_data,
    output wire                 native_rd_valid,
    output wire                 native_ctrl_idle,
    input  wire                 dyn_pll_phase_en,
    input  wire [2:0]           dyn_pll_phase_sel,
    output wire                 hbc_cal_SHIFT_ENA,
    output wire [2:0]           hbc_cal_SHIFT,
    output wire [4:0]           hbc_cal_SHIFT_SEL,
    output wire [2:0]           hbc_cal_SHIFT_HI,
    output wire [2:0]           hbc_cal_SHIFT_LO,
    output wire [26:0]          hbc_cal_debug_info,
    output wire                 hbc_rst_n,
    output wire                 hbc_cs_n,
    output wire                 hbc_ck_p_HI,
    output wire                 hbc_ck_p_LO,
    output wire                 hbc_ck_n_HI,
    output wire                 hbc_ck_n_LO,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_HI,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_LO,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_HI,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_LO,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OE,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_HI,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_LO,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_HI,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_LO,
    output wire [RAM_DBW-1:0]   hbc_dq_OE,
    output wire                 hbc_rst_n_2,
    output wire                 hbc_cs_n_2,
    output wire                 hbc_ck_p_HI_2,
    output wire                 hbc_ck_p_LO_2,
    output wire                 hbc_ck_n_HI_2,
    output wire                 hbc_ck_n_LO_2,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_HI_2,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_LO_2,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_HI_2,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_LO_2,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_LO_2,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_HI_2,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OE_2,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_HI_2,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_LO_2,
    output wire [RAM_DBW-1:0]   hbc_dq_OE_2,
    output wire                 hbc_cal_pass,
    input wire					prd_user_ack,
    output wire					prd_user_req
);
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2021.1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
Y9WZ+u/4O87GB0TrNOd3Hlmscfo7SsTPBvR3nuxTutmqneitmmO4tvqymOAQ0Qib
XkjjHXs1zc+rQRuyt1QryMAv7xEiLUUYGIMxJ/jiZ7Jt4lfpcJiM2Sr58LSLPCEL
nN1Z2CWeFaJuIiBI3J5j/Bx0Uwhv83rq11jSfxFYHHD85Otpg2gz5xZeK+mOwgLZ
MVweANpSqvbGVP+9xXQ+JBCJEs/buHzrYBEFeqJNlF/6V7cxAZns+rZFQwFuTjM8
vy4sm+LyxYI0BjowkrV2Fe3S7jC/9xqTAw/n0hkT8xds4isWI3beKxBVZW+ZZow3
QY5NW3K2oqkcR0daDALW8w==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9616 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
